/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvRectangle;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.io.IOException;

public class IlvShadowRectangle
extends IlvRectangle {
    private float a = 4.0f;
    private int b = 10;

    public IlvShadowRectangle() {
        this(new IlvRect(0.0f, 0.0f, 100.0f, 100.0f), 2.0f, 10);
    }

    public IlvShadowRectangle(IlvRect ilvRect, float f, int n) {
        super(ilvRect);
        this.setThickness(f);
        this.setShadowPosition(n);
        super.setFillOn(true);
    }

    public IlvShadowRectangle(IlvRect ilvRect) {
        this(ilvRect, 5.0f, 10);
    }

    public IlvShadowRectangle(IlvShadowRectangle ilvShadowRectangle) {
        super(ilvShadowRectangle);
        this.setThickness(ilvShadowRectangle.getThickness());
        this.setShadowPosition(ilvShadowRectangle.getShadowPosition());
    }

    public IlvShadowRectangle(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setThickness(ilvInputStream.readFloat("thickness"));
        this.setShadowPosition(ilvInputStream.readInt("shadowPosition"));
    }

    @Override
    public IlvGraphic copy() {
        return new IlvShadowRectangle(this);
    }

    public int getShadowPosition() {
        return this.b;
    }

    public void setShadowPosition(int n) {
        if (n != 5 && n != 9 && n != 6 && n != 10) {
            throw new IllegalArgumentException("bad position");
        }
        this.b = n;
    }

    public float getThickness() {
        return this.a;
    }

    public void setThickness(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException();
        }
        this.a = f;
    }

    protected void drawContent(Graphics graphics, IlvRect ilvRect, IlvTransformer ilvTransformer) {
    }

    @Override
    public final void setRadius(int n) {
        throw new RuntimeException("could not change radius for IlvShadowRectangle");
    }

    @Override
    public final void setStrokeOn(boolean bl) {
        throw new RuntimeException("could not change stroke on/off for IlvShadowRectangle");
    }

    @Override
    public final void setFillOn(boolean bl) {
        throw new RuntimeException("could not change fill on/off for IlvShadowRectangle");
    }

    @Override
    public final void setCorners(int n) {
    }

    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        float f = this.getThickness();
        int n = this.getShadowPosition();
        IlvRect ilvRect = new IlvRect(this.drawrect);
        if (ilvTransformer != null) {
            ilvTransformer.applyFloor(ilvRect);
        } else {
            ilvRect.floor();
        }
        if (3.0f * f > ilvRect.width) {
            f = ilvRect.width / 3.0f;
        }
        if (3.0f * f > ilvRect.height) {
            f = ilvRect.height / 3.0f;
        }
        float f2 = ilvRect.x;
        float f3 = ilvRect.y;
        if ((n & 3) != 0) {
            ilvRect.width = Math.max(0.0f, ilvRect.width - f);
            if ((n & 1) != 0) {
                ilvRect.x += f;
            } else {
                f2 += f;
            }
        }
        if ((n & 0xC) != 0) {
            ilvRect.height = Math.max(0.0f, ilvRect.height - f);
            if ((n & 4) != 0) {
                ilvRect.y += f;
            } else {
                f3 += f;
            }
        }
        graphics.setColor(this.getForeground());
        graphics.fillRect((int)f2, (int)f3, (int)ilvRect.width, (int)ilvRect.height);
        graphics.setColor(this.getBackground());
        graphics.fillRect((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width, (int)ilvRect.height);
        graphics.setColor(this.getForeground());
        graphics.drawRect((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width, (int)ilvRect.height);
        this.drawContent(graphics, ilvRect, ilvTransformer);
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("thickness", this.getThickness());
        ilvOutputStream.write("shadowPosition", this.getShadowPosition());
    }
}

