/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.graphic.IlvPointArray;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import ilog.views.linkconnector.IlvClippingUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;

public class IlvGraphicPath
extends IlvGraphic {
    public static final int STROKE_ONLY = 0;
    public static final int FILL_ONLY = 1;
    public static final int STROKE_AND_FILL = 2;
    private int a;
    private IlvPointArray[] b;
    private final IlvRect c = new IlvRect();
    private boolean d;
    private Color e = null;
    private Color f = null;

    public IlvGraphicPath(IlvPoint[] ilvPointArray, boolean bl) {
        this.d = false;
        this.setDrawRule(0);
        this.b = new IlvPointArray[1];
        this.b[0] = new IlvPointArray(ilvPointArray, bl);
    }

    public IlvGraphicPath(IlvPointArray[] ilvPointArrayArray, boolean bl) {
        this.d = false;
        this.setDrawRule(0);
        this.b = bl ? this.a(ilvPointArrayArray) : ilvPointArrayArray;
    }

    private IlvPointArray[] a(IlvPointArray[] ilvPointArrayArray) {
        if (ilvPointArrayArray == null) {
            return null;
        }
        int n = ilvPointArrayArray.length;
        IlvPointArray[] ilvPointArrayArray2 = new IlvPointArray[n];
        for (int i = 0; i < n; ++i) {
            ilvPointArrayArray2[i] = new IlvPointArray(ilvPointArrayArray[i]);
        }
        return ilvPointArrayArray2;
    }

    public IlvGraphicPath(IlvGraphicPath ilvGraphicPath) {
        super(ilvGraphicPath);
        this.setBackground(ilvGraphicPath.f);
        this.setForeground(ilvGraphicPath.e);
        this.d = false;
        this.c.x = ilvGraphicPath.c.x;
        this.c.y = ilvGraphicPath.c.y;
        this.c.width = ilvGraphicPath.c.width;
        this.c.height = ilvGraphicPath.c.height;
        this.setDrawRule(ilvGraphicPath.getDrawRule());
        this.b = this.a(ilvGraphicPath.b);
    }

    public IlvGraphicPath(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.d = false;
        Color color = ilvInputStream.readColor("foreground");
        this.setForeground(color);
        color = ilvInputStream.readColor("background");
        this.setBackground(color);
        this.setDrawRule(ilvInputStream.readInt("drawRule"));
        IlvPersistentObject[] ilvPersistentObjectArray = ilvInputStream.readPersistentObjects("paths");
        if (ilvPersistentObjectArray != null) {
            this.b = new IlvPointArray[ilvPersistentObjectArray.length];
            System.arraycopy(ilvPersistentObjectArray, 0, this.b, 0, ilvPersistentObjectArray.length);
        } else {
            this.b = null;
        }
    }

    @Override
    public IlvGraphic copy() {
        return new IlvGraphicPath(this);
    }

    public void setDrawRule(int n) {
        this.a = n;
    }

    public int getDrawRule() {
        return this.a;
    }

    public int getNumPaths() {
        return this.b == null ? 0 : this.b.length;
    }

    public void setPaths(IlvPoint[] ilvPointArray, boolean bl) {
        this.d = false;
        this.b = new IlvPointArray[1];
        this.b[0] = new IlvPointArray(ilvPointArray, bl);
    }

    public void setPaths(IlvPointArray[] ilvPointArrayArray, boolean bl) {
        this.d = false;
        this.b = bl ? this.a(ilvPointArrayArray) : ilvPointArrayArray;
    }

    public IlvPointArray[] getPaths() {
        return this.b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (this.b == null) {
            return false;
        }
        if (this.a == 0) {
            int n = this.b.length;
            IlvRect ilvRect = new IlvRect(0.0f, 0.0f, 4.0f, 4.0f);
            if (ilvTransformer != null) {
                ilvTransformer.inverse(ilvRect);
            }
            float f = IlvUtil.GetDeltaLine();
            IlvUtil.SetDeltaLine(Math.max(ilvRect.width, ilvRect.height));
            try {
                for (int i = 0; i < n; ++i) {
                    if (!this.b[i].outlineContains(ilvPoint)) continue;
                    IlvUtil.SetDeltaLine(f);
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                IlvUtil.SetDeltaLine(f);
            }
        } else {
            int n = 0;
            int n2 = this.b.length;
            for (int i = 0; i < n2; ++i) {
                n += this.b[i].nbHorizontalIntersection(ilvPoint);
            }
            if (n != 0 && n & true) {
                return true;
            }
        }
        return false;
    }

    @Override
    public IlvPoint getIntersectionWithOutline(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (ilvPoint == null || ilvPoint2 == null) {
            return null;
        }
        if (ilvPoint.equals(ilvPoint2)) {
            return new IlvPoint(ilvPoint);
        }
        boolean bl = this.getDrawRule() != 0;
        boolean bl2 = ilvTransformer != null && !ilvTransformer.isIdentity();
        int n = this.b == null ? 0 : this.b.length;
        IlvPoint[] ilvPointArray = new IlvPoint[n];
        for (int i = 0; i < n; ++i) {
            IlvPoint[] ilvPointArray2 = this.b[i].getPoints();
            int n2 = this.b[i].getNumberOfPoints();
            IlvPoint[] ilvPointArray3 = new IlvPoint[n2];
            for (int j = 0; j < n2; ++j) {
                ilvPointArray3[j] = new IlvPoint(ilvPointArray2[j].x, ilvPointArray2[j].y);
                if (!bl2) continue;
                ilvTransformer.apply(ilvPointArray3[j]);
            }
            IlvPoint[] ilvPointArray4 = new IlvPoint[ilvPointArray3.length];
            int n3 = IlvClippingUtil.LineIntersectsPolyPoints(ilvPoint, ilvPoint2, ilvPointArray3, bl, ilvPointArray4);
            ilvPointArray[i] = IlvClippingUtil.BestClipPointOnRay(ilvPoint, ilvPoint2, ilvPointArray4, n3);
        }
        return IlvClippingUtil.BestClipPointOnRay(ilvPoint, ilvPoint2, ilvPointArray, n);
    }

    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        int n;
        int n2;
        IlvPointArray[] ilvPointArrayArray = this.b;
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            n2 = this.b == null ? 0 : this.b.length;
            ilvPointArrayArray = n2 == 0 ? null : new IlvPointArray[n2];
            for (n = 0; n < n2; ++n) {
                IlvPoint[] ilvPointArray = this.b[n].getPoints();
                int n3 = this.b[n].getNumberOfPoints();
                IlvPoint[] ilvPointArray2 = new IlvPoint[n3];
                for (int i = 0; i < n3; ++i) {
                    ilvPointArray2[i] = new IlvPoint(ilvPointArray[i].x, ilvPointArray[i].y);
                    ilvTransformer.apply(ilvPointArray2[i]);
                }
                ilvPointArrayArray[n] = new IlvPointArray(ilvPointArray2, false);
            }
        }
        n2 = this.a != 0 ? 1 : 0;
        int n4 = n = this.a != 1 ? 1 : 0;
        if (n2 != 0) {
            IlvPointArray.FillPaths(graphics, this.getBackground(), ilvPointArrayArray);
        }
        if (n != 0) {
            IlvPointArray.DrawPaths(graphics, this.getForeground(), ilvPointArrayArray);
        }
    }

    private void a(IlvRect ilvRect) {
        if (!this.d) {
            int n;
            int n2 = n = this.b == null ? 0 : this.b.length;
            if (n != 0) {
                this.b[0].boundingBox(this.c, null);
                IlvRect ilvRect2 = new IlvRect();
                for (int i = 1; i < n; ++i) {
                    this.b[i].boundingBox(ilvRect2, null);
                    this.c.add(ilvRect2);
                }
            } else {
                this.c.reshape(0.0f, 0.0f, 0.0f, 0.0f);
            }
            this.d = true;
        }
        ilvRect.reshape(this.c.x, this.c.y, this.c.width, this.c.height);
    }

    @Override
    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = new IlvRect();
        if (ilvTransformer != null && this.b != null) {
            this.b[0].boundingBox(ilvRect, ilvTransformer);
            IlvRect ilvRect2 = new IlvRect();
            int n = this.b == null ? 0 : this.b.length;
            for (int i = 1; i < n; ++i) {
                this.b[i].boundingBox(ilvRect2, ilvTransformer);
                ilvRect.add(ilvRect2);
            }
        } else {
            this.a(ilvRect);
        }
        if (ilvRect.width == 0.0f) {
            ilvRect.width = 1.0E-20f;
        }
        if (ilvRect.height == 0.0f) {
            ilvRect.height = 1.0E-20f;
        }
        return ilvRect;
    }

    @Override
    public void applyTransform(IlvTransformer ilvTransformer) {
        if (this.b != null) {
            for (int i = 0; i < this.b.length; ++i) {
                this.b[i].applyTransform(ilvTransformer);
            }
        }
        this.d = false;
    }

    @Override
    public void setForeground(Color color) {
        Color color2 = this.e;
        this.e = color;
        this.registerBlinkingResource(color2, color);
    }

    public Color getForeground() {
        return this.e != null ? this.e : Color.black;
    }

    @Override
    public void setBackground(Color color) {
        Color color2 = this.f;
        this.f = color;
        this.registerBlinkingResource(color2, color);
    }

    public Color getBackground() {
        return this.f != null ? this.f : Color.black;
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("foreground", this.getForeground());
        ilvOutputStream.write("background", this.getBackground());
        ilvOutputStream.write("drawRule", this.getDrawRule());
        ilvOutputStream.write("paths", this.b);
    }
}

