/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvDoubleLinkImage;
import ilog.views.internal.IlvStrokeInfo;
import ilog.views.internal.IlvUtility;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;

public class IlvDoubleSplineLinkImage
extends IlvDoubleLinkImage {
    public IlvDoubleSplineLinkImage(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, boolean bl) {
        this(ilvGraphic, ilvGraphic2, 0, bl);
    }

    public IlvDoubleSplineLinkImage(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, int n, boolean bl) {
        super(ilvGraphic, ilvGraphic2, n, bl);
    }

    public IlvDoubleSplineLinkImage(IlvDoubleSplineLinkImage ilvDoubleSplineLinkImage) {
        super(ilvDoubleSplineLinkImage);
    }

    public IlvDoubleSplineLinkImage(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
    }

    @Override
    public IlvGraphic copy() {
        return new IlvDoubleSplineLinkImage(this);
    }

    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        if (this.a(ilvTransformer)) {
            super.draw(graphics, ilvTransformer);
            return;
        }
        IlvPoint[] ilvPointArray = this.getLinkPoints(ilvTransformer);
        int n = ilvPointArray.length;
        float f = this.getLineWidth();
        float[] fArray = this.getLineStyle();
        graphics.setColor(this.getForeground());
        if (f == 0.0f && fArray == null) {
            IlvGraphicUtil.DrawBezier(graphics, ilvPointArray, n, 0.0f, 0, 0, null, null);
        } else {
            float f2 = this.getMaximumLineWidth();
            fArray = IlvStrokeInfo.zoomedLineStyle(fArray, f, f2, ilvTransformer);
            f = IlvStrokeInfo.zoomedLineWidth(f, f2, ilvTransformer, false);
            float f3 = ilvPointArray[n - 1].x;
            float f4 = ilvPointArray[n - 1].y;
            IlvUtility.retractPointsForArrowHead(this, ilvPointArray, f, ilvTransformer);
            IlvGraphicUtil.DrawBezier(graphics, ilvPointArray, n, f, 0, this.getEndCap(), fArray, ilvTransformer, true);
            ilvPointArray[n - 1].x = f3;
            ilvPointArray[n - 1].y = f4;
        }
        this.drawArrow(graphics, ilvPointArray[2], ilvPointArray[3], ilvTransformer);
    }

    @Override
    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (this.a(ilvTransformer)) {
            return super.contains(ilvPoint, ilvPoint2, ilvTransformer);
        }
        float f = this.getLineWidth();
        IlvPoint[] ilvPointArray = this.getLinkPoints(ilvTransformer);
        if (f <= 1.0f) {
            return IlvGraphicUtil.PointInBezier(ilvPoint2, ilvPointArray, ilvPointArray.length, 1.0f, 0, 0, null);
        }
        f = IlvStrokeInfo.zoomedLineWidth(f, this.getMaximumLineWidth(), ilvTransformer, false);
        double d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
        int n = ilvPointArray.length;
        if (this.isOriented() && this.arrowContains(ilvPoint, ilvPoint2, ilvPointArray[n - 2], ilvPointArray[n - 1], ilvTransformer)) {
            return true;
        }
        IlvUtility.retractPointsForArrowHead(this, ilvPointArray, f, ilvTransformer);
        return IlvGraphicUtil.PointInBezier(ilvPoint2, ilvPointArray, n, (float)((double)f * d), 0, this.getEndCap(), null);
    }

    @Override
    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        if (this.a(ilvTransformer)) {
            return super.boundingBox(ilvTransformer);
        }
        IlvRect ilvRect = new IlvRect();
        IlvPoint[] ilvPointArray = this.getLinkPoints(ilvTransformer);
        int n = ilvPointArray.length;
        float f = this.getLineWidth();
        if (f == 0.0f) {
            ilvRect.x = Math.min(Math.min(ilvPointArray[0].x, ilvPointArray[1].x), ilvPointArray[3].x);
            ilvRect.y = Math.min(Math.min(ilvPointArray[0].y, ilvPointArray[1].y), ilvPointArray[3].y);
            float f2 = Math.max(Math.max(ilvPointArray[0].x, ilvPointArray[1].x), ilvPointArray[3].x);
            ilvRect.width = f2 - ilvRect.x;
            f2 = Math.max(Math.max(ilvPointArray[0].y, ilvPointArray[1].y), ilvPointArray[3].y);
            ilvRect.height = f2 - ilvRect.y;
        } else {
            f = IlvStrokeInfo.zoomedLineWidth(f, this.getMaximumLineWidth(), ilvTransformer, true);
            double d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            float f3 = ilvPointArray[n - 1].x;
            float f4 = ilvPointArray[n - 1].y;
            IlvUtility.retractPointsForArrowHead(this, ilvPointArray, -1.0f, ilvTransformer);
            IlvGraphicUtil.BezierBoundingBox(ilvRect, ilvPointArray, ilvPointArray.length, (float)((double)f * d), 0, this.getEndCap(), null);
            ilvPointArray[n - 1].x = f3;
            ilvPointArray[n - 1].y = f4;
        }
        if (this.isOriented()) {
            ilvRect.add(this.arrowBBox(ilvPointArray[2], ilvPointArray[3], ilvTransformer));
        }
        if (ilvRect.width < 1.0E-20f) {
            ilvRect.width = 1.0E-20f;
        }
        if (ilvRect.height < 1.0E-20f) {
            ilvRect.height = 1.0E-20f;
        }
        return ilvRect;
    }
}

