/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.builder.wizard;

import ilog.views.applications.util.IlvApplicationsUtil;
import ilog.views.applications.util.wizard.IlvWizardPage;
import ilog.views.applications.util.wizard.IlvWizardPanel;
import ilog.views.builder.IlvBuilder;
import ilog.views.builder.IlvBuilderPluginInstaller;
import ilog.views.builder.docview.IlvMessageView;
import ilog.views.builder.gui.IlvAbstractHelpComponent;
import ilog.views.builder.gui.IlvEmbeddedHelpComponent;
import ilog.views.builder.wizard.IlvDataSourceChoicePage;
import ilog.views.builder.wizard.IlvEndPage;
import ilog.views.builder.wizard.IlvFromTemplatePage;
import ilog.views.builder.wizard.IlvStartPage;
import ilog.views.builder.wizard.IlvThemePage;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.swing.SwingFactories;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class IlvBuilderWizard
extends IlvWizardPanel {
    public static final String TEMPLATE_PAGE = "Wizard_Template_Page";
    public static final String DATASOURCE_PAGE = "Wizard_DataSource_Page";
    public static final String MEMORY_DATASOURCE_PAGE = "Wizard_MemoryDataSource_Page";
    public static final String FLATFILE_PAGE = "Wizard_FlatFile_Page";
    public static final String XML_DATASOURCE_PAGE = "Wizard_XML_Page";
    public static final String JDBC_DATASOURCE_PAGE = "Wizard_JDBC_Page";
    public static final String MAPPING_PAGE = "Wizard_Mapping_Page";
    public static final String TGO_XML_DATASOURCE_PAGE = "Wizard_TGOXML_Page";
    public static final String READONLY_MAPPING_PAGE = "Wizard_Readonly_Mapping_Page";
    public static final String END_PAGE = "Wizard_End_Page";
    public static final String THEME_PAGE = "Wizard_Theme_Page";
    protected IlvBuilder builder;
    private JCheckBox a;
    private JPanel b;
    private JLabel c;
    private JPanel d;
    private JComponent e;
    private IlvAbstractHelpComponent f;

    public IlvBuilderWizard(IlvBuilder ilvBuilder, String string, String string2) {
        this(ilvBuilder, string, string2, true);
    }

    public IlvBuilderWizard(IlvBuilder ilvBuilder, String string, String string2, boolean bl) {
        super(string, string2, false);
        this.builder = ilvBuilder;
        this.setOwner(ilvBuilder.getFrame());
        this.getStatusBar().setLayout(new BoxLayout(this.getStatusBar(), SwingFactories.getBoxLayoutLineAxis()));
        if (bl) {
            this.a = new JCheckBox(IlvWizardPanel.getMessage("BuilderWizard.ShowAtStartup"), this.b());
            this.a.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    IlvBuilderWizard.this.a(itemEvent.getStateChange() == 1);
                }
            });
            this.a.setHorizontalAlignment(10);
            this.a.setOpaque(false);
            this.a.setBorder(new EmptyBorder(15, 10, 15, 10));
            this.getStatusBar().add(this.a);
        }
    }

    @Override
    protected void initResources() {
        super.initResources();
        IlvWizardPanel.addResourceBundle("ilog.views.builder.wizard.wizard", IlvLocaleUtil.getCurrentLocale());
    }

    @Override
    protected void initIconBox(JPanel jPanel) {
        jPanel.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0}, {-1.0, -2.0, -1.0}}));
        jPanel.setBackground(IlvApplicationsUtil.WIZARD_DEFAULT_BACKGROUND);
        jPanel.setBorder(null);
        jPanel.add(Box.createVerticalGlue(), "0,0");
        JComponent jComponent = this.createPreviewComponent();
        if (jComponent != null) {
            this.setPreviewComponent(jComponent);
        }
        jPanel.add(Box.createVerticalGlue(), "0,2");
    }

    protected JComponent getPreviewComponent() {
        return this.e;
    }

    protected void setPreviewComponent(JComponent jComponent) {
        this.e = jComponent;
        if (jComponent == null) {
            if (this.d != null) {
                this.d.removeAll();
            }
        } else {
            if (this.b == null) {
                this.d = new JPanel();
                this.d.setOpaque(false);
                this.d.setBorder(new LineBorder(IlvApplicationsUtil.ILOG_DARK_BLUE, 4));
                this.c = new JLabel();
                this.c.setFont(UIManager.getFont("TitledBorder.font"));
                this.c.setForeground(UIManager.getColor("TitledBorder.titleColor"));
                this.c.setBorder(new EmptyBorder(0, 2, 4, 2));
                this.b = new JPanel();
                this.b.setOpaque(false);
                this.b.setLayout(new BorderLayout());
                this.b.add((Component)this.d, "Center");
                this.b.add((Component)this.c, "North");
                this.getIconBox().add((Component)this.b, "0,1");
            } else {
                this.d.removeAll();
            }
            jComponent.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    long l = hierarchyEvent.getChangeFlags();
                    JComponent jComponent = (JComponent)hierarchyEvent.getComponent();
                    if ((l & 4L) != 0L && jComponent.isShowing()) {
                        IlvBuilderWizard.this.previewComponentShown();
                        jComponent.removeHierarchyListener(this);
                    }
                }
            });
            this.d.add(jComponent);
        }
    }

    protected void previewComponentShown() {
    }

    public void setPreviewTitle(String string) {
        this.c.setText(string);
    }

    protected JComponent createPreviewComponent() {
        return null;
    }

    public void setShowAtStartupVisible(boolean bl) {
        if (this.a != null) {
            this.a.setVisible(bl);
        }
    }

    public boolean isShowAtStartupVisible() {
        return this.a != null ? this.a.isVisible() : false;
    }

    public final IlvBuilder getBuilder() {
        return this.builder;
    }

    private void a(boolean bl) {
        IlvBuilderPluginInstaller ilvBuilderPluginInstaller = IlvBuilderPluginInstaller.getInstaller(this.getBuilder());
        ilvBuilderPluginInstaller.setShowWizardAtStartup(bl);
    }

    private boolean b() {
        IlvBuilderPluginInstaller ilvBuilderPluginInstaller = IlvBuilderPluginInstaller.getInstaller(this.getBuilder());
        return ilvBuilderPluginInstaller.isShowWizardAtStartup();
    }

    public boolean edit(Object object) {
        IlvStartPage ilvStartPage = null;
        if (object == null) {
            ilvStartPage = new IlvStartPage();
        }
        this.setFirstPage(ilvStartPage);
        return this.go(true);
    }

    @Override
    public IlvWizardPage getOrCreatePage(String string) {
        IlvWizardPage ilvWizardPage = this.getPage(string);
        if (ilvWizardPage == null) {
            ilvWizardPage = this.createPage(string);
        }
        if (ilvWizardPage != null) {
            this.addPage(ilvWizardPage);
            return ilvWizardPage;
        }
        return super.getOrCreatePage(string);
    }

    protected IlvWizardPage createPage(String string) {
        if (TEMPLATE_PAGE.equals(string)) {
            return new IlvFromTemplatePage();
        }
        if (DATASOURCE_PAGE.equals(string)) {
            return new IlvDataSourceChoicePage();
        }
        if (THEME_PAGE.equals(string)) {
            return new IlvThemePage();
        }
        if (END_PAGE.equals(string)) {
            return new IlvEndPage();
        }
        if (READONLY_MAPPING_PAGE.equals(string)) {
            return this.createPage(MAPPING_PAGE);
        }
        return null;
    }

    @Override
    public boolean go(boolean bl) {
        IlvMessageView.setEnabled(this.getBuilder().getApplication(), false);
        boolean bl2 = super.go(bl);
        IlvMessageView.setEnabled(this.getBuilder().getApplication(), true);
        return bl2;
    }

    @Override
    protected JDialog createDialog(Frame frame, String string, boolean bl) {
        return new JDialog(frame, string, bl){

            @Override
            public void setVisible(boolean bl) {
                super.setVisible(bl);
                if (!bl && !IlvBuilderWizard.this.isDone()) {
                    IlvBuilderWizard.this.cancel();
                    IlvBuilderWizard.this.setCancelled(true);
                    IlvBuilderWizard.this.done();
                }
            }
        };
    }

    @Override
    protected JComponent createHelpButton() {
        if (this.f == null) {
            this.f = new IlvEmbeddedHelpComponent((Container)this, this.getTopPanel());
        }
        return this.f.getHelpButton();
    }

    @Override
    protected void updateHelpContents(URL uRL) {
        if (this.f != null) {
            try {
                if (uRL != null) {
                    this.f.setHelpURL(uRL);
                } else {
                    this.f.setHelpPanelVisible(false);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

