/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v11.ac;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import oracle.security.xmlsec.liberty.v11.LibertyInitializer;
import oracle.security.xmlsec.liberty.v11.ac.ACElement;
import oracle.security.xmlsec.liberty.v11.ac.AuthenticationContextException;
import oracle.security.xmlsec.liberty.v11.ac.AuthenticationMethod;
import oracle.security.xmlsec.liberty.v11.ac.Authenticator;
import oracle.security.xmlsec.liberty.v11.ac.AuthenticatorTransportProtocol;
import oracle.security.xmlsec.liberty.v11.ac.DeactivationCallCenter;
import oracle.security.xmlsec.liberty.v11.ac.DigSig;
import oracle.security.xmlsec.liberty.v11.ac.Generation;
import oracle.security.xmlsec.liberty.v11.ac.GenericClass;
import oracle.security.xmlsec.liberty.v11.ac.GoverningAgreementRef;
import oracle.security.xmlsec.liberty.v11.ac.GoverningAgreements;
import oracle.security.xmlsec.liberty.v11.ac.HTTP;
import oracle.security.xmlsec.liberty.v11.ac.IPSec;
import oracle.security.xmlsec.liberty.v11.ac.Identification;
import oracle.security.xmlsec.liberty.v11.ac.KeyActivation;
import oracle.security.xmlsec.liberty.v11.ac.KeyStorage;
import oracle.security.xmlsec.liberty.v11.ac.Length;
import oracle.security.xmlsec.liberty.v11.ac.LibertyUtils;
import oracle.security.xmlsec.liberty.v11.ac.MobileAuthCard;
import oracle.security.xmlsec.liberty.v11.ac.MobileDevice;
import oracle.security.xmlsec.liberty.v11.ac.MobileNetwork;
import oracle.security.xmlsec.liberty.v11.ac.OperationalProtection;
import oracle.security.xmlsec.liberty.v11.ac.Password;
import oracle.security.xmlsec.liberty.v11.ac.PhysicalVerification;
import oracle.security.xmlsec.liberty.v11.ac.PreviousSession;
import oracle.security.xmlsec.liberty.v11.ac.PrincipalAuthenticationMechanism;
import oracle.security.xmlsec.liberty.v11.ac.PrivateKeyProtection;
import oracle.security.xmlsec.liberty.v11.ac.SSL;
import oracle.security.xmlsec.liberty.v11.ac.SecurityAudit;
import oracle.security.xmlsec.liberty.v11.ac.SharedKeyProtection;
import oracle.security.xmlsec.liberty.v11.ac.SharedSecretChallengeResponse;
import oracle.security.xmlsec.liberty.v11.ac.Smartcard;
import oracle.security.xmlsec.liberty.v11.ac.SwitchAudit;
import oracle.security.xmlsec.liberty.v11.ac.TechnicalProtection;
import oracle.security.xmlsec.liberty.v11.ac.TimeSyncToken;
import oracle.security.xmlsec.liberty.v11.ac.Token;
import oracle.security.xmlsec.liberty.v11.ac.WTLS;
import oracle.security.xmlsec.liberty.v11.ac.WrittenConsent;
import oracle.security.xmlsec.liberty.v11.ac.ZeroKnowledge;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.URIManager;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AuthenticationContextStatement
extends XMLElement {
    private String[] ns = new String[]{"http://projectliberty.org/schemas/authctx/2002/05", "http://projectliberty.org/schemas/authctx/2002/05", "http://projectliberty.org/schemas/authctx/2002/05", "http://projectliberty.org/schemas/authctx/2002/05", "http://projectliberty.org/schemas/authctx/2002/05"};
    private String[] localNames = new String[]{"Identification", "TechnicalProtection", "AuthenticationMethod", "OperationalProtection", "GoverningAgreements"};
    private Hashtable validElements = new Hashtable();
    private static Object obj = new Object();
    private String className = null;
    private String associatedURI = null;

    protected AuthenticationContextStatement(Element element) {
        super(element);
        this.initialize();
    }

    protected AuthenticationContextStatement(Element element, String systemId) {
        super(element, systemId);
        this.initialize();
    }

    protected AuthenticationContextStatement(Document owner) {
        super(owner, "http://projectliberty.org/schemas/authctx/2002/05", "AuthenticationContextStatement");
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://projectliberty.org/schemas/authctx/2002/05");
        this.addNSPrefixAttrDefault("http://projectliberty.org/schemas/authctx/2002/05");
        this.initialize();
    }

    protected AuthenticationContextStatement(Document owner, String id) throws AuthenticationContextException {
        this(owner);
        this.setID(id);
    }

    public static AuthenticationContextStatement getInstance(String uri, Element element) throws AuthenticationContextException {
        if (uri == null) {
            return new GenericClass(element);
        }
        try {
            Class c = URIManager.getURIManager().getClassForURI(uri, "authenticationContextClass");
            if (c == null) {
                return new GenericClass(element);
            }
            Class[] params = new Class[]{Element.class};
            Constructor con = c.getConstructor(params);
            Object[] args = new Object[]{element};
            return (AuthenticationContextStatement)((Object)con.newInstance(args));
        }
        catch (InstantiationException ex) {
            throw new AuthenticationContextException("Could not instantiate class associated with the following uri: " + uri + "; " + ex.toString());
        }
        catch (IllegalAccessException ex) {
            throw new AuthenticationContextException("Could not instantiate class associated with the following uri: " + uri + "; " + ex.toString());
        }
        catch (InvocationTargetException ex) {
            throw new AuthenticationContextException("Could not instantiate class associated with the following uri: " + uri + "; " + ex.toString());
        }
        catch (NoSuchMethodException ex) {
            throw new AuthenticationContextException("Could not instantiate class associated with the following uri: " + uri + "; " + ex.toString());
        }
        catch (ClassNotFoundException ex) {
            throw new AuthenticationContextException("Could not instantiate class associated with the following uri: " + uri + "; " + ex.toString());
        }
    }

    public static AuthenticationContextStatement getInstance(String uri, Element element, String systemId) throws AuthenticationContextException {
        if (uri == null) {
            return new GenericClass(element, systemId);
        }
        try {
            Class c = URIManager.getURIManager().getClassForURI(uri, "authenticationContextClass");
            if (c == null) {
                return new GenericClass(element, systemId);
            }
            Class[] params = new Class[]{Element.class, String.class};
            Constructor con = c.getConstructor(params);
            Object[] args = new Object[]{element, systemId};
            return (AuthenticationContextStatement)((Object)con.newInstance(args));
        }
        catch (InstantiationException ex) {
            throw new AuthenticationContextException("Could not instantiate class associated with the following uri: " + uri + "; " + ex.toString());
        }
        catch (IllegalAccessException ex) {
            throw new AuthenticationContextException("Could not instantiate class associated with the following uri: " + uri + "; " + ex.toString());
        }
        catch (InvocationTargetException ex) {
            throw new AuthenticationContextException("Could not instantiate class associated with the following uri: " + uri + "; " + ex.toString());
        }
        catch (NoSuchMethodException ex) {
            throw new AuthenticationContextException("Could not instantiate class associated with the following uri: " + uri + "; " + ex.toString());
        }
        catch (ClassNotFoundException ex) {
            throw new AuthenticationContextException("Could not instantiate class associated with the following uri: " + uri + "; " + ex.toString());
        }
    }

    public static AuthenticationContextStatement getInstance(String uri, Document owner, String id) throws AuthenticationContextException {
        if (uri == null) {
            return new GenericClass(owner);
        }
        try {
            Class c = URIManager.getURIManager().getClassForURI(uri, "authenticationContextClass");
            if (c == null) {
                return new GenericClass(owner);
            }
            Class[] params = new Class[]{Document.class};
            Constructor con = c.getConstructor(params);
            Object[] args = new Object[]{owner};
            AuthenticationContextStatement acs = (AuthenticationContextStatement)((Object)con.newInstance(args));
            if (id != null) {
                acs.setID(id);
            }
            return acs;
        }
        catch (InstantiationException ex) {
            throw new AuthenticationContextException("Could not instantiate class associated with the following uri: " + uri + "; " + ex.toString());
        }
        catch (IllegalAccessException ex) {
            throw new AuthenticationContextException("Could not instantiate class associated with the following uri: " + uri + "; " + ex.toString());
        }
        catch (InvocationTargetException ex) {
            throw new AuthenticationContextException("Could not instantiate class associated with the following uri: " + uri + "; " + ex.toString());
        }
        catch (NoSuchMethodException ex) {
            throw new AuthenticationContextException("Could not instantiate class associated with the following uri: " + uri + "; " + ex.toString());
        }
        catch (ClassNotFoundException ex) {
            throw new AuthenticationContextException("Could not instantiate class associated with the following uri: " + uri + "; " + ex.toString());
        }
    }

    public void setIdentification(Identification id) throws AuthenticationContextException {
        this.setChildACElement(id, 0);
    }

    public Identification getIdentification() {
        return (Identification)LibertyUtils.getChildACElement(this, "Identification", this);
    }

    public void setTechnicalProtection(TechnicalProtection tp) throws AuthenticationContextException {
        this.setChildACElement(tp, 1);
    }

    public TechnicalProtection getTechnicalProtection() {
        return (TechnicalProtection)LibertyUtils.getChildACElement(this, "TechnicalProtection", this);
    }

    public void setAuthenticationMethod(AuthenticationMethod am) throws AuthenticationContextException {
        this.setChildACElement(am, 2);
    }

    public AuthenticationMethod getAuthenticationMethod() {
        NodeList nList = this.getChildElementsByTagNameNS("http://projectliberty.org/schemas/authctx/2002/05", "AuthenticationMethod");
        if (nList.getLength() != 0) {
            return new AuthenticationMethod((Element)nList.item(0), this.systemId, this);
        }
        return null;
    }

    public void setOperationalProtection(OperationalProtection op) throws AuthenticationContextException {
        this.setChildACElement(op, 3);
    }

    public OperationalProtection getOperationalProtection() {
        return (OperationalProtection)LibertyUtils.getChildACElement(this, "OperationalProtection", this);
    }

    public void setGoverningAgreements(GoverningAgreements ga) throws AuthenticationContextException {
        this.setChildACElement(ga, 4);
    }

    public GoverningAgreements getGoverningAgreements() {
        return (GoverningAgreements)LibertyUtils.getChildACElement(this, "GoverningAgreements", this);
    }

    public void setID(String id) throws AuthenticationContextException {
        this.setAttribute("ID", id);
    }

    public String getID() {
        if (this.hasAttribute("ID")) {
            return this.getAttribute("ID");
        }
        return null;
    }

    public Identification createIdentification(String nym) throws DOMException, AuthenticationContextException {
        Identification id = new Identification(this.getOwnerDocument(), this);
        id.setSystemId(this.systemId);
        id.setNym(nym);
        return id;
    }

    public TechnicalProtection createTechnicalProtection() throws DOMException, AuthenticationContextException {
        TechnicalProtection tp = new TechnicalProtection(this.getOwnerDocument(), this);
        tp.setSystemId(this.systemId);
        return tp;
    }

    public AuthenticationMethod createAuthenticationMethod() throws DOMException, AuthenticationContextException {
        AuthenticationMethod am = new AuthenticationMethod(this.getOwnerDocument(), this);
        am.setSystemId(this.systemId);
        return am;
    }

    public OperationalProtection createOperationalProtection() throws DOMException, AuthenticationContextException {
        OperationalProtection op = new OperationalProtection(this.getOwnerDocument(), this);
        op.setSystemId(this.systemId);
        return op;
    }

    public GoverningAgreements createGoverningAgreements() throws DOMException, AuthenticationContextException {
        GoverningAgreements ga = new GoverningAgreements(this.getOwnerDocument(), this);
        ga.setSystemId(this.systemId);
        return ga;
    }

    public PhysicalVerification createPhysicalVerification(String credentialLevel) throws DOMException, AuthenticationContextException {
        PhysicalVerification pv = new PhysicalVerification(this.getOwnerDocument(), this);
        pv.setSystemId(this.systemId);
        pv.setCredentialLevel(credentialLevel);
        return pv;
    }

    public WrittenConsent createWrittenConsent() throws DOMException, AuthenticationContextException {
        WrittenConsent wc = new WrittenConsent(this.getOwnerDocument(), this);
        wc.setSystemId(this.systemId);
        return wc;
    }

    public PrincipalAuthenticationMechanism createPrincipalAuthenticationMechanism() throws DOMException, AuthenticationContextException {
        PrincipalAuthenticationMechanism pam = new PrincipalAuthenticationMechanism(this.getOwnerDocument(), this);
        pam.setSystemId(this.systemId);
        return pam;
    }

    public Password createPassword() throws DOMException, AuthenticationContextException {
        Password pw = new Password(this.getOwnerDocument(), this);
        pw.setSystemId(this.systemId);
        return pw;
    }

    public Length createLength(int min) throws DOMException, AuthenticationContextException {
        Length l = new Length(this.getOwnerDocument(), this);
        l.setSystemId(this.systemId);
        l.setMin(min);
        return l;
    }

    public Generation createGeneration(String mechanism) throws DOMException, AuthenticationContextException {
        Generation g = new Generation(this.getOwnerDocument(), this);
        g.setSystemId(this.systemId);
        g.setMechanism(mechanism);
        return g;
    }

    public Smartcard createSmartcard() throws DOMException, AuthenticationContextException {
        Smartcard sc = new Smartcard(this.getOwnerDocument(), this);
        sc.setSystemId(this.systemId);
        return sc;
    }

    public Token createToken() throws DOMException, AuthenticationContextException {
        Token tk = new Token(this.getOwnerDocument(), this);
        tk.setSystemId(this.systemId);
        return tk;
    }

    public TimeSyncToken createTimeSyncToken(String deviceType, int seedLength, boolean deviceInHand) throws DOMException, AuthenticationContextException {
        TimeSyncToken tst = new TimeSyncToken(this.getOwnerDocument(), this);
        tst.setSystemId(this.systemId);
        tst.setDeviceType(deviceType);
        tst.setSeedLength(seedLength);
        tst.setDeviceInHand(deviceInHand);
        return tst;
    }

    public Authenticator createAuthenticator() throws DOMException, AuthenticationContextException {
        Authenticator au = new Authenticator(this.getOwnerDocument(), this);
        au.setSystemId(this.systemId);
        return au;
    }

    public AuthenticatorTransportProtocol createAuthenticatorTransportProtocol() throws DOMException, AuthenticationContextException {
        AuthenticatorTransportProtocol atp = new AuthenticatorTransportProtocol(this.getOwnerDocument(), this);
        atp.setSystemId(this.systemId);
        return atp;
    }

    public MobileNetwork createMobileNetwork() throws DOMException, AuthenticationContextException {
        MobileNetwork mn = new MobileNetwork(this.getOwnerDocument(), this);
        mn.setSystemId(this.systemId);
        return mn;
    }

    public SSL createSSL() throws DOMException, AuthenticationContextException {
        SSL ssl = new SSL(this.getOwnerDocument(), this);
        ssl.setSystemId(this.systemId);
        return ssl;
    }

    public HTTP createHTTP() throws DOMException, AuthenticationContextException {
        HTTP http = new HTTP(this.getOwnerDocument(), this);
        http.setSystemId(this.systemId);
        return http;
    }

    public WTLS createWTLS() throws DOMException, AuthenticationContextException {
        WTLS wtls = new WTLS(this.getOwnerDocument(), this);
        wtls.setSystemId(this.systemId);
        return wtls;
    }

    public IPSec createIPSec() throws DOMException, AuthenticationContextException {
        IPSec ipSec = new IPSec(this.getOwnerDocument(), this);
        ipSec.setSystemId(this.systemId);
        return ipSec;
    }

    public DeactivationCallCenter createDeactivationCallCenter() throws DOMException, AuthenticationContextException {
        DeactivationCallCenter dcc = new DeactivationCallCenter(this.getOwnerDocument(), this);
        dcc.setSystemId(this.systemId);
        return dcc;
    }

    public GoverningAgreementRef createGoverningAgreementRef(String ref) throws DOMException, AuthenticationContextException {
        GoverningAgreementRef gar = new GoverningAgreementRef(this.getOwnerDocument(), this);
        gar.setSystemId(this.systemId);
        gar.setRef(ref);
        return gar;
    }

    public SharedSecretChallengeResponse createSharedSecretChallengeResponse() throws DOMException, AuthenticationContextException {
        SharedSecretChallengeResponse sscr = new SharedSecretChallengeResponse(this.getOwnerDocument(), this);
        sscr.setSystemId(this.systemId);
        return sscr;
    }

    public MobileAuthCard createMobileAuthCard() throws DOMException, AuthenticationContextException {
        MobileAuthCard mac = new MobileAuthCard(this.getOwnerDocument(), this);
        mac.setSystemId(this.systemId);
        return mac;
    }

    public MobileDevice createMobileDevice() throws DOMException, AuthenticationContextException {
        MobileDevice md = new MobileDevice(this.getOwnerDocument(), this);
        md.setSystemId(this.systemId);
        return md;
    }

    public SecurityAudit createSecurityAudit() throws DOMException, AuthenticationContextException {
        SecurityAudit sa = new SecurityAudit(this.getOwnerDocument(), this);
        sa.setSystemId(this.systemId);
        return sa;
    }

    public SwitchAudit createSwitchAudit() throws DOMException, AuthenticationContextException {
        SwitchAudit sa = new SwitchAudit(this.getOwnerDocument(), this);
        sa.setSystemId(this.systemId);
        return sa;
    }

    public PrivateKeyProtection createPrivateKeyProtection() throws DOMException, AuthenticationContextException {
        PrivateKeyProtection pkp = new PrivateKeyProtection(this.getOwnerDocument(), this);
        pkp.setSystemId(this.systemId);
        return pkp;
    }

    public KeyActivation createKeyActivation() throws DOMException, AuthenticationContextException {
        KeyActivation ka = new KeyActivation(this.getOwnerDocument(), this);
        ka.setSystemId(this.systemId);
        return ka;
    }

    public KeyStorage createKeyStorage(String medium) throws DOMException, AuthenticationContextException {
        KeyStorage ks = new KeyStorage(this.getOwnerDocument(), this);
        ks.setSystemId(this.systemId);
        ks.setMedium(medium);
        return ks;
    }

    public SharedKeyProtection createSharedKeyProtection() throws DOMException, AuthenticationContextException {
        SharedKeyProtection skp = new SharedKeyProtection(this.getOwnerDocument(), this);
        skp.setSystemId(this.systemId);
        return skp;
    }

    public DigSig createDigSig() throws DOMException, AuthenticationContextException {
        DigSig ds = new DigSig(this.getOwnerDocument(), this);
        ds.setSystemId(this.systemId);
        return ds;
    }

    public ZeroKnowledge createZeroKnowledge() throws DOMException, AuthenticationContextException {
        ZeroKnowledge zn = new ZeroKnowledge(this.getOwnerDocument(), this);
        zn.setSystemId(this.systemId);
        return zn;
    }

    public PreviousSession createPreviousSession() throws DOMException, AuthenticationContextException {
        PreviousSession ps = new PreviousSession(this.getOwnerDocument(), this);
        ps.setSystemId(this.systemId);
        return ps;
    }

    protected void setClassName(String name) {
        this.className = name;
    }

    public String getClassName() {
        return this.className;
    }

    protected void setAssociatedURI(String uri) {
        this.associatedURI = uri;
    }

    public String getAssociatedURI() {
        return this.associatedURI;
    }

    protected void setValidElement(String nsURI, String localName, String nsURIParent, String localNameParent) {
        this.validElements.put(nsURIParent + ":" + localNameParent + "=>" + nsURI + ":" + localName, obj);
    }

    protected void removeValidElement(String nsURI, String localName, String nsURIParent, String localNameParent) {
        this.validElements.remove(nsURIParent + ":" + localNameParent + "=>" + nsURI + ":" + localName);
    }

    protected boolean isValidElement(ACElement element, XMLElement parent) {
        String tagName = QName.getLocalPart((String)element.getTagName());
        String nsURI = element.getNamespaceURI();
        String tagNameParent = QName.getLocalPart((String)parent.getTagName());
        String nsURIParent = parent.getNamespaceURI();
        String key = nsURIParent + ":" + tagNameParent + "=>" + nsURI + ":" + tagName;
        return this.validElements.containsKey(key);
    }

    protected void validateElement(ACElement element, XMLElement parent) throws AuthenticationContextException {
        if (!this.isValidElement(element, parent)) {
            String tagName = QName.getLocalPart((String)element.getTagName());
            String nsURI = element.getNamespaceURI();
            String tagNameParent = QName.getLocalPart((String)parent.getTagName());
            String nsURIParent = parent.getNamespaceURI();
            throw new AuthenticationContextException(tagName + " element in namespace " + nsURI + " with parent element " + tagNameParent + " in namespace " + nsURIParent + " is not valid for " + this.getClassName() + " class.");
        }
    }

    protected boolean isValidAttributeValue(String value, String attrName, String attrNSURI, XMLElement element) {
        if (attrName.equals("nym") && attrNSURI.equals("http://projectliberty.org/schemas/authctx/2002/05") && element instanceof Identification) {
            return value.equals("anonymity") || value.equals("verinymity") || value.equals("pseudonymity");
        }
        if (attrName.equals("credentialLevel") && attrNSURI.equals("http://projectliberty.org/schemas/authctx/2002/05") && element instanceof PhysicalVerification) {
            return value.equals("primary") || value.equals("secondary");
        }
        if (attrName.equals("medium") && attrNSURI.equals("http://projectliberty.org/schemas/authctx/2002/05") && element instanceof KeyStorage) {
            return value.equals("memory") || value.equals("token") || value.equals("smartcard") || value.equals("MobileAuthCard");
        }
        if (attrName.equals("DeviceType") && attrNSURI.equals("http://projectliberty.org/schemas/authctx/2002/05") && element instanceof TimeSyncToken) {
            return value.equals("hardware") || value.equals("software");
        }
        if (attrName.equals("SeedLength") && attrNSURI.equals("http://projectliberty.org/schemas/authctx/2002/05") && element instanceof TimeSyncToken) {
            try {
                Integer.parseInt(value);
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        if (attrName.equals("DeviceInHand") && attrNSURI.equals("http://projectliberty.org/schemas/authctx/2002/05") && element instanceof TimeSyncToken) {
            return value.equals("true") || value.equals("false");
        }
        if (attrName.equals("min") && attrNSURI.equals("http://projectliberty.org/schemas/authctx/2002/05") && element instanceof Length) {
            try {
                Integer.parseInt(value);
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        if (attrName.equals("max") && attrNSURI.equals("http://projectliberty.org/schemas/authctx/2002/05") && element instanceof Length) {
            try {
                if (value.length() > 0) {
                    Integer.parseInt(value);
                }
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        if (attrName.equals("mechanism") && attrNSURI.equals("http://projectliberty.org/schemas/authctx/2002/05") && element instanceof Generation) {
            return value.equals("principalchosen") || value.equals("automatic");
        }
        return true;
    }

    protected void validateAttributeValue(String value, String attrName, String attrNSURI, XMLElement element) throws AuthenticationContextException {
        if (!this.isValidAttributeValue(value, attrName, attrNSURI, element)) {
            throw new AuthenticationContextException("Value of \"" + value + "\" for attribute " + attrName + " in namespace " + attrNSURI + " for element " + element + " is not valid  for " + this.getClassName() + " class.");
        }
    }

    protected void setChildACElement(ACElement element, int pos) throws AuthenticationContextException {
        this.validateElement(element, this);
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"http://projectliberty.org/schemas/authctx/2002/05", (String)element.getLocalName());
        XMLUtils.insertChild((XMLElement)this, (XMLElement)element, (String[])this.ns, (String[])this.localNames, (int)pos);
    }

    protected abstract void initialize();

    static {
        SAMLInitializer.initialize();
        LibertyInitializer.initialize();
    }
}

