/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v11;

import java.net.URLEncoder;
import java.security.PrivateKey;
import java.util.Date;
import oracle.security.xmlsec.dsig.SigningException;
import oracle.security.xmlsec.liberty.v11.IDPProvidedNameIdentifier;
import oracle.security.xmlsec.liberty.v11.LibDSigUtils;
import oracle.security.xmlsec.liberty.v11.LibRequestMessage;
import oracle.security.xmlsec.liberty.v11.LibertyInitializer;
import oracle.security.xmlsec.liberty.v11.LibertyUtils;
import oracle.security.xmlsec.liberty.v11.OldProvidedNameIdentifier;
import oracle.security.xmlsec.liberty.v11.SPProvidedNameIdentifier;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RegisterNameIdentifierRequest
extends LibRequestMessage {
    public RegisterNameIdentifierRequest(Element element) throws DOMException {
        super(element);
    }

    public RegisterNameIdentifierRequest(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public RegisterNameIdentifierRequest(Document owner) throws DOMException {
        super(owner, "http://projectliberty.org/schemas/core/2002/12", "RegisterNameIdentifierRequest");
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://projectliberty.org/schemas/core/2002/12");
        this.addNSPrefixAttrDefault("http://projectliberty.org/schemas/core/2002/12");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:1.0:protocol");
    }

    public RegisterNameIdentifierRequest(Document owner, String requestId, Date issueInstant, String providerId) {
        this(owner);
        this.setRequestID(requestId);
        this.setIssueInstant(issueInstant);
        this.setProviderID(providerId);
    }

    public void setIDPProvidedNameIdentifier(IDPProvidedNameIdentifier idpNameId) {
        LibertyUtils.setChildElement((XMLElement)this, (XMLElement)idpNameId, this.getChildElementsNSURIs(), this.getChildElementsLocalNames());
    }

    public IDPProvidedNameIdentifier getIDPProvidedNameIdentifier() {
        return (IDPProvidedNameIdentifier)LibertyUtils.getChildElement((XMLElement)this, "http://projectliberty.org/schemas/core/2002/12", "IDPProvidedNameIdentifier");
    }

    public void setSPProvidedNameIdentifier(SPProvidedNameIdentifier spNameId) {
        LibertyUtils.setChildElement((XMLElement)this, (XMLElement)spNameId, this.getChildElementsNSURIs(), this.getChildElementsLocalNames());
    }

    public SPProvidedNameIdentifier getSPProvidedNameIdentifier() {
        return (SPProvidedNameIdentifier)LibertyUtils.getChildElement((XMLElement)this, "http://projectliberty.org/schemas/core/2002/12", "SPProvidedNameIdentifier");
    }

    public void setOldProvidedNameIdentifier(OldProvidedNameIdentifier oldNameId) {
        LibertyUtils.setChildElement((XMLElement)this, (XMLElement)oldNameId, this.getChildElementsNSURIs(), this.getChildElementsLocalNames());
    }

    public OldProvidedNameIdentifier getOldProvidedNameIdentifier() {
        return (OldProvidedNameIdentifier)LibertyUtils.getChildElement((XMLElement)this, "http://projectliberty.org/schemas/core/2002/12", "OldProvidedNameIdentifier");
    }

    public String toURLString(PrivateKey key, String sigAlg) throws SigningException {
        int last;
        String relayState;
        OldProvidedNameIdentifier oldni;
        SPProvidedNameIdentifier spni;
        IDPProvidedNameIdentifier idpni;
        String providerID;
        StringBuffer queryBuffer = new StringBuffer();
        String requestID = this.getRequestID();
        if (requestID != null) {
            queryBuffer.append("RequestID");
            queryBuffer.append("=");
            queryBuffer.append(URLEncoder.encode(requestID));
            queryBuffer.append('&');
        }
        queryBuffer.append("MajorVersion");
        queryBuffer.append("=1&");
        queryBuffer.append("MinorVersion");
        queryBuffer.append("=0&");
        Date issueInstant = this.getIssueInstant();
        if (issueInstant != null) {
            queryBuffer.append("IssueInstant");
            queryBuffer.append("=");
            queryBuffer.append(URLEncoder.encode(XMLUtils.formatDateTime((Date)issueInstant)));
            queryBuffer.append('&');
        }
        if ((providerID = this.getProviderID()) != null) {
            queryBuffer.append("ProviderID");
            queryBuffer.append("=");
            queryBuffer.append(URLEncoder.encode(providerID));
            queryBuffer.append('&');
        }
        if ((idpni = this.getIDPProvidedNameIdentifier()) != null) {
            String nameValue;
            String nameFormat;
            String nameQualifier = idpni.getNameQualifier();
            if (nameQualifier != null) {
                queryBuffer.append("IDPNameQualifier");
                queryBuffer.append("=");
                queryBuffer.append(URLEncoder.encode(nameQualifier));
                queryBuffer.append('&');
            }
            if ((nameFormat = idpni.getFormat()) != null) {
                queryBuffer.append("IDPNameFormat");
                queryBuffer.append("=");
                queryBuffer.append(URLEncoder.encode(nameFormat));
                queryBuffer.append('&');
            }
            if ((nameValue = idpni.getValue()) != null) {
                queryBuffer.append("IDPProvidedNameIdentifier");
                queryBuffer.append("=");
                queryBuffer.append(URLEncoder.encode(nameValue));
                queryBuffer.append('&');
            }
        }
        if ((spni = this.getSPProvidedNameIdentifier()) != null) {
            String nameValue;
            String nameFormat;
            String nameQualifier = spni.getNameQualifier();
            if (nameQualifier != null) {
                queryBuffer.append("SPNameQualifier");
                queryBuffer.append("=");
                queryBuffer.append(URLEncoder.encode(nameQualifier));
                queryBuffer.append('&');
            }
            if ((nameFormat = spni.getFormat()) != null) {
                queryBuffer.append("SPNameFormat");
                queryBuffer.append("=");
                queryBuffer.append(URLEncoder.encode(nameFormat));
                queryBuffer.append('&');
            }
            if ((nameValue = spni.getValue()) != null) {
                queryBuffer.append("SPProvidedNameIdentifier");
                queryBuffer.append("=");
                queryBuffer.append(URLEncoder.encode(nameValue));
                queryBuffer.append('&');
            }
        }
        if ((oldni = this.getOldProvidedNameIdentifier()) != null) {
            String nameValue;
            String nameFormat;
            String nameQualifier = oldni.getNameQualifier();
            if (nameQualifier != null) {
                queryBuffer.append("OldNameQualifier");
                queryBuffer.append("=");
                queryBuffer.append(URLEncoder.encode(nameQualifier));
                queryBuffer.append('&');
            }
            if ((nameFormat = oldni.getFormat()) != null) {
                queryBuffer.append("OldNameFormat");
                queryBuffer.append("=");
                queryBuffer.append(URLEncoder.encode(nameFormat));
                queryBuffer.append('&');
            }
            if ((nameValue = oldni.getValue()) != null) {
                queryBuffer.append("OldProvidedNameIdentifier");
                queryBuffer.append("=");
                queryBuffer.append(URLEncoder.encode(nameValue));
                queryBuffer.append('&');
            }
        }
        if ((relayState = this.getRelayState()) != null) {
            queryBuffer.append("RelayState");
            queryBuffer.append("=");
            queryBuffer.append(URLEncoder.encode(relayState));
            queryBuffer.append('&');
        }
        if (key != null && sigAlg != null) {
            queryBuffer.append("SigAlg");
            queryBuffer.append("=");
            queryBuffer.append(URLEncoder.encode(sigAlg));
            String toBeSigned = queryBuffer.toString();
            String sigValue = LibDSigUtils.signURL(toBeSigned, key, sigAlg);
            queryBuffer.append("&");
            queryBuffer.append("Signature");
            queryBuffer.append("=");
            queryBuffer.append(sigValue);
        }
        if ((last = queryBuffer.length() - 1) >= 0 && queryBuffer.charAt(last) == '&') {
            queryBuffer.deleteCharAt(last);
        }
        return queryBuffer.toString();
    }

    @Override
    protected String[] getChildElementsNSURIs() {
        return new String[]{"urn:oasis:names:tc:SAML:1.0:protocol", "http://www.w3.org/2000/09/xmldsig#", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12"};
    }

    @Override
    protected String[] getChildElementsLocalNames() {
        return new String[]{"RespondWith", "Signature", "ProviderID", "IDPProvidedNameIdentifier", "SPProvidedNameIdentifier", "OldProvidedNameIdentifier", "RelayState"};
    }

    static {
        SAMLInitializer.initialize();
        LibertyInitializer.initialize();
    }
}

