/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v11;

import java.util.List;
import oracle.security.xmlsec.liberty.v11.LibertyInitializer;
import oracle.security.xmlsec.liberty.v11.LibertyUtils;
import oracle.security.xmlsec.liberty.v11.ProviderDescriptor;
import oracle.security.xmlsec.saml.SAMLInitializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IDPDescriptor
extends ProviderDescriptor {
    private static final String[] nsURIs = new String[]{"http://projectliberty.org/schemas/core/2002/12", "http://www.w3.org/2000/09/xmldsig#", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12", "http://projectliberty.org/schemas/core/2002/12"};
    private static final String[] localNames = new String[]{"ProviderID", "KeyInfo", "SoapEndpoint", "SingleLogoutServiceURL", "SingleLogoutServiceReturnURL", "FederationTerminationServiceURL", "FederationTerminationServiceReturnURL", "FederationTerminationNotificationProtocolProfile", "SingleLogoutProtocolProfile", "RegisterNameIdentifierProtocolProfile", "RegisterNameIdentifierServiceURL", "RegisterNameIdentifierServiceReturnURL", "SingleSignOnServiceURL", "SingleSignOnProtocolProfile"};

    public IDPDescriptor(Element element) throws DOMException {
        super(element);
    }

    public IDPDescriptor(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public IDPDescriptor(Document owner) throws DOMException {
        super(owner, "http://projectliberty.org/schemas/core/2002/12", "IDPDescriptor");
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://projectliberty.org/schemas/core/2002/12");
        this.addNSPrefixAttrDefault("http://projectliberty.org/schemas/core/2002/12");
    }

    public IDPDescriptor(Document owner, String providerId, String ssoServiceURL) throws DOMException {
        this(owner);
        this.setProviderID(providerId);
        this.setSingleSignOnServiceURL(ssoServiceURL);
    }

    public void setSingleSignOnServiceURL(String serviceURI) {
        LibertyUtils.insertChildElementWithText(this, "http://projectliberty.org/schemas/core/2002/12", "SingleSignOnServiceURL", nsURIs, localNames, serviceURI, true);
    }

    public String getSingleSignOnServiceURL() {
        return LibertyUtils.collectTextFromChild(this, "http://projectliberty.org/schemas/core/2002/12", "SingleSignOnServiceURL");
    }

    public void addSingleSignOnProtocolProfile(String ssoProfURI) {
        LibertyUtils.insertChildElementWithText(this, "http://projectliberty.org/schemas/core/2002/12", "SingleSignOnProtocolProfile", nsURIs, localNames, ssoProfURI, false);
    }

    public List getSingleSignOnProtocolProfiles() {
        return LibertyUtils.collectTextFromChildren(this, "http://projectliberty.org/schemas/core/2002/12", "SingleSignOnProtocolProfile");
    }

    static {
        SAMLInitializer.initialize();
        LibertyInitializer.initialize();
    }
}

