/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.id;

import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.id.Scope;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ScopedIdLocation {
    private final Scope _scope;
    private final Element _element;
    private final QualifiedName _identifyingProperty;
    private final boolean _identifyingPropertyIsAttr;

    public static final ScopedIdLocation createAttrLocation(Scope scope, Element element, QualifiedName attrName) {
        if (scope == null) {
            throw new IllegalArgumentException("null scope argument");
        }
        if (element == null) {
            throw new IllegalArgumentException("null element argument");
        }
        if (attrName == null) {
            throw new IllegalArgumentException("null attrName argument");
        }
        return new ScopedIdLocation(scope, element, attrName, true);
    }

    public static final ScopedIdLocation createChildLocation(Scope scope, Element element, QualifiedName childName) {
        if (scope == null) {
            throw new IllegalArgumentException("null scope argument");
        }
        if (element == null) {
            throw new IllegalArgumentException("null element argument");
        }
        if (childName == null) {
            throw new IllegalArgumentException("null childName argument");
        }
        return new ScopedIdLocation(scope, element, childName, false);
    }

    public static final ScopedIdLocation createTextValueLocation(Scope scope, Element element) {
        if (scope == null) {
            throw new IllegalArgumentException("null scope argument");
        }
        if (element == null) {
            throw new IllegalArgumentException("null element argument");
        }
        return new ScopedIdLocation(scope, element, null, false);
    }

    public Scope getScope() {
        return this._scope;
    }

    public Element getElement() {
        return this._element;
    }

    public QualifiedName getIdentifyingProperty() {
        return this._identifyingProperty;
    }

    public boolean isIdentifyingPropertyAttr() {
        return this._identifyingPropertyIsAttr;
    }

    public String getValue() {
        String returnValue = null;
        Node idHolder = this._getNodeAtLocation();
        if (idHolder != null) {
            returnValue = DomUtils.isElement((Node)idHolder) ? DomUtils.getTextNodeValue((Node)idHolder) : idHolder.getNodeValue();
        }
        if ("".equals(returnValue)) {
            returnValue = null;
        }
        return returnValue;
    }

    public void setValue(XmlModel model, String newId) throws XmlCommitException {
        if (this._identifyingPropertyIsAttr) {
            this._element.setAttributeNS(this._identifyingProperty.getNamespace(), this._identifyingProperty.getName(), newId);
        } else if (this._identifyingProperty != null) {
            Element child = (Element)DomUtils.getNamedChild((Node)this._element, (String)this._identifyingProperty.getNamespace(), (String)this._identifyingProperty.getName());
            if (child == null) {
                Document document = this._element.getOwnerDocument();
                child = document.createElementNS(this._identifyingProperty.getNamespace(), this._identifyingProperty.getName());
                child = (Element)model.insertNode(child, DomPositionFactory.inside((Node)this._element), false);
            }
            if (child != null) {
                DomUtils.setTextNodeValue((Node)child, (String)newId);
            }
        } else {
            DomUtils.setTextNodeValue((Node)this._element, (String)newId);
        }
    }

    private Node _getNodeAtLocation() {
        Node returnValue = null;
        returnValue = this._identifyingPropertyIsAttr ? this._element.getAttributeNodeNS(this._identifyingProperty.getNamespace(), this._identifyingProperty.getName()) : (this._identifyingProperty != null ? DomUtils.getNamedChild((Node)this._element, (String)this._identifyingProperty.getNamespace(), (String)this._identifyingProperty.getName()) : this._element);
        return returnValue;
    }

    private ScopedIdLocation(Scope scope, Element element, QualifiedName identifyingProperty, boolean identifyingPropertyIsAttr) {
        this._scope = scope;
        this._element = element;
        this._identifyingProperty = identifyingProperty;
        this._identifyingPropertyIsAttr = identifyingPropertyIsAttr;
    }
}

