/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.net.JarIndex;
import oracle.ide.net.JarIndexEntry;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.FileUtilities;
import oracle.javatools.util.ArraySortedSet;
import oracle.jdeveloper.java.locator.ModularizedJdkBaseLocator;
import oracle.jdeveloper.java.locator.ModularizedJdkClassLocator;
import oracle.jdeveloper.java.locator.ModularizedJdkURLFileSystemHelper;
import oracle.jdeveloper.java.locator.ModularizedPackageEntry;

public class ModularizedJdkJmodLocator
extends ModularizedJdkClassLocator {
    private URL jmodDir;
    private static final Map<String, ModularizedJdkJmodLocator> INSTANCES = new HashMap<String, ModularizedJdkJmodLocator>();

    private ModularizedJdkJmodLocator(URL jmodDir) {
        this.jmodDir = jmodDir;
        this._lastModified = URLFileSystem.lastModified((URL)jmodDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModularizedJdkJmodLocator getInstance(URL jmodDir) {
        assert (URLFileSystem.isDirectory((URL)jmodDir));
        Map<String, ModularizedJdkJmodLocator> map = INSTANCES;
        synchronized (map) {
            String filePath = ModularizedJdkJmodLocator.getJmodDirFilePath(jmodDir);
            ModularizedJdkJmodLocator locator = INSTANCES.get(filePath);
            if (locator != null) {
                return locator;
            }
            locator = new ModularizedJdkJmodLocator(jmodDir);
            INSTANCES.put(filePath, locator);
            return locator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ModularizedJdkJmodLocator getInstance(String filePath) {
        Map<String, ModularizedJdkJmodLocator> map = INSTANCES;
        synchronized (map) {
            ModularizedJdkJmodLocator locator = INSTANCES.get(filePath);
            return locator;
        }
    }

    private static String getJmodDirFilePath(URL jmodDir) {
        return URLFileSystem.getPath((URL)jmodDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void buildIndexImpl(boolean checkInterrupt) throws InterruptedException {
        if (this._packageMap != null) {
            return;
        }
        ModularizedJdkJmodLocator modularizedJdkJmodLocator = this;
        synchronized (modularizedJdkJmodLocator) {
            block15: {
                if (this._packageMap != null) {
                    return;
                }
                if (checkInterrupt) {
                    ModularizedJdkJmodLocator.checkInterrupt();
                }
                this._moduleNames = new ArrayList();
                try {
                    HashMap<String, Map<String, ModularizedJdkBaseLocator.ClassDetails>> packageToClassDetails = new HashMap<String, Map<String, ModularizedJdkBaseLocator.ClassDetails>>(512);
                    HashMap<String, Collection<String>> packageToSubMap = new HashMap<String, Collection<String>>(512);
                    URL[] jmods = URLFileSystem.list((URL)this.jmodDir);
                    int moduleCount = 0;
                    for (URL jmod : jmods) {
                        if (checkInterrupt) {
                            ModularizedJdkJmodLocator.checkInterrupt();
                        }
                        if (!URLFileSystem.hasSuffix((URL)jmod, (String)".jmod")) continue;
                        String moduleIndex = Integer.toHexString(moduleCount);
                        ++moduleCount;
                        String moduleName = URLFileSystem.getName((URL)jmod);
                        this._moduleNames.add(moduleName);
                        URL rootJmodPath = URLFactory.newJarURL((URL)jmod, (String)"classes/");
                        JarIndex jarIndex = JarIndex.getInstance((URL)rootJmodPath);
                        final ArrayList entries = new ArrayList(4096);
                        jarIndex.visit(new JarIndex.Visitor(){

                            public boolean visit(JarIndexEntry entry) {
                                entries.add(entry);
                                return true;
                            }
                        });
                        for (JarIndexEntry entry : entries) {
                            if (checkInterrupt) {
                                ModularizedJdkJmodLocator.checkInterrupt();
                            }
                            if (!entry.getName().endsWith(".class")) continue;
                            String className = entry.getName().substring(8);
                            this.indexClassMaps(moduleIndex, moduleName, className, entry.getSize(), packageToClassDetails, packageToSubMap);
                        }
                    }
                    ArraySortedSet allKeys = new ArraySortedSet(100);
                    allKeys.addAll(packageToClassDetails.keySet());
                    allKeys.addAll(packageToSubMap.keySet());
                    HashMap<String, ModularizedPackageEntry> finalPackageMap = new HashMap<String, ModularizedPackageEntry>(allKeys.size());
                    for (String packageName : allKeys) {
                        if (checkInterrupt) {
                            ModularizedJdkJmodLocator.checkInterrupt();
                        }
                        Map classNamesToDetails = (Map)packageToClassDetails.get(packageName);
                        Collection subs = (Collection)packageToSubMap.get(packageName);
                        if ((classNamesToDetails == null || classNamesToDetails.isEmpty()) && (subs == null || subs.isEmpty())) continue;
                        finalPackageMap.put(packageName, new ModularizedPackageEntry(packageName, classNamesToDetails, (Collection<String>)subs));
                    }
                    ArrayList<String> packedModuleNames = new ArrayList<String>(this._moduleNames.size());
                    for (String moduleName : this._moduleNames) {
                        packedModuleNames.add(moduleName);
                    }
                    this._moduleNames = packedModuleNames;
                    this._packageMap = finalPackageMap;
                }
                catch (Exception ex) {
                    if ($assertionsDisabled) break block15;
                    throw new AssertionError();
                }
            }
        }
    }

    @Override
    protected String getUrlLocatorFilePath() {
        return ModularizedJdkJmodLocator.getJmodDirFilePath(this.jmodDir);
    }

    private URL getModuleFileURL(String moduleName) {
        return URLFactory.newURL((URL)this.jmodDir, (String)(moduleName + ".jmod"));
    }

    private URL getModuleRoot(String moduleName) {
        URL url = this.getModuleFileURL(moduleName);
        return URLFactory.newJarURL((URL)url, (String)"classes");
    }

    @Override
    protected boolean isLocal() {
        return URLFileSystem.isLocal((URL)this.jmodDir);
    }

    @Override
    protected byte[] getBytes(String moduleIndex, String className) throws IOException {
        this.buildIndex();
        URL classUrl = this.getExistingClassUrl(moduleIndex, className);
        if (classUrl != null) {
            return FileUtilities.readFile((URL)classUrl);
        }
        return new byte[0];
    }

    @Override
    protected long getLength(String moduleIndex, String className) throws IOException {
        this.buildIndex();
        if ("module-info".equals(className)) {
            URL classUrl = this.getExistingClassUrl(moduleIndex, className);
            if (classUrl != null) {
                return URLFileSystem.getLength((URL)classUrl);
            }
            return -1L;
        }
        return this.getLengthForClass(className.replace('\\', '.').replace('/', '.'));
    }

    private URL getExistingClassUrl(String moduleIndex, String className) {
        String moduleName = this.getModuleName(moduleIndex);
        if (moduleName == null) {
            moduleName = this.getModuleNameOfClass(className.replace('\\', '.').replace('/', '.'));
        }
        if (moduleName != null) {
            URL classUrl = this.getModuleRoot(moduleName);
            return URLFactory.newURL((URL)classUrl, (String)(className + ".class"));
        }
        return null;
    }

    @Override
    public URLPath getClassPath() {
        this.buildIndex();
        URL rootURL = ModularizedJdkURLFileSystemHelper.createDirURL(this.getUrlLocatorFilePath(), this.getLocatorType(), "");
        return rootURL == null ? new URLPath() : new URLPath(rootURL);
    }

    @Override
    protected ModularizedJdkURLFileSystemHelper.LocatorType getLocatorType() {
        return ModularizedJdkURLFileSystemHelper.LocatorType.MOD_LOCATOR;
    }

    @Override
    public URLPath getExpandedClassPath() {
        URL[] jmods;
        URLPath path = new URLPath();
        for (URL jmod : jmods = URLFileSystem.list((URL)this.jmodDir)) {
            if (!URLFileSystem.hasSuffix((URL)jmod, (String)".jmod")) continue;
            URL rootPath = URLFactory.newJarURL((URL)jmod, (String)"classes/");
            path.add(rootPath);
        }
        return path;
    }
}

