/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.parser.java.v2.classfile.ClassFile;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.JarURLClassLocator;
import oracle.jdeveloper.java.util.ClassFileCache;

public class JmodURLClassLocator
extends JarURLClassLocator {
    private boolean hasClassesRoot;

    public JmodURLClassLocator(URL jmodURL, int classType) {
        super(jmodURL, classType);
        this.hasClassesRoot = URLFileSystem.hasSuffix((URL)jmodURL, (String)".jmod!/classes/");
    }

    @Override
    public void getAllClasses(Collection<String> out, final ClassNameFilter filter) {
        int originalSize = out.size();
        ClassNameFilter wrappedFilter = null;
        if (filter != null) {
            wrappedFilter = new ClassNameFilter(){

                @Override
                public boolean acceptClassName(String className, String packagePrefix) {
                    String prefix = JmodURLClassLocator.this.hasClassesRoot ? packagePrefix : (packagePrefix.equals("classes") ? "" : (packagePrefix.startsWith("classes.") ? packagePrefix.substring(8) : packagePrefix));
                    return filter.acceptClassName(className, prefix);
                }

                @Override
                public void setMatchName(String matchName) {
                    filter.setMatchName(matchName);
                }
            };
        }
        super.getAllClasses(out, wrappedFilter);
        this.trimNames(out, originalSize, false);
    }

    @Override
    public void getAllPackages(Collection<String> out, final PackageNameFilter filter) {
        int originalSize = out.size();
        PackageNameFilter wrappedFilter = null;
        if (filter != null) {
            wrappedFilter = new PackageNameFilter(){

                @Override
                public boolean acceptPackageName(String packageName) {
                    String name = JmodURLClassLocator.this.hasClassesRoot ? packageName : (packageName.equals("classes") ? "" : (packageName.startsWith("classes.") ? packageName.substring(8) : packageName));
                    return filter.acceptPackageName(name);
                }

                @Override
                public void setMatchName(String matchName) {
                    filter.setMatchName(matchName);
                }
            };
        }
        super.getAllPackages(out, wrappedFilter);
        this.trimNames(out, originalSize, true);
        Iterator<String> iter = out.iterator();
        while (iter.hasNext()) {
            if (!"".equals(iter.next())) continue;
            iter.remove();
        }
    }

    @Override
    public void getClassesInPackage(String packagePrefix, Collection<String> out) {
        Object prefix = this.hasClassesRoot ? packagePrefix : (packagePrefix.length() == 0 ? "classes" : "classes." + packagePrefix);
        super.getClassesInPackage((String)prefix, out);
    }

    @Override
    public void getPackages(String packagePrefix, Collection<String> out) {
        int originalSize = out.size();
        Object prefix = this.hasClassesRoot ? packagePrefix : (packagePrefix.length() == 0 ? "classes" : "classes." + packagePrefix);
        super.getPackages((String)prefix, out);
        this.trimNames(out, originalSize, true);
    }

    @Override
    public URL getResourceURL(String resourceName) {
        URL url = super.getResourceURL(resourceName);
        if (url != null || this.hasClassesRoot) {
            return url;
        }
        return super.getResourceURL("classes/" + resourceName);
    }

    @Override
    public URL getURL(String fqClassName) {
        URL url = super.getURL(fqClassName);
        if (url != null || this.hasClassesRoot) {
            return url;
        }
        return super.getURL("classes." + fqClassName);
    }

    @Override
    public URL getClassURL(String fqClassName) {
        if (this.isClassTypeLocator()) {
            String prefix = this.hasClassesRoot ? "" : "classes.";
            return super.getClassURL(prefix + fqClassName);
        }
        return null;
    }

    @Override
    public URL getSourceURL(String fqClassName) {
        if (this.isSourceTypeLocator()) {
            return super.getSourceURL(fqClassName);
        }
        return null;
    }

    private void trimNames(Collection<String> names, int originalSize, boolean isPackageNames) {
        if (this.hasClassesRoot) {
            return;
        }
        ArrayList<String> trimmedOut = new ArrayList<String>(names.size());
        int count = 0;
        for (String classOrPackageName : names) {
            if (count++ >= originalSize) {
                if (classOrPackageName.startsWith("classes.")) {
                    classOrPackageName = classOrPackageName.substring(8);
                } else if (isPackageNames && "classes".equals(classOrPackageName)) {
                    classOrPackageName = "";
                }
            }
            trimmedOut.add(classOrPackageName);
        }
        names.clear();
        for (String trimmed : trimmedOut) {
            names.add(trimmed);
        }
    }

    @Override
    public String getModuleNameOfClass(String fqClassName) {
        URL classURL = this.getClassURL(fqClassName);
        return classURL != null ? this.getModuleName() : null;
    }

    @Override
    public Collection<String> getAllModules() {
        ArrayList<String> list = new ArrayList<String>(1);
        String moduleName = this.getModuleName();
        if (moduleName != null) {
            list.add(moduleName);
        }
        return list;
    }

    @Override
    public URL getClassModuleInfoURL(String moduleName) {
        String thisModuleName = this.getModuleName();
        if (thisModuleName == null || !thisModuleName.equals(moduleName)) {
            return null;
        }
        return this.getClassURL("module-info");
    }

    private String getModuleName() {
        ClassFile classFile;
        URL classURL = this.getClassURL("module-info");
        ClassFile classFile2 = classFile = classURL != null ? ClassFileCache.getClassFile(classURL) : null;
        if (classFile != null) {
            return classFile.getModuleName();
        }
        return null;
    }
}

