/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.share.nls;

import java.util.Locale;
import oracle.bali.share.collection.OptimisticHashMap;
import oracle.bali.share.nls.AvailableLocaleMapper;

public class ArrayAvailableLocaleMapper
extends AvailableLocaleMapper {
    private static final Object _NOT_FOUND = new Object();
    private OptimisticHashMap _supportedMap;

    public ArrayAvailableLocaleMapper(Locale[] localeArray) {
        this(localeArray, null);
    }

    public ArrayAvailableLocaleMapper(Locale[] localeArray, Locale locale) {
        super(locale);
        if (localeArray == null) {
            throw new IllegalArgumentException();
        }
        int n = localeArray.length;
        this._supportedMap = new OptimisticHashMap((int)((double)n * 1.5));
        for (int i = 0; i < n; ++i) {
            Locale locale2 = localeArray[i];
            this._supportedMap.put(locale2, locale2);
        }
    }

    @Override
    protected boolean isSupportedLocale(Locale locale) {
        Object object = this._supportedMap.get(locale);
        if (object == null) {
            this._supportedMap.put(locale, _NOT_FOUND);
            return false;
        }
        return _NOT_FOUND != object;
    }
}

