/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.macros.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.macros.MacroDefinition;
import oracle.ideimpl.macros.MacrosArb;
import oracle.ideimpl.macros.Scope;
import oracle.ideimpl.macros.UserMacroHandler;
import oracle.ideimpl.macros.ui.MacroCompletionProvider;
import oracle.javatools.data.HashStructure;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.completion.CompletionPopupHandler;
import oracle.javatools.ui.completion.CompletionProvider;
import oracle.javatools.ui.completion.CompletionTextField;

public class UserDefinedMacrosPanel
extends ProjectSettingsTraversablePanel
implements ActionListener {
    private static final int NAME_COLUMN = 0;
    private static final int DESCRIPTION_COLUMN = 1;
    private static final int VALUE_COLUMN = 2;
    private static final int SCOPE_COLUMN = 3;
    private DefaultTableModel macrosModel;
    private transient List<TransientMacroDefinition> profilesMacros;
    private List<String> macroNames;
    private JTable macrosTable;
    private JButton editButton;
    private JButton newButton;
    private JButton deleteButton;
    private transient TraversableContext traversableContext;
    private static final String[] PROPERTY_KEYS = new String[]{"macro-definitions-list"};
    private MacroTableCellEditor cellEditor;

    public UserDefinedMacrosPanel() {
        this.setHelpID("f1_editrun_user_var_html");
        JLabel macrosLabel = new JLabel();
        this.macrosModel = new DefaultTableModel();
        this.macrosModel.setColumnCount(4);
        this.profilesMacros = new ArrayList<TransientMacroDefinition>();
        this.macroNames = new ArrayList<String>();
        this.macrosTable = new JTable(this.macrosModel);
        this.macrosTable.setTableHeader(null);
        this.macrosTable.setSelectionMode(0);
        this.macrosTable.setShowGrid(false);
        this.cellEditor = new MacroTableCellEditor();
        this.macrosTable.getColumnModel().getColumn(0).setCellEditor(this.cellEditor);
        this.macrosTable.getColumnModel().getColumn(1).setCellEditor(this.cellEditor);
        this.macrosTable.getColumnModel().getColumn(2).setCellEditor(this.cellEditor);
        this.macrosTable.getColumnModel().getColumn(3).setCellEditor(null);
        JScrollPane macrosScrollPane = new JScrollPane(this.macrosTable);
        JViewport viewport = macrosScrollPane.getViewport();
        macrosScrollPane.setOpaque(true);
        viewport.setOpaque(true);
        macrosScrollPane.setBackground(this.macrosTable.getBackground());
        viewport.setBackground(this.macrosTable.getBackground());
        Border border = macrosScrollPane.getBorder();
        if (border == null || border instanceof UIResource) {
            macrosScrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
        }
        macrosScrollPane.setCorner("LOWER_RIGHT_CORNER", new JPanel());
        this.editButton = new JButton(OracleIcons.getIcon((String)"edit.png"));
        this.editButton.setToolTipText(MacrosArb.get("MACRO_DEFINITIONS_EDIT_BUTTON").replace("&", ""));
        this.newButton = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.newButton.setToolTipText(MacrosArb.get("MACRO_DEFINITIONS_NEW_BUTTON").replace("&", ""));
        this.deleteButton = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this.deleteButton.setToolTipText(MacrosArb.get("MACRO_DEFINITIONS_DELETE_BUTTON").replace("&", ""));
        ResourceUtils.resLabel((JLabel)macrosLabel, (Component)this.macrosTable, (String)MacrosArb.get("USER_DEFINED_MACROS"));
        this.macrosTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                UserDefinedMacrosPanel.this.updateButtons();
            }
        });
        this.editButton.addActionListener(this);
        this.newButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        ControlBar toolbar = new ControlBar();
        toolbar.add((Component)this.newButton);
        toolbar.add((Component)this.editButton);
        toolbar.add((Component)this.deleteButton);
        ComponentWithTitlebar titled = new ComponentWithTitlebar((JComponent)macrosScrollPane, macrosLabel, toolbar);
        this.setLayout(new GridBagLayout());
        this.add((Component)titled, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onProjectPanelEntry(TraversableContext tc) {
        Context ideContext;
        this.traversableContext = tc;
        EnumSet<Scope> scopesToShow = UserDefinedMacrosPanel.isEditingSharedProperties((Namespace)tc) ? EnumSet.of(Scope.WORKSPACE, Scope.GLOBAL) : (UserDefinedMacrosPanel.editingUserProperties((Namespace)tc) ? EnumSet.of(Scope.USER, Scope.PROJECT, Scope.WORKSPACE, Scope.GLOBAL) : EnumSet.of(Scope.PROJECT, Scope.WORKSPACE, Scope.GLOBAL));
        UserMacroHandler umh = UserMacroHandler.getInstance();
        List<MacroDefinition> visibleMacros = umh.getUserDefinedMacrosForScopes(ideContext = Context.newIdeContext(), scopesToShow);
        if (visibleMacros != null) {
            this.loadFrom(visibleMacros, true);
        }
        this.updateButtons();
    }

    public void onExit(TraversableContext tc) {
        this.cellEditor.cancelCellEditing();
        this.commitTo(tc);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.cellEditor.cancelCellEditing();
        Object source = e.getSource();
        if (source == this.editButton) {
            this.editMacro();
        } else if (source == this.newButton) {
            this.newMacro();
        } else if (source == this.deleteButton) {
            this.deleteMacro();
        }
    }

    private void loadFrom(List<MacroDefinition> macros, boolean clear) {
        if (clear) {
            this.profilesMacros.clear();
            this.macroNames.clear();
            for (int i = this.macrosModel.getRowCount() - 1; i >= 0; --i) {
                this.macrosModel.removeRow(i);
            }
        }
        for (MacroDefinition def : macros) {
            String name = def.getName();
            this.macrosModel.addRow(new Object[]{def.getName(), def.getDescription(), def.getValue(), def.getScope().name()});
            TransientMacroDefinition tdef = new TransientMacroDefinition(def);
            this.profilesMacros.add(tdef);
            this.macroNames.add(name);
        }
    }

    private void commitTo(TraversableContext tc) {
        ArrayList<MacroDefinition> allMacros = new ArrayList<MacroDefinition>();
        for (TransientMacroDefinition macro : this.profilesMacros) {
            macro.commit();
            allMacros.add(new MacroDefinition(macro.getHash()));
        }
        Context ideContext = Context.newIdeContext();
        ideContext.setBoolean("isEditingSharedProperties", UserDefinedMacrosPanel.isEditingSharedProperties((Namespace)tc));
        ideContext.setBoolean("isEditingUserProperties", UserDefinedMacrosPanel.editingUserProperties((Namespace)tc));
        UserMacroHandler umh = UserMacroHandler.getInstance();
        umh.setUserDefinedMacros(ideContext, allMacros);
    }

    private TransientMacroDefinition getSelectedMacro() {
        int index = this.macrosTable.getSelectionModel().getMinSelectionIndex();
        if (index >= 0 && index < this.profilesMacros.size()) {
            return this.profilesMacros.get(index);
        }
        return null;
    }

    private void updateButtons() {
        TransientMacroDefinition macroDefinition = this.getSelectedMacro();
        boolean macroSelected = macroDefinition != null;
        this.editButton.setEnabled(macroSelected);
        this.deleteButton.setEnabled(macroSelected);
    }

    private void editMacro() {
        TransientMacroDefinition selected = this.getSelectedMacro();
        if (selected != null) {
            boolean allowEditing = true;
            EnumSet<Scope> allowedScopes = null;
            allowedScopes = UserDefinedMacrosPanel.isEditingSharedProperties((Namespace)this.traversableContext) ? EnumSet.of(Scope.WORKSPACE, Scope.GLOBAL) : (UserDefinedMacrosPanel.editingUserProperties((Namespace)this.traversableContext) ? EnumSet.of(Scope.USER, Scope.PROJECT, Scope.WORKSPACE, Scope.GLOBAL) : EnumSet.of(Scope.PROJECT, Scope.WORKSPACE, Scope.GLOBAL));
            this.editMacroDefinition(selected, allowedScopes, allowEditing);
            this.updateButtons();
        }
    }

    private void editMacroDefinition(TransientMacroDefinition macroDefinition, EnumSet<Scope> allowedScopes, boolean allowEdit) {
        TreeSet<String> usedNames = new TreeSet<String>();
        usedNames.addAll(this.macroNames);
        MacroDefinitionDialog editMacroDialog = new MacroDefinitionDialog(macroDefinition.getName(), usedNames, allowedScopes, allowEdit);
        editMacroDialog.showEditDialog(macroDefinition);
        int row = this.macrosTable.getSelectionModel().getMinSelectionIndex();
        this.macrosModel.setValueAt(macroDefinition.getName(), row, 0);
        this.macrosModel.setValueAt(macroDefinition.getDescription(), row, 1);
        this.macrosModel.setValueAt(macroDefinition.getValue(), row, 2);
        this.macrosModel.setValueAt(macroDefinition.getScope().name(), row, 3);
    }

    private void newMacro() {
        TreeSet<String> usedNames = new TreeSet<String>();
        for (int i = this.macroNames.size() - 1; i >= 0; --i) {
            usedNames.add(this.macroNames.get(i));
        }
        EnumSet<Scope> allowedScopes = null;
        allowedScopes = UserDefinedMacrosPanel.isEditingSharedProperties((Namespace)this.traversableContext) ? EnumSet.of(Scope.WORKSPACE, Scope.GLOBAL) : (UserDefinedMacrosPanel.editingUserProperties((Namespace)this.traversableContext) ? EnumSet.of(Scope.USER, Scope.PROJECT, Scope.WORKSPACE, Scope.GLOBAL) : EnumSet.of(Scope.PROJECT, Scope.WORKSPACE, Scope.GLOBAL));
        MacroDefinitionDialog newDialog = new MacroDefinitionDialog(null, usedNames, allowedScopes, true);
        String name = newDialog.showNewDialog();
        if (name != null) {
            String profileName;
            int insertRow;
            TransientMacroDefinition newMacroDefinition = new TransientMacroDefinition(name);
            newMacroDefinition.setQualifier("user");
            newMacroDefinition.setDescription(newDialog.getDescription());
            newMacroDefinition.setValue(newDialog.getValue());
            newMacroDefinition.setScope(newDialog.getScope());
            newMacroDefinition.setIsLocation(newDialog.getIsLocation());
            newMacroDefinition.setCustom(UserDefinedMacrosPanel.editingUserProperties((Namespace)this.traversableContext));
            name = newMacroDefinition.getName();
            for (insertRow = 0; insertRow < this.macroNames.size() && (profileName = this.macroNames.get(insertRow)).compareTo(name) <= 0; ++insertRow) {
            }
            if (insertRow < this.macroNames.size()) {
                this.macrosModel.insertRow(insertRow, new Object[]{newMacroDefinition.getName(), newMacroDefinition.getDescription(), newMacroDefinition.getValue(), newMacroDefinition.getScope().name()});
                this.profilesMacros.add(insertRow, newMacroDefinition);
                this.macroNames.add(insertRow, newMacroDefinition.getName());
            } else {
                this.macrosModel.addRow(new Object[]{newMacroDefinition.getName(), newMacroDefinition.getDescription(), newMacroDefinition.getValue(), newMacroDefinition.getScope().name()});
                this.profilesMacros.add(newMacroDefinition);
                this.macroNames.add(newMacroDefinition.getName());
            }
            this.macrosTable.getSelectionModel().setSelectionInterval(insertRow, insertRow);
            this.updateButtons();
        }
    }

    private void deleteMacro() {
        int index = this.macrosTable.getSelectionModel().getMinSelectionIndex();
        if (index != -1) {
            this.macrosModel.removeRow(index);
            this.profilesMacros.remove(index);
            this.macroNames.remove(index);
            if (index >= this.macrosModel.getRowCount()) {
                --index;
            }
            this.macrosTable.getSelectionModel().setSelectionInterval(index, index);
            this.updateButtons();
        }
    }

    public String getDataKey() {
        return "oracle.ideimpl.macros.MacroDefinition";
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    private class MacroTableCellEditor
    extends DefaultCellEditor {
        private transient Object currentValue;
        private boolean editing;
        private int column;

        MacroTableCellEditor() {
            super(new JTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currentValue = value;
            this.editing = true;
            this.column = column;
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            if (!this.editing) {
                return true;
            }
            String newValue = this.getCellEditorValue().toString().trim();
            if (newValue.equals(this.currentValue.toString())) {
                return false;
            }
            TransientMacroDefinition currentMacro = UserDefinedMacrosPanel.this.getSelectedMacro();
            switch (this.column) {
                case 0: {
                    if (newValue.length() <= 0) {
                        MessageDialog.error((Component)((Object)UserDefinedMacrosPanel.this), (Object)MacrosArb.get("EDIT_MACRO_NAME_IS_REQUIRED"), (String)MacrosArb.get("EDIT_MACRO_ERROR_TITLE"), null);
                        this.delegate.setValue(this.currentValue);
                        this.editing = true;
                        return true;
                    }
                    if (UserDefinedMacrosPanel.this.macroNames.contains(newValue)) {
                        MessageDialog.error((Component)((Object)UserDefinedMacrosPanel.this), (Object)MacrosArb.get("NEW_MACRO_NAME_DUPLICATE_MESSAGE"), (String)MacrosArb.get("NEW_MACRO_NAME_DUPLICATE_TITLE"), null);
                        this.delegate.setValue(this.currentValue);
                        this.editing = true;
                        return true;
                    }
                    UserDefinedMacrosPanel.this.macroNames.remove(this.currentValue);
                    UserDefinedMacrosPanel.this.macroNames.add(newValue);
                    currentMacro.setName(newValue);
                    break;
                }
                case 1: {
                    currentMacro.setDescription(newValue);
                    break;
                }
                case 2: {
                    if (newValue.length() <= 0) {
                        MessageDialog.error((Component)((Object)UserDefinedMacrosPanel.this), (Object)MacrosArb.get("EDIT_MACRO_VALUE_IS_REQUIRED"), (String)MacrosArb.get("EDIT_MACRO_ERROR_TITLE"), null);
                        this.delegate.setValue(this.currentValue);
                        this.editing = true;
                        return true;
                    }
                    currentMacro.setValue(newValue);
                }
            }
            this.editing = false;
            return super.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            if (this.editing) {
                this.editing = false;
                super.cancelCellEditing();
            }
        }
    }

    class TransientMacroDefinition {
        private MacroDefinition persistentVersion;
        private String qualifier;
        private String name;
        private String description;
        private String value;
        private Scope scope;
        private boolean isLocation;
        private boolean isCustom;
        private HashStructure _hash;

        TransientMacroDefinition(MacroDefinition md) {
            this.qualifier = md.getQualifier();
            this.name = md.getName();
            this.description = md.getDescription();
            this.value = md.getValue();
            this.scope = md.getScope();
            this.isLocation = md.isLocation();
            this.isCustom = md.isCustom();
            this.persistentVersion = md;
            this._hash = md.getHash();
        }

        TransientMacroDefinition(String name) {
            this.name = name;
            this._hash = null;
        }

        public void commit() {
            if (this._hash == null) {
                this.persistentVersion = new MacroDefinition(this.name);
                this._hash = this.persistentVersion.getHash();
            }
            this.persistentVersion.setQualifier(this.qualifier);
            this.persistentVersion.setName(this.name);
            this.persistentVersion.setDescription(this.description);
            this.persistentVersion.setValue(this.value);
            this.persistentVersion.setScope(this.scope);
            this.persistentVersion.setIsLocation(this.isLocation);
            this.persistentVersion.setCustom(this.isCustom);
        }

        private String getName() {
            return this.name;
        }

        private String getDescription() {
            return this.description;
        }

        private String getValue() {
            return this.value;
        }

        private Scope getScope() {
            return this.scope;
        }

        private boolean isLocation() {
            return this.isLocation;
        }

        private boolean isCustom() {
            return this.isCustom;
        }

        private HashStructure getHash() {
            return this._hash;
        }

        private void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        private void setName(String name) {
            this.name = name;
        }

        private void setDescription(String description) {
            this.description = description;
        }

        private void setValue(String value) {
            this.value = value;
        }

        private void setScope(Scope scope) {
            this.scope = scope;
        }

        private void setIsLocation(boolean isLocation) {
            this.isLocation = isLocation;
        }

        private void setCustom(boolean isCustom) {
            this.isCustom = isCustom;
        }
    }

    class MacroDefinitionDialog
    extends JPanel
    implements DocumentListener {
        private JTextField nameTextField;
        private JTextField descriptionTextField;
        private CompletionTextField valueTextField;
        private JComboBox<String> scopeCombo;
        private JCheckBox isLocation;
        private EnumSet<Scope> allowedScopes;
        private JEWTDialog dlg;
        private Set usedNames;
        private boolean allowEdit;

        MacroDefinitionDialog(String name, Set usedNames, EnumSet<Scope> allowedScopes, boolean allowEdit) {
            super(new GridBagLayout());
            this.usedNames = usedNames;
            this.allowedScopes = allowedScopes;
            this.allowEdit = allowEdit;
            if (name != null && this.usedNames.contains(name)) {
                this.usedNames.remove(name);
            }
            JLabel nameLabel = new JLabel();
            this.nameTextField = new JTextField();
            JLabel descriptionLabel = new JLabel();
            this.descriptionTextField = new JTextField();
            JLabel valueLabel = new JLabel();
            this.valueTextField = new CompletionTextField();
            CompletionPopupHandler popupHandler = this.valueTextField.getPopupHandler();
            Context context = Context.newIdeContext();
            MacroCompletionProvider macroCompletionProvider = new MacroCompletionProvider(context);
            popupHandler.registerInsightProvider((CompletionProvider)macroCompletionProvider);
            JLabel scopeLabel = new JLabel();
            this.scopeCombo = new JComboBox();
            this.isLocation = new JCheckBox();
            if (allowedScopes.contains((Object)Scope.USER)) {
                this.scopeCombo.addItem(MacrosArb.get("MACRO_SCOPE_USER"));
            }
            if (allowedScopes.contains((Object)Scope.PROJECT)) {
                this.scopeCombo.addItem(MacrosArb.get("MACRO_SCOPE_PROJECT"));
            }
            if (allowedScopes.contains((Object)Scope.WORKSPACE)) {
                this.scopeCombo.addItem(MacrosArb.get("MACRO_SCOPE_WORKSPACE"));
            }
            if (allowedScopes.contains((Object)Scope.GLOBAL)) {
                this.scopeCombo.addItem(MacrosArb.get("MACRO_SCOPE_GLOBAL"));
            }
            this.scopeCombo.setSelectedIndex(0);
            ResourceUtils.resLabel((JLabel)nameLabel, (Component)this.nameTextField, (String)MacrosArb.get("EDIT_MACRO_DEF_NAME_LABEL"));
            ResourceUtils.resLabel((JLabel)descriptionLabel, (Component)this.descriptionTextField, (String)MacrosArb.get("EDIT_MACRO_DEF_DESCRIPTION_LABEL"));
            ResourceUtils.resLabel((JLabel)valueLabel, (Component)this.valueTextField, (String)MacrosArb.get("EDIT_MACRO_DEF_VALUE_LABEL"));
            ResourceUtils.resButton((AbstractButton)this.isLocation, (String)MacrosArb.get("MACRO_PATH_EXPRESSION_CHECKBOX_LABEL"));
            this.nameTextField.getDocument().addDocumentListener(this);
            this.descriptionTextField.getDocument().addDocumentListener(this);
            this.valueTextField.getDocument().addDocumentListener(this);
            this.nameTextField.setEnabled(allowEdit);
            this.descriptionTextField.setEnabled(allowEdit);
            this.valueTextField.setEnabled(allowEdit);
            this.isLocation.setEnabled(allowEdit);
            int y = 0;
            this.add((Component)nameLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.nameTextField, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 5), 0, 0));
            this.add((Component)descriptionLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.descriptionTextField, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 5), 0, 0));
            this.add((Component)valueLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.valueTextField, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 5), 0, 0));
            this.add((Component)scopeLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add(this.scopeCombo, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 5), 0, 0));
            this.add((Component)this.isLocation, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)new JLabel(), new GridBagConstraints(0, y, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        String showNewDialog() {
            String title = MacrosArb.get("NEW_MACRO_DIALOG_TITLE");
            JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)this, (Component)this.nameTextField, (String)title);
            this.setJEWTDialog(dlg);
            dlg.setOKButtonEnabled(this.canOk());
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_editrun_new_userdef_macro_html");
            if (WizardLauncher.runDialog((JDialog)dlg)) {
                return this.getNewName();
            }
            return null;
        }

        void showEditDialog(TransientMacroDefinition macroDef) {
            String title = MacrosArb.get("EDIT_MACRO_DIALOG_TITLE");
            JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)this, (Component)this.nameTextField, (String)title);
            this.setJEWTDialog(dlg);
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_editrun_edit_userdef_macro_html");
            this.nameTextField.setText(macroDef.getName());
            this.descriptionTextField.setText(macroDef.getDescription());
            this.valueTextField.setText(macroDef.getValue());
            this.isLocation.setSelected(macroDef.isLocation());
            switch (macroDef.getScope()) {
                case PROJECT: {
                    this.scopeCombo.setSelectedItem(MacrosArb.get("MACRO_SCOPE_PROJECT"));
                    break;
                }
                case WORKSPACE: {
                    this.scopeCombo.setSelectedItem(MacrosArb.get("MACRO_SCOPE_WORKSPACE"));
                    break;
                }
                case GLOBAL: {
                    this.scopeCombo.setSelectedItem(MacrosArb.get("MACRO_SCOPE_GLOBAL"));
                    break;
                }
                case USER: {
                    this.scopeCombo.setSelectedItem(MacrosArb.get("MACRO_SCOPE_USER"));
                }
            }
            dlg.setOKButtonEnabled(this.canOk());
            if (WizardLauncher.runDialog((JDialog)dlg)) {
                macroDef.setName(this.nameTextField.getText());
                macroDef.setDescription(this.descriptionTextField.getText());
                macroDef.setValue(this.valueTextField.getText());
                macroDef.setScope(this.getScope());
                macroDef.setIsLocation(this.isLocation.isSelected());
                return;
            }
        }

        String getDescription() {
            return this.descriptionTextField.getText();
        }

        String getValue() {
            return this.valueTextField.getText();
        }

        boolean getIsLocation() {
            return this.isLocation.isSelected();
        }

        Scope getScope() {
            if (this.scopeCombo.getSelectedItem().equals(MacrosArb.get("MACRO_SCOPE_PROJECT"))) {
                return Scope.PROJECT;
            }
            if (this.scopeCombo.getSelectedItem().equals(MacrosArb.get("MACRO_SCOPE_WORKSPACE"))) {
                return Scope.WORKSPACE;
            }
            if (this.scopeCombo.getSelectedItem().equals(MacrosArb.get("MACRO_SCOPE_GLOBAL"))) {
                return Scope.GLOBAL;
            }
            if (this.scopeCombo.getSelectedItem().equals(MacrosArb.get("MACRO_SCOPE_USER"))) {
                return Scope.USER;
            }
            return Scope.PROJECT;
        }

        private void setJEWTDialog(JEWTDialog dlg) {
            this.dlg = dlg;
            dlg.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt) && MacroDefinitionDialog.this.veto()) {
                        throw new PropertyVetoException("no", evt);
                    }
                }
            });
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            this.dlg.setOKButtonEnabled(this.canOk());
        }

        private boolean canOk() {
            return this.nameTextField.getText().length() > 0 && this.valueTextField.getText().length() > 0;
        }

        private boolean veto() {
            String name = this.nameTextField.getText();
            if (this.usedNames.contains(name)) {
                MessageDialog.error((Component)this, (Object)MacrosArb.format("NEW_MACRO_NAME_DUPLICATE_MESSAGE", name), (String)MacrosArb.format("NEW_MACRO_NAME_DUPLICATE_TITLE", this.dlg.getTitle()), null);
                return true;
            }
            return false;
        }

        private String getNewName() {
            return this.nameTextField.getText();
        }
    }
}

