/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.wiz;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.LayerUI;
import javax.swing.table.TableModel;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.EmptyTableTextLayer;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.GenericTablePersistentSettings;
import oracle.jdeveloper.vcs.vop.DisplayProperty;
import oracle.jdevimpl.vcs.git.GITDisplayProperty;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.wiz.GITRemoteBranchTableModel;
import org.netbeans.libs.git.GitBranch;

public class GITCloneBranchPanel
extends DefaultTraversablePanel {
    private static final String BRANCH_KEY = "git-clone-branch-table";
    private static final String F1_HELP_ID = "f1_git_clone_wizard_3_html";
    private static final String DEFAULT_BRANCH = "master";
    private JMultiLineLabel _hintText = new JMultiLineLabel();
    private SearchControl _search = new SearchControl();
    private GenericTable _tableBranches = new GenericTable();
    private JButton _btnSelect = new JButton();
    private JButton _btnDeselect = new JButton();
    private Map<String, GitBranch> _branches = Collections.emptyMap();
    private Collection<String> _checkedBranches = new HashSet<String>();
    private EmptyTableTextLayer _emptyBranchTable;

    public GITCloneBranchPanel() {
        this.init();
        this.addListeners();
        this.setHelpID(F1_HELP_ID);
    }

    private void init() {
        Insets ins = new Insets(5, 5, 5, 5);
        this._tableBranches.setModel((TableModel)new GITRemoteBranchTableModel(this.getDisplayProperties()));
        this._hintText.setText(Resource.get("WZ_CLONE_BRANCH_HINT"));
        this._emptyBranchTable = new EmptyTableTextLayer((JTable)this._tableBranches, Resource.get("CLONE_EMPTY_NO_BRANCH"));
        JScrollPane scrollpane = new JScrollPane((Component)this._tableBranches);
        JLayer<JScrollPane> layer = new JLayer<JScrollPane>(scrollpane, (LayerUI<JScrollPane>)this._emptyBranchTable);
        ResourceUtils.resButton((AbstractButton)this._btnSelect, (String)Resource.get("BRANCH_SELECT_ALL"));
        ResourceUtils.resButton((AbstractButton)this._btnDeselect, (String)Resource.get("BRANCH_DESELECT_ALL"));
        this._tableBranches.setAutoResizeMode(3);
        this.autoSizeCoumnstoFit((GITRemoteBranchTableModel)this._tableBranches.getModel());
        this.setLayout(new GridBagLayout());
        this.add((Component)this._hintText, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)this._search.getUI(), new GridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 17, 2, ins, 0, 0));
        this.add(layer, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 17, 1, ins, 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add(this._btnSelect, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add(this._btnDeselect, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
    }

    private void autoSizeCoumnstoFit(GITRemoteBranchTableModel model) {
        Object[] prototypeValues = new Object[model.getColumnCount()];
        for (int i = 0; i < prototypeValues.length; ++i) {
            prototypeValues[i] = model.getProperty(i).getPrototypeValue();
        }
        this._tableBranches.autoSizeColumnsToFit(prototypeValues);
    }

    private DisplayProperty[] getDisplayProperties() {
        DisplayProperty[] props = new DisplayProperty[]{new GITDisplayProperty(Resource.get("WZ_CLONE_BRANCH_COLUMN1"), null, 0, Boolean.FALSE, null, Boolean.class, 80, true), new GITDisplayProperty(Resource.get("WZ_CLONE_BRANCH_COLUMN2"), null, 2, " a very long branch name that may be used in a clone operation ", null, String.class, 200, false)};
        return props;
    }

    public void onEntry(TraversableContext dataContext) {
        if (dataContext.getDirection() == 1) {
            this._branches = (Map)dataContext.get("git.remote-branches");
            ((GITRemoteBranchTableModel)this._tableBranches.getModel()).addData(this._branches.keySet(), DEFAULT_BRANCH, Collections.emptyList());
            this._tableBranches.setSortColumn(1, true);
            this._checkedBranches.addAll(((GITRemoteBranchTableModel)this._tableBranches.getModel()).getIncludeBranches());
        }
        WizardCallbacks callbacks = dataContext.getWizardCallbacks();
        callbacks.wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        dataContext.setWizardCallbacks(callbacks);
        Map settings = (Map)Ide.getDTCache().getData(BRANCH_KEY);
        if (settings != null) {
            this._tableBranches.setPersistentSettings(new GenericTablePersistentSettings(settings));
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        if (dataContext.getDirection() == 1) {
            Collection<String> branches = ((GITRemoteBranchTableModel)this._tableBranches.getModel()).getIncludeBranches();
            int nbranches = ((GITRemoteBranchTableModel)this._tableBranches.getModel()).getRowCount();
            if (branches.isEmpty() && nbranches > 0) {
                throw new TraversalException(Resource.get("WZ_NO_BRANCH"), Resource.get("WZ_NO_BRANCH_TITLE"));
            }
            dataContext.put("git.use-branches", branches);
            GenericTablePersistentSettings settings = this._tableBranches.getPersistentSettings();
            Ide.getDTCache().putData(BRANCH_KEY, settings.toMap());
        }
    }

    private void addListeners() {
        this._btnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GITCloneBranchPanel.this.selectAllBranches(true);
            }
        });
        this._btnDeselect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GITCloneBranchPanel.this.selectAllBranches(false);
            }
        });
        this._tableBranches.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getColumn() == 0) {
                    Boolean inc = (Boolean)((GITRemoteBranchTableModel)e.getSource()).getValueAt(e.getFirstRow(), 0);
                    String branch = (String)((GITRemoteBranchTableModel)e.getSource()).getValueAt(e.getFirstRow(), 1);
                    if (inc.booleanValue()) {
                        GITCloneBranchPanel.this._checkedBranches.add(branch);
                    } else {
                        GITCloneBranchPanel.this._checkedBranches.remove(branch);
                    }
                }
            }
        });
    }

    private void selectAllBranches(boolean enable) {
        TableModel model = this._tableBranches.getModel();
        for (int r = 0; r < model.getRowCount(); ++r) {
            model.setValueAt(enable, r, 0);
        }
    }

    private class SearchControl {
        private SearchField _search;

        private SearchControl() {
        }

        SearchField getUI() {
            if (this._search == null) {
                this.initSearch();
            }
            return this._search;
        }

        private void initSearch() {
            this._search = new SearchField();
            this._search.setPrompt(Resource.get("BRANCH_SEARCH"));
            this._search.setStyle(SearchField.Style.FILTER);
            this._search.addSearchListener(new SearchListener(){

                public void searchPerformed(SearchEvent se) {
                    String txt = se.getSearchText();
                    if (txt.isEmpty()) {
                        this.restoreTable();
                        return;
                    }
                    this.filterBranch(txt);
                }

                public void searchCategoryChanged(SearchEvent se) {
                }

                private void filterBranch(String txt) {
                    GITRemoteBranchTableModel model = (GITRemoteBranchTableModel)GITCloneBranchPanel.this._tableBranches.getModel();
                    Set<String> matching = GITCloneBranchPanel.this._branches.keySet().stream().filter(item -> item.contains(txt)).collect(Collectors.toSet());
                    model.removeAll();
                    model.addData(matching, "", GITCloneBranchPanel.this._checkedBranches);
                    if (matching.isEmpty()) {
                        GITCloneBranchPanel.this._emptyBranchTable.setText(Resource.get("NO_BRANCH_SEARCH"));
                    }
                }

                private void restoreTable() {
                    GITRemoteBranchTableModel model = (GITRemoteBranchTableModel)GITCloneBranchPanel.this._tableBranches.getModel();
                    model.removeAll();
                    model.addData(GITCloneBranchPanel.this._branches.keySet(), "", GITCloneBranchPanel.this._checkedBranches);
                }
            });
        }
    }
}

