/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdevimpl.vcs.git.GITIgnore;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.res.Resource;

public class GITRemovePanel
extends JPanel {
    private JLabel _lblFile = new JLabel();
    private JComboBox _cmbFile;
    private JTextArea _txtPatterns = new JTextArea();
    private URL _url;
    private Map<VCSHashURL, Collection<String>> _urlIgnorePattern = new HashMap<VCSHashURL, Collection<String>>();
    private Collection<VCSHashURL> _modified = new ArrayList<VCSHashURL>();

    public GITRemovePanel(URL url) {
        super(new GridBagLayout());
        this._url = url;
        this.initialize();
        this.layoutComponent();
        this.initListeners();
    }

    public Map<VCSHashURL, Collection<String>> getUpdatedPatterns() {
        this.recordIgnorePattern((VCSHashURL)this._cmbFile.getModel().getSelectedItem());
        if (this._modified.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<VCSHashURL, Collection<String>> updated = new HashMap<VCSHashURL, Collection<String>>();
        for (VCSHashURL url : this._modified) {
            updated.put(url, this._urlIgnorePattern.get(url));
        }
        return updated;
    }

    private void layoutComponent() {
        Insets insets = new Insets(5, 5, 5, 5);
        this.add((Component)this._lblFile, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._cmbFile, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)new JScrollPane(this._txtPatterns), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, insets, 0, 0));
    }

    private void initialize() {
        VCSHashURL hIg;
        URL ignore;
        ResourceUtils.resLabel((JLabel)this._lblFile, (Component)this._cmbFile, (String)Resource.get("IGNORE_RM_LABEL"));
        IgnoreComboModel model = new IgnoreComboModel();
        this._cmbFile = new JComboBox(model);
        this._cmbFile.setRenderer(new IgnoreFileRender());
        this._txtPatterns.setLineWrap(false);
        this._txtPatterns.setRows(10);
        URL root = GITUtil.getRootContaining(this._url);
        URL parent = this._url;
        VCSHashURL selectURL = null;
        while (!root.equals(parent)) {
            ignore = URLFactory.newURL((URL)parent, (String)".gitignore");
            if (URLFileSystem.exists((URL)ignore)) {
                hIg = new VCSHashURL(ignore);
                model.addElement(hIg);
                if (selectURL == null) {
                    selectURL = hIg;
                }
            }
            parent = URLFileSystem.getParent((URL)parent);
        }
        ignore = URLFactory.newURL((URL)root, (String)".gitignore");
        if (URLFileSystem.exists((URL)ignore)) {
            hIg = new VCSHashURL(ignore);
            if (selectURL == null) {
                selectURL = hIg;
            }
            model.addElement(hIg);
        }
        this.updateIgnorePattern(selectURL);
    }

    private void initListeners() {
        this._cmbFile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object obj = GITRemovePanel.this._cmbFile.getModel().getSelectedItem();
                if (e.getStateChange() == 1) {
                    GITRemovePanel.this.updateIgnorePattern((VCSHashURL)GITRemovePanel.this._cmbFile.getModel().getSelectedItem());
                } else if (e.getStateChange() == 2) {
                    GITRemovePanel.this.recordIgnorePattern((VCSHashURL)e.getItem());
                }
            }
        });
    }

    public Component getInitialFocusComponent() {
        return this._cmbFile;
    }

    private void recordIgnorePattern(VCSHashURL url) {
        String[] patterns = this._txtPatterns.getText().split("\n");
        Collection<String> existPatterns = this._urlIgnorePattern.get(url);
        boolean diff = true;
        if (existPatterns.size() == patterns.length) {
            for (String pattern : patterns) {
                if (!existPatterns.contains(pattern.trim())) break;
            }
            diff = false;
        }
        if (diff) {
            existPatterns.clear();
            for (String pattern : patterns) {
                existPatterns.add(pattern.trim());
            }
            this._modified.add(url);
        }
    }

    private void updateIgnorePattern(VCSHashURL url) {
        Collection<String> patterns = this._urlIgnorePattern.get(url);
        if (patterns == null) {
            GITIgnore ignore = new GITIgnore();
            try {
                patterns = ignore.getIgnorePatterns(url.getURL());
                this._urlIgnorePattern.put(url, patterns);
            }
            catch (GITProcessException e) {
                VCSExceptionHandler handler = new VCSExceptionHandler();
                handler.handleException((Exception)((Object)e));
            }
        }
        this._txtPatterns.setText("");
        for (String pattern : patterns) {
            this._txtPatterns.append(pattern);
            this._txtPatterns.append("\n");
        }
    }

    private static class IgnoreComboModel
    extends DefaultComboBoxModel {
        private IgnoreComboModel() {
        }
    }

    private static class IgnoreFileRender
    extends DefaultListCellRenderer {
        private IgnoreFileRender() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String path = URLFileSystem.getPlatformPathName((URL)((VCSHashURL)value).getURL());
            return super.getListCellRendererComponent((JList<?>)list, path, index, isSelected, cellHasFocus);
        }
    }
}

