/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.merge;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.compare.InputStreamTextContributor;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.merge.BaseTextMergeEditor;
import oracle.jdeveloper.merge.MergeContext;
import oracle.jdeveloper.merge.MergeEngine;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;

public class GITMergeEditor
extends BaseTextMergeEditor {
    private static String SEARCH = ">>>>>>>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeMergeContextCS(Context context) throws Exception {
        URL url = this.getRealURL();
        String type = this.getSuffixAsType(url);
        Collection<File> files = GITUtil.convertURLToFile(new URL[]{url});
        String extrevision = this.getExternalRevision(files.toArray(new File[0])[0]);
        if (extrevision == null) {
            MergeContext.setClientSideMerge((Context)context, (boolean)false);
            return;
        }
        String charsetName = StreamDecoder.getDefaultEncoding((URL)url);
        String resourceName = URLFileSystem.getFileName((URL)url);
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("catFile");
        GitClient client = null;
        ByteArrayOutputStream externalOS = null;
        ByteArrayOutputStream ancestorOS = null;
        ByteArrayOutputStream userOS = null;
        try {
            client = GITClientAdaptor.getClient(url);
            externalOS = new ByteArrayOutputStream();
            if (!client.catFile(files.toArray(new File[0])[0], extrevision, externalOS, monitor)) {
                MergeContext.setClientSideMerge((Context)context, (boolean)false);
                return;
            }
            InputStreamTextContributor contributor = new InputStreamTextContributor((InputStream)new ByteArrayInputStream(externalOS.toByteArray()), charsetName, extrevision, extrevision, type);
            contributor.setType(type);
            MergeContext.setFirstContributor((Context)context, (CompareContributor)contributor);
            String[] revisions = new String[]{"HEAD", extrevision};
            GitRevisionInfo info = client.getCommonAncestor(revisions, monitor);
            ancestorOS = new ByteArrayOutputStream();
            if (info == null || !client.catFile(files.toArray(new File[0])[0], info.getRevision(), ancestorOS, monitor)) {
                MergeContext.setClientSideMerge((Context)context, (boolean)false);
                return;
            }
            contributor = new InputStreamTextContributor((InputStream)new ByteArrayInputStream(ancestorOS.toByteArray()), charsetName, "", "", type);
            contributor.setType(type);
            MergeContext.setAncestorContributor((Context)context, (CompareContributor)contributor);
            userOS = new ByteArrayOutputStream();
            if (!client.catFile(files.toArray(new File[0])[0], "HEAD", userOS, monitor)) {
                MergeContext.setClientSideMerge((Context)context, (boolean)false);
                return;
            }
            contributor = new InputStreamTextContributor((InputStream)new ByteArrayInputStream(userOS.toByteArray()), charsetName, resourceName, resourceName, type);
            contributor.setType(type);
            MergeContext.setSecondContributor((Context)context, (CompareContributor)contributor);
            MergeContext.setMergeEngine((Context)context, (MergeEngine)MergeEngine.getInstance());
        }
        catch (GitException.MissingObjectException ex) {
            GITProfile.getQualifiedLogger(GITMergeEditor.class.getName()).warning("Unable to get file content " + ex.getMessage());
            MergeContext.setClientSideMerge((Context)context, (boolean)false);
        }
        finally {
            if (ancestorOS != null) {
                ancestorOS.close();
            }
            if (externalOS != null) {
                externalOS.close();
            }
            if (userOS != null) {
                userOS.close();
            }
            if (client != null) {
                client.release();
            }
        }
    }

    protected boolean getClientSideMergeSetting() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveMergeStatus(URL url) {
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(url);
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("add");
            Collection<File> files = GITUtil.convertURLToFile(new URL[]{url});
            client.add(files.toArray(new File[0]), monitor);
            if (monitor.getError() != null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)monitor.getError(), (String)Resource.get("MERGE_ERROR_TITLE"), null);
            }
            VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
            profile.getPolicyStatusCache().clear(url);
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITMergeEditor.class.getName()).warning(e.getMessage());
            new VCSExceptionHandler().handleException((Exception)((Object)new GITProcessException(Resource.format("MERGE_ERROR_RESOLVE", URLFileSystem.getPlatformPathName((URL)url)), e.getMessage())), (Component)Ide.getMainWindow());
            FeedbackManager.reportException((Throwable)e);
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getExternalRevision(File file) {
        String string;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            while (true) {
                String line;
                if ((line = reader.readLine()) != null) {
                    if (!line.startsWith(SEARCH)) continue;
                    String[] split = line.split(" ");
                    if (split.length != 2) continue;
                    String string2 = split[1];
                    return string2;
                    continue;
                }
                break;
            }
        }
        catch (FileNotFoundException e) {
            GITProfile.getQualifiedLogger(GITMergeEditor.class.getName()).warning("Failed to open " + file.getPath() + " " + e.getCause());
            string = null;
            return string;
        }
        catch (IOException e) {
            GITProfile.getQualifiedLogger(GITMergeEditor.class.getName()).warning("Failed to open " + file.getPath() + " " + e.getCause());
            string = null;
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

