/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.api;

import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.spi.VCSCancelException;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.spi.VCSDockableViewRegistry;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.util.VCSIgnoreFilters;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITConnection;
import oracle.jdevimpl.vcs.git.GITConnectionManager;
import oracle.jdevimpl.vcs.git.GITPostUpdate;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.commithistory.GITCommitVersionDockableWindow;
import oracle.jdevimpl.vcs.git.imp.GITImport;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.wiz.GITCloneWizard;
import oracle.jdevimpl.vcs.git.wiz.GITPullWizard;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.progress.ProgressMonitor;

public final class GITExtension {
    private VCSExceptionHandler _exceptionHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRemoteLocation(URL url) {
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(url);
            if (client == null) {
                String string = null;
                return string;
            }
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("remote");
            Map<String, GitRemoteConfig> config = client.getRemotes(monitor);
            for (String key : config.keySet()) {
                GitRemoteConfig remConfig = config.get(key);
                if (remConfig.getUris().isEmpty()) continue;
                String string = remConfig.getUris().get(0);
                return string;
            }
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITExtension.class.getName()).warning(e.getMessage());
            this.getExceptionHandler().handleException((Exception)e, (Component)VCSWindowUtils.getCurrentWindow());
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return null;
    }

    public boolean showHistory(File root, final String commitId) {
        final URL rurl = URLFactory.newDirURL((File)root);
        if (!this.isExist(root, commitId)) {
            boolean ans = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)Resource.format("HISTORY_COMMIT_NOT_EXIST", GITUtil.shortCommitId(commitId)), (String)Resource.get("HISTORY_COMMIT_NOT_EXIST_TITLE"), null);
            if (ans) {
                try {
                    GITPostUpdate update = new GITPostUpdate(){

                        @Override
                        public void postUpdate() {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    GITExtension.this.showHistory(commitId, rurl);
                                }
                            });
                        }
                    };
                    GITPullWizard wizard = new GITPullWizard(update);
                    Node node = NodeFactory.findOrCreate((URL)rurl);
                    Context context = Context.newIdeContext((Node)node);
                    wizard.runWizard((Component)Ide.getMainWindow(), context);
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
        return this.showHistory(commitId, rurl);
    }

    private boolean showHistory(String commitId, URL rurl) {
        VCSDockableViewRegistry.showDockableView((String)"GIT-Commit-Version");
        Dockable dockable = DockStation.getDockStation().findDockable(new ViewId("GIT-Commit-Version"));
        if (dockable != null) {
            ((GITCommitVersionDockableWindow)dockable).update(rurl, commitId);
            return true;
        }
        return false;
    }

    public File cloneRepository(String reposUrl, String user, char[] passwd) {
        GITCloneWizard wizard = new GITCloneWizard();
        try {
            URL dest = wizard.runWizard((Component)Ide.getMainWindow(), reposUrl, user, passwd);
            if (dest != null) {
                return new File(dest.toURI());
            }
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException(e, (Component)VCSWindowUtils.getCurrentWindow());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initRepository(File folder, String remoteUrl, String username, char[] passwd) throws MalformedURLException {
        if (!GITExtension.validateFolder(folder)) {
            return false;
        }
        Collection filters = VCSIgnoreFilters.getAllIgnoreFilters();
        GITImport impOp = new GITImport();
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor(Resource.get("IMPORT_OPERATION"));
        VCSCancellable cancellable = new VCSCancellable(){

            public boolean isCancelled() {
                return false;
            }
        };
        GitClient client = null;
        try {
            URL local = folder.toURI().toURL();
            if (!URLFileSystem.exists((URL)URLFactory.newURL((URL)local, (String)".git"))) {
                client = impOp.initializeRepositoy(local, monitor, cancellable);
            }
            String name = this.addRemote(local, remoteUrl);
            GITExtension.setConnection(name, remoteUrl, username, passwd);
            boolean bl = true;
            return bl;
        }
        catch (VCSCancelException local) {
        }
        catch (GITProcessException e) {
            this.getExceptionHandler().handleException((Exception)((Object)e), (Component)VCSWindowUtils.getCurrentWindow());
        }
        finally {
            if (client != null) {
                client.release();
            }
            monitor.logCompleted();
        }
        return false;
    }

    public boolean isControlled(File file) {
        return GITUtil.insideWorkingCopy(URLFactory.newFileURL((File)file));
    }

    private static boolean validateFolder(File folder) {
        if (!folder.exists() && !folder.mkdirs()) {
            MessageDialog.error((Component)VCSWindowUtils.getCurrentWindow(), (Object)Resource.format("INIT_FOLDER_LOCATION", folder.getPath()), (String)Resource.get("INIT_ERROR_TITLE"), null);
            return false;
        }
        if (!folder.isDirectory()) {
            MessageDialog.error((Component)VCSWindowUtils.getCurrentWindow(), (Object)Resource.format("INIT_FOLDER_DIRECTORY", folder.getPath()), (String)Resource.get("INIT_ERROR_TITLE"), null);
            return false;
        }
        if (!folder.canWrite()) {
            MessageDialog.error((Component)VCSWindowUtils.getCurrentWindow(), (Object)Resource.format("INIT_WRITE_DIRECTORY", folder.getPath()), (String)Resource.get("INIT_ERROR_TITLE"), null);
            return false;
        }
        return true;
    }

    private VCSExceptionHandler getExceptionHandler() {
        if (this._exceptionHandler == null) {
            this._exceptionHandler = new VCSExceptionHandler();
        }
        return this._exceptionHandler;
    }

    private String addRemote(URL local, String remoteUrl) throws GITProcessException {
        String name;
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(local);
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("remote");
            monitor.setLog(false);
            name = GITExtension.getUniqueName(client, monitor);
            ArrayList<String> furls = new ArrayList<String>();
            furls.add(remoteUrl);
            ArrayList<String> purls = new ArrayList<String>();
            purls.add(remoteUrl);
            List<String> spec = Collections.emptyList();
            GitRemoteConfig config = new GitRemoteConfig(name, furls, purls, spec, spec);
            client.setRemote(config, monitor);
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITExtension.class.getName()).log(Level.WARNING, e.getMessage());
            throw new GITProcessException(Resource.format("ERROR_FAILED_CLOUD_REMOTE", URLFileSystem.getPlatformPathName((URL)local), e));
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return name;
    }

    private static String getUniqueName(GitClient client, GITCommandProgressMonitor monitor) throws GitException {
        Map<String, GitRemoteConfig> remotes = client.getRemotes(monitor);
        Object remote = Resource.get("WZ_CLONE_REMOTE_DEFAULT");
        if (remotes.isEmpty()) {
            return remote;
        }
        int c = 1;
        while (remotes.containsKey(remote)) {
            remote = Resource.get("WZ_CLONE_REMOTE_DEFAULT") + c++;
        }
        return remote;
    }

    private static void setConnection(String name, String remoteUrl, String username, char[] passwd) {
        GITConnection connection = new GITConnection(remoteUrl);
        connection.setRemote(name);
        connection.setUsername(username);
        connection.setPassword(passwd);
        GITConnectionManager.getInstance().putConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isExist(File root, String commitId) {
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("log");
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(URLFactory.newFileURL((File)root));
            GitRevisionInfo rInfo = client.log(commitId, (ProgressMonitor)monitor);
            boolean bl = rInfo != null;
            return bl;
        }
        catch (GitException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }
}

