/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.net.URL;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.patch.PatchAssistance;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSFileEventSender;

public class GITPatchAssistance
extends PatchAssistance {
    private static Pattern pattern = Pattern.compile("(?i)diff --git");
    private static Pattern filepattern = Pattern.compile("(---|\\+\\+\\+)([\\s]+)([^\\t]+)");
    private static Pattern newFilepattern = Pattern.compile("(?i)new file mode");
    private String _toFile;
    private String _fromFile;
    private boolean _newFile = false;

    public boolean isRecognised(byte[] source) {
        Matcher matcher = pattern.matcher(new String(source));
        boolean rec = matcher.find();
        if (rec) {
            this.clearDetails();
        }
        return rec;
    }

    public Date getFromModificationTime() {
        return null;
    }

    public String getFromRevision() {
        return null;
    }

    public String toFile() {
        return this._toFile;
    }

    public String fromFile() {
        return this._fromFile;
    }

    public Date getToModificationTime() {
        return null;
    }

    public String getToRevision() {
        return null;
    }

    public void process(String line) {
        String sLine = line.trim();
        Matcher newFileMatcher = newFilepattern.matcher(sLine);
        Matcher matcher = pattern.matcher(sLine);
        if (newFileMatcher.find()) {
            this._newFile = true;
        } else if (matcher.find()) {
            this._newFile = false;
        } else {
            this.extractFileName(line);
        }
    }

    public boolean isNew() {
        return this._newFile;
    }

    public void fixUpFilenames() {
        if (this.isNewFile(this._fromFile)) {
            this._fromFile = this.newFilename(this._toFile);
        } else if (this.isNewFile(this._toFile)) {
            this._toFile = this.newFilename(this._fromFile);
        }
    }

    private void extractFileName(String line) {
        Matcher matcher = filepattern.matcher(line.trim());
        if (matcher.matches()) {
            String fileName = matcher.group(3);
            if (matcher.group(1).startsWith("-")) {
                this._fromFile = fileName;
            } else {
                this._toFile = fileName;
            }
        }
    }

    private String newFilename(String fromFile) {
        int pos = fromFile.indexOf(47);
        pos = pos == -1 ? 0 : pos;
        return "a" + fromFile.substring(pos);
    }

    private boolean isNewFile(String fileName) {
        return fileName.equals("nul") || fileName.equals("/dev/null");
    }

    private void clearDetails() {
        this._toFile = null;
        this._fromFile = null;
        this._newFile = false;
    }

    public void updated(URL[] urls) {
        if (urls != null) {
            VCSFileEventSender.fireFileStructureChanged((URL[])urls);
            VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git").getPolicyStatusCache().clear(urls);
        }
    }
}

