/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.accessibility.AccessibleContext;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.event.SwingDBObjectListener;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIMnemonicBuilder;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.components.BooleanPropertyComponentWrapper;
import oracle.ideimpl.db.components.EnumPropertyComponentWrapper;
import oracle.ideimpl.db.components.NumberPropertyComponentWrapper;
import oracle.ideimpl.db.components.TextPropertyComponentWrapper;
import oracle.ideimpl.db.components.UnlimitedNumberComponentWrapper;
import oracle.ideimpl.db.controls.NumberTextFieldUnlimited;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.XMLTypeColumnProperties;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.util.ModelUtil;

public class DataTypeEditorPanel
extends ChildObjectEditorPanel<Column, Table> {
    private static String DATATYPES_SEPARATOR = "--------";
    private LayoutChoice m_currentLayout;
    private boolean m_listening;
    private final boolean m_singleColEditOnly;
    private TypeComboListMember m_lastSelected;
    private final JRadioButton m_rdbSimpleType = new JRadioButton();
    private final JRadioButton m_rdbComplexType = new JRadioButton();
    private final JRadioButton m_rdbVirtual = new JRadioButton();
    private final JPanel m_typePanel = new JPanel();
    private final JLabel m_lblType = new JLabel();
    private final JComboBox m_cmbType = new DataTypesComboBox();
    private final JLabel m_lblSchemas = new JLabel();
    private final DBObjectChooser m_cmbSchemas = new DBObjectChooser("SCHEMA");
    private final JLabel m_lblComplexType = new JLabel();
    private final DBObjectChooser m_cmbComplexType = new DBObjectChooser(this.m_cmbSchemas, "TYPE");
    private final DefaultComboBoxModel m_mdlTypes = new NonNullableComboBoxModel();
    private final TypeComboListMember m_derivedDataType = new TypeComboListMember(true);
    private final DataTypeAttributesCWFactory m_attribsCWFactory;

    public DataTypeEditorPanel() {
        this(false);
    }

    DataTypeEditorPanel(boolean bl) {
        super("DataTypeEditorPanel", "columns");
        this.m_singleColEditOnly = bl;
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LayoutChoice layoutChoice;
                if (DataTypeEditorPanel.this.m_listening && (layoutChoice = DataTypeEditorPanel.this.getChoiceFromRadios()) != DataTypeEditorPanel.this.m_currentLayout) {
                    DataTypeEditorPanel.this.resetColumnModel(layoutChoice);
                    DataTypeEditorPanel.this.syncUIFromModel(layoutChoice);
                    Component component = DataTypeEditorPanel.this.getDefaultFocusComponent(layoutChoice);
                    if (component != null) {
                        component.requestFocusInWindow();
                    }
                }
            }
        };
        this.m_rdbComplexType.addActionListener(actionListener);
        this.m_rdbSimpleType.addActionListener(actionListener);
        this.m_rdbVirtual.addActionListener(actionListener);
        this.m_cmbType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DataTypeEditorPanel.this.m_listening) {
                    DataType dataType = DataTypeEditorPanel.this.getSelectedSimpleType();
                    DataTypeEditorPanel.this.setDataTypeInModel(dataType);
                    DataTypeEditorPanel.this.syncUIFromModel(DataTypeEditorPanel.this.m_currentLayout);
                }
            }
        });
        this.m_cmbComplexType.addChangeListener(new DBObjectChooser.ChangeListener(){

            @Override
            public void chooserChanged(DBObjectChooser dBObjectChooser, DBObjectID dBObjectID) {
                if (DataTypeEditorPanel.this.m_listening) {
                    Type type = DataTypeEditorPanel.this.getSelectedComplexType();
                    DataTypeEditorPanel.this.setDataTypeInModel((DataType)type);
                    if (type == null) {
                        DataTypeEditorPanel.this.layoutAttributesOnly();
                    } else {
                        DataTypeEditorPanel.this.syncUIFromModel(LayoutChoice.COMPLEX);
                    }
                }
            }
        });
        this.m_attribsCWFactory = new DataTypeAttributesCWFactory();
    }

    @Override
    protected DBObjectListener createComponentFactoryObjectListener() {
        return new SwingDBObjectListener(){

            @Override
            protected void updateUI(DBObjectChange dBObjectChange) {
                DBObjectChange dBObjectChange2;
                if (DataTypeEditorPanel.this.m_listening && (dBObjectChange2 = dBObjectChange.getOwnedObjectUpdate((DBObject)((Column)dBObjectChange.getDBObject()).getDataTypeUsage())) != null) {
                    DataTypeEditorPanel.this.handleDataTypeUsageUpdates(dBObjectChange2);
                }
            }
        };
    }

    private void handleDataTypeUsageUpdates(DBObjectChange dBObjectChange) {
        PropertyChangeEvent propertyChangeEvent;
        PropertyChangeEvent propertyChangeEvent2;
        String string = Property.createPath((String[])new String[]{"attributeValues", "size"});
        String string2 = Property.createPath((String[])new String[]{"attributeValues", "precision"});
        PropertyChangeEvent propertyChangeEvent3 = dBObjectChange.getPropertyChange(string);
        if (propertyChangeEvent3 != null) {
            this.m_attribsCWFactory.setAttributeWrapperValue("size", propertyChangeEvent3.getNewValue());
        }
        if ((propertyChangeEvent2 = dBObjectChange.getPropertyChange(string2)) != null) {
            this.m_attribsCWFactory.setAttributeWrapperValue("precision", propertyChangeEvent2.getNewValue());
        }
        if ((propertyChangeEvent = dBObjectChange.getPropertyChange("dataTypeID")) != null) {
            TypeComboListMember typeComboListMember = new TypeComboListMember(this.getDataTypeFromModel(), "TOP");
            this.m_listening = false;
            this.m_mdlTypes.setSelectedItem(typeComboListMember);
            this.syncUIFromModel(null);
            this.m_listening = true;
        }
    }

    @Override
    public void initialiseComponents() {
        DBUIResourceHelper dBUIResourceHelper = this.getComponentFactory().getResourceHelper();
        dBUIResourceHelper.resLabel(this.m_lblType, this.m_cmbType, UIBundle.get("COLUMN_INFO_NAME_TYPE"), "SimpleTypeList");
        dBUIResourceHelper.resLabel(this.m_lblComplexType, this.m_cmbComplexType, UIBundle.get("COLUMN_INFO_NAME_TYPE"), "ComplexTypeList");
        dBUIResourceHelper.resLabel(this.m_lblSchemas, this.m_cmbSchemas, UIBundle.get("COLUMN_INFO_LABEL_SCHEMA"), "ComplexTypeSchema");
        dBUIResourceHelper.resButton(this.m_rdbSimpleType, UIBundle.get("COLUMN_INFO_LABEL_SIMPLE"), "SimpleType");
        dBUIResourceHelper.resButton(this.m_rdbComplexType, UIBundle.get("COLUMN_INFO_LABEL_COMPLEX"), "ComplexType");
        dBUIResourceHelper.resButton(this.m_rdbVirtual, UIBundle.get("COLUMN_INFO_LABEL_VIRTUAL_COLUMN"), "Virtual");
        this.m_cmbType.setModel(this.m_mdlTypes);
        this.fixAccessibleName(this.m_rdbSimpleType);
        this.fixAccessibleName(this.m_rdbComplexType);
        this.fixAccessibleName(this.m_rdbVirtual);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_rdbSimpleType);
        buttonGroup.add(this.m_rdbComplexType);
        buttonGroup.add(this.m_rdbVirtual);
        this.m_rdbSimpleType.setSelected(true);
        DBObjectProvider dBObjectProvider = this.getProvider();
        DataTypeEditorPanel.populateDataTypeModel(dBObjectProvider, this.m_mdlTypes);
        this.m_cmbSchemas.setProvider(dBObjectProvider);
        this.m_cmbComplexType.setProvider(dBObjectProvider);
        this.m_cmbComplexType.enableProviderListener(true);
        ComponentWrapper componentWrapper = this.getOrCreateWrapper("virtualExpressionSource");
    }

    private void fixAccessibleName(JRadioButton jRadioButton) {
        AccessibleContext accessibleContext = jRadioButton.getAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.setAccessibleName(UIBundle.get("COLUMN_INFO_LABEL_DATATYPE") + " " + jRadioButton.getText());
        }
    }

    @Override
    public void initialiseChildComponents() {
        if (this.getChildObject() != null) {
            DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
            if (this.m_singleColEditOnly || this.isInFlatEditor()) {
                this.layoutComponents(dBUILayoutHelper);
            } else {
                JPanel jPanel = new JPanel();
                DBUILayoutHelper dBUILayoutHelper2 = new DBUILayoutHelper(jPanel, this.isInFlatEditor());
                dBUILayoutHelper2.setMargins(0);
                this.layoutComponents(dBUILayoutHelper2);
                dBUILayoutHelper2.layout();
                JScrollPane jScrollPane = new JScrollPane(jPanel, 20, 31);
                jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
                dBUILayoutHelper.add(jScrollPane, 1, 3, true, true);
            }
            dBUILayoutHelper.pushUp();
            dBUILayoutHelper.layout();
        } else {
            this.removeAll();
        }
    }

    private void layoutComponents(DBUILayoutHelper dBUILayoutHelper) {
        DBUILayoutHelper dBUILayoutHelper2 = dBUILayoutHelper.newChildHelper("typeRadioButtons", 2, 1, false, false);
        dBUILayoutHelper2.add(this.m_rdbSimpleType);
        dBUILayoutHelper2.add(this.m_rdbComplexType);
        dBUILayoutHelper2.add(this.m_rdbVirtual);
        dBUILayoutHelper2.pushLeft();
        dBUILayoutHelper2.layout();
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(this.m_typePanel, 1, 1, true, true);
        dBUILayoutHelper.layout();
    }

    @Override
    public void initialisePanel() {
        this.m_lastSelected = null;
        super.initialisePanel();
        this.syncUIFromModel(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncUIFromModel(LayoutChoice layoutChoice) {
        Column column = (Column)this.getChildObject();
        this.m_listening = false;
        if (column != null) {
            try {
                LayoutChoice layoutChoice2;
                DBObjectProvider dBObjectProvider = this.getProvider();
                ComponentWrapper componentWrapper = this.getOrCreateWrapper("virtualExpressionSource");
                PropertyManager propertyManager = dBObjectProvider.getPropertyManager();
                Table.TableType tableType = (Table.TableType)((Table)this.getUpdatedObject()).getProperty("TableType");
                boolean bl = tableType == Table.TableType.EXTERNAL;
                boolean bl2 = false;
                bl2 = this.getOriginalObject() == null ? propertyManager.canCreateProperty((SystemObject)this.getUpdatedObject(), Property.createPath((String[])new String[]{"columns", "default"})) : propertyManager.canAlterProperty((SystemObject)this.getOriginalObject(), (SystemObject)this.getUpdatedObject(), Property.createPath((String[])new String[]{"columns", "default"}));
                this.m_rdbVirtual.setEnabled(bl2 && !bl);
                componentWrapper.setEnabled(bl2 && !bl);
                this.m_rdbVirtual.setVisible(componentWrapper.isSupported());
                componentWrapper.refreshObject((DBObject)column);
                boolean bl3 = componentWrapper.isSupported() && column.getVirtualExpressionSource() != null;
                DataType dataType = this.getDataTypeFromModel();
                this.m_mdlTypes.removeElement(this.m_derivedDataType);
                if (dataType instanceof Type) {
                    layoutChoice2 = LayoutChoice.COMPLEX;
                    this.initComplexTypeCombos();
                    this.m_cmbSchemas.setDBObject((DBObject)((Type)dataType).getSchema());
                    this.m_cmbComplexType.setDBObject((DBObject)dataType);
                } else {
                    TypeComboListMember typeComboListMember = this.getSelectedTypeComboListMember(dataType);
                    if (bl3) {
                        layoutChoice2 = LayoutChoice.VIRTUAL;
                        DBObject dBObject = TemporaryObjectID.getOriginalObject((DBObject)column);
                        if (dBObject == null || !(dBObjectProvider instanceof Database)) {
                            this.m_mdlTypes.insertElementAt(this.m_derivedDataType, 0);
                        }
                        if (dataType == null) {
                            typeComboListMember = this.m_derivedDataType;
                        }
                    } else {
                        layoutChoice2 = LayoutChoice.SIMPLE;
                    }
                    this.m_cmbType.getModel().setSelectedItem(typeComboListMember);
                    this.m_lastSelected = typeComboListMember;
                }
                boolean bl4 = dBObjectProvider.supportsObjectType("TYPE");
                boolean bl5 = bl4 && !bl;
                this.m_rdbSimpleType.setVisible(bl5);
                this.m_rdbComplexType.setVisible(bl5);
                this.m_lblSchemas.setEnabled(bl5);
                this.m_cmbSchemas.setEnabled(bl5);
                this.m_lblComplexType.setEnabled(bl5);
                this.m_cmbComplexType.setEnabled(bl5);
                this.layoutTypePanel(layoutChoice == null ? layoutChoice2 : layoutChoice);
            }
            finally {
                this.m_listening = true;
            }
        }
    }

    private TypeComboListMember getSelectedTypeComboListMember(DataType dataType) {
        TypeComboListMember typeComboListMember = (TypeComboListMember)this.m_mdlTypes.getSelectedItem();
        if (!(typeComboListMember != null && DBUtil.areNamesAndTypesEqual((DBObject)typeComboListMember.getDataType(), (DBObject)dataType) || this.m_mdlTypes.getIndexOf(typeComboListMember = new TypeComboListMember(dataType, "TOP")) != -1)) {
            typeComboListMember.setPosition("BOTTOM");
        }
        return typeComboListMember;
    }

    private void layoutTypePanel(LayoutChoice layoutChoice) {
        if (this.m_currentLayout == layoutChoice && this.m_typePanel.getComponentCount() > 0) {
            this.layoutAttributesOnly();
        } else {
            this.m_typePanel.removeAll();
            this.m_attribsCWFactory.clearWrappers();
            DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(this.m_typePanel, this.isInFlatEditor());
            dBUILayoutHelper.setMargins(0);
            this.m_currentLayout = layoutChoice;
            if (layoutChoice == LayoutChoice.COMPLEX) {
                this.m_rdbComplexType.getModel().setSelected(true);
                dBUILayoutHelper.add(this.m_lblSchemas);
                dBUILayoutHelper.add(this.m_cmbSchemas);
                dBUILayoutHelper.nextRow();
                dBUILayoutHelper.add(this.m_lblComplexType);
                dBUILayoutHelper.add(this.m_cmbComplexType);
                dBUILayoutHelper.nextRow();
                this.layoutComplexAttributes(dBUILayoutHelper);
            } else {
                if (layoutChoice == LayoutChoice.VIRTUAL) {
                    this.m_rdbVirtual.getModel().setSelected(true);
                    ComponentWrapper componentWrapper = this.getOrCreateWrapper("virtualExpressionSource");
                    JLabel jLabel = componentWrapper.getLabel();
                    dBUILayoutHelper.add(jLabel);
                    dBUILayoutHelper.getConstraints((Component)jLabel).anchor = 18;
                    Component component = componentWrapper.getComponent();
                    component.setPreferredSize(new Dimension(200, 40));
                    dBUILayoutHelper.add(component, 3, 1, true, false);
                    dBUILayoutHelper.nextRow();
                } else {
                    this.m_rdbSimpleType.getModel().setSelected(true);
                }
                dBUILayoutHelper.add(this.m_lblType);
                dBUILayoutHelper.add(this.m_cmbType);
                dBUILayoutHelper.nextRow();
                this.layoutSimpleAttributes(dBUILayoutHelper);
            }
            dBUILayoutHelper.layout();
            this.layoutChanged();
        }
    }

    private void layoutChanged() {
        DBUIMnemonicBuilder dBUIMnemonicBuilder = new DBUIMnemonicBuilder((JPanel)((Object)this));
        if (this.isInFlatEditor()) {
            dBUIMnemonicBuilder.removeAll();
        } else {
            dBUIMnemonicBuilder.build();
        }
        this.validate();
        this.repaint();
    }

    private void layoutAttributesOnly() {
        this.m_attribsCWFactory.clearWrappers();
        DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(this.m_typePanel, this.isInFlatEditor());
        if (this.m_currentLayout == LayoutChoice.VIRTUAL) {
            dBUILayoutHelper.setReuseExistingLayout(4);
            this.layoutSimpleAttributes(dBUILayoutHelper);
        } else if (this.m_currentLayout == LayoutChoice.COMPLEX) {
            dBUILayoutHelper.setReuseExistingLayout(3);
            this.layoutComplexAttributes(dBUILayoutHelper);
        } else {
            dBUILayoutHelper.setReuseExistingLayout(2);
            this.layoutSimpleAttributes(dBUILayoutHelper);
        }
        dBUILayoutHelper.layout();
        this.layoutChanged();
    }

    private boolean layoutSimpleAttributes(DBUILayoutHelper dBUILayoutHelper) {
        DataTypeAttribute[] dataTypeAttributeArray;
        DataType dataType = this.getDataTypeFromModel();
        if (dataType != null && (dataTypeAttributeArray = dataType.getDataTypeAttributes()) != null && dataTypeAttributeArray.length > 0) {
            int n = 0;
            for (DataTypeAttribute dataTypeAttribute : dataTypeAttributeArray) {
                if (this.m_singleColEditOnly || n > 0 && n % 2 == 0) {
                    dBUILayoutHelper.nextRow();
                }
                if (!dataTypeAttribute.isDeclarable()) continue;
                ComponentWrapper componentWrapper = this.m_attribsCWFactory.createWrapper(dataTypeAttribute);
                dBUILayoutHelper.add(componentWrapper);
                GridBagConstraints gridBagConstraints = dBUILayoutHelper.getConstraints(componentWrapper.getComponent());
                gridBagConstraints.fill = 2;
                ++n;
            }
        }
        dBUILayoutHelper.pushUp();
        return true;
    }

    private boolean layoutComplexAttributes(DBUILayoutHelper dBUILayoutHelper) {
        ComponentWrapper componentWrapper;
        DataType dataType = this.getDataTypeFromModel();
        if (dataType instanceof Type && (componentWrapper = this.m_attribsCWFactory.createComplexWrapper((Type)dataType)) != null) {
            dBUILayoutHelper.addChildren(componentWrapper, new Integer[0]);
        }
        dBUILayoutHelper.pushUp();
        return true;
    }

    private Type getSelectedComplexType() {
        return (Type)this.m_cmbComplexType.getDBObject();
    }

    private DataType getSelectedSimpleType() {
        Object object = this.m_mdlTypes.getSelectedItem();
        if (object instanceof TypeComboListMember) {
            return ((TypeComboListMember)object).getDataType();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDataTypeInModel(DataType dataType) {
        this.m_listening = false;
        try {
            Column column = (Column)this.getChildObject();
            if (column != null) {
                DataTypeUsage dataTypeUsage = column.getDataTypeUsage();
                if (dataTypeUsage == null && dataType != null) {
                    dataTypeUsage = new DataTypeUsage();
                    column.setDataTypeUsage(dataTypeUsage);
                }
                if (dataTypeUsage != null) {
                    DataTypeEditorPanel.setDataType(dataTypeUsage, dataType);
                }
            }
        }
        finally {
            this.m_listening = true;
        }
    }

    private Component getDefaultFocusComponent(LayoutChoice layoutChoice) {
        Component component;
        if (layoutChoice == LayoutChoice.VIRTUAL) {
            ComponentWrapper componentWrapper = this.getOrCreateWrapper("virtualExpressionSource");
            component = componentWrapper.getActiveComponent();
        } else {
            component = layoutChoice == LayoutChoice.COMPLEX ? (this.getSelectedComplexType() == null ? this.m_cmbSchemas.getDefaultFocusComponent() : this.m_cmbComplexType.getDefaultFocusComponent()) : this.m_cmbType;
        }
        return component;
    }

    private LayoutChoice getChoiceFromRadios() {
        LayoutChoice layoutChoice = this.m_rdbComplexType.isSelected() ? LayoutChoice.COMPLEX : (this.m_rdbVirtual.isSelected() ? LayoutChoice.VIRTUAL : LayoutChoice.SIMPLE);
        return layoutChoice;
    }

    private DataType getDataTypeFromModel() {
        DataTypeUsage dataTypeUsage;
        DataType dataType = null;
        Column column = (Column)this.getChildObject();
        if (column != null && (dataTypeUsage = column.getDataTypeUsage()) != null) {
            try {
                dataType = DataTypeHelper.getDataType((DataTypeUsage)dataTypeUsage, (boolean)false);
            }
            catch (DBException dBException) {
                this.getLogger().fine(dBException.getMessage());
            }
        }
        return dataType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetColumnModel(LayoutChoice layoutChoice) {
        Column column = (Column)this.getChildObject();
        if (column != null) {
            this.m_listening = false;
            try {
                DataType dataType = null;
                if (layoutChoice == LayoutChoice.VIRTUAL) {
                    column.setVirtualExpressionSource("");
                } else {
                    column.setVirtualExpressionSource(null);
                    if (layoutChoice == LayoutChoice.COMPLEX) {
                        this.initComplexTypeCombos();
                        dataType = this.getSelectedComplexType();
                    } else {
                        Iterator iterator;
                        dataType = this.getSelectedSimpleType();
                        if (dataType == null && (iterator = this.getProvider().getDescriptor().listPreferredDataTypes().iterator()).hasNext()) {
                            dataType = (DataType)iterator.next();
                        }
                    }
                }
                this.setDataTypeInModel(dataType);
            }
            finally {
                this.m_listening = true;
            }
        }
    }

    private void initComplexTypeCombos() {
        if (this.getSelectedComplexType() == null) {
            SchemaObject schemaObject = null;
            try {
                schemaObject = (SchemaObject)this.getProvider().getObject(DBObjectCriteria.createSingleObjectCriteria((String)"TYPE", (String)"SYS", (String)"XMLTYPE"));
            }
            catch (DBException dBException) {
                this.getLogger().info(dBException.getMessage());
            }
            if (schemaObject == null) {
                Schema schema = DBUtil.getSchema(this.getUpdatedObject());
                if (schema != null) {
                    this.m_cmbSchemas.setDBObject((DBObject)schema);
                }
                this.m_cmbComplexType.setDBObject(null);
            } else {
                this.m_cmbSchemas.setDBObject((DBObject)((Type)schemaObject).getSchema());
                this.m_cmbComplexType.setDBObject((DBObject)((Type)schemaObject));
            }
        }
    }

    public static void setDataType(DataTypeUsage dataTypeUsage, DataType dataType) {
        DBObjectID dBObjectID;
        DBObjectID dBObjectID2 = dBObjectID = dataType == null ? null : dataType.getID();
        if (ModelUtil.areDifferent((Object)dataTypeUsage.getDataTypeID(), (Object)dBObjectID)) {
            dataTypeUsage.getParent().setProperty("OracleColumnProperties", null);
            if (dataType != null) {
                dataTypeUsage.setDataTypeID(dBObjectID);
                dataType.createDefaultUsage().copyTo((Object)dataTypeUsage);
            } else {
                dataTypeUsage.setDataTypeID(null);
                dataTypeUsage.setAttributeValues(null);
            }
        }
    }

    public static void populateDataTypeModel(DBObjectProvider dBObjectProvider, DefaultComboBoxModel defaultComboBoxModel) {
        if (defaultComboBoxModel.getSize() < 1) {
            DataType[] dataTypeArray = dBObjectProvider.listSupportedDataTypes();
            TreeSet<DataType> treeSet = new TreeSet<DataType>(new Comparator(){

                public int compare(Object object, Object object2) {
                    if (object instanceof PredefinedDataType && object2 instanceof Type) {
                        return -1;
                    }
                    if (object instanceof Type && object2 instanceof PredefinedDataType) {
                        return 1;
                    }
                    return object.toString().compareTo(object2.toString());
                }
            });
            for (int i = 0; i < dataTypeArray.length; ++i) {
                treeSet.add(dataTypeArray[i]);
            }
            Collection collection = dBObjectProvider.getDescriptor().listPreferredDataTypes();
            if (collection != null && collection.size() > 0) {
                for (Object object : collection) {
                    TypeComboListMember typeComboListMember = new TypeComboListMember((DataType)object, "TOP");
                    defaultComboBoxModel.addElement(typeComboListMember);
                }
                defaultComboBoxModel.addElement(DATATYPES_SEPARATOR);
            }
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                Object object;
                object = new TypeComboListMember((DataType)iterator.next(), "BOTTOM");
                defaultComboBoxModel.addElement(object);
            }
        }
    }

    public static class DataTypesComboBox
    extends JComboBox {
        public DataTypesComboBox() {
            this.setRenderer(new DataTypeListRenderer());
        }

        @Override
        public void setSelectedIndex(int n) {
            int n2 = this.getSelectedIndex();
            if (this.isSeparatorSelected(n)) {
                n = n2 < n ? ++n : --n;
            }
            super.setSelectedIndex(n);
        }

        private boolean isSeparatorSelected(int n) {
            Object e = this.getModel().getElementAt(n);
            return e instanceof String && e.equals(DATATYPES_SEPARATOR);
        }

        private class DataTypeListRenderer
        extends BasicComboBoxRenderer {
            private DataTypeListRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component;
                if (DataTypesComboBox.this.isSeparatorSelected(n)) {
                    component = super.getListCellRendererComponent((JList<?>)jList, object, n, false, false);
                    component.setEnabled(false);
                } else {
                    component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    component.setEnabled(true);
                }
                return component;
            }
        }
    }

    public static class TypeComboListMember {
        private final DataType m_dataType;
        private String m_position;
        private boolean m_derived;
        public static final String BOTTOM_OF_LIST = "BOTTOM";
        public static final String TOP_OF_LIST = "TOP";

        public TypeComboListMember(DataType dataType, String string) {
            this.m_dataType = dataType;
            this.m_position = string;
            this.m_derived = false;
        }

        public TypeComboListMember(boolean bl) {
            this(null, TOP_OF_LIST);
            this.m_derived = bl;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof TypeComboListMember) {
                bl = DBUtil.areNamesAndTypesEqual((DBObject)this.m_dataType, (DBObject)((TypeComboListMember)object).m_dataType) && ModelUtil.areEqual((Object)this.m_position, (Object)((TypeComboListMember)object).m_position);
            }
            return bl;
        }

        public String toString() {
            String string = this.m_derived ? UIBundle.get("COLUMN_INFO_VIRTUAL_DERIVED_DATATYPE") : (this.m_dataType != null ? this.m_dataType.getName() : UIBundle.get("TABLE_DTU_INVALID"));
            return string;
        }

        public DataType getDataType() {
            return this.m_dataType;
        }

        public String getPosition() {
            return this.m_position;
        }

        public void setPosition(String string) {
            this.m_position = string;
        }
    }

    private class DataTypeAttributesCWFactory {
        private final Map<String, ComponentWrapper> m_wrappers = new HashMap<String, ComponentWrapper>();
        private final List<String> m_paths = new ArrayList<String>();

        private DataTypeAttributesCWFactory() {
        }

        ComponentWrapper createComplexWrapper(Type type) {
            String string = null;
            if (XMLTypeColumnProperties.isXMLType((DataType)type)) {
                string = Property.createPath((String[])new String[]{"OracleColumnProperties", "XMLTypeColumnProperties"});
            } else if (DataTypeHelper.isTableType((DataType)type)) {
                string = Property.createPath((String[])new String[]{"OracleColumnProperties", "nestedTableProperties"});
            }
            ComponentWrapper componentWrapper = null;
            if (string != null) {
                componentWrapper = DataTypeEditorPanel.this.getOrCreateWrapper(string);
                componentWrapper.initialise(this.createComponentContext(string));
                componentWrapper.setActive(true);
                this.m_paths.add(string);
            }
            return componentWrapper;
        }

        private ComponentWrapper createWrapper(DataTypeAttribute dataTypeAttribute) {
            ComponentContext componentContext = this.createComponentContext(dataTypeAttribute);
            String string = dataTypeAttribute.getName();
            ComponentWrapper componentWrapper = null;
            int n = dataTypeAttribute.getValueType();
            switch (n) {
                case 1: {
                    componentWrapper = new NumberPropertyComponentWrapper();
                    break;
                }
                case 0: {
                    String[] stringArray = dataTypeAttribute.getValues();
                    if (stringArray == null) {
                        componentWrapper = new TextPropertyComponentWrapper.SingleLineTextWrapper();
                        break;
                    }
                    if (stringArray.length == 1 && !dataTypeAttribute.isExtensible() && dataTypeAttribute.getDefaultValue() == null) {
                        componentWrapper = new DataTypeAttributeBooleanComponentWrapper(stringArray[0]);
                        break;
                    }
                    componentWrapper = new EnumPropertyComponentWrapper();
                    break;
                }
                case 2: {
                    String[] stringArray = dataTypeAttribute.getValues();
                    if (stringArray == null || stringArray.length == 0) {
                        componentWrapper = new NumberPropertyComponentWrapper();
                        break;
                    }
                    if (stringArray.length == 1) {
                        componentWrapper = new CheckBoxOrNumberAttributeComponentWrapper(stringArray[0]);
                        break;
                    }
                    throw new UnsupportedOperationException("Integer with combo not currently implemented for datatype attributes.");
                }
            }
            if (componentWrapper == null) {
                throw new IllegalStateException("Failed to create component for attribute value \"" + string + "\" with value type " + n + ".");
            }
            componentWrapper.initialise(componentContext);
            componentWrapper.setActive(true);
            componentWrapper.setPropertyDisplayName(dataTypeAttribute.getNLSLabel());
            DataTypeEditorPanel.this.getComponentFactory().registerComponentWrapper(componentWrapper);
            this.m_paths.add(componentWrapper.getPropertyName());
            this.m_wrappers.put(string, componentWrapper);
            return componentWrapper;
        }

        private String createAttributePath(String string) {
            return Property.createPath((String[])new String[]{"dataTypeUsage", "attributeValues", string});
        }

        private ComponentContext createComponentContext(DataTypeAttribute dataTypeAttribute) {
            String string = this.createAttributePath(dataTypeAttribute.getName());
            return this.createComponentContext(string);
        }

        private ComponentContext createComponentContext(String string) {
            Column column = (Column)DataTypeEditorPanel.this.getChildObject();
            DBObjectID dBObjectID = column.getID();
            Column column2 = null;
            if (dBObjectID instanceof TemporaryObjectID) {
                column2 = (Column)TemporaryObjectID.findOriginalObject((TemporaryObjectID)((TemporaryObjectID)dBObjectID));
            }
            ComponentContext componentContext = DataTypeEditorPanel.this.getComponentFactory().createComponentContext(string, (DBObject)column2, (DBObject)column);
            componentContext.setBasePath("columns");
            return componentContext;
        }

        private void setAttributeWrapperValue(String string, Object object) {
            ComponentWrapper componentWrapper = this.m_wrappers.get(string);
            if (componentWrapper != null) {
                componentWrapper.setPropertyValue(object);
            }
        }

        private void clearWrappers() {
            for (String string : this.m_paths) {
                DataTypeEditorPanel.this.getComponentFactory().removeComponentWrapper(string);
            }
            this.m_paths.clear();
            this.m_wrappers.clear();
        }
    }

    private static enum LayoutChoice {
        SIMPLE,
        COMPLEX,
        VIRTUAL;

    }

    public class CheckBoxOrNumberAttributeComponentWrapper
    extends UnlimitedNumberComponentWrapper {
        private String m_attributeValue;

        public CheckBoxOrNumberAttributeComponentWrapper(String string) {
            this.m_attributeValue = string;
        }

        @Override
        protected void initialiseComponent() {
            ((NumberTextFieldUnlimited)this.getActiveComponent()).setCheckBoxLabel(this.m_attributeValue);
        }

        @Override
        public Object getPropertyValue() {
            Object object = super.getPropertyValue();
            if (object == Integer.valueOf(0)) {
                object = this.m_attributeValue;
            }
            return object;
        }

        @Override
        protected void setPropertyValueImpl(Object object) {
            if (object != null && object.equals(this.m_attributeValue)) {
                object = 0;
            }
            super.setPropertyValueImpl(object);
        }
    }

    public class DataTypeAttributeBooleanComponentWrapper
    extends BooleanPropertyComponentWrapper {
        private String m_attributeValue;

        public DataTypeAttributeBooleanComponentWrapper(String string) {
            this.m_attributeValue = string;
        }

        @Override
        public Object getPropertyValue() {
            String string = null;
            if (((JCheckBox)this.getActiveComponent()).isSelected()) {
                string = this.m_attributeValue;
            }
            return string;
        }

        @Override
        public void setPropertyValue(Object object) {
            ((JCheckBox)this.getActiveComponent()).setSelected(object != null);
        }
    }
}

