/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.sql;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.ide.Context;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controls.JTextComponentUndoSupport;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.controls.ReadOnlyScrollPane;
import oracle.ide.db.insight.completion.DBCompletionSupportFactory;
import oracle.ide.db.insight.model.DBInsightContext;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.db.panels.sql.SQLQueryEditDialog;
import oracle.ide.db.panels.sql.tester.SQLQueryTester;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.model.Node;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.ora.SQLQueryOwnerPanelLibrary;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryCancelledException;
import oracle.javatools.db.sql.SQLQueryClauseException;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorKit;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.FindHighlightPlugin;
import oracle.javatools.ui.ResizeComponent;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public class SQLQueryComponentPanel
extends JPanel {
    private final JLabel m_queryLabel = new JLabel();
    private final BasicEditorPane m_query = SQLQueryComponentPanel.createSQLEditorPane();
    private SearchField m_search = new SearchField(SearchField.Style.FIND);
    private final JLabel m_feedbackLabel = new JLabel();
    private ReadOnlyScrollPane m_feedback;
    private JTextComponentUndoSupport m_undo;
    private final JButton m_edit = new JButton();
    private final JButton m_test = new JButton();
    private final JButton m_liveTest = new JButton();
    private SQLQueryTester m_liveTester;
    private final JButton m_revert = new JButton();
    private final Collection<SQLQueryListener> m_listeners;
    private ComponentContext m_context;
    private String m_originalText;
    private final DocumentListener m_queryTextListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            SQLQueryComponentPanel.this.notifyListeners();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            SQLQueryComponentPanel.this.notifyListeners();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    };

    public SQLQueryComponentPanel() {
        this.m_listeners = new ArrayList<SQLQueryListener>();
        this.addButtonListeners();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.m_queryLabel.setEnabled(bl);
        this.m_query.setEnabled(bl);
        this.m_feedbackLabel.setEnabled(bl);
        this.m_feedback.setEnabled(bl);
        this.m_edit.setEnabled(bl);
        this.m_test.setEnabled(bl);
        this.m_liveTest.setEnabled(bl);
        this.m_revert.setEnabled(bl && this.canRevertBeEnabled());
    }

    @Override
    public void setVisible(boolean bl) {
        this.m_queryLabel.setVisible(bl);
        this.m_query.setVisible(bl);
        this.m_test.setVisible(bl);
        this.m_liveTest.setVisible(bl);
        this.m_revert.setVisible(bl);
        if (!bl) {
            this.m_feedbackLabel.setVisible(bl);
            this.m_feedback.setVisible(bl);
        }
    }

    public void initialisePanel(ComponentContext componentContext) {
        this.m_context = componentContext;
        DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(this, componentContext.isInFlatEditor());
        dBUILayoutHelper.setMarginTop(0);
        DBUIResourceHelper dBUIResourceHelper = new DBUIResourceHelper("QueryPanel");
        dBUIResourceHelper.setName(this, componentContext.getPropertyName());
        JScrollPane jScrollPane = new JScrollPane((Component)this.m_query);
        dBUIResourceHelper.resLabel(this.m_queryLabel, jScrollPane, UIBundle.get("QUERY_LABEL"), "QueryText");
        dBUILayoutHelper.add(this.m_queryLabel, 2, 1, false, false);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add((Component)this.m_search, 1, 1, true, false);
        dBUILayoutHelper.pushLeft();
        if (componentContext.isInFlatEditor()) {
            dBUIResourceHelper.resButton(this.m_edit, UIBundle.get("QUERY_EDIT"), "QueryEdit");
            dBUILayoutHelper.add(this.m_edit);
        } else {
            dBUIResourceHelper.resButton(this.m_revert, UIBundle.get("QUERY_REVERT"), "Revert");
            dBUILayoutHelper.add(this.m_revert);
        }
        dBUIResourceHelper.resButton(this.m_liveTest, UIBundle.get("QUERY_TEST"), "LiveTest");
        ToolTipManager.sharedInstance().registerComponent(this.m_liveTest);
        dBUILayoutHelper.add(this.m_liveTest);
        dBUILayoutHelper.nextRow();
        this.configureEditor();
        JScrollPane jScrollPane2 = jScrollPane;
        if (componentContext.isInFlatEditor()) {
            ResizeComponent resizeComponent = new ResizeComponent((JComponent)jScrollPane);
            resizeComponent.setPreferredSize(new Dimension(400, 100));
            jScrollPane2 = resizeComponent;
        }
        dBUILayoutHelper.add(jScrollPane2, 5, 1, true, true);
        dBUILayoutHelper.nextRow();
        dBUIResourceHelper.resButton(this.m_test, UIBundle.get("QUERY_CHECK"), "Test");
        dBUILayoutHelper.add(this.m_test);
        dBUILayoutHelper.nextRow();
        this.m_feedback = new ReadOnlyScrollPane();
        dBUIResourceHelper.resLabel(this.m_feedbackLabel, this.m_feedback.getTextArea(), UIBundle.get("QUERY_FEEDBACK"), "Results");
        this.m_feedback.setBorder(null);
        this.m_feedback.setMinimumSize(new Dimension(0, 50));
        dBUILayoutHelper.add(this.m_feedbackLabel, 5, 1);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(this.m_feedback, 5, 1, true, false);
        dBUILayoutHelper.getConstraints((Component)this.m_feedback).anchor = 18;
        dBUILayoutHelper.layout();
        this.initQuery();
    }

    private void configureEditor() {
        this.m_undo = new JTextComponentUndoSupport((JTextComponent)this.m_query);
        DBObjectProvider dBObjectProvider = this.m_context.getProvider();
        Schema schema = this.m_context.getEditorConfig().getSchema();
        final FindHighlightPlugin findHighlightPlugin = new FindHighlightPlugin();
        findHighlightPlugin.install(this.m_query);
        DBInsightContext dBInsightContext = new DBInsightContext();
        dBInsightContext.setProvider(dBObjectProvider);
        dBInsightContext.setSchema(schema);
        dBInsightContext.setContextObject((DBObject)this.m_context.getEditorConfig().getUpdatedObject());
        dBInsightContext.setIncludeReservedWords(true);
        DBCompletionSupportFactory.getCompletionSupport(dBInsightContext, this.getIdeContextForInsight(), (JTextComponent)this.m_query);
        this.ensureInActionMap("select-all");
        this.ensureInActionMap("insert-break");
        this.m_search.getTextField().addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                findHighlightPlugin.clearFindHighlighting();
            }
        });
        this.m_search.addSearchListener(new SearchListener(){

            public void searchCategoryChanged(SearchEvent searchEvent) {
                findHighlightPlugin.clearFindHighlighting();
            }

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                if (ModelUtil.hasLength((String)string)) {
                    int n = findHighlightPlugin.findText(string, SQLQueryComponentPanel.this.m_query.getCaretPosition() + 1, searchEvent.getDirection() == SearchEvent.Direction.FORWARD, false, true, true);
                    if (n >= 0) {
                        SQLQueryComponentPanel.this.setSelection(n, string.length());
                        SQLQueryComponentPanel.this.m_query.requestFocusInWindow();
                    }
                } else {
                    findHighlightPlugin.clearFindHighlighting();
                }
            }
        });
    }

    private Context getIdeContextForInsight() {
        Context context = Context.newIdeContext();
        DBObjectNode dBObjectNode = this.m_context.getEditorConfig().getOriginalObjectNode();
        Node node = null;
        node = dBObjectNode instanceof Node ? (Node)dBObjectNode : new Node();
        context.setNode(node);
        return context;
    }

    private void ensureInActionMap(String string) {
        Action action;
        ActionMap actionMap = this.m_query.getActionMap();
        if (actionMap.get(string) == null && (action = ((BasicEditorKit)this.m_query.getEditorKit()).findAction(string)) != null) {
            actionMap.put(string, action);
        }
    }

    public String getQueryString() {
        return this.getTextComponent().getText();
    }

    public void setQueryString(String string) {
        this.m_query.setEditable(true);
        if (string == null) {
            SQLQuery sQLQuery = new SQLQuery();
            sQLQuery.setDeclarative(true);
            String string2 = sQLQuery.getSQLText();
            this.m_originalText = string2 == null ? "" : string2.trim();
            string = string2;
        } else if (!ModelUtil.hasLength((String)this.m_originalText)) {
            this.m_originalText = string;
        }
        this.setQueryTextImpl(string);
    }

    private void setQueryTextImpl(String string) {
        String string2 = this.m_query.getText();
        if (ModelUtil.areDifferent((Object)string2, (Object)string)) {
            this.m_query.setText(string);
            this.m_undo.clearUndo();
            this.m_query.setCaretPosition(0, true);
        }
    }

    private void setSelection(int n, int n2) {
        try {
            this.m_query.setCaretPosition(n, true);
            this.m_query.setSelectionStart(n);
            this.m_query.setSelectionEnd(n2 + n);
        }
        catch (Exception exception) {
            DBLog.getLogger((Object)this).log(Level.FINE, "Selection error", exception);
        }
    }

    void setSelection(SQLFragment sQLFragment) {
        Integer n;
        if (sQLFragment != null && (n = sQLFragment.getStartOffset()) != null) {
            this.setSelection(n, sQLFragment.getSQLText().length());
        }
    }

    public boolean addQueryListener(SQLQueryListener sQLQueryListener) {
        if (sQLQueryListener != null) {
            return this.m_listeners.add(sQLQueryListener);
        }
        return false;
    }

    public boolean removeQueryListener(SQLQueryListener sQLQueryListener) {
        if (sQLQueryListener != null) {
            return this.m_listeners.remove(sQLQueryListener);
        }
        return false;
    }

    private boolean canRevertBeEnabled() {
        return ModelUtil.hasLength((String)this.m_originalText) && !this.m_originalText.equals("SELECT \n    \nFROM \n    \n") && !this.m_originalText.equals(this.getTextComponent().getText());
    }

    private void addButtonListeners() {
        this.m_edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SQLQueryOwner sQLQueryOwner = (SQLQueryOwner)SQLQueryComponentPanel.this.m_context.getUpdatedObject();
                SQLQueryEditDialog sQLQueryEditDialog = new SQLQueryEditDialog(sQLQueryOwner.getType() == "MATERIALIZED VIEW");
                SQLQuery sQLQuery = sQLQueryOwner.getSQLQuery();
                String string = sQLQuery.getQueryString();
                SQLQuery sQLQuery2 = (SQLQuery)sQLQuery.copyTo(null, (IDPolicy)new IDPolicy.SameIDPolicy());
                SQLQuery sQLQuery3 = sQLQueryEditDialog.editQuery(sQLQuery2, SQLQueryComponentPanel.this.m_context.getProvider(), DBUtil.getSchema((DBObject)sQLQueryOwner));
                String string2 = sQLQuery2.getQueryString();
                if (string.equals(string2)) {
                    SQLQueryComponentPanel.this.copyToSilently(sQLQuery2, sQLQuery);
                } else if (sQLQuery3 != null) {
                    sQLQuery2.copyTo((Object)sQLQuery);
                    SQLQueryComponentPanel.this.setQueryTextImpl(string2);
                    SQLQueryComponentPanel.this.notifyListeners();
                }
            }
        });
        this.m_revert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SQLQueryComponentPanel.this.initQuery();
                SQLQueryComponentPanel.this.getTextComponent().requestFocusInWindow();
                SQLQueryComponentPanel.this.notifyListeners();
            }
        });
        this.m_liveTest.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object var2_2 = null;
                Database database = null;
                try {
                    Object object;
                    Object object2;
                    if (SQLQueryComponentPanel.this.m_liveTester == null) {
                        object2 = SQLQueryComponentPanel.this.m_context.getProvider();
                        object = null;
                        if (object2 instanceof Database) {
                            boolean bl = false;
                            object = (Database)object2;
                            Schema schema = DBUtil.getSchema((DBObject)SQLQueryComponentPanel.this.m_context.getUpdatedObject());
                            if (schema != null) {
                                try {
                                    Schema schema2 = object.getDefaultSchema();
                                    if (!object.getDescriptor().areNamesEqual((DBObject)schema, (DBObject)schema2)) {
                                        bl = true;
                                        if (object instanceof OracleDatabase) {
                                            database = ((OracleDatabase)object).createStandaloneDatabase(schema);
                                        }
                                    }
                                }
                                catch (DBException dBException) {
                                    DBLog.getLogger((Object)this).warning(dBException.getMessage());
                                }
                            }
                            if (bl && database == null) {
                                MessageDialog.error((Component)SQLQueryComponentPanel.this, (Object)UIBundle.get("TESTSQL_SCHEMA_CHANGE_ERR"), (String)UIBundle.get("TESTSQL_TITLE"), null);
                            }
                        }
                        (SQLQueryComponentPanel.this.m_liveTester = new SQLQueryTester((Database)(database == null ? object : database), true)).setShowConnectionPicker(object == null);
                        if (object != null) {
                            SQLQueryComponentPanel.this.m_liveTester.setDefaultConnectionStore(object.getConnectionStore());
                        }
                        SQLQueryComponentPanel.this.m_liveTester.setContext((Context)SQLQueryComponentPanel.this.m_context.getDataContext().find(Context.class));
                    }
                    object = (object2 = SQLQueryComponentPanel.this.m_liveTester.showDialog(SQLQueryComponentPanel.this.m_liveTest, SQLQueryComponentPanel.this.getTextComponent().getText())) == null ? null : ((SQLQueryTester.Result)object2).getMessage();
                    SQLQueryComponentPanel.this.m_liveTest.setToolTipText((String)object);
                }
                finally {
                    if (database != null) {
                        SQLQueryComponentPanel.this.m_liveTester = null;
                        database.close();
                    }
                }
            }
        });
        this.m_test.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SQLQueryComponentPanel.this.testQuery();
            }
        });
    }

    private void notifyListeners() {
        this.m_revert.setEnabled(this.canRevertBeEnabled());
        for (SQLQueryListener sQLQueryListener : this.m_listeners) {
            sQLQueryListener.queryUpdated();
        }
    }

    public final JTextComponent getTextComponent() {
        return this.m_query;
    }

    public final JLabel getLabel() {
        return this.m_queryLabel;
    }

    public final Component[] getEditingComponents() {
        return new Component[]{this.getTextComponent(), this.m_revert};
    }

    public static BasicEditorPane createSQLEditorPane() {
        BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane();
        basicEditorPane.setLanguageSupport("foo.sql");
        basicEditorPane.getDocument().putProperty("__EndOfLine__", "\n");
        return basicEditorPane;
    }

    private void initQuery() {
        this.m_query.getDocument().removeDocumentListener(this.m_queryTextListener);
        if (ModelUtil.hasLength((String)this.m_originalText)) {
            this.setQueryTextImpl(this.m_originalText);
        } else {
            this.setQueryTextImpl("SELECT \n    \nFROM \n    \n");
        }
        this.m_query.getDocument().addDocumentListener(this.m_queryTextListener);
        this.m_revert.setEnabled(false);
        this.m_feedback.setText(null, false);
        this.m_feedbackLabel.setVisible(false);
        this.m_feedback.setVisible(false);
        this.validate();
    }

    protected boolean isCheckSyntaxDeclarative() {
        boolean bl = true;
        PanelLibrary panelLibrary = (PanelLibrary)this.m_context.getDataContext().find(PanelLibrary.class);
        if (panelLibrary instanceof SQLQueryOwnerPanelLibrary) {
            bl = ((SQLQueryOwnerPanelLibrary)panelLibrary).showDeclarativePanels();
        }
        return bl;
    }

    private void testQuery() {
        this.m_feedbackLabel.setVisible(true);
        this.m_feedback.setVisible(true);
        final String string = this.getTextComponent().getText().trim();
        DBObjectProvider dBObjectProvider = this.m_context.getProvider();
        final DBObject dBObject = this.m_context.getUpdatedObject();
        SchemaObject schemaObject = DBUtil.getSchemaObject((DBObject)dBObject);
        Schema schema = DBUtil.getSchema((DBObject)schemaObject);
        final SQLQuery sQLQuery = new SQLQuery(string);
        if (schemaObject instanceof SQLQueryOwner) {
            sQLQuery.setParent((DBObject)((SQLQueryOwner)schemaObject));
        }
        final SQLQueryBuilder sQLQueryBuilder = SQLQueryBuilderFactory.findOrCreateBuilder((SQLQuery)sQLQuery, (DBObjectProvider)dBObjectProvider, (Schema)schema);
        final Holder holder = new Holder((Object)false);
        final Holder holder2 = new Holder();
        final ProgressBar progressBar = new ProgressBar((Component)this.m_test, this.m_test.getText(), null, true);
        progressBar.setCancelable(true);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String string2;
                try {
                    if (SQLQueryComponentPanel.this.isCheckSyntaxDeclarative()) {
                        sQLQueryBuilder.buildQuery(sQLQuery);
                        holder.set((Object)true);
                        OrderByObject[] orderByObjectArray = sQLQuery.getOrderByObjects();
                        string2 = dBObject instanceof MaterializedView && orderByObjectArray != null && orderByObjectArray.length > 0 ? UIBundle.get("QUERY_ORDER_BY_ON_MV") : UIBundle.get("QUERY_SUCCESS");
                    } else {
                        SyntaxError syntaxError = SyntaxError.checkSyntax((String)string, (String[])new String[]{"subquery", "select"});
                        string2 = syntaxError != null ? syntaxError.getDetailedMessage() : UIBundle.get("QUERY_SUCCESS");
                    }
                }
                catch (SQLParseException sQLParseException) {
                    string2 = sQLParseException.getMessage();
                }
                catch (SQLQueryClauseException sQLQueryClauseException) {
                    string2 = sQLQueryClauseException.getMessage();
                }
                catch (SQLQueryCancelledException sQLQueryCancelledException) {
                    string2 = null;
                }
                catch (SQLQueryException sQLQueryException) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(UIBundle.get("QUERY_TOO_CLEVER"));
                    stringBuilder.append("\n\n").append(sQLQueryException.getMessage());
                    string2 = stringBuilder.toString();
                }
                catch (Exception exception) {
                    DBLog.getLogger((Object)this).log(Level.SEVERE, "Error parsing sql query", exception);
                    string2 = null;
                }
                holder2.set((Object)string2);
                progressBar.setDoneStatus();
            }
        };
        progressBar.setRunnable(runnable);
        progressBar.start(null, null, 1500);
        String string2 = (String)holder2.get();
        if (progressBar.hasUserCancelled() && string2 == null) {
            sQLQueryBuilder.cancelCurrentBuild(sQLQuery);
            string2 = new SQLQueryCancelledException(null).getMessage();
        }
        if (string2 != null) {
            this.m_feedback.setText(string2, true);
            if (Boolean.TRUE.equals(holder.get())) {
                DBObject dBObject2 = this.m_context.getUpdatedObject();
                this.copyToSilently(sQLQuery, dBObject2 instanceof SQLQueryOwner ? ((SQLQueryOwner)dBObject2).getSQLQuery() : (SQLQuery)dBObject2);
            }
            this.validate();
        }
    }

    private void copyToSilently(final SQLQuery sQLQuery, final SQLQuery sQLQuery2) {
        if (sQLQuery.isDeclarative() && !sQLQuery2.isDeclarative()) {
            DBLog.getLogger((Object)this).fine("Preserving declarative copy for query");
            DBUtil.invokeCompoundChange((DBObject)sQLQuery2, (Runnable)new Runnable(){

                @Override
                public void run() {
                    sQLQuery.copyTo((Object)sQLQuery2);
                }
            }, (boolean)false);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "--CREATE VIEW clerk AS\n   SELECT employee_id, last_name, department_id, job_id \n   FROM employees\n   WHERE job_id = 'PU_CLERK' \n      or job_id = 'SH_CLERK' \n      or job_id = 'ST_CLERK'";
        OracleSQLQueryBuilderHelper.checkSyntax((String)string);
    }

    public static interface SQLQueryListener {
        public void queryUpdated();
    }
}

