/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.mviewlog;

import java.beans.PropertyChangeEvent;
import javax.swing.JLabel;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.icons.OracleIcons;

public class MViewLogHeader
extends BaseEditorPanel<MaterializedViewLog> {
    @Override
    protected void initialisePanel() {
        ComponentWrapper componentWrapper = this.getOrCreateWrapper("masterTableID");
        if (this.getProvider() instanceof Database && this.getEditorConfig().isEdit()) {
            componentWrapper.setEnabled(false);
        }
    }

    @Override
    protected void initialiseComponents() {
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        ComponentWrapper componentWrapper = this.getOrCreateWrapper("masterTableID");
        dBUILayoutHelper.addChildren(componentWrapper, new Integer[0]);
        dBUILayoutHelper.nextRow();
        String string = TemplateExpander.getTemplateObjectName(this.getUpdatedObject());
        if (string != null) {
            JLabel jLabel = new JLabel();
            jLabel.setText(string);
            jLabel.setIcon(OracleIcons.getIcon((String)"copy.png"));
            jLabel.setToolTipText(UIBundle.format("TEMPLATE_USAGE_HINT_GENERAL", string));
            dBUILayoutHelper.add(jLabel, 2, 1);
        }
        dBUILayoutHelper.pushUp();
        dBUILayoutHelper.layout();
    }

    @Override
    protected DBObjectListener createObjectListener() {
        return new DBObjectListener(){

            public void objectUpdated(DBObjectChange dBObjectChange) {
                super.objectUpdated(dBObjectChange);
                PropertyChangeEvent propertyChangeEvent = dBObjectChange.getPropertyChange("masterTableID");
                if (propertyChangeEvent != null) {
                    MaterializedViewLog materializedViewLog = (MaterializedViewLog)MViewLogHeader.this.getUpdatedObject();
                    DBObjectID dBObjectID = (DBObjectID)propertyChangeEvent.getNewValue();
                    String string = dBObjectID == null ? null : DBUtil.getDBObjectName((DBObjectID)dBObjectID);
                    materializedViewLog.setName(string);
                    if (dBObjectID != null) {
                        try {
                            Schema schema = MViewLogHeader.this.getProvider().getSchema(DBUtil.getSchemaName((DBObjectID)dBObjectID));
                            materializedViewLog.setSchema(schema);
                        }
                        catch (DBException dBException) {
                            MViewLogHeader.this.getLogger().warning(dBException.getMessage());
                        }
                    } else {
                        materializedViewLog.setSchema(null);
                    }
                }
            }
        };
    }
}

