/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.model;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ide.util.dnd.DragHelper;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.ModelUtil;

public class DatabaseDragHelper
implements DragHelper {
    private static final Map<String, DataFlavor> s_typeFlavor = new HashMap<String, DataFlavor>();
    private static final Map<String, DataFlavor> s_providerFlavor = new HashMap<String, DataFlavor>();

    private static DataFlavor findTypeDataFlavor(String string) {
        return s_typeFlavor.get(string);
    }

    private static DataFlavor findProviderDataFlavor(String string) {
        return s_providerFlavor.get(string);
    }

    private static DataFlavor[] getDataFlavors(String string, String string2) {
        DataFlavor[] dataFlavorArray;
        Metadata metadata;
        Class clazz;
        DataFlavor dataFlavor = null;
        if (ModelUtil.hasLength((String)string) && (dataFlavor = DatabaseDragHelper.findProviderDataFlavor(string)) == null) {
            dataFlavor = new DataFlavor(DBObjectProvider.class, string);
            s_providerFlavor.put(string, dataFlavor);
        }
        if ((clazz = (metadata = Metadata.getInstance()).getObjectClass(string2)) != null) {
            DataFlavor dataFlavor2 = DatabaseDragHelper.findTypeDataFlavor(string2);
            if (dataFlavor2 == null) {
                dataFlavor2 = new DataFlavor(clazz, string2);
                s_typeFlavor.put(string2, dataFlavor2);
            }
            dataFlavorArray = dataFlavor != null ? new DataFlavor[]{dataFlavor, dataFlavor2} : new DataFlavor[]{dataFlavor2};
        } else {
            dataFlavorArray = new DataFlavor[]{};
        }
        return dataFlavorArray;
    }

    public Transferable getTransferable(Object object) {
        DBObjectTransferable dBObjectTransferable = new DBObjectTransferable(object);
        return dBObjectTransferable;
    }

    public class DBObjectTransferable
    implements Transferable {
        private Object m_data;

        private DBObjectTransferable(Object object) {
            this.m_data = object;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray;
            if (this.m_data instanceof DBObjectTypeNode) {
                String string = DBObjectNodeUtil.normalizeType((DBObjectTypeNode)this.m_data);
                String string2 = DBObjectNodeUtil.getProviderType(this.m_data);
                dataFlavorArray = DatabaseDragHelper.getDataFlavors(string2, string);
            } else {
                dataFlavorArray = new DataFlavor[]{};
            }
            return dataFlavorArray;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            Class<?> clazz = dataFlavor.getRepresentationClass();
            boolean bl = DBObject.class.isAssignableFrom(clazz) || DBObjectProvider.class.isAssignableFrom(clazz);
            return bl;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            Object object = null;
            if (this.isDataFlavorSupported(dataFlavor)) {
                Class<?> clazz = dataFlavor.getRepresentationClass();
                object = DBObjectProvider.class.isAssignableFrom(clazz) ? DBObjectNodeUtil.findProvider(this.m_data) : DBObjectNodeUtil.getDBObject(this.m_data);
            } else {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return object;
        }
    }
}

