/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.ui.ExtendedTextField;
import oracle.javatools.ui.PopupButton;
import oracle.javatools.ui.plaf.IconicButtonUI;

public abstract class TableCellEditorWithPopup
extends AbstractCellEditor
implements TableCellEditor {
    private final DBUIResourceHelper m_helper;
    private final ExtendedTextField m_editor;
    private final EditButton m_button;
    private boolean m_popupShowing;

    public TableCellEditorWithPopup(String string) {
        this(string, false, true, null);
    }

    public TableCellEditorWithPopup(String string, boolean bl, boolean bl2, Icon icon) {
        this.m_helper = new DBUIResourceHelper(string);
        this.m_editor = new ExtendedTextField();
        this.m_editor.setAllowBreaks(bl);
        this.m_helper.setName((Component)this.m_editor, "Editor");
        this.m_button = new EditButton();
        this.m_button.setPopupLocation(PopupButton.PopupLocation.BOTTOM_LEFT);
        if (icon != null) {
            this.m_button.setIcon(icon);
        }
        IconicButtonUI.install((AbstractButton)((Object)this.m_button));
        this.m_helper.setName((Component)((Object)this.m_button), "PopupButton");
    }

    protected final ExtendedTextField getEditor() {
        return this.m_editor;
    }

    protected final DBUIResourceHelper getResourceHelper() {
        return this.m_helper;
    }

    protected final JPanel getPopupPanel() {
        return this.m_button.m_panel;
    }

    @Override
    public Object getCellEditorValue() {
        return this.m_editor.getText();
    }

    protected boolean supportsPopup(JTable jTable, Object object, int n, int n2) {
        return true;
    }

    protected String getEditorText(JTable jTable, Object object, int n, int n2) {
        String string = object instanceof String ? (String)object : null;
        return string;
    }

    @Override
    public boolean stopCellEditing() {
        this.hidePopup();
        return super.stopCellEditing();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        String string = this.getEditorText(jTable, object, n, n2);
        this.m_editor.setText(string);
        if (this.supportsPopup(jTable, object, n, n2)) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)this.m_editor, "Center");
            jPanel.add((Component)((Object)this.m_button), "East");
            InputMap inputMap = jPanel.getInputMap(1);
            inputMap.put(KeyStroke.getKeyStroke(40, 0), "popup");
            jPanel.getActionMap().put("popup", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableCellEditorWithPopup.this.showPopup();
                }
            });
            return jPanel;
        }
        return this.m_editor;
    }

    protected Integer getPreferredPopupHeight() {
        return 200;
    }

    protected final void hidePopup() {
        this.m_button.hidePopup();
    }

    protected final void showPopup() {
        this.m_button.showPopup();
    }

    protected abstract void initPopup(JPanel var1);

    protected abstract void commitPopup();

    protected final boolean isPopupShowing() {
        return this.m_popupShowing;
    }

    private class EditButton
    extends PopupButton {
        private final JPanel m_panel;

        EditButton() {
            this.m_panel = new JPanel(){

                @Override
                public Dimension getPreferredSize() {
                    Integer n = TableCellEditorWithPopup.this.getPreferredPopupHeight();
                    int n2 = n == null ? super.getPreferredSize().height : n;
                    int n3 = TableCellEditorWithPopup.this.m_editor.getWidth() + EditButton.this.getWidth();
                    return new Dimension(n3, n2);
                }
            };
            this.setPopupContent(this.m_panel);
        }

        protected void hidePopup() {
            super.hidePopup();
            TableCellEditorWithPopup.this.m_popupShowing = false;
            TableCellEditorWithPopup.this.commitPopup();
        }

        protected void showPopup() {
            TableCellEditorWithPopup.this.initPopup(this.m_panel);
            super.showPopup();
            TableCellEditorWithPopup.this.m_popupShowing = true;
        }
    }
}

