/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.concurrent.CancellationException;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.DBURLFactory;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.model.NodeFactory;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.db.AbstractDBObjectID;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlBlock;
import oracle.javatools.db.plsql.PlSqlCodeFragment;
import oracle.javatools.db.plsql.PlSqlComment;
import oracle.javatools.db.plsql.PlSqlDatatype;
import oracle.javatools.db.plsql.PlSqlDatum;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSchemaObject;
import oracle.javatools.db.plsql.PlSqlSchemaObjectBody;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.db.sql.BuiltInFunctionArgument;
import oracle.javatools.db.token.Token;
import oracle.javatools.editor.popup.HtmlContentProvider;
import oracle.javatools.editor.popup.HtmlPopupView;
import oracle.javatools.util.ModelUtil;

public class PlSqlPopupContentProvider
implements HtmlContentProvider {
    private final DBObjectProvider m_pro;
    private final BaseDBObjectTextNode m_node;
    private final int m_offset;
    private final String m_anchor;
    private DBObjectID m_id;
    private String m_content;
    private static final String COLUMNS_ANCHOR = "COL";
    private static final String METHODS_ANCHOR = "METH";
    private static final String ATTRIBUTES_ANCHOR = "ATTR";
    private static final String COMMA = ",";
    private static final String SPACE = " ";
    private static final String SEMICOLON = ";";
    private static final String LPAREN = "(";
    private static final String RPAREN = ")";
    private static final String HASH = "#";
    private static final String NEW_LINE = "\n";
    private static final String DOUBLE_NEW_LINE = "\n\n";
    private static final String PREFORMAT = "<pre>";
    private static final String PREFORMAT_END = "</pre>";
    private static final String BOLD = "<b>";
    private static final String BOLD_END = "</b>";
    private static final String SMALL = "<small>";
    private static final String SMALL_END = "</small>";
    private static final String ARG_PREFIX = "a";

    PlSqlPopupContentProvider(BaseDBObjectTextNode baseDBObjectTextNode, int n) {
        this(baseDBObjectTextNode.getProvider(), null, null, baseDBObjectTextNode, n);
    }

    private PlSqlPopupContentProvider(DBObjectProvider dBObjectProvider, DBObjectID dBObjectID, String string, BaseDBObjectTextNode baseDBObjectTextNode, int n) {
        if (dBObjectProvider == null) {
            throw new IllegalArgumentException("m_pro is null");
        }
        if (dBObjectID == null && baseDBObjectTextNode == null) {
            throw new IllegalArgumentException("id and node both null, one must be set");
        }
        this.m_pro = dBObjectProvider;
        this.m_node = baseDBObjectTextNode;
        this.m_offset = n;
        this.m_id = dBObjectID;
        this.m_anchor = string;
        this.m_content = null;
    }

    public String getHTML() {
        try {
            return this.getHTMLImpl();
        }
        catch (CancelledException cancelledException) {
            throw new CancellationException();
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getHTMLImpl() throws CancelledException {
        if (this.m_content == null) {
            Object object;
            Object object2;
            SourceObject sourceObject;
            if (this.m_id == null && (sourceObject = this.m_node.getDBObjectFromBuffer()) instanceof PlSqlSourceObject && (object2 = (object = (PlSqlSourceObject)sourceObject).getReferenceAtOffset(this.m_offset)) instanceof PlSqlReference) {
                PlSqlReference plSqlReference = (PlSqlReference)object2;
                this.m_id = plSqlReference.getReferenceID();
            }
            if (this.m_id != null) {
                PlSqlSourceObject plSqlSourceObject;
                Object object3;
                Object object4;
                sourceObject = null;
                try {
                    sourceObject = this.m_id.resolveID();
                }
                catch (CancelledException cancelledException) {
                    throw cancelledException;
                }
                catch (DBException dBException) {
                    sourceObject = null;
                }
                if (sourceObject == null && this.m_id instanceof BaseObjectID && this.m_id.getParent() == null) {
                    object = ((BaseObjectID)this.m_id).getName();
                    object2 = new StringTokenizer((String)object, "(),", false);
                    int n = ((StringTokenizer)object2).countTokens() - 1;
                    object4 = ((StringTokenizer)object2).nextToken();
                    object3 = this.m_pro.getDescriptor().listBuiltInFunctions((String)object4).iterator();
                    if (object3.hasNext()) {
                        plSqlSourceObject = (BuiltInFunction)object3.next();
                        sourceObject = plSqlSourceObject;
                    }
                }
                object = new StringBuilder();
                int n = ((StringBuilder)object).length();
                boolean bl = false;
                if (sourceObject != null) {
                    int n2;
                    PlSqlComment plSqlComment;
                    object4 = sourceObject.getParent();
                    if (object4 != null) {
                        ((StringBuilder)object).append(SMALL);
                        this.addLink((StringBuilder)object, this.getType((DBObject)object4) + SPACE + this.getName((DBObject)object4), object4.getID());
                        ((StringBuilder)object).append(SMALL_END);
                        ((StringBuilder)object).append(DOUBLE_NEW_LINE);
                    }
                    n = ((StringBuilder)object).length();
                    if (sourceObject instanceof PlSqlCodeFragment) {
                        object3 = (PlSqlCodeFragment)sourceObject;
                        plSqlSourceObject = (PlSqlSourceObject)DBUtil.getSchemaObject((DBObject)object3);
                        plSqlComment = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)plSqlSourceObject, (DBObjectProvider)this.m_pro);
                        if (plSqlComment != null) {
                            for (n2 = 1; n2 < this.getLineOfset((DBObjectPlSqlFragment)object3); ++n2) {
                                ((StringBuilder)object).append(SPACE);
                            }
                            n2 = object3.getStartOffset();
                            int n3 = n2 - 1;
                            if (sourceObject instanceof PlSqlSubProgram) {
                                PlSqlSubProgram plSqlSubProgram2 = (PlSqlSubProgram)sourceObject;
                                n2 = sourceObject == plSqlSourceObject ? plSqlComment.getRoot().getStartOffset().intValue() : plSqlSubProgram2.getStartOffset().intValue();
                                if (plSqlSubProgram2.getReturnTypeReference() != null) {
                                    n3 = plSqlSubProgram2.getReturnTypeReference().getEndOffset();
                                } else if (plSqlSubProgram2.getParameters().length > 0) {
                                    for (PlSqlToken plSqlToken : plSqlSubProgram2.getParameters()) {
                                        int n4 = plSqlToken.getDataTypeReference().getEndOffset();
                                        if (n4 <= n3) continue;
                                        n3 = n4;
                                    }
                                    if (n3 != n2) {
                                        var12_39 = plSqlComment.getTokenAtOffset(n3);
                                        var12_39 = (PlSqlToken)var12_39.getNextCodeToken();
                                        n3 = var12_39.getEnd();
                                    }
                                } else {
                                    var12_39 = plSqlComment.getNameToken();
                                    n3 = var12_39.getEnd();
                                }
                            } else if (sourceObject instanceof PlSqlDatum || sourceObject instanceof PlSqlDatatype) {
                                void var11_25;
                                PlSqlToken plSqlToken = plSqlComment.getTokenAtOffset(n2);
                                int n5 = 0;
                                while (!(var11_25.getType() == Token.Type.END_MARKER || n5 == 0 && (var11_25.matches(RPAREN) || var11_25.matches(COMMA) || var11_25.matches(SEMICOLON)))) {
                                    if (var11_25.matches(LPAREN)) {
                                        ++n5;
                                    } else if (var11_25.matches(RPAREN)) {
                                        --n5;
                                    }
                                    n3 = var11_25.getEnd();
                                    PlSqlToken plSqlToken2 = (PlSqlToken)var11_25.getNextCodeToken();
                                }
                            }
                            if (n2 <= n3) {
                                void var11_29;
                                PlSqlToken plSqlToken = plSqlComment.getTokenAtOffset(n2);
                                boolean bl2 = false;
                                while (var11_29.getStart() <= n3) {
                                    PlSqlToken plSqlToken3;
                                    DBObjectPlSqlFragment dBObjectPlSqlFragment = object3.getDeclarationAtOffset(var11_29.getStart());
                                    PlSqlReference plSqlReference = (PlSqlReference)object3.getReferenceAtOffset(var11_29.getStart());
                                    if (plSqlReference != null && !(plSqlReference.getReferenceID() instanceof DataTypeID) && (dBObjectPlSqlFragment == null || ModelUtil.areDifferent((Object)dBObjectPlSqlFragment.getStartOffset(), (Object)plSqlReference.getStartOffset()))) {
                                        this.addLink((StringBuilder)object, var11_29.getSource(), plSqlReference.getReferenceID());
                                    } else if (var11_29.matches(this.getName((DBObject)sourceObject)) && !bl2) {
                                        ((StringBuilder)object).append(BOLD);
                                        ((StringBuilder)object).append(var11_29.getSource());
                                        ((StringBuilder)object).append(BOLD_END);
                                        bl2 = true;
                                    } else {
                                        ((StringBuilder)object).append(var11_29.getSource());
                                    }
                                    if (!(plSqlToken3 = (PlSqlToken)var11_29.getNextToken()).isEndMarker()) continue;
                                    break;
                                }
                                bl = true;
                                ((StringBuilder)object).append(DOUBLE_NEW_LINE);
                            }
                        }
                    } else if (sourceObject instanceof Column) {
                        ((StringBuilder)object).append(this.getType((DBObject)sourceObject));
                        ((StringBuilder)object).append(SPACE);
                        ((StringBuilder)object).append(this.getColumnDetails((Column)sourceObject, false));
                        bl = true;
                        ((StringBuilder)object).append(DOUBLE_NEW_LINE);
                    } else if (sourceObject instanceof BuiltInFunction) {
                        this.addBuiltInFunctionDoc((StringBuilder)object, (BuiltInFunction)sourceObject, this.m_pro);
                        bl = true;
                    }
                    if (!bl) {
                        ((StringBuilder)object).append(this.getType((DBObject)sourceObject));
                        ((StringBuilder)object).append(SPACE);
                        ((StringBuilder)object).append(BOLD);
                        ((StringBuilder)object).append(this.getName((DBObject)sourceObject));
                        ((StringBuilder)object).append(BOLD_END);
                        ((StringBuilder)object).append(DOUBLE_NEW_LINE);
                    }
                    if (this.m_anchor == null) {
                        if (sourceObject instanceof Relation) {
                            this.addLink((StringBuilder)object, DBTypeDisplayRegistry.getDisplayName("COLUMN"), this.m_id, COLUMNS_ANCHOR);
                            ((StringBuilder)object).append(DOUBLE_NEW_LINE);
                        } else if (sourceObject instanceof PlSqlBlock && !(sourceObject instanceof PlSqlSubProgram)) {
                            this.addLink((StringBuilder)object, DBTypeDisplayRegistry.getDisplayName("PlSqlSubProgram"), this.m_id, METHODS_ANCHOR);
                            ((StringBuilder)object).append(SPACE);
                            this.addLink((StringBuilder)object, DBTypeDisplayRegistry.getDisplayName("PlSqlVariable"), this.m_id, ATTRIBUTES_ANCHOR);
                            ((StringBuilder)object).append(DOUBLE_NEW_LINE);
                        }
                    } else {
                        object3 = null;
                        if (COLUMNS_ANCHOR.equals(this.m_anchor)) {
                            if (sourceObject instanceof Relation) {
                                object3 = Boolean.FALSE;
                                ((StringBuilder)object).append(DBTypeDisplayRegistry.getDisplayName("COLUMN"));
                                ((StringBuilder)object).append(NEW_LINE);
                                plSqlSourceObject = ((Relation)sourceObject).getColumns();
                                int n6 = ((Column[])plSqlSourceObject).length;
                                for (n2 = 0; n2 < n6; ++n2) {
                                    Column column = plSqlSourceObject[n2];
                                    ((StringBuilder)object).append(this.getColumnDetails(column, true));
                                    ((StringBuilder)object).append(NEW_LINE);
                                    object3 = Boolean.TRUE;
                                }
                            }
                        } else if (sourceObject instanceof PlSqlBlock && !(sourceObject instanceof PlSqlSubProgram)) {
                            plSqlSourceObject = (PlSqlBlock)sourceObject;
                            if (METHODS_ANCHOR.equals(this.m_anchor)) {
                                object3 = Boolean.FALSE;
                                ((StringBuilder)object).append(DBTypeDisplayRegistry.getDisplayName("PlSqlSubProgram"));
                                ((StringBuilder)object).append(SPACE);
                                this.addLink((StringBuilder)object, DBTypeDisplayRegistry.getDisplayName("PlSqlVariable"), this.m_id, ATTRIBUTES_ANCHOR);
                                ((StringBuilder)object).append(DOUBLE_NEW_LINE);
                                for (PlSqlSubProgram plSqlSubProgram : plSqlSourceObject.getSubPrograms()) {
                                    this.addLink((StringBuilder)object, this.getName((DBObject)plSqlSubProgram), plSqlSubProgram.getID());
                                    ((StringBuilder)object).append(NEW_LINE);
                                    object3 = Boolean.TRUE;
                                }
                            } else if (ATTRIBUTES_ANCHOR.equals(this.m_anchor)) {
                                object3 = Boolean.FALSE;
                                this.addLink((StringBuilder)object, DBTypeDisplayRegistry.getDisplayName("PlSqlSubProgram"), this.m_id, METHODS_ANCHOR);
                                ((StringBuilder)object).append(SPACE);
                                ((StringBuilder)object).append(DBTypeDisplayRegistry.getDisplayName("PlSqlVariable"));
                                ((StringBuilder)object).append(DOUBLE_NEW_LINE);
                                for (PlSqlComment plSqlComment2 : plSqlSourceObject.getVariables()) {
                                    this.addLink((StringBuilder)object, this.getName((DBObject)plSqlComment2), plSqlComment2.getID());
                                    ((StringBuilder)object).append(NEW_LINE);
                                    object3 = Boolean.TRUE;
                                }
                            }
                        }
                        if (object3 != null) {
                            if (!((Boolean)object3).booleanValue()) {
                                ((StringBuilder)object).append(UIBundle.get("PLSQL_DOC_NONE"));
                            }
                            ((StringBuilder)object).append(NEW_LINE);
                        }
                    }
                    boolean bl3 = true;
                    if (sourceObject instanceof PlSqlCodeFragment) {
                        PlSqlSourceObject plSqlSourceObject2;
                        plSqlSourceObject = (PlSqlCodeFragment)sourceObject;
                        plSqlComment = this.getPrecedingComment((PlSqlCodeFragment)plSqlSourceObject);
                        if (plSqlComment == null && (plSqlSourceObject2 = (PlSqlSourceObject)DBUtil.getSchemaObject((DBObject)plSqlSourceObject)) instanceof PlSqlSchemaObjectBody) {
                            PlSqlSchemaObjectBody plSqlSchemaObjectBody = (PlSqlSchemaObjectBody)plSqlSourceObject2;
                            ReferenceID referenceID = new ReferenceID((DBObject)plSqlSourceObject, this.m_pro);
                            ReferenceID referenceID2 = (ReferenceID)ReferenceID.copyWithNewType((AbstractDBObjectID)referenceID, Collections.singletonMap(plSqlSourceObject2.getType(), PlSqlUtil.getCompanionObjectType((PlSqlSchemaObject)plSqlSchemaObjectBody)));
                            PlSqlCodeFragment plSqlCodeFragment = null;
                            try {
                                plSqlCodeFragment = (PlSqlCodeFragment)referenceID2.resolveID();
                                if (plSqlCodeFragment != null) {
                                    plSqlComment = this.getPrecedingComment(plSqlCodeFragment);
                                }
                            }
                            catch (DBException dBException) {
                                DBLog.getLogger((Object)this).fine(dBException.getMessage());
                            }
                        }
                        if (plSqlComment != null) {
                            ((StringBuilder)object).append(BOLD);
                            ((StringBuilder)object).append(UIBundle.get("PLSQL_DOC_COMMENTS"));
                            ((StringBuilder)object).append(BOLD_END);
                            ((StringBuilder)object).append(DOUBLE_NEW_LINE);
                            for (int i = 0; i < this.getLineOfset((DBObjectPlSqlFragment)plSqlComment); ++i) {
                                ((StringBuilder)object).append(SPACE);
                            }
                            String string = this.tidyComment(plSqlComment.getText(), bl3);
                            ((StringBuilder)object).append(string);
                            ((StringBuilder)object).append(NEW_LINE);
                        }
                    } else if (sourceObject != null && (plSqlSourceObject = this.tidyComment((String)sourceObject.getProperty("Comment"), bl3)) != null) {
                        ((StringBuilder)object).append(BOLD);
                        ((StringBuilder)object).append(UIBundle.get("PLSQL_DOC_COMMENTS"));
                        ((StringBuilder)object).append(BOLD_END);
                        ((StringBuilder)object).append(DOUBLE_NEW_LINE);
                        ((StringBuilder)object).append((String)plSqlSourceObject);
                        ((StringBuilder)object).append(NEW_LINE);
                    }
                }
                if (((StringBuilder)object).length() == n) {
                    ((StringBuilder)object).append(UIBundle.get("NO_PLSQL_DOC_AVAILABLE"));
                    ((StringBuilder)object).append(NEW_LINE);
                }
                ((StringBuilder)object).insert(0, PREFORMAT);
                ((StringBuilder)object).append(PREFORMAT_END);
                this.m_content = ((StringBuilder)object).toString();
            }
        }
        return this.m_content;
    }

    public void navigate(HtmlPopupView htmlPopupView, String string) {
        Object object;
        String[] stringArray = string.split(HASH);
        String string2 = null;
        if (stringArray.length > 1) {
            string2 = stringArray[1];
        }
        BaseObjectID baseObjectID = BaseObjectID.createFromString((String)stringArray[0]);
        baseObjectID.setProvider(this.m_pro);
        DBObjectID dBObjectID = this.m_id == null ? null : DBUtil.getUppermostParent((DBObjectID)this.m_id);
        DBObjectID dBObjectID2 = DBUtil.getUppermostParent((DBObjectID)baseObjectID);
        BaseDBObjectTextNode baseDBObjectTextNode = null;
        if (dBObjectID2.equals(dBObjectID)) {
            baseDBObjectTextNode = this.m_node;
        } else {
            try {
                URL uRL;
                object = dBObjectID2.resolveID();
                if (object instanceof PlSqlSourceObject && (uRL = DBURLFactory.getURL(this.m_pro, (SystemObject)((PlSqlSourceObject)object))) != null) {
                    try {
                        baseDBObjectTextNode = (BaseDBObjectTextNode)NodeFactory.findOrCreate((URL)uRL);
                    }
                    catch (Exception exception) {
                        DBLog.getLogger((Object)this).fine("failed to find other node: " + exception.getMessage());
                        baseDBObjectTextNode = null;
                    }
                }
            }
            catch (DBException dBException) {
                if (!(dBException instanceof CancelledException)) {
                    DBLog.getLogger((Object)this).fine("failed to resolve ID: " + dBException.getMessage());
                }
                return;
            }
        }
        object = new PlSqlPopupContentProvider(this.m_pro, (DBObjectID)baseObjectID, string2, baseDBObjectTextNode, 0);
        htmlPopupView.push((HtmlContentProvider)object);
    }

    public boolean isError() {
        return false;
    }

    private String getName(DBObject dBObject) {
        if (dBObject == null) {
            return "";
        }
        String string = dBObject.getName();
        if (string != null && dBObject instanceof PlSqlSubProgram) {
            PlSqlToken plSqlToken = PlSqlTokenizer.tokenize((String)string, (String[])new String[0]);
            string = plSqlToken.getSource();
        }
        if (this.m_pro != null) {
            string = this.m_pro.getExternalName(string);
        }
        return string;
    }

    private String getType(DBObject dBObject) {
        String string = dBObject.getType();
        if (dBObject instanceof PlSqlSubProgram) {
            PlSqlSubProgram plSqlSubProgram = (PlSqlSubProgram)dBObject;
            string = plSqlSubProgram.getReturnTypeReference() == null ? "PROCEDURE" : "FUNCTION";
        }
        return DBTypeDisplayRegistry.getSingularDisplayName(string);
    }

    private String tidyComment(String string, boolean bl) {
        if (string != null) {
            string = string.trim();
            if (bl) {
                string = string.replace("&", "&amp;");
                string = string.replace("<", "&lt;");
                string = string.replace(">", "&gt;");
            }
        }
        return string;
    }

    private String getColumnDetails(Column column, boolean bl) {
        Object object;
        DataTypeUsage dataTypeUsage;
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            this.addLink(stringBuilder, this.getName((DBObject)column), column.getID());
        } else {
            stringBuilder.append(BOLD);
            stringBuilder.append(this.getName((DBObject)column));
            stringBuilder.append(BOLD_END);
        }
        if (column.isNotNull()) {
            stringBuilder.append(" NOT NULL");
        }
        if ((dataTypeUsage = column.getDataTypeUsage()) != null) {
            stringBuilder.append(SPACE);
            stringBuilder.append(DataTypeHelper.getDDL((DataTypeUsage)dataTypeUsage, (DBObjectProvider)this.m_pro));
        }
        if ((object = column.getDefault()) instanceof String) {
            stringBuilder.append(" DEFAULT ");
            stringBuilder.append((String)object);
        }
        return stringBuilder.toString();
    }

    private void addLink(StringBuilder stringBuilder, String string, DBObjectID dBObjectID) {
        this.addLink(stringBuilder, string, dBObjectID, null);
    }

    private void addLink(StringBuilder stringBuilder, String string, DBObjectID dBObjectID, String string2) {
        stringBuilder.append("<a href=\"");
        stringBuilder.append(dBObjectID.toString().replace("\"", "&quot;"));
        if (string2 != null) {
            stringBuilder.append(HASH);
            stringBuilder.append(string2);
        }
        stringBuilder.append("\">");
        stringBuilder.append(string);
        stringBuilder.append("</a>");
    }

    private PlSqlComment getPrecedingComment(PlSqlCodeFragment plSqlCodeFragment) throws CancelledException {
        PlSqlParser plSqlParser;
        PlSqlCodeFragment plSqlCodeFragment2 = (PlSqlCodeFragment)DBUtil.getSystemObject((DBObject)plSqlCodeFragment);
        if (plSqlCodeFragment2 instanceof PlSqlSourceObject && (plSqlParser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)((PlSqlSourceObject)plSqlCodeFragment2), (DBObjectProvider)this.m_pro)) != null) {
            PlSqlToken plSqlToken = plSqlParser.getTokenAtOffset(plSqlCodeFragment.getStartOffset().intValue());
            plSqlToken = (PlSqlToken)plSqlToken.getPrevToken();
            while (plSqlToken.getType() == Token.Type.WHITESPACE || plSqlCodeFragment instanceof PlSqlSourceObject && (plSqlToken.matches("create") || plSqlToken.matches("or") || plSqlToken.matches("replace"))) {
                plSqlToken = (PlSqlToken)plSqlToken.getPrevToken();
            }
            if (plSqlToken.getType() == Token.Type.SINGLE_LINE_COMMENT || plSqlToken.getType() == Token.Type.MULTI_LINE_COMMENT) {
                for (PlSqlComment plSqlComment : plSqlCodeFragment2.getComments()) {
                    if (plSqlComment.getStartOffset() > plSqlToken.getStart() || plSqlComment.getEndOffset() < plSqlToken.getEnd()) continue;
                    return plSqlComment;
                }
            }
        }
        return null;
    }

    private void addBuiltInFunctionDoc(StringBuilder stringBuilder, BuiltInFunction builtInFunction, DBObjectProvider dBObjectProvider) {
        String string;
        stringBuilder.append(this.getType((DBObject)builtInFunction));
        stringBuilder.append(SPACE);
        stringBuilder.append(BOLD);
        stringBuilder.append(this.getName((DBObject)builtInFunction));
        stringBuilder.append(BOLD_END);
        stringBuilder.append(NEW_LINE);
        String string2 = builtInFunction.getDescription();
        if (ModelUtil.hasLength((String)string2)) {
            stringBuilder.append(NEW_LINE);
            stringBuilder.append(string2);
        }
        HashMap<String, BIFHolder> hashMap = new HashMap<String, BIFHolder>();
        for (Object object : dBObjectProvider.getDescriptor().listBuiltInFunctions(builtInFunction.getName())) {
            string = object.getSignature(true);
            BIFHolder bIFHolder = (BIFHolder)hashMap.get(string = string.substring(0, string.lastIndexOf("/")));
            if (bIFHolder == null) {
                bIFHolder = new BIFHolder();
                bIFHolder.m_bif = object;
                hashMap.put(string, bIFHolder);
            }
            if (object.isAggregate()) {
                bIFHolder.m_aggregate = true;
            }
            if (!object.isWindow()) continue;
            bIFHolder.m_window = true;
        }
        for (Object object : hashMap.values()) {
            stringBuilder.append(NEW_LINE);
            string = object.m_bif;
            stringBuilder.append(string.getName());
            if (string.isParenthesesRequired()) {
                stringBuilder.append(LPAREN);
            }
            int n = 1;
            for (BuiltInFunctionArgument builtInFunctionArgument : string.getArguments()) {
                if (builtInFunctionArgument.isOptional()) {
                    stringBuilder.append("[");
                }
                if (n != 1) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(ARG_PREFIX);
                stringBuilder.append(n++);
                if (!builtInFunctionArgument.isOptional()) continue;
                stringBuilder.append("]");
            }
            if (string.isVariableArgumentList()) {
                stringBuilder.append("[");
                if (n != 1) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("...]");
            }
            if (string.isParenthesesRequired()) {
                stringBuilder.append(RPAREN);
            }
            Integer object2 = string.getArgumentDefiningReturnType();
            DBObjectID dBObjectID = string.getReturnTypeID();
            if (object2 != null) {
                stringBuilder.append(NEW_LINE);
                stringBuilder.append(UIBundle.get("QUICKDOC_BUILTIN_FUNC_RETURN_TYPE_DERIVED"));
                stringBuilder.append(SPACE);
                stringBuilder.append(ARG_PREFIX);
                stringBuilder.append(object2);
            } else if (dBObjectID != null) {
                stringBuilder.append(NEW_LINE);
                stringBuilder.append(UIBundle.get("QUICKDOC_BUILTIN_FUNC_RETURN_TYPE"));
                stringBuilder.append(SPACE);
                stringBuilder.append(DBUtil.getDBObjectName((DBObjectID)dBObjectID));
            }
            n = 1;
            for (BuiltInFunctionArgument builtInFunctionArgument : string.getArguments()) {
                DBObjectID dBObjectID2 = builtInFunctionArgument.getDataTypeID();
                if (dBObjectID2 != null) {
                    stringBuilder.append(NEW_LINE);
                    stringBuilder.append(ARG_PREFIX);
                    stringBuilder.append(n);
                    stringBuilder.append(": ");
                    stringBuilder.append(DBUtil.getDBObjectName((DBObjectID)dBObjectID2));
                }
                ++n;
            }
            if (object.m_aggregate) {
                stringBuilder.append(NEW_LINE);
                stringBuilder.append(UIBundle.get("QUICKDOC_BUILTIN_FUNC_AGGREGATE"));
                continue;
            }
            if (!object.m_window) continue;
            stringBuilder.append(NEW_LINE);
            stringBuilder.append(UIBundle.get("QUICKDOC_BUILTIN_FUNC_WINDOWING"));
        }
    }

    private int getLineOfset(DBObjectPlSqlFragment dBObjectPlSqlFragment) {
        int n;
        int n2 = dBObjectPlSqlFragment.getStartOffset();
        if (this.m_node != null) {
            LineMap lineMap = this.m_node.acquireTextBuffer().getLineMap();
            int n3 = lineMap.getLineFromOffset(dBObjectPlSqlFragment.getStartOffset().intValue());
            n = lineMap.getLineStartOffset(n3);
        } else {
            n = 0;
        }
        int n4 = n2 - n;
        if (n4 > 10) {
            n4 = 10;
        }
        return n4;
    }

    private static class BIFHolder {
        BuiltInFunction m_bif;
        boolean m_aggregate;
        boolean m_window;

        private BIFHolder() {
        }
    }
}

