/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ceditor;

import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import oracle.ide.Context;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.model.Node;
import oracle.ide.model.SingletonProvider;
import oracle.ide.net.URLComparator;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseFactory;

public abstract class DBEditorConnectionProvider {
    private static final Map<URL, String> m_urlToConnMap = new TreeMap<URL, String>((Comparator<URL>)new URLComparator());

    public abstract Collection<String> getAvailableConnections(Context var1);

    protected abstract String getStoreName(Context var1);

    public abstract void addConnectionsListener(Context var1, ConnectionProviderListener var2);

    public abstract void removeConnectionsListener(Context var1, ConnectionProviderListener var2);

    public static DBEditorConnectionProvider getInstance() {
        return (DBEditorConnectionProvider)SingletonProvider.find(DBEditorConnectionProvider.class);
    }

    public static Database getCurrentDatabase(Context context) {
        Node node = context.getNode();
        if (DBObjectNodeUtil.isOnlineNode(node)) {
            DBObjectProvider dBObjectProvider = ((DBObjectNode)node).getProvider();
            if (dBObjectProvider instanceof Database) {
                return (Database)dBObjectProvider;
            }
        } else if (node != null) {
            String string = m_urlToConnMap.get(node.getURL());
            String string2 = DBEditorConnectionProvider.getInstance().getStoreName(context);
            if (string != null && string2 != null) {
                try {
                    Database database = DatabaseFactory.findOrCreateDatabase((String)string2, (String)string);
                    return database;
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static boolean hasCurrentDatabase(Node node) {
        if (node == null) {
            return false;
        }
        if (DBObjectNodeUtil.isOnlineNode(node)) {
            return true;
        }
        return m_urlToConnMap.get(node.getURL()) != null;
    }

    static void setURLConnection(URL uRL, String string, boolean bl) {
        if (uRL != null) {
            if (string == null) {
                m_urlToConnMap.remove(uRL);
            } else {
                m_urlToConnMap.put(uRL, string);
            }
            if (bl) {
                URL uRL2 = URLFileSystem.getParent((URL)uRL);
                DBEditorConnectionProvider.setURLConnection(uRL2, string, false);
            }
        }
    }

    static String getDefaultConnection(URL uRL) {
        URL uRL2;
        if (uRL != null && (uRL2 = URLFileSystem.getParent((URL)uRL)) != null) {
            return m_urlToConnMap.get(uRL2);
        }
        return null;
    }

    public static interface ConnectionProviderListener {
        public void connectionsChanged();
    }
}

