/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.Context;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.controls.MultiProviderPicker;
import oracle.ide.db.dialogs.DBDialogHeader;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ideimpl.db.extension.DatabaseUIExtensionHook;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderID;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public abstract class DBObjectProviderPicker {
    private Collection<PickerListener> m_pickerListeners;
    private PickerValidator m_pickerValidator;
    private boolean m_readOnly = false;

    public abstract Component getComponent();

    public final void setProvider(DBObjectProvider dBObjectProvider) {
        if (dBObjectProvider == null) {
            this.setProvider(null, null);
        } else {
            this.setProvider(dBObjectProvider.getProviderType(), dBObjectProvider.getProviderIdentifier());
        }
    }

    public void setRelatedPicker(DBObjectProviderPicker dBObjectProviderPicker) {
    }

    public final void setPickerEnabled(boolean bl) {
        this.setPickerEnabledImpl(!this.m_readOnly && bl);
    }

    protected void setPickerEnabledImpl(boolean bl) {
        this.getComponent().setEnabled(bl);
    }

    public abstract void setProvider(String var1, Object var2);

    public final DBObjectProvider getProvider() throws DBException {
        DBObjectProvider dBObjectProvider = this.getProviderImpl();
        this.validateProvider(dBObjectProvider);
        return dBObjectProvider;
    }

    protected abstract DBObjectProvider getProviderImpl() throws DBException;

    private void validateProvider(DBObjectProvider dBObjectProvider) throws DBException {
        if (this.m_pickerValidator != null) {
            this.m_pickerValidator.validateProvider(dBObjectProvider);
        }
    }

    public abstract DBObjectProviderID getProviderID();

    public boolean hasDBObjectProvider() {
        DBObjectProviderID dBObjectProviderID = this.getProviderID();
        return dBObjectProviderID != null && dBObjectProviderID.isValid();
    }

    protected String getDefaultProviderType(PickerConfiguration pickerConfiguration) {
        DBObjectProviderID dBObjectProviderID = pickerConfiguration.getDefaultProviderID();
        String string = dBObjectProviderID == null ? null : dBObjectProviderID.getType();
        return string;
    }

    protected abstract boolean isAvailable(PickerConfiguration var1);

    protected abstract void init(PickerConfiguration var1);

    protected abstract void addImplementationListener();

    protected abstract void removeImplementationListener();

    void init(PickerConfiguration pickerConfiguration, boolean bl) {
        this.init(pickerConfiguration);
        this.m_readOnly = bl;
        this.setPickerEnabled(true);
    }

    public final void addPickerListener(PickerListener pickerListener) {
        if (pickerListener != null) {
            if (this.m_pickerListeners == null) {
                this.m_pickerListeners = new HashSet<PickerListener>();
                this.addImplementationListener();
            }
            this.m_pickerListeners.add(pickerListener);
        }
    }

    public final void removePickerListener(PickerListener pickerListener) {
        if (pickerListener != null && this.m_pickerListeners != null) {
            this.m_pickerListeners.remove(pickerListener);
            if (this.m_pickerListeners.isEmpty()) {
                this.m_pickerListeners = null;
                this.removeImplementationListener();
            }
        }
    }

    protected final void firePickerChanged(DBObjectProviderID dBObjectProviderID) {
        if (this.m_pickerListeners != null) {
            for (PickerListener pickerListener : this.m_pickerListeners) {
                try {
                    pickerListener.providerChanged(dBObjectProviderID);
                }
                catch (Exception exception) {
                    DBLog.logStackTrace((String)"PickerListener failed", (Throwable)exception);
                }
            }
        }
    }

    public static DBObjectProviderPicker getPicker(PickerConfiguration pickerConfiguration) {
        Object object;
        ArrayList<DatabaseUIExtensionHook.ProviderPickerHash> arrayList = new ArrayList<DatabaseUIExtensionHook.ProviderPickerHash>();
        List list = pickerConfiguration.getProviderTypes() == null ? Collections.emptyList() : Arrays.asList(pickerConfiguration.getProviderTypes());
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (DatabaseUIExtensionHook.ProviderPickerHash providerPickerHash : DatabaseUIExtensionHook.getHook().getDBObjectProviderPickers()) {
            DBObjectProviderPicker dBObjectProviderPicker;
            String string = providerPickerHash.getProviderType();
            if (!list.isEmpty() && !list.contains(string) || arrayList2.contains(string) || (dBObjectProviderPicker = providerPickerHash.getProviderPicker()) == null || !dBObjectProviderPicker.isAvailable(pickerConfiguration)) continue;
            arrayList.add(providerPickerHash);
            arrayList2.add(string);
        }
        if (arrayList.size() == 0) {
            DBLog.logIllegalState((String)"No DBObjectProviderPicker found");
            object = null;
        } else {
            object = arrayList.size() == 1 ? ((DatabaseUIExtensionHook.ProviderPickerHash)((Object)arrayList.get(0))).getProviderPicker() : new MultiProviderPicker(arrayList);
        }
        if (object != null) {
            DatabaseUIExtensionHook.ProviderPickerHash providerPickerHash;
            ((DBObjectProviderPicker)object).init(pickerConfiguration);
            ((DBObjectProviderPicker)object).addPickerListener(pickerConfiguration.getPickerListener());
            ((DBObjectProviderPicker)object).m_pickerValidator = pickerConfiguration.getPickerValidator();
            providerPickerHash = pickerConfiguration.getDefaultProviderID();
            if (providerPickerHash != null && providerPickerHash.isValid()) {
                ((DBObjectProviderPicker)object).setProvider(providerPickerHash.getType(), providerPickerHash.getIdentifier());
            }
        }
        return object;
    }

    public static DBObjectProvider chooseProvider(PickerConfiguration pickerConfiguration, Component component, String string, String string2, String string3) {
        pickerConfiguration.setTitle(string);
        pickerConfiguration.setPrompt(string2);
        pickerConfiguration.setHelpID(string3);
        return DBObjectProviderPicker.chooseProvider(pickerConfiguration, component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBObjectProvider chooseProvider(PickerConfiguration pickerConfiguration, Component component) {
        final Holder holder = new Holder();
        final DBObjectProviderPicker dBObjectProviderPicker = DBObjectProviderPicker.getPicker(pickerConfiguration);
        if (dBObjectProviderPicker != null) {
            JPanel jPanel = new JPanel();
            jPanel.setName("DBObjectProviderPickerPanel");
            String string = pickerConfiguration.getHelpID();
            HelpUtils.setHelpID((JComponent)jPanel, (String)string);
            jPanel.setLayout(new BorderLayout(0, 15));
            String string2 = pickerConfiguration.getPrompt();
            if (ModelUtil.hasLength((String)string2)) {
                JWrappedLabel jWrappedLabel = new JWrappedLabel(string2);
                jPanel.add((Component)jWrappedLabel, "North");
            }
            jPanel.add(dBObjectProviderPicker.getComponent(), "Center");
            jPanel.add(Box.createHorizontalStrut(400), "South");
            int n = 3;
            if (string != null) {
                n |= 4;
            }
            final JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)component, (String)pickerConfiguration.getTitle(), (int)n);
            jEWTDialog.setName("DBObjectProviderPickerDialog");
            jEWTDialog.setContent((Component)jPanel);
            jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                    if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
                        try {
                            DBObjectProvider dBObjectProvider = dBObjectProviderPicker.getProvider();
                            holder.set((Object)dBObjectProvider);
                        }
                        catch (DBException dBException) {
                            DBExceptionDialog.showErrorDialog((Component)jEWTDialog, null, dBException);
                            throw new PropertyVetoException(dBException.getMessage(), propertyChangeEvent);
                        }
                    }
                }
            });
            if (ModelUtil.hasLength((String)pickerConfiguration.getHeaderText())) {
                DBDialogHeader dBDialogHeader = new DBDialogHeader();
                dBDialogHeader.setHeaderDescription(pickerConfiguration.getHeaderText());
                jEWTDialog.setDialogHeader((Component)((Object)dBDialogHeader));
            }
            try {
                jEWTDialog.runDialog();
            }
            finally {
                jEWTDialog.dispose();
            }
        }
        return (DBObjectProvider)holder.get();
    }

    public static abstract class PickerValidator {
        public abstract void validateProvider(DBObjectProvider var1) throws DBException;
    }

    public static class PickerConfiguration {
        private Context m_context;
        private boolean m_forceGlobal;
        private boolean m_showDetails;
        private boolean m_onlyShowProjectDependencies;
        private boolean m_allowCreateProject;
        private boolean m_allowCreate = true;
        private boolean m_allowNull;
        private boolean m_controlEnable;
        private ActionListener m_controlEnableListener;
        private String m_label;
        private String[] m_providerTypes;
        private boolean m_disablePickerForDefault;
        private Map<String, Boolean> m_canBeGlobalProvider;
        private DBObjectProviderID m_defaultProviderID;
        private PickerListener m_pickerListener;
        private DBObjectProvider m_otherProvider;
        private PickerValidator m_pickerValidator;
        private String[] m_databaseTypes;
        private String m_title;
        private String m_headerText;
        private String m_prompt;
        private String m_helpID;

        public Context getContext() {
            if (this.m_context == null) {
                this.m_context = Context.newIdeContext();
            }
            return this.m_context;
        }

        public String getTitle() {
            return this.m_title;
        }

        public void setTitle(String string) {
            this.m_title = string;
        }

        public String getHeaderText() {
            return this.m_headerText;
        }

        public void setHeaderText(String string) {
            this.m_headerText = string;
        }

        public String getPrompt() {
            return this.m_prompt;
        }

        public void setPrompt(String string) {
            this.m_prompt = string;
        }

        public String getHelpID() {
            return this.m_helpID;
        }

        public void setHelpID(String string) {
            this.m_helpID = string;
        }

        public void setContext(Context context) {
            this.m_context = context;
        }

        public boolean getForceGlobal() {
            return this.m_forceGlobal;
        }

        public boolean canBeGlobal(String string) {
            boolean bl = this.m_forceGlobal;
            if (!bl && this.m_canBeGlobalProvider != null) {
                bl = Boolean.TRUE.equals(this.m_canBeGlobalProvider.get(string));
            }
            return bl;
        }

        public void setForceGlobal(boolean bl) {
            this.m_forceGlobal = bl;
        }

        public boolean getShowDetails() {
            return this.m_showDetails;
        }

        public void setShowDetails(boolean bl) {
            this.m_showDetails = bl;
        }

        public void setAllowCreateProject(boolean bl) {
            this.m_allowCreateProject = bl;
        }

        public boolean getAllowCreateProject() {
            return this.m_allowCreateProject;
        }

        public void setOnlyShowProjectDependencies(boolean bl) {
            this.m_onlyShowProjectDependencies = bl;
        }

        public boolean getOnlyShowProjectDependencies() {
            return this.m_onlyShowProjectDependencies;
        }

        public boolean getAllowCreate() {
            return this.m_allowCreate;
        }

        public void setAllowCreate(boolean bl) {
            this.m_allowCreate = bl;
        }

        public boolean getControlEnable() {
            return this.m_controlEnable;
        }

        public void setControlEnable(boolean bl) {
            this.m_controlEnable = bl;
        }

        public boolean getAllowNull() {
            return this.m_allowNull;
        }

        public void setAllowNull(boolean bl) {
            this.m_allowNull = bl;
        }

        public String getLabel() {
            return this.m_label;
        }

        public void setLabel(String string) {
            this.m_label = string;
        }

        public String[] getProviderTypes() {
            return this.m_providerTypes;
        }

        public void setProviderTypes(String ... stringArray) {
            this.m_providerTypes = stringArray;
        }

        public boolean shouldDisablePickerForDefaultProvider() {
            return this.m_disablePickerForDefault;
        }

        public void setDisablePickerForDefaultProvider(boolean bl) {
            this.m_disablePickerForDefault = bl;
        }

        public void setCanBeGlobal(String string, boolean bl) {
            if (this.m_canBeGlobalProvider == null) {
                this.m_canBeGlobalProvider = new HashMap<String, Boolean>();
            }
            this.m_canBeGlobalProvider.put(string, bl);
        }

        public DBObjectProviderID getDefaultProviderID() {
            return this.m_defaultProviderID;
        }

        public void setDefaultProviderID(DBObjectProviderID dBObjectProviderID) {
            this.m_defaultProviderID = dBObjectProviderID;
        }

        public void setControlEnableListener(ActionListener actionListener) {
            this.m_controlEnableListener = actionListener;
        }

        public ActionListener getControlEnableListener() {
            return this.m_controlEnableListener;
        }

        public PickerListener getPickerListener() {
            return this.m_pickerListener;
        }

        public void setPickerListener(PickerListener pickerListener) {
            this.m_pickerListener = pickerListener;
        }

        public DBObjectProvider getOtherProvider() {
            return this.m_otherProvider;
        }

        public void setOtherProvider(DBObjectProvider dBObjectProvider) {
            this.m_otherProvider = dBObjectProvider;
        }

        public PickerValidator getPickerValidator() {
            return this.m_pickerValidator;
        }

        public void setPickerValidator(PickerValidator pickerValidator) {
            this.m_pickerValidator = pickerValidator;
        }

        public String[] getDatabaseTypes() {
            return this.m_databaseTypes;
        }

        public void setDatabaseTypes(String ... stringArray) {
            this.m_databaseTypes = stringArray;
        }
    }

    public static interface PickerListener {
        public void providerChanged(DBObjectProviderID var1);
    }
}

