/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.ideimpl.db.extension.DatabaseExtensionHook;
import oracle.ideimpl.db.resource.PropertyValueUI;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.property.DisplayNames;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.resource.PropertyBundle;
import oracle.javatools.marshal.ToStringManager;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.deferred.Thunk;

public final class PropertyDisplayRegistry {
    private ExtrasPlugin m_extrasPlugin = new ExtrasPlugin();
    private Collection<Thunk<Plugin>> m_plugins = new CopyOnWriteArrayList<Thunk<Plugin>>();
    private Collection<Thunk<ResourceBundle>> m_bundles = new CopyOnWriteArrayList<Thunk<ResourceBundle>>();

    private PropertyDisplayRegistry() {
        this.registerBundle(PropertyBundle.getBundle());
        this.registerPlugin(this.m_extrasPlugin);
    }

    public static synchronized PropertyDisplayRegistry getInstance() {
        DBCore dBCore = DBCore.getInstance();
        PropertyDisplayRegistry propertyDisplayRegistry = (PropertyDisplayRegistry)dBCore.get(PropertyDisplayRegistry.class);
        if (propertyDisplayRegistry == null) {
            propertyDisplayRegistry = new PropertyDisplayRegistry();
            dBCore.put((Object)propertyDisplayRegistry);
        }
        return propertyDisplayRegistry;
    }

    public static final String getDisplayName(String string) {
        return PropertyDisplayRegistry.getDisplayName(string, null, null);
    }

    public static final String getDisplayName(String string, DBObjectProvider dBObjectProvider, DBObject dBObject) {
        String string2 = PropertyDisplayRegistry.getDisplayNameOrNull(string, dBObjectProvider, dBObject);
        return string2 == null ? string : string2;
    }

    public static final String getDisplayNameOrNull(String string, DBObjectProvider dBObjectProvider, DBObject dBObject) {
        String string2 = null;
        if (string != null) {
            string = Property.getLastProperty((String)string);
            DatabaseExtensionHook databaseExtensionHook = DatabaseExtensionHook.getHook();
            if (databaseExtensionHook != null) {
                string2 = databaseExtensionHook.getExtensionPropertyDisplayName(string, dBObjectProvider, dBObject);
            }
            if (string2 == null) {
                string2 = PropertyDisplayRegistry.getInstance().getDisplayNameFromResourceBundle(string);
            }
            if (string2 == null) {
                string2 = PropertyDisplayRegistry.getInstance().getDisplayNameFromPlugins(string, dBObjectProvider, dBObject);
            }
        }
        return string2;
    }

    private String getDisplayNameFromPlugins(String string, DBObjectProvider dBObjectProvider, DBObject dBObject) {
        for (Thunk<Plugin> thunk : this.m_plugins) {
            Plugin plugin = (Plugin)thunk.get();
            if (plugin == null) continue;
            try {
                String string2 = plugin.getDisplayName(string, dBObjectProvider, dBObject);
                if (!ModelUtil.hasLength((String)string2)) continue;
                return string2;
            }
            catch (Exception exception) {
                DBLog.getLogger(PropertyDisplayRegistry.class).log(DBLog.getExceptionLogLevel(), "Error calling property display plugin " + plugin.getClass().getName(), exception);
            }
        }
        return null;
    }

    private final String getDisplayNameFromResourceBundle(String string) {
        String string2 = null;
        for (Thunk<ResourceBundle> thunk : this.m_bundles) {
            ResourceBundle resourceBundle = (ResourceBundle)thunk.get();
            if (resourceBundle != null) {
                string2 = DisplayNames.getPropertyDisplayName((String)string, (ResourceBundle)resourceBundle);
            }
            if (!ModelUtil.hasLength(string2)) continue;
            break;
        }
        return string2;
    }

    private static final String getNlsStringForPropValue(String string, Object object) {
        String string2;
        ResourceBundle resourceBundle;
        String string3;
        String string4 = null;
        if (string != null && (string4 = PropertyDisplayRegistry.lookupInBundle(string, string3 = ToStringManager.converterAvailable((Object)object) ? ToStringManager.toString((Object)object) : String.valueOf(object), resourceBundle = PropertyValueUI.getBundle())) == null && !string.equals(string2 = Property.getLastProperty((String)string))) {
            string4 = PropertyDisplayRegistry.lookupInBundle(string2, string3, resourceBundle);
        }
        return string4;
    }

    private static String lookupInBundle(String string, String string2, ResourceBundle resourceBundle) {
        String string3 = null;
        try {
            string3 = resourceBundle.getString(string + "." + string2);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string3;
    }

    public static final String getPropValueDisplay(String string, Object object) {
        String string2 = PropertyDisplayRegistry.getNlsStringForPropValue(string, object);
        if (string2 == null) {
            if (object == null) {
                string2 = PropertyDisplayRegistry.getNullPropValueDisplay();
            } else if (!(object instanceof Enum) && ToStringManager.converterAvailable((Object)object)) {
                string2 = ToStringManager.toString((Object)object);
            } else if (PropertyDisplayRegistry.useToString(object)) {
                string2 = object.toString();
            }
        }
        return string2;
    }

    private static boolean useToString(Object object) {
        boolean bl;
        try {
            bl = !Object.class.equals(object.getClass().getMethod("toString", new Class[0]).getDeclaringClass());
        }
        catch (Exception exception) {
            bl = true;
        }
        return bl;
    }

    public static final String getNullPropValueDisplay() {
        return PropertyValueUI.get("DEFAULT_NULL_VALUE");
    }

    public static final boolean hasNlsStringForPropValue(String string, Object object) {
        return PropertyDisplayRegistry.getNlsStringForPropValue(string, object) != null;
    }

    private <T> Thunk<T> findThunk(Collection<Thunk<T>> collection, T t) {
        Thunk<T> thunk = null;
        for (Thunk<T> thunk2 : collection) {
            Object object = thunk2.getIfSet();
            if (object == null || !object.equals(t)) continue;
            thunk = thunk2;
            break;
        }
        return thunk;
    }

    public void registerBundle(ResourceBundle resourceBundle) {
        if (this.findThunk(this.m_bundles, resourceBundle) == null) {
            this.registerBundle((Thunk<ResourceBundle>)Thunk.directReference((Object)resourceBundle));
        }
    }

    public void registerBundle(Thunk<ResourceBundle> thunk) {
        this.m_bundles.add(thunk);
    }

    public boolean unregisterBundle(ResourceBundle resourceBundle) {
        Thunk<ResourceBundle> thunk;
        boolean bl = false;
        if (resourceBundle != PropertyBundle.getBundle() && (thunk = this.findThunk(this.m_bundles, resourceBundle)) != null) {
            bl = this.m_bundles.remove(thunk);
        }
        return bl;
    }

    @Deprecated
    public void registerDisplayName(String string, String string2) {
        this.m_extrasPlugin.registerDisplayName(string, string2);
    }

    public void registerPlugin(Plugin plugin) {
        if (this.findThunk(this.m_plugins, plugin) == null) {
            this.registerPlugin((Thunk<Plugin>)Thunk.directReference((Object)plugin));
        }
    }

    public void registerPlugin(Thunk<Plugin> thunk) {
        this.m_plugins.add(thunk);
    }

    public boolean unregisterPlugin(Plugin plugin) {
        return this.m_plugins.remove(plugin);
    }

    private static class ExtrasPlugin
    extends Plugin {
        private final Map<String, String> m_extras = new HashMap<String, String>();

        private ExtrasPlugin() {
        }

        @Override
        public String getDisplayName(String string, DBObjectProvider dBObjectProvider, DBObject dBObject) {
            return this.m_extras.get(string);
        }

        public void registerDisplayName(String string, String string2) {
            this.m_extras.put(string, string2);
        }
    }

    public static abstract class Plugin {
        public abstract String getDisplayName(String var1, DBObjectProvider var2, DBObject var3);
    }
}

