/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.r2rml.editor.subjectmap;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.r2rml.R2RMLArb;
import oracle.dbtools.rdfgraph.r2rml.editor.ColumnHelperUtils;
import oracle.dbtools.rdfgraph.r2rml.language.ColumnNameNode;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLNode;
import oracle.dbtools.rdfgraph.r2rml.language.R2RMLStringNode;
import oracle.dbtools.rdfgraph.r2rml.language.SubjectMapNode;
import oracle.dbtools.rdfgraph.r2rml.language.SubjectTemplateNode;
import oracle.dbtools.rdfgraph.r2rml.language.TermTypeNode;
import oracle.dbtools.rdfgraph.r2rml.language.TriplesMapNode;
import oracle.dbtools.rdfgraph.utils.RDFPrefixManager;
import oracle.dbtools.rdfgraph.utils.RDFStringUtils;
import oracle.dbtools.util.Logger;
import oracle.javatools.icons.OracleIcons;

public class SubjectMappingEditor
extends JPanel
implements LayoutControl {
    private static final String SUBJECT_IRI_TITLE = R2RMLArb.getString("SUBJECT_MAP");
    private static final int VALUE_COLS_WIDTH = 50;
    TriplesMapNode tmap;
    SubjectMapNode node;
    Connection connection;
    JTextArea txtTemplate;
    JComboBox slType;
    JComboBox selTermType;
    JButton btnSave;

    public SubjectMappingEditor(TriplesMapNode triplesMapNode, SubjectMapNode subjectMapNode, Connection connection) {
        this.node = subjectMapNode;
        this.tmap = triplesMapNode;
        this.connection = connection;
        this.setBorder(BorderFactory.createTitledBorder(R2RMLArb.getString("SubjectMapNodeEditor.TERM_MAP")));
        this.setLayout(new GridBagLayout());
        this.initUI();
    }

    private void initUI() {
        Object object;
        Object object2;
        String[] stringArray2;
        Object object3;
        JLabel jLabel = new JLabel(R2RMLArb.getString("SubjectMappingEditor.VALUE_"));
        this.txtTemplate = new JTextArea(this.node.getSimpleValue().toString());
        jLabel.setLabelFor(this.txtTemplate);
        this.txtTemplate.setColumns(50);
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.txtTemplate.add(jPopupMenu);
        this.txtTemplate.setComponentPopupMenu(jPopupMenu);
        this.txtTemplate.setFocusTraversalKeys(0, null);
        this.txtTemplate.setFocusTraversalKeys(1, null);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                int n = SubjectMappingEditor.this.txtTemplate.getCaretPosition();
                try {
                    SubjectMappingEditor.this.txtTemplate.getDocument().insertString(n, "{\\\"" + jMenuItem.getText() + "\\\"}", null);
                }
                catch (BadLocationException badLocationException) {
                    Logger.warn(this.getClass(), (Throwable)badLocationException);
                }
            }
        };
        String string = this.tmap.getCleanSource();
        if (string.isEmpty()) {
            return;
        }
        String[] stringArray3 = string.split("\\.");
        String string2 = "";
        String string3 = "";
        switch (stringArray3.length) {
            case 1: {
                string3 = string.split("\\.")[0];
                break;
            }
            case 2: {
                string2 = string.split("\\.")[0];
                string3 = string.split("\\.")[1];
            }
        }
        if (this.tmap.getSourceType().equalsIgnoreCase(RdfgraphArb.getString("QUERY"))) {
            object3 = (R2RMLStringNode)this.tmap.getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#logicalTable>").getFirstChildByPredicate("<http://www.w3.org/ns/r2rml#sqlQuery>");
            stringArray2 = RDFStringUtils.unescapeJavaString(((R2RMLNode)object3).getValue());
            stringArray2 = RDFStringUtils.removeWrappingQuotes((String)stringArray2);
            for (String stringArray4 : ColumnHelperUtils.getColumnsFromQuery(this.connection, (String)stringArray2)) {
                jPopupMenu.add(stringArray4).addActionListener(actionListener);
            }
        } else {
            object3 = "SELECT COLUMN_NAME from ALL_TAB_COLUMNS where TABLE_NAME = '" + string3 + "' ";
            stringArray2 = DBUtil.getInstance((Connection)this.connection);
            object2 = stringArray2.executeReturnList((String)object3, new HashMap());
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (Map)iterator.next();
                jPopupMenu.add((String)object.get("COLUMN_NAME")).addActionListener(actionListener);
            }
        }
        this.btnSave = new JButton(RdfgraphArb.getString("SAVE"), OracleIcons.getIcon((String)"filesave.png"));
        this.btnSave.addActionListener(actionEvent -> {
            String string;
            String string2 = this.txtTemplate.getText().trim();
            this.node.removeChildEdge("<http://www.w3.org/ns/r2rml#template>");
            this.node.removeChildEdge("<http://www.w3.org/ns/r2rml#constant>");
            this.node.removeChildEdge("<http://www.w3.org/ns/r2rml#column>");
            String string3 = (String)this.slType.getSelectedItem();
            R2RMLNode r2RMLNode = null;
            if (string3.equals(R2RMLArb.getString("TEMPLATE"))) {
                string2 = this.enquoteTerm(string2);
                r2RMLNode = new SubjectTemplateNode(string2);
                this.node.addChildEdge("<http://www.w3.org/ns/r2rml#template>", r2RMLNode);
            }
            if (string3.equals(R2RMLArb.getString("CONSTANT"))) {
                string2 = this.bracketizeTerm(string2);
                r2RMLNode = new R2RMLNode(string2);
                this.node.addChildEdge("<http://www.w3.org/ns/r2rml#constant>", r2RMLNode);
            }
            if (string3.equals(R2RMLArb.getString("COLUMN"))) {
                string2 = this.enquoteTerm(string2);
                r2RMLNode = new ColumnNameNode(string2);
                this.node.addChildEdge("<http://www.w3.org/ns/r2rml#column>", r2RMLNode);
            }
            if (!(string = (String)this.selTermType.getSelectedItem()).equals(R2RMLArb.getString("SubjectMappingEditor.DEFAULT"))) {
                this.node.addChildEdge("<http://www.w3.org/ns/r2rml#termType>", new TermTypeNode(RDFPrefixManager.expandURI(string)));
            }
            this.txtTemplate.setText(string2);
        });
        this.txtTemplate.setInputVerifier(new TemplateInputVerifier());
        object3 = new JLabel(R2RMLArb.getString("SubjectMappingEditor.MAPPING_TYPE_"));
        stringArray2 = new String[]{R2RMLArb.getString("COLUMN"), R2RMLArb.getString("TEMPLATE"), R2RMLArb.getString("CONSTANT")};
        this.slType = new JComboBox<String>(stringArray2);
        ((JLabel)object3).setLabelFor(this.slType);
        this.slType.setSelectedItem(this.node.getMappingType());
        object2 = new JLabel(R2RMLArb.getString("SubjectMappingEditor.TERM_TYPE_"));
        String[] stringArray = new String[]{R2RMLArb.getString("SubjectMappingEditor.DEFAULT"), RDFPrefixManager.shortenURI("<http://www.w3.org/ns/r2rml#IRI>"), RDFPrefixManager.shortenURI("<http://www.w3.org/ns/r2rml#BlankNode>")};
        this.selTermType = new JComboBox<String>(stringArray);
        ((JLabel)object2).setLabelFor(this.selTermType);
        if (this.node.getTermType() != null) {
            this.selTermType.setSelectedItem(RDFPrefixManager.shortenURI(this.node.getTermType().getValue()));
        }
        this.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        this.add((Component)this.txtTemplate, LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP));
        this.add((Component)this.btnSave, LayoutControl.GBC.gbc((int)2, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2BUTTON_COMP));
        object = LayoutControl.GBC.createPanel();
        ((Container)object).add((Component)object3, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        ((Container)object).add((Component)this.slType, LayoutControl.GBC.gbc((int)1, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        ((Container)object).add((Component)object2, LayoutControl.GBC.gbc((int)2, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP));
        ((Container)object).add((Component)this.selTermType, LayoutControl.GBC.gbc((int)3, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        this.add((Component)object, LayoutControl.GBC.gbc((int)0, (int)1, (int)0, (int)0, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE));
    }

    public String enquoteTerm(String object) {
        if (((String)object).charAt(0) != '\"') {
            object = "\"" + (String)object;
        }
        if (((String)object).charAt(((String)object).length() - 1) != '\"') {
            object = (String)object + "\"";
        }
        return object;
    }

    private String bracketizeTerm(String object) {
        if (((String)(object = ((String)object).trim())).charAt(0) != '<') {
            object = "<" + (String)object;
        }
        if (((String)object).charAt(((String)object).length() - 1) != '>') {
            object = (String)object + ">";
        }
        return object;
    }

    public class TemplateInputVerifier
    extends InputVerifier {
        @Override
        public boolean verify(JComponent jComponent) {
            String string = ((JTextArea)jComponent).getText();
            return !string.trim().isEmpty();
        }
    }
}

