/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.sql.CallableStatement;
import java.sql.SQLException;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.DatabaseFeature;
import oracle.dbtools.raptor.utils.UtilsResources;
import oracle.dbtools.util.Logger;
import oracle.jdbc.OracleCallableStatement;

public class DbmsCloudFeatureCheck
implements DatabaseFeature {
    private static final String DBMS_CLOUD_ID = "dbms_cloud";
    static final String QUERIES_FILE = "oracle/dbtools/raptor/utils/queries.xml";
    static final String PLSQL_NAME_RESOLVE_QUERY = "PLSQL_NAME_RESOLVE";
    private static final String DBMS_CLOUD_NAME = "DBMS_CLOUD";

    public boolean isFeatureEnabled(ConnectionIdentifier connectionIdentifier, String string) {
        Query query;
        boolean bl = false;
        if (DBMS_CLOUD_ID.equals(string) && (query = Holder.QUERIES.getQuery(PLSQL_NAME_RESOLVE_QUERY, connectionIdentifier)) != null) {
            try (CallableStatement callableStatement = connectionIdentifier.getConnection().prepareCall(query.getSql());){
                ((OracleCallableStatement)callableStatement).setStringAtName("obj_name", DBMS_CLOUD_NAME);
                callableStatement.execute();
                bl = true;
            }
            catch (SQLException sQLException) {
                Logger.info(DbmsCloudFeatureCheck.class, (String)UtilsResources.getString("MESSAGE_NO_DBMS_CLOUD"));
            }
        }
        return bl;
    }

    private static class Holder {
        static final QueryXMLSupport QUERIES = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(DbmsCloudFeatureCheck.class.getClassLoader(), "oracle/dbtools/raptor/utils/queries.xml"));

        private Holder() {
        }
    }
}

