/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.structure.arbori;

import oracle.dbtools.raptor.plsql.language.PLSQLStyles;
import oracle.dbtools.raptor.plsql.structure.arbori.ArboriBlockRenderer;
import oracle.dbtools.raptor.plsql.structure.arbori.ArboriDocumentRenderer;
import oracle.dbtools.raptor.plsql.structure.arbori.ArboriEditor;
import oracle.dbtools.raptor.plsql.structure.arbori.ArboriNode;
import oracle.dbtools.raptor.plsql.structure.arbori.BackgroundParser;
import oracle.dbtools.util.Logger;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.util.MenuSpec;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.AbstractLanguageSupport;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.BraceProvider;
import oracle.javatools.editor.language.DocumentRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.language.OffsetDescriptionProvider;
import oracle.javatools.editor.language.StyleRegistry;

public class ArboriLanguageSupport
extends AbstractLanguageSupport {
    public final BackgroundParser parser = new BackgroundParser();

    public static void register() {
        LanguageModule languageModule = new LanguageModule(){

            public String getPresentationName() {
                return "Arbori";
            }

            public String[] getSupportedFileTypes() {
                return new String[]{"arbori"};
            }

            public String[] getStyleNames() {
                return PLSQLStyles.getAllStyleNames();
            }

            public String getContentSample() {
                return "include \"std.arbori\"\r\n\r\nprelude: runOnce -> {\r\n    function breaks4JSON() { return true; };\r\n    function breaks4XML() { return true; };\r\n}";
            }

            public void registerStyles(StyleRegistry styleRegistry) {
                new PLSQLStyles(styleRegistry);
            }

            public LanguageSupport createLanguageSupport() {
                return new ArboriLanguageSupport();
            }

            public BlockRenderer createBlockRenderer(TextBuffer textBuffer) {
                Logger.info(ArboriLanguageSupport.class, (String)"Created BlockRenderer (DocumentRenderer is supposed to be used)");
                return new ArboriBlockRenderer(textBuffer);
            }
        };
        EditorAddin editorAddin = new EditorAddin(){

            public Class<? extends Editor> getEditorClass() {
                return ArboriEditor.class;
            }

            public MenuSpec getMenuSpecification() {
                return new MenuSpec("Worksheet", null);
            }

            public boolean isDefault() {
                return true;
            }

            public float getEditorWeight(Element element) {
                return 100.0f;
            }
        };
        EditorManager.getEditorManager().register(editorAddin, new Class[]{ArboriNode.class});
    }

    protected Object getPropertyImpl(String string) {
        if (string.equals("line-comment-start")) {
            return "--";
        }
        return null;
    }

    protected DocumentRenderer createDocumentRenderer() {
        return new ArboriDocumentRenderer((LanguageSupport)this, this.parser);
    }

    public void deinstall() {
        super.deinstall();
        this.parser.quit = true;
    }

    protected BraceProvider createBraceProvider() {
        return new BraceProvider(){

            public int isPartOfBrace(int n, NumberRange numberRange) {
                return 0;
            }

            public int findMatchingBrace(int n, NumberRange numberRange, NumberRange numberRange2) {
                return 0;
            }
        };
    }

    protected OffsetDescriptionProvider createOffsetDescriptionProvider() {
        return new OffsetDescriptionProvider(){

            public String getDescription(TextBuffer textBuffer, int n) {
                return "Offset=" + n;
            }
        };
    }
}

