/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ide.util.MetaClass;
import oracle.dbtools.raptor.navigator.db.DBURLResolver;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorHook;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.util.Logger;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.javatools.data.HashStructure;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;

public class URLResolver {
    private static DBURLResolver s_defaultResolver = new DBURLResolver(){
        private final Map<String, String> mPublicTypes = new HashMap<String, String>();
        {
            this.mPublicTypes.put("DATABASE LINK", "PUBLIC DATABASE LINK");
            this.mPublicTypes.put("SYNONYM", "PUBLIC_SYNONYM");
        }

        @Override
        public URL resolveSchemaObject(Database database, SchemaObject schemaObject) {
            Object object;
            String string = database.getQualifiedName();
            Schema schema = schemaObject.getSchema();
            String string2 = schema != null ? schema.getName() : null;
            Object object2 = schemaObject.getType();
            if ("PUBLIC".equals(string2) && (object = this.mPublicTypes.get(object2)) != null) {
                try {
                    String string3;
                    Schema schema2 = database.getDefaultSchema();
                    String string4 = string3 = schema2 != null ? schema2.getName() : null;
                    if (string3 != null) {
                        string2 = string3;
                        object2 = object;
                    }
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
            object = DBURLFormatHelper.getURL("sqldev.nav", string, null, string2, (String)object2);
            return DBURLFormatHelper.getURL((URL)object, schemaObject.getName());
        }
    };
    private static Listener s_hookListener;

    private static synchronized List<Holder> getResolvers() {
        if (s_hookListener == null) {
            s_hookListener = new Listener();
            HashStructureHook hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(NavigatorHook.ELEMENT_NAME);
            if (hashStructureHook != null) {
                hashStructureHook.addHashStructureHookListener((HashStructureHookListener)s_hookListener);
            }
        }
        return s_hookListener.getResolvers();
    }

    public static URL resolveSchemaObject(Database database, SchemaObject schemaObject) {
        URL uRL = null;
        for (Holder holder : URLResolver.getResolvers()) {
            DBURLResolver dBURLResolver = holder.getResolver();
            if (dBURLResolver != null) {
                uRL = dBURLResolver.resolveSchemaObject(database, schemaObject);
            }
            if (uRL == null) continue;
            break;
        }
        if (uRL == null) {
            uRL = s_defaultResolver.resolveSchemaObject(database, schemaObject);
        }
        return uRL;
    }

    private static class Listener
    implements HashStructureHookListener {
        private static final String TEXT_ELEMENT = "#text";
        private static final String ELEMENT_KEY = "url-resolver";
        private List<Holder> s_resolvers = new ArrayList<Holder>();

        private Listener() {
        }

        public void elementVisited(HashStructureHookEvent hashStructureHookEvent) {
            this.processDescriptors(hashStructureHookEvent.getNewElementHashStructure());
        }

        public void listenerAttached(HashStructureHookEvent hashStructureHookEvent) {
            this.processDescriptors(hashStructureHookEvent.getCombinedHashStructure());
        }

        private void processDescriptors(HashStructure hashStructure) {
            List list = hashStructure.getAsList(ELEMENT_KEY);
            if (list != null) {
                for (HashStructure hashStructure2 : list) {
                    LazyClassAdapter lazyClassAdapter = LazyClassAdapter.getInstance((HashStructure)hashStructure2);
                    MetaClass metaClass = lazyClassAdapter.getMetaClass(TEXT_ELEMENT);
                    if (metaClass == null) continue;
                    this.s_resolvers.add(new Holder((MetaClass<DBURLResolver>)metaClass));
                }
            }
        }

        List<Holder> getResolvers() {
            return this.s_resolvers;
        }
    }

    private static class Holder {
        DBURLResolver m_resolver;
        MetaClass<DBURLResolver> m_cls;

        Holder(MetaClass<DBURLResolver> metaClass) {
            this.m_cls = metaClass;
        }

        synchronized DBURLResolver getResolver() {
            if (this.m_resolver == null) {
                try {
                    this.m_resolver = (DBURLResolver)this.m_cls.newInstance();
                }
                catch (Exception exception) {
                    Logger.severe(URLResolver.class, (Throwable)exception);
                }
            }
            return this.m_resolver;
        }
    }
}

