/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db;

import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.controls.sqldialog.IObjectActionListener;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.navigator.db.UIUpdater;
import oracle.dbtools.raptor.navigator.db.URLResolver;
import oracle.dbtools.raptor.navigator.db.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.db.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.ConnectionDetails;
import oracle.dbtools.raptor.utils.ConnectionDisconnectListener;
import oracle.dbtools.raptor.utils.ConnectionInitializer;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.DisconnectVetoException;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.util.Logger;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectProviderListener;

public final class DBAdapter {
    private static DBAdapter INSTANCE = new DBAdapter();
    private List<UIUpdater> m_updaters = new CopyOnWriteArrayList<UIUpdater>();
    private IObjectActionListener m_actionListener = new IObjectActionListener(){

        @Override
        public final void removedFromParent(final String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, final DBObject dBObject) {
            final Collection<UIUpdater> collection = DBAdapter.this.getUpdatersForObject(dBObject);
            if (collection.size() > 0) {
                DBAdapter.this.invokeUI(new Runnable(){

                    @Override
                    public void run() {
                        for (UIUpdater uIUpdater : collection) {
                            uIUpdater.objectRemoved(string, dBObject);
                        }
                    }
                });
            }
        }

        @Override
        public final void reloadParent(final String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, final DBObject dBObject) {
            final Collection<UIUpdater> collection = DBAdapter.this.getUpdatersForObject(dBObject);
            if (collection.size() > 0) {
                DBAdapter.this.invokeUI(new Runnable(){

                    @Override
                    public void run() {
                        for (UIUpdater uIUpdater : collection) {
                            uIUpdater.refreshParent(string, dBObject);
                        }
                    }
                });
            }
        }

        @Override
        public final void reload(final String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, final DBObject dBObject) {
            final Collection<UIUpdater> collection = DBAdapter.this.getUpdatersForObject(dBObject);
            if (collection.size() > 0) {
                DBAdapter.this.invokeUI(new Runnable(){

                    @Override
                    public void run() {
                        for (UIUpdater uIUpdater : collection) {
                            uIUpdater.refreshObject(string, dBObject);
                        }
                    }
                });
            }
        }

        @Override
        public void notify(String string, ObjectAction objectAction, Map<String, Object> map, List<String> list, DBObject dBObject) {
        }
    };
    private ConnListener m_connListener = new ConnListener();
    private DBObjectProviderListener m_dbAPIListener = new DBObjectProviderListener(){

        public void schemaObjectsAdded(DBObjectProvider dBObjectProvider, Schema schema, Collection<? extends SchemaObject> collection) {
            Node node;
            URL uRL;
            HashMap<URL, HashSet<String>> hashMap = new HashMap<URL, HashSet<String>>();
            Database database = (Database)dBObjectProvider;
            for (SchemaObject object : collection) {
                uRL = DBAdapter.this.getTypeURL(database, object);
                node = (Node)hashMap.get(uRL);
                if (node == null) {
                    node = new Node();
                    hashMap.put(uRL, (HashSet<String>)node);
                }
                node.add(object.getName());
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                DBFolderInstance dBFolderInstance;
                uRL = (URL)entry.getKey();
                node = NodeFactory.find((URL)uRL);
                if (!(node instanceof ObjectFolder) || (dBFolderInstance = ((ObjectFolder)node).getFolderInstance()) == null) continue;
                final ArrayList<DatabaseNode> arrayList = new ArrayList<DatabaseNode>();
                try {
                    for (DBObjectInstance dBObjectInstance : dBFolderInstance.getChildren(((Set)entry.getValue()).toArray(new String[0]), true)) {
                        DatabaseNode databaseNode = DatabaseNavigatorElementFactory.createObjectNode(uRL, dBObjectInstance);
                        if (databaseNode == null) continue;
                        arrayList.add(databaseNode);
                    }
                }
                catch (SQLException sQLException) {
                    ExceptionHandler.handleException((Throwable)sQLException);
                }
                catch (AbortException abortException) {
                    arrayList.clear();
                }
                DBAdapter.this.invokeUI(new Runnable(){

                    @Override
                    public void run() {
                        UpdateMessage.fireChildrenAdded((Subject)node, (Collection)arrayList);
                    }
                });
            }
        }

        public void schemaObjectsRemoved(DBObjectProvider dBObjectProvider, Schema schema, Collection<? extends SchemaObject> collection) {
        }

        public void objectUpdated(DBObjectChange dBObjectChange) {
            oracle.javatools.db.DBObject dBObject = dBObjectChange.getDBObject();
            if (dBObject instanceof SchemaObject) {
                DBFolderInstance dBFolderInstance;
                Node node;
                Node node2;
                Object object;
                Serializable serializable;
                SchemaObject schemaObject = (SchemaObject)dBObject;
                Database database = (Database)dBObjectChange.getProvider();
                String string = database.getQualifiedName();
                final URL uRL = DBAdapter.this.getTypeURL(database, schemaObject);
                final URL uRL2 = DBURLFormatHelper.getURL(uRL, schemaObject.getName());
                SchemaObject schemaObject2 = schemaObject;
                if (dBObjectChange.hasNameChanged()) {
                    schemaObject2 = (SchemaObject)schemaObject.copyTo(null, true);
                    serializable = dBObjectChange.getPropertyChange("name");
                    if (serializable != null) {
                        object = (String)((PropertyChangeEvent)serializable).getOldValue();
                        schemaObject2.setName((String)object);
                    }
                    if ((object = dBObjectChange.getPropertyChange("schema")) != null) {
                        node2 = (Schema)((PropertyChangeEvent)object).getOldValue();
                        schemaObject2.setSchema((Schema)node2);
                    }
                }
                serializable = DBAdapter.this.getTypeURL(database, schemaObject2);
                object = DBURLFormatHelper.getURL((URL)serializable, schemaObject2.getName());
                node2 = NodeFactory.find((URL)uRL);
                if (node2 instanceof ObjectFolder && (node = NodeFactory.find((URL)object)) instanceof DatabaseNode && (dBFolderInstance = ((ObjectFolder)node2).getFolderInstance()) != null) {
                    try {
                        List<? extends DBObjectInstance> list = dBFolderInstance.getChildren(new String[]{schemaObject.getName()}, true);
                        if (list.size() > 0) {
                            DBObjectInstance dBObjectInstance = list.get(0);
                            ((DatabaseNode)node).setNodeInstance(dBObjectInstance);
                            if (ModelUtil.areDifferent((Object)uRL2, (Object)object)) {
                                DBAdapter.this.invokeUI(new Runnable(){
                                    final /* synthetic */ URL val$origTypeURL;
                                    final /* synthetic */ Node val$parent;
                                    {
                                        this.val$origTypeURL = uRL3;
                                        this.val$parent = node2;
                                    }

                                    @Override
                                    public void run() {
                                        node.setURL(uRL2);
                                        if (ModelUtil.areDifferent((Object)uRL, (Object)this.val$origTypeURL)) {
                                            Node node2 = NodeFactory.find((URL)this.val$origTypeURL);
                                            if (node2 != null) {
                                                UpdateMessage.fireChildRemoved((Subject)node2, (Element)node);
                                            }
                                            UpdateMessage.fireChildAdded((Subject)this.val$parent, (Element)node);
                                        }
                                        UpdateMessage.fireObjectRenamed((Subject)node);
                                    }
                                });
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        ExceptionHandler.handleException((Throwable)sQLException);
                    }
                    catch (AbortException abortException) {
                        // empty catch block
                    }
                }
            }
        }
    };

    public static void registerTreeUpdater(UIUpdater uIUpdater) {
        DBAdapter.INSTANCE.m_updaters.add(uIUpdater);
    }

    private Collection<UIUpdater> getUpdatersForObject(DBObject dBObject) {
        ArrayList<UIUpdater> arrayList = new ArrayList<UIUpdater>();
        for (UIUpdater uIUpdater : this.m_updaters) {
            if (!uIUpdater.canHandleObject(dBObject)) continue;
            arrayList.add(uIUpdater);
        }
        return arrayList;
    }

    private DBAdapter() {
        ObjectActionController.addListener(this.m_actionListener);
        Connections connections = Connections.getInstance();
        connections.addInitializer(this.m_connListener);
        connections.addConnectionDisconnectListener(this.m_connListener);
        for (String string : connections.getConnNames()) {
            try {
                Database database = connections.getDatabase(string, false);
                if (database == null || !database.isConnectionAlive()) continue;
                database.addProviderListener(this.m_dbAPIListener);
            }
            catch (DBException dBException) {
                Logger.severe(DBAdapter.class, (Throwable)dBException);
            }
        }
    }

    protected final void invokeUI(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private URL getTypeURL(Database database, SchemaObject schemaObject) {
        URL uRL = URLResolver.resolveSchemaObject(database, schemaObject);
        return DBURLFormatHelper.getTypeURL(uRL);
    }

    private class ConnListener
    implements ConnectionInitializer,
    ConnectionDisconnectListener {
        private ConnListener() {
        }

        @Override
        public void checkDisconnect(ConnectionDetails connectionDetails) throws DisconnectVetoException {
        }

        @Override
        public void connectionDisconnected(ConnectionDetails connectionDetails) {
            Database database = connectionDetails.getDatabase();
            if (database != null) {
                database.removeProviderListener(DBAdapter.this.m_dbAPIListener);
            }
        }

        @Override
        public void initializeConnection(ConnectionDetails connectionDetails) {
            Database database = connectionDetails.getDatabase();
            if (database != null) {
                database.addProviderListener(DBAdapter.this.m_dbAPIListener);
            }
        }
    }
}

