/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.javafx.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyFloatWrapper;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyLongWrapper;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.util.Logger;
import oracle.javatools.util.ModelUtil;

public abstract class FxQuery<S, T> {
    private DBUtil dbUtil;
    private String fqConnectionName;
    private long updateInterval = 5000L;
    private boolean pauseWhenViewDeactivated;
    private FxQueryTask task;
    private static final Timer SCHEDULER = new Timer("FxQuery Scheduler");
    private List<T> targets = new ArrayList<T>();

    public FxQuery(String string) {
        this.fqConnectionName = string;
        this.dbUtil = ModelUtil.hasLength((String)string) ? DBUtil.getInstance((String)string) : null;
    }

    protected abstract boolean bindImpl(S var1, T var2);

    protected abstract S executeQueryImpl();

    protected abstract void updateObservableValuesImpl(S var1);

    protected abstract boolean unbindImpl(T var1);

    public final void bind(T t) {
        try {
            S s = this.executeQuery();
            if (this.bindImpl(s, t)) {
                this.targets.add(t);
            }
        }
        catch (Exception exception) {
            Logger.severe(this.getClass(), (Throwable)exception);
        }
    }

    public final void unbind(T t) {
        try {
            if (this.unbindImpl(t)) {
                this.targets.remove(t);
            }
        }
        catch (Exception exception) {
            Logger.severe(this.getClass(), (Throwable)exception);
        }
    }

    public final void setUpdateInterval(long l) {
        try {
            this.updateInterval = l;
            if (l > 0L) {
                this.scheduleTask();
            } else {
                this.cancelTask();
            }
        }
        catch (Exception exception) {
            Logger.severe(this.getClass(), (Throwable)exception);
        }
    }

    public void setViewActive(boolean bl) {
        if (this.isPauseWhenViewDeactivated()) {
            if (bl && this.getUpdateInterval() > 0L) {
                this.scheduleTask();
            } else {
                this.cancelTask();
            }
        }
    }

    public final void update() {
        if (this.isBound()) {
            this.updateImpl();
        }
    }

    protected final void updateImpl() {
        try {
            S s = this.executeQuery();
            this.updateObservableValues(s);
        }
        catch (Exception exception) {
            Logger.severe(this.getClass(), (Throwable)exception);
        }
    }

    protected void bind(Property<?> property, ObservableValue<?> observableValue) {
        if (property instanceof BooleanProperty) {
            ((BooleanProperty)property).bind((ObservableValue)((BooleanProperty)observableValue));
        } else if (property instanceof IntegerProperty) {
            ((IntegerProperty)property).bind((ObservableValue)((IntegerProperty)observableValue));
        } else if (property instanceof FloatProperty) {
            ((FloatProperty)property).bind((ObservableValue)((FloatProperty)observableValue));
        } else if (property instanceof LongProperty) {
            ((LongProperty)property).bind((ObservableValue)((LongProperty)observableValue));
        } else if (property instanceof DoubleProperty) {
            ((DoubleProperty)property).bind((ObservableValue)((DoubleProperty)observableValue));
        } else if (property instanceof StringProperty) {
            ((StringProperty)property).bind((ObservableValue)((StringProperty)observableValue));
        } else {
            ((ObjectProperty)property).bind((ObservableValue)((ObjectProperty)observableValue));
        }
    }

    protected ObservableValue<?> createObservableValueFor(Property<?> property) {
        assert (Platform.isFxApplicationThread());
        Object object = null;
        object = property instanceof BooleanProperty ? new ReadOnlyBooleanWrapper() : (property instanceof IntegerProperty ? new ReadOnlyIntegerWrapper() : (property instanceof FloatProperty ? new ReadOnlyFloatWrapper() : (property instanceof LongProperty ? new ReadOnlyLongWrapper() : (property instanceof DoubleProperty ? new ReadOnlyDoubleWrapper() : (property instanceof StringProperty ? new ReadOnlyStringWrapper() : new ReadOnlyObjectWrapper(property))))));
        return object;
    }

    protected void setObservableValue(ObservableValue<?> observableValue, Object object) {
        assert (Platform.isFxApplicationThread());
        if (observableValue instanceof BooleanProperty) {
            if (object != null) {
                ((BooleanProperty)observableValue).set(Boolean.parseBoolean(object.toString()));
            } else {
                ((BooleanProperty)observableValue).set(Boolean.FALSE.booleanValue());
            }
        } else if (observableValue instanceof FloatProperty) {
            if (object instanceof Number) {
                ((FloatProperty)observableValue).set(((Number)object).floatValue());
            } else {
                ((FloatProperty)observableValue).set((null == object ? null : Float.valueOf(object.toString())).floatValue());
            }
        } else if (observableValue instanceof IntegerProperty) {
            if (object instanceof Number) {
                ((IntegerProperty)observableValue).set(((Number)object).intValue());
            } else {
                ((IntegerProperty)observableValue).set((null == object ? null : Integer.valueOf(object.toString())).intValue());
            }
        } else if (observableValue instanceof LongProperty) {
            if (object instanceof Number) {
                ((LongProperty)observableValue).set(((Number)object).longValue());
            } else {
                ((LongProperty)observableValue).set((null == object ? null : Long.valueOf(object.toString())).longValue());
            }
        } else if (observableValue instanceof DoubleProperty) {
            if (object instanceof Number) {
                ((DoubleProperty)observableValue).set(((Number)object).doubleValue());
            } else {
                ((DoubleProperty)observableValue).set((null == object ? null : Double.valueOf(object.toString())).doubleValue());
            }
        } else if (observableValue instanceof StringProperty) {
            ((StringProperty)observableValue).set((Object)(null == object ? null : object.toString()));
        } else {
            ((ObjectProperty)observableValue).set(object);
        }
    }

    private final void updateObservableValues(final S s) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FxQuery.this.updateObservableValuesImpl(s);
            }
        };
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    private final S executeQuery() {
        Object object = null;
        DatabaseQueryTask databaseQueryTask = new DatabaseQueryTask<S>("FxQuery", IRaptorTaskRunMode.TASKVIEWER, false, false){

            public String getConnectionName() {
                return FxQuery.this.getFqConnectionName();
            }

            public String getQuery() {
                return "";
            }

            protected S doWork() throws TaskException {
                return FxQuery.this.executeQueryImpl();
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)databaseQueryTask);
        try {
            object = databaseQueryTask.getResult();
        }
        catch (Exception exception) {
            Logger.severe(this.getClass(), (Throwable)exception);
        }
        return (S)object;
    }

    protected DBUtil getDBUtil() {
        return this.dbUtil;
    }

    protected String getFqConnectionName() {
        return this.fqConnectionName;
    }

    protected long getUpdateInterval() {
        return this.updateInterval;
    }

    public void setPauseWhenViewDeactivated(boolean bl) {
        this.pauseWhenViewDeactivated = bl;
    }

    protected boolean isPauseWhenViewDeactivated() {
        return this.pauseWhenViewDeactivated;
    }

    private void cancelTask() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    private void scheduleTask() {
        this.cancelTask();
        this.task = new FxQueryTask(this);
        SCHEDULER.schedule((TimerTask)this.task, this.updateInterval, this.updateInterval);
    }

    protected List<T> getTargets() {
        return this.targets;
    }

    private boolean isBound() {
        return !this.targets.isEmpty();
    }

    static class FxQueryTask
    extends TimerTask {
        private FxQuery<?, ?> query;

        public FxQueryTask(FxQuery<?, ?> fxQuery) {
            this.query = fxQuery;
        }

        @Override
        public void run() {
            this.query.update();
        }
    }
}

