/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.conn;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Properties;
import javax.ide.extension.ElementName;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.conn.ConnectionPromptUI;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Logger;
import oracle.ide.ExtensionRegistry;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ModelUtil;

public class ConnectionInfoPanel
extends JPanel
implements ConnectionPromptUI {
    private static final String NS = "http://xmlns.oracle.com/sqldeveloper/sqldev-prompt";
    public static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/sqldeveloper/sqldev-prompt", "sqldev-prompt-hook");
    private static final String PROMPT_ELEMENT = "prompt";
    private static final String KEY_ATTRIBUTE = "key";
    private static final String CLS_ATTRIBUTE = "classname";
    JPasswordField fldPwd = new JPasswordField();
    JTextField fldUser = new JTextField();

    private static ConnectionPromptUI getPromptUI(String string) {
        HashStructure hashStructure;
        List list;
        ConnectionPromptUI connectionPromptUI = null;
        HashStructureHook hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(ELEMENT_NAME);
        if (hashStructureHook != null && (list = (hashStructure = hashStructureHook.getHashStructure()).getAsList(PROMPT_ELEMENT)) != null) {
            for (HashStructure hashStructure2 : list) {
                if (!ModelUtil.areEqual((Object)string, (Object)hashStructure2.getString(KEY_ATTRIBUTE))) continue;
                LazyClassAdapter lazyClassAdapter = LazyClassAdapter.getInstance((HashStructure)hashStructure2);
                connectionPromptUI = (ConnectionPromptUI)lazyClassAdapter.createInstance(ConnectionPromptUI.class, CLS_ATTRIBUTE);
                break;
            }
        }
        return connectionPromptUI;
    }

    private static ConnectionPromptUI createPanel(Properties properties) {
        ConnectionPromptUI connectionPromptUI = null;
        String string = properties.getProperty("SQLDEV_PROMPT_KEY");
        if (string != null) {
            connectionPromptUI = ConnectionInfoPanel.getPromptUI(string);
        }
        if (connectionPromptUI == null) {
            connectionPromptUI = new ConnectionInfoPanel();
        }
        connectionPromptUI.init(properties);
        return connectionPromptUI;
    }

    public static void promptForConnection(Properties properties) throws ConnectionCanceledException {
        Prompter prompter = new Prompter(properties);
        if (SwingUtilities.isEventDispatchThread()) {
            prompter.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(prompter);
            }
            catch (InterruptedException interruptedException) {
                Logger.severe(ConnectionInfoPanel.class, (Throwable)interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Logger.severe(ConnectionInfoPanel.class, (Throwable)invocationTargetException);
            }
        }
        if (prompter.isCanceled()) {
            throw new ConnectionCanceledException();
        }
    }

    public ConnectionInfoPanel() {
        try {
            this.jbInit();
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_connection_info_html");
        }
        catch (Exception exception) {
            Logger.severe(ConnectionInfoPanel.class, (Throwable)exception);
        }
    }

    @Override
    public void init(Properties properties) {
        String string = properties.getProperty("user");
        this.fldUser.setText(string != null ? string : "");
        String string2 = properties.getProperty("password");
        this.fldPwd.setText(string2 != null ? string2 : "");
    }

    @Override
    public void commit(Properties properties) throws TraversalException {
        String string = this.fldUser.getText();
        if (!ModelUtil.hasLength((String)string)) {
            throw new TraversalException(CreateDialogArb.getString("CONNECT_INFO_ERROR_USERNAME"));
        }
        properties.setProperty("user", string);
        char[] cArray = this.fldPwd.getPassword();
        String string2 = cArray != null ? new String(cArray) : "";
        string2 = string2.trim();
        if (string2.length() == 0) {
            this.fldPwd.setText("");
        }
        properties.setProperty("password", string2);
    }

    @Override
    public Component getInitialFocus() {
        return ModelUtil.hasLength((String)this.fldUser.getText()) ? this.fldPwd : this.fldUser;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.fldUser, (String)CreateDialogArb.getString("CONNECT_LABEL_USERNAME"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.fldPwd, (String)CreateDialogArb.getString("CONNECT_LABEL_PWD"));
        this.fldUser.setColumns(30);
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)this.fldPwd, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.fldUser, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private static final class Prompter
    implements Runnable {
        private boolean canceled;
        private final Properties desc;

        Prompter(Properties properties) {
            this.desc = properties;
        }

        @Override
        public void run() {
            final ConnectionPromptUI connectionPromptUI = ConnectionInfoPanel.createPanel(this.desc);
            Component component = connectionPromptUI.getComponent();
            String string = this.desc.getProperty("ConnName");
            String string2 = string != null ? CreateDialogArb.format("CONNECT_INFO_TITLE", Connections.getDisplayName(string)) : CreateDialogArb.getString("CONNECT_INFO_TITLE_NO_NAME");
            JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)component, (Component)connectionPromptUI.getInitialFocus(), (String)string2);
            jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                    if ("closed".equals(propertyChangeEvent.getPropertyName()) && Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                        try {
                            connectionPromptUI.commit(desc);
                        }
                        catch (TraversalException traversalException) {
                            traversalException.showMessageDialog(connectionPromptUI.getComponent());
                            throw new PropertyVetoException("no", propertyChangeEvent);
                        }
                    }
                }
            });
            jEWTDialog.setResizable(true);
            if (!WizardLauncher.runDialog((JDialog)jEWTDialog)) {
                this.canceled = true;
            }
        }

        boolean isCanceled() {
            return this.canceled;
        }
    }
}

