/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.datatools.BaseDataFormat;
import oracle.dbtools.datatools.DataToolsResources;
import oracle.dbtools.importer.ImportResources;
import oracle.dbtools.importer.core.CloudStorageUtils;
import oracle.dbtools.importer.core.ImportDataFormat;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.importer.core.ImportXMLUtil;
import oracle.dbtools.importer.readers.DataReaderEvent;
import oracle.dbtools.importer.readers.DataReaderException;
import oracle.dbtools.importer.readers.DataReaderListener;
import oracle.dbtools.importer.readers.DataReaderRegistry;
import oracle.dbtools.importer.readers.DataReaderUtils;
import oracle.dbtools.importer.readers.IDataReadable;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.NonUserConfigOptions;
import oracle.dbtools.raptor.controls.OracleConnectionComboBox;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.headless.ImportHeadlessResources;
import oracle.dbtools.raptor.data.ui.DataPreviewGizmo;
import oracle.dbtools.raptor.data.ui.DataUIUtils;
import oracle.dbtools.raptor.data.ui.ImportFormatOptionsPanel;
import oracle.dbtools.raptor.datatools.core.DataFormatHelper;
import oracle.dbtools.raptor.headless.InvalidCommandArgumentException;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.ui.dialogs.MessageDetailsDialog;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;

public class DataPreviewPage
extends DefaultTraversablePanel
implements DataReaderListener,
CommitListener {
    private static final long serialVersionUID = -5525219439802104748L;
    private static final String HTTPS_PROTOCOL = "https";
    private static final String HTTPS_PREFIX = "https://";
    static final String CONFIG_PATH_CONTEXT = DataPreviewPage.class.getName() + "_configChooser";
    private JPanel _sourceTypePanel;
    private JLabel _sourceTypeLabel = new JLabel(StringUtils.stripMnemonic((String)DataImportArb.getString("SOURCE_TYPE")));
    private JComboBox<String> _sourceTypeCmp;
    private ActionListener _sourceTypeListener;
    private JLabel _dataChooserLabel = new JLabel(StringUtils.stripMnemonic((String)DataImportArb.getString("DATA_FILE")));
    private JLabel _ossLabel = new JLabel(StringUtils.stripMnemonic((String)DataImportArb.getString("DATA_FILE")));
    private URLFileChooser.URLFileChooserPanel _ossCmp;
    protected JLabel _ossCredConnLabel = new JLabel();
    protected OracleConnectionComboBox _ossCredConnSelector = new OracleConnectionComboBox();
    private ActionListener _ossCredConnListener;
    private JLabel _ossCredLabel = new JLabel(StringUtils.stripMnemonic((String)DataImportArb.getString("CREDENTIAL")));
    private JComboBox<String> _ossCredCmp;
    private JButton _ossSampleCmp;
    protected ImportFormatOptionsPanel _formatOptions;
    protected ImportDataFormat _dataFormat;
    private DataPreviewGizmo _dataGizmo;
    private JPanel _formatPanel;
    private JComboBox _format;
    private JPanel _topPanel;
    private JPanel _filePanel;
    private JPanel _configPanel;
    private final FileNameExtensionFilter _configFilter = new FileNameExtensionFilter(DataImportArb.getString("CONFIG_FILE_TYPE"), "sdimp");
    protected URLFileChooser _configChooser;
    private File _configFile;
    private boolean _isConfigUsed = false;
    private ExitCode _exitCode;
    private URLFileChooser.URLFileChooserPanel _dataChooser;
    private String _defaultFileDir;
    protected LoadFile _loadFile;
    private URL _lastURL;
    private DataPreviewPage _previewPage = this;
    private String _ossCredConnName;
    protected IDataReadable _datareader;
    private int pages;
    boolean _isExistingTable = false;
    private boolean resetData;
    private boolean initUI = false;
    private boolean _initSource = false;
    private boolean _isCart = false;
    private boolean _isInitialFile = false;
    private boolean _isShowConfigPanel = true;
    private boolean _isBackEnabled = false;
    private boolean _isFinishEnabled = false;
    private TraversableContext _ctx;
    private ImportProperties _iProps;
    private ActionListener _dataFileListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (URLFileChooser.URL_SELECTED == actionEvent.getActionCommand()) {
                DataPreviewPage.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(DataPreviewPage.this._isBackEnabled), Boolean.valueOf(false), Boolean.valueOf(DataPreviewPage.this._isFinishEnabled));
                this.dataFileChanged();
                SwingUtilities.invokeLater(() -> DataPreviewPage.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(DataPreviewPage.this._isBackEnabled), Boolean.valueOf(DataPreviewPage.this._dataGizmo.isEnabled()), Boolean.valueOf(DataPreviewPage.this._isFinishEnabled)));
            }
        }

        void dataFileChanged() {
            try {
                File file = DataPreviewPage.this._dataChooser.getSelectedFile();
                if (file != null && file.isFile() && !file.isDirectory()) {
                    boolean bl;
                    String string = file.getAbsolutePath();
                    if (!DataPreviewPage.this._loadFile.getName().isEmpty() && DataPreviewPage.this._loadFile.getName().equals(string)) {
                        return;
                    }
                    LoadFile loadFile = new LoadFile(string);
                    if (DataPreviewPage.this._loadFile.getType() != loadFile.getType() && DataPreviewPage.this._isShowConfigPanel && DataPreviewPage.this._isConfigUsed && !DataFormatHelper.isCompatible(DataPreviewPage.this._dataFormat, loadFile.getType()) && !(bl = MessageDialog.confirm((Component)((Object)DataPreviewPage.this._previewPage), (Object)ImportResources.getString((String)"XML_FILE_COMPATIBILITY"), (String)ImportResources.getString((String)"TASK_SHORT_NAME"), null))) {
                        DataPreviewPage.this._filePanel.remove(DataPreviewPage.this._dataChooser);
                        DataPreviewPage.this.initDataChooser(DataPreviewPage.this._loadFile.getURL());
                        DataPreviewPage.this._filePanel.add((Component)DataPreviewPage.this._dataChooser, "Center");
                        DataPreviewPage.this.newFileInit(DataPreviewPage.this._loadFile.getType());
                        return;
                    }
                    DataPreviewPage.this._isConfigUsed = false;
                    DataPreviewPage.this._loadFile = new LoadFile(string);
                    if (DataPreviewPage.this._datareader != null) {
                        DataPreviewPage.this._datareader.closeFile();
                    }
                    DataPreviewPage.this._formatOptions = new ImportFormatOptionsPanel(BaseDataFormat.IMPORT_WIZARD, DataPreviewPage.this._loadFile.getType());
                    DataPreviewPage.this.newFileInit(DataPreviewPage.this._loadFile.getType());
                    DataPreviewPage.this._iProps.put(ImportKeys.SELECTED_COLUMNS, null);
                    DataPreviewPage.this._iProps.put(ImportKeys.SELECTABLE_COLUMNS, null);
                } else {
                    DataPreviewPage.this.resetUI();
                }
            }
            catch (Exception exception) {
                Logger.warn(this.getClass(), (Throwable)exception);
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)ImportResources.format((String)"OPEN_FILE_ERROR", (Object[])new Object[]{DataPreviewPage.this._loadFile.getName(), exception.getMessage()}), (String)ImportResources.getString((String)"OPEN_FILE_ERROR_TITLE"), (String)"IMPORT_OPEN_FILE_ERROR");
                DataPreviewPage.this._dataChooser.setText("");
                DataPreviewPage.this.resetUI();
            }
        }
    };
    private DocumentListener _enclosureRightTextListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.enclosureRightChanged(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.enclosureRightChanged(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.enclosureRightChanged(documentEvent);
        }

        void enclosureRightChanged(DocumentEvent documentEvent) {
            String string = "";
            try {
                string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (DataPreviewPage.this.isValid(string)) {
                DataPreviewPage.this._dataFormat.setEnclosureRight(string);
                DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
            }
        }
    };
    private DocumentListener _enclosureLeftTextListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.enclosureLeftChanged(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.enclosureLeftChanged(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.enclosureLeftChanged(documentEvent);
        }

        void enclosureLeftChanged(DocumentEvent documentEvent) {
            String string = "";
            try {
                string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (DataPreviewPage.this.isValid(string)) {
                DataPreviewPage.this._dataFormat.setEnclosureLeft(string);
                String string2 = DataPreviewPage.this._dataFormat.getEnclosureRightFromLeft(string);
                if (string2 != null) {
                    ((JTextField)DataPreviewPage.this._formatOptions.getEnclosuresRightComponent().getEditor().getEditorComponent()).getDocument().removeDocumentListener(DataPreviewPage.this._enclosureRightTextListener);
                    DataPreviewPage.this._formatOptions.getEnclosuresRightComponent().setSelectedItem(string2);
                    DataPreviewPage.this._dataFormat.setEnclosureRight(string2);
                    ((JTextField)DataPreviewPage.this._formatOptions.getEnclosuresRightComponent().getEditor().getEditorComponent()).getDocument().addDocumentListener(DataPreviewPage.this._enclosureRightTextListener);
                }
                DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
            }
        }
    };
    private DocumentListener _delimiterTextListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.delimiterValueChanged(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.delimiterValueChanged(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.delimiterValueChanged(documentEvent);
        }

        void delimiterValueChanged(DocumentEvent documentEvent) {
            String string = "";
            try {
                string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (DataPreviewPage.this.isValid(string)) {
                DataPreviewPage.this._dataFormat.setDelimiter(string);
                DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
                DataPreviewPage.this.resetData = true;
            }
        }
    };
    ItemListener _delimiterItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            String string;
            if (itemEvent.getStateChange() == 1 && !(string = (String)((JComboBox)itemEvent.getSource()).getSelectedItem()).equals(DataPreviewPage.this._dataFormat.getDelimiter())) {
                DataPreviewPage.this._dataFormat.setDelimiter(string);
                DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
                DataPreviewPage.this.resetData = true;
            }
        }
    };
    private ChangeListener _skipRowsChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            DataPreviewPage.this._dataFormat.setSkipRows(((NumericSpinBox)changeEvent.getSource()).getIntValue());
            DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
            DataPreviewPage.this.resetData = true;
        }
    };
    private ActionListener _headerLocationActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DataPreviewPage.this._dataFormat.setHeaderLocation(((JComboBox)actionEvent.getSource()).getSelectedIndex());
            DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
            DataPreviewPage.this.resetData = true;
        }
    };
    private DocumentListener _terminatorTextListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.terminatorValueChanged(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.terminatorValueChanged(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.terminatorValueChanged(documentEvent);
        }

        void terminatorValueChanged(DocumentEvent documentEvent) {
            String string = "";
            try {
                string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (DataPreviewPage.this.isValid(string)) {
                ((JTextField)DataPreviewPage.this._formatOptions.getRecordTerminatorComponent().getEditor().getEditorComponent()).getDocument().removeDocumentListener(DataPreviewPage.this._terminatorTextListener);
                DataPreviewPage.this._dataFormat.setRecordTerminator(string);
                DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
                ((JTextField)DataPreviewPage.this._formatOptions.getRecordTerminatorComponent().getEditor().getEditorComponent()).getDocument().addDocumentListener(DataPreviewPage.this._terminatorTextListener);
            }
        }
    };
    ItemListener _terminatorItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                DataPreviewPage.this._formatOptions.getRecordTerminatorComponent().removeItemListener(DataPreviewPage.this._terminatorItemListener);
                ((JTextField)DataPreviewPage.this._formatOptions.getRecordTerminatorComponent().getEditor().getEditorComponent()).getDocument().removeDocumentListener(DataPreviewPage.this._terminatorTextListener);
                DataPreviewPage.this._formatOptions.getRecordTerminatorComponent().setSelectedItem(DataPreviewPage.this._dataFormat.getRecordTerminator());
                DataPreviewPage.this._formatOptions.getRecordTerminatorComponent().addItemListener(DataPreviewPage.this._terminatorItemListener);
                ((JTextField)DataPreviewPage.this._formatOptions.getRecordTerminatorComponent().getEditor().getEditorComponent()).getDocument().addDocumentListener(DataPreviewPage.this._terminatorTextListener);
            }
        }
    };
    KeyAdapter _keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 10) {
                keyEvent.consume();
            }
        }
    };
    ChangeListener previewLimitChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
        }
    };
    ItemListener _formatListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                if (DataPreviewPage.this._dataFormat.isHeaderLocationSupported()) {
                    DataPreviewPage.this._formatOptions.getHeaderLocationComponent().removeActionListener(DataPreviewPage.this._headerLocationActionListener);
                }
                if (!DataFormatHelper.isExcel(DataPreviewPage.this._dataFormat.getFormat()) && !DataFormatHelper.isExcelX(DataPreviewPage.this._dataFormat.getFormat())) {
                    DataPreviewPage.this._format.removeItemListener(DataPreviewPage.this._formatListener);
                    DataPreviewPage.this._formatOptions.getDelimiterComponent().removeItemListener(DataPreviewPage.this._delimiterItemListener);
                    ((JTextField)DataPreviewPage.this._formatOptions.getDelimiterComponent().getEditor().getEditorComponent()).getDocument().removeDocumentListener(DataPreviewPage.this._delimiterTextListener);
                    DataPreviewPage.this._formatOptions.getRecordTerminatorComponent().removeItemListener(DataPreviewPage.this._terminatorItemListener);
                    ((JTextField)DataPreviewPage.this._formatOptions.getRecordTerminatorComponent().getEditor().getEditorComponent()).getDocument().removeDocumentListener(DataPreviewPage.this._terminatorTextListener);
                    DataPreviewPage.this._formatOptions.getSkipRowsComponent().removeChangeListener(DataPreviewPage.this._skipRowsChangeListener);
                }
                DataPreviewPage.this._dataFormat.setFormat((String)DataPreviewPage.this._format.getSelectedItem());
                DataPreviewPage.this._formatPanel.removeAll();
                DataPreviewPage.this._formatOptions.setOptions(DataPreviewPage.this._dataFormat.getOptions());
                DataPreviewPage.this._formatPanel = DataPreviewPage.this._formatOptions.getFormatPanel();
                DataPreviewPage.this._formatPanel.setBorder(BorderFactory.createTitledBorder(DataImportArb.getString("FILE_FORMAT")));
                DataPreviewPage.this._format = DataPreviewPage.this._formatOptions.getFormatComponent();
                DataPreviewPage.this._format.setSelectedItem(DataPreviewPage.this._dataFormat.getFormat());
                if (!DataFormatHelper.isExcel(DataPreviewPage.this._dataFormat.getFormat()) && !DataFormatHelper.isExcelX(DataPreviewPage.this._dataFormat.getFormat())) {
                    DataPreviewPage.this._format.addItemListener(DataPreviewPage.this._formatListener);
                    DataPreviewPage.this._formatOptions.getDelimiterComponent().addItemListener(DataPreviewPage.this._delimiterItemListener);
                    ((JTextField)DataPreviewPage.this._formatOptions.getDelimiterComponent().getEditor().getEditorComponent()).getDocument().addDocumentListener(DataPreviewPage.this._delimiterTextListener);
                    DataPreviewPage.this._formatOptions.getRecordTerminatorComponent().addItemListener(DataPreviewPage.this._terminatorItemListener);
                    ((JTextField)DataPreviewPage.this._formatOptions.getRecordTerminatorComponent().getEditor().getEditorComponent()).getDocument().addDocumentListener(DataPreviewPage.this._terminatorTextListener);
                    DataPreviewPage.this._formatOptions.getSkipRowsComponent().addChangeListener(DataPreviewPage.this._skipRowsChangeListener);
                }
                if (DataPreviewPage.this._dataFormat.isHeaderLocationSupported()) {
                    DataPreviewPage.this._formatOptions.getHeaderLocationComponent().addActionListener(DataPreviewPage.this._headerLocationActionListener);
                }
                DataPreviewPage.this._formatPanel.revalidate();
                DataPreviewPage.this._formatPanel.repaint();
                DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
            }
        }
    };

    protected JPanel getDataChooser() {
        return this._dataChooser;
    }

    protected void setDataChooserText(String string) {
        this._dataChooser.setText(string);
    }

    protected String getDataChooserText() {
        return this._dataChooser.getText();
    }

    protected void initDataChooser() {
        this.initDataChooser(null);
    }

    protected String getDefaultFileType() {
        return "dsv";
    }

    protected void resetData(boolean bl) {
        this.resetData = bl;
    }

    private void addListeners() {
        if (this._formatOptions.getEncodingsComponent() != null) {
            this._formatOptions.getEncodingsComponent().addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    String string;
                    if (itemEvent.getStateChange() == 1 && !(string = (String)((JComboBox)itemEvent.getSource()).getSelectedItem()).equals(DataPreviewPage.this._dataFormat.getEncoding())) {
                        DataPreviewPage.this._dataFormat.setEncoding(string);
                        DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
                        DataPreviewPage.this.resetData = true;
                    }
                }
            });
        }
        this._formatOptions.getHeaderComponent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataPreviewPage.this._dataFormat.isHeader(((JCheckBox)actionEvent.getSource()).isSelected());
                DataPreviewPage.this.resetData = true;
                DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
            }
        });
        this._formatOptions.getUsePreviewLimitComponent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataPreviewPage.this._dataFormat.setUsePreviewLimit(((JCheckBox)actionEvent.getSource()).isSelected());
                DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
                DataPreviewPage.this.resetData = true;
            }
        });
        this._formatOptions.getPreviewLimitComponent().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DataPreviewPage.this._dataFormat.setPreviewLimit(((NumericSpinBox)changeEvent.getSource()).getIntValue());
                DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
                DataPreviewPage.this.resetData = true;
            }
        });
        this._formatOptions.getSkipRowsComponent().addChangeListener(this._skipRowsChangeListener);
        if (this._dataFormat.isHeaderLocationSupported()) {
            this._formatOptions.getHeaderLocationComponent().addActionListener(this._headerLocationActionListener);
        }
        this._format = this._formatOptions.getFormatComponent();
        if (this._format != null) {
            this._format.addItemListener(this._formatListener);
        }
        if (!DataFormatHelper.isExcel(this._dataFormat.getFormat()) && !DataFormatHelper.isExcelX(this._dataFormat.getFormat())) {
            this._formatOptions.getDelimiterComponent().addKeyListener(this._keyListener);
            ((JTextField)this._formatOptions.getDelimiterComponent().getEditor().getEditorComponent()).getDocument().addDocumentListener(this._delimiterTextListener);
            this._formatOptions.getDelimiterComponent().addItemListener(this._delimiterItemListener);
            this._formatOptions.getEnclosuresLeftComponent().addKeyListener(this._keyListener);
            ((JTextField)this._formatOptions.getEnclosuresLeftComponent().getEditor().getEditorComponent()).getDocument().addDocumentListener(this._enclosureLeftTextListener);
            this._formatOptions.getEnclosuresRightComponent().addKeyListener(this._keyListener);
            ((JTextField)this._formatOptions.getEnclosuresRightComponent().getEditor().getEditorComponent()).getDocument().addDocumentListener(this._enclosureRightTextListener);
            this._formatOptions.getRecordTerminatorComponent().addKeyListener(this._keyListener);
            ((JTextField)this._formatOptions.getRecordTerminatorComponent().getEditor().getEditorComponent()).getDocument().addDocumentListener(this._terminatorTextListener);
            this._formatOptions.getRecordTerminatorComponent().addItemListener(this._terminatorItemListener);
        } else if (this.pages > 1) {
            this._formatOptions.getWorksheetComponent().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ((JComboBox)actionEvent.getSource()).getSelectedIndex();
                    DataPreviewPage.this._dataFormat.setPageId(n);
                    DataPreviewPage.this._dataFormat.setWorksheet((String)((JComboBox)actionEvent.getSource()).getSelectedItem());
                    try {
                        DataPreviewPage.this._datareader.setPage(n);
                        DataPreviewPage.this.populateDataTable(DataPreviewPage.this._datareader);
                        DataPreviewPage.this.resetData = true;
                    }
                    catch (DataReaderException dataReaderException) {
                        ExceptionHandler.handleException((Throwable)dataReaderException);
                    }
                }
            });
        }
    }

    public IDataReadable getDataReader() {
        return this._datareader;
    }

    public void setDataReader(IDataReadable iDataReadable) {
        this._datareader = iDataReadable;
        this.pages = iDataReadable.getNosPages();
        String string = this._dataFormat.getRecordTerminator();
        this._dataGizmo.setDataReader(this._datareader);
        if (iDataReadable.isLineTerminatorSupported() && string.equals(this._dataFormat.getRecordTerminator()) && this._formatOptions.getRecordTerminatorComponent() != null) {
            this._formatOptions.getRecordTerminatorComponent().setSelectedItem(this._dataFormat.getRecordTerminator());
        }
        this.validate();
        this.resetData = true;
    }

    private void populateDataTable(IDataReadable iDataReadable) {
        String string = this._dataFormat.getRecordTerminator();
        if (iDataReadable.isLineTerminatorSupported() && !this._dataFormat.getRecordTerminator().equals(string)) {
            this._formatOptions.getRecordTerminatorComponent().setSelectedItem(iDataReadable.getLineTerminator());
        }
        this._dataGizmo.populateDataTable(iDataReadable);
        this._dataGizmo.resetData(true);
    }

    public void raiseEvent(DataReaderEvent dataReaderEvent) {
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        Object object;
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        this._isFinishEnabled = false;
        this._iProps.put(ImportKeys.IS_FINISH_ENABLED, (Object)false);
        this._iProps.put(ImportKeys.IS_CONFIGFILE, (Object)this._isConfigUsed);
        if (this._sourceTypeCmp != null) {
            this._iProps.put(ImportKeys.IS_SOURCE_OSS, (Object)(this._sourceTypeCmp.getSelectedIndex() == 1 ? 1 : 0));
        } else {
            this._iProps.put(ImportKeys.IS_SOURCE_OSS, (Object)false);
        }
        this._iProps.put(ImportKeys.IMPORT_DATA_FORMAT, (Object)this._dataFormat);
        if (this._dataFormat.getUsePreviewLimit()) {
            object = this._dataFormat.getPreviewLimit();
            this._iProps.put(ImportKeys.PREVIEW_LIMIT, (Object)((Integer)object).toString());
        }
        this._iProps.put(ImportKeys.PAGEID, (Object)this._dataFormat.getPageId());
        this._iProps.put(ImportKeys.LOCALE, (Object)Locale.getDefault());
        this._iProps.put(ImportKeys.GIZMO, (Object)this._dataGizmo);
        this._iProps.put(ImportKeys.USE_NLS_NUMERIC, (Object)this._dataFormat.getUseNlsNumeric());
        if (this._dataFormat.getUseNlsNumeric() && (object = (String)this._iProps.get(ImportKeys.CONNECTION_NAME)) != null && !((String)object).isEmpty()) {
            try {
                Connection connection = Connections.getInstance().getConnection((String)object);
                this._iProps.put(ImportKeys.NLS_DECIMAL_SEPARATOR, (Object)new Character(((OracleNLSProvider)NLSProvider.getProvider((Connection)connection)).getDecimalSeparator()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this._isConfigUsed || this.resetData) {
            this._dataGizmo.createFields(this._loadFile);
            if (!this._isExistingTable) {
                this._iProps.put(ImportKeys.TABLE, null);
            }
            this._iProps.put(ImportKeys.LOAD_FILE, (Object)this._loadFile);
            this._dataGizmo.onExit(traversableContext);
            if (!this._isCart || !this._isExistingTable) {
                DataUIUtils.setFileColumnsFromSource(this._iProps);
                if (this._iProps.get(ImportKeys.SELECTABLE_COLUMNS) == null) {
                    this._iProps.put(ImportKeys.SELECTED_COLUMNS, this._iProps.get(ImportKeys.FILE_COLUMNS));
                    this._iProps.put(ImportKeys.SELECTABLE_COLUMNS, (Object)new Column[0]);
                }
            }
            if (this.resetData) {
                this._iProps.put(ImportKeys.SELECTED_COLUMNS, this._iProps.get(ImportKeys.FILE_COLUMNS));
                this._iProps.put(ImportKeys.SELECTABLE_COLUMNS, (Object)new Column[0]);
            }
        } else {
            this._iProps.put(ImportKeys.LOAD_FILE, (Object)this._loadFile);
            this._dataGizmo.onExit(traversableContext);
        }
        this._iProps.put(ImportKeys.IS_EXISTING_TABLE, (Object)this._isExistingTable);
        if (this._datareader != null) {
            if (!DataFormatHelper.isExcel(this._dataFormat.getFormat()) && !DataFormatHelper.isExcelX(this._dataFormat.getFormat())) {
                this._datareader.closeFile();
            } else {
                this._iProps.put(ImportKeys.DATA_READER, (Object)this._datareader);
            }
        }
        this._iProps.put(ImportKeys.IS_SOURCE_OSS, (Object)this._sourceTypeCmp.getSelectedItem().equals(DataImportArb.getString("OSS_FILE")));
    }

    public void showConfigPanel(boolean bl) {
        this._isShowConfigPanel = bl;
    }

    public void isBackEnabled(boolean bl) {
        this._isBackEnabled = bl;
    }

    public void onEntry(TraversableContext traversableContext) {
        this._ctx = traversableContext;
        this._iProps = (ImportProperties)this._ctx.get("IMPORT_PROPERTIES");
        if (!this.initUI) {
            Object object;
            Object object2;
            URL uRL = (URL)this._iProps.get(ImportKeys.INITIAL_FILE_URL);
            URL uRL2 = (URL)this._iProps.get(ImportKeys.INITIAL_CONFIG_URL);
            this._iProps.put(ImportKeys.CONFIG_URL, (Object)uRL2);
            boolean bl = this._isInitialFile = uRL != null;
            if (this._iProps.getValueBoolean(ImportKeys.IS_CART) != null) {
                this._isCart = this._iProps.getValueBoolean(ImportKeys.IS_CART);
                this.showConfigPanel(!this._isCart || uRL2 == null);
            }
            this._loadFile = new LoadFile("");
            if (this._isShowConfigPanel) {
                this.initConfigPanel();
            }
            if (uRL2 != null) {
                this.initDataChooser();
                this.initUI();
                if (!uRL.getProtocol().equals(HTTPS_PROTOCOL)) {
                    this._loadFile.setName(uRL.getFile());
                    this._dataChooser.setSelectedURL(uRL);
                } else {
                    try {
                        object2 = new URL(HTTPS_PREFIX);
                        this._ossCmp.setSelectedURL((URL)object2);
                        this._ossCmp.setSelectedURL(uRL);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this._datareader.showPreviewMessages(true);
                object2 = URLFileSystem.getSuffix((URL)uRL2);
                if (((String)object2).equals(".sdimp")) {
                    this._configFile = new File(uRL2.getPath());
                    this.openConfigOptions(this._configFile, true);
                }
                if (this._iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS).booleanValue()) {
                    try {
                        this._ossCredConnSelector.setCurrentConnection((String)this._iProps.get(ImportKeys.CONNECTION_NAME));
                    }
                    catch (Exception exception) {
                        this._ossCredConnSelector.setCurrentConnection(null);
                    }
                    try {
                        object = (String)this._iProps.get(ImportKeys.OSS_CREDENTIAL);
                        if (object == null) {
                            this._ossCredCmp.setSelectedIndex(-1);
                        } else {
                            this._ossCredCmp.setSelectedItem(object == null ? Integer.valueOf(-1) : object);
                        }
                    }
                    catch (Exception exception) {
                        this._ossCredCmp.setSelectedIndex(-1);
                    }
                }
                this._dataChooserLabel.setEnabled(false);
                this._dataChooser.setEnabled(false);
                this._sourceTypeLabel.setEnabled(false);
                this._sourceTypeCmp.setEnabled(false);
                this._isFinishEnabled = true;
                this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(this._isBackEnabled), Boolean.valueOf(true), Boolean.valueOf(this._isFinishEnabled));
            } else {
                this.initDataChooser();
                this.initUI();
                if (uRL != null) {
                    this._loadFile.setName(uRL.getPath());
                    this._dataChooserLabel.setEnabled(false);
                    this._dataChooser.setSelectedURL(uRL);
                    this._dataChooser.setEnabled(false);
                    this._sourceTypeLabel.setEnabled(false);
                    this._sourceTypeCmp.setEnabled(false);
                } else {
                    this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(this._isBackEnabled), Boolean.valueOf(false), Boolean.valueOf(this._isFinishEnabled));
                }
            }
            object2 = this._iProps.get(ImportKeys.DBOBJECT);
            if (object2 != null && object2 instanceof DBObject && (object = (DBObject)((Object)object2)).getObjectType().equals("TABLE")) {
                this._isExistingTable = true;
            }
            this._iProps.put(ImportKeys.IS_FINISH_ENABLED, (Object)this._isFinishEnabled);
            this.initUI = true;
        } else {
            this.remove(this._dataGizmo);
            this.add(this._dataGizmo, "Center");
            this._isExistingTable = this._iProps.getValueBoolean(ImportKeys.IS_EXISTING_TABLE);
            this._loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
            this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(this._isBackEnabled), Boolean.valueOf(true), Boolean.valueOf(this._isFinishEnabled));
        }
        this.validate();
        if (this._dataGizmo != null) {
            this._dataGizmo.resetData(false);
        }
    }

    private void initUI() {
        this.setLayout(new BorderLayout(0, 16));
        this._topPanel = new JPanel(new BorderLayout());
        if (this._isShowConfigPanel) {
            this._topPanel.add((Component)this._configPanel, "North");
        }
        this.initSourcePanel();
        this._topPanel.add((Component)this._sourceTypePanel, "Center");
        this._dataFormat = this.getDefaultFormat(BaseDataFormat.IMPORT_WIZARD);
        this._formatOptions = new ImportFormatOptionsPanel((BaseDataFormat)this._dataFormat);
        this._datareader = DataReaderRegistry.getReader((String)this.getDefaultFileType());
        this._formatOptions.setDataReader(this._datareader);
        this._formatPanel = this._formatOptions.getFormatPanel();
        this._formatPanel.setBorder(BorderFactory.createTitledBorder(DataImportArb.getString("FILE_FORMAT")));
        JPanel jPanel = new JPanel(new BorderLayout(0, 8));
        jPanel.add((Component)this._topPanel, "North");
        jPanel.add((Component)this._formatPanel, "South");
        this.add(jPanel, "North");
        this.add(jPanel, "North");
        this._dataGizmo = new DataPreviewGizmo(null);
        this._iProps.put(ImportKeys.GIZMO, (Object)this._dataGizmo);
        this._dataGizmo.initUI();
        this._dataGizmo.setEnabled(false);
        this.add(this._dataGizmo, "Center");
    }

    protected ImportDataFormat getDefaultFormat(int n) {
        return new ImportDataFormat(n, BaseDataFormat.DELIMITED);
    }

    protected void initConn() {
        this._ossCredConnLabel.setText(StringUtils.stripMnemonic((String)DataImportArb.getString("CCON_LABEL")));
        this._ossCredConnLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DataImportArb.getString("CCON_LABEL")));
        this._ossCredConnLabel.setLabelFor(this._ossCredConnSelector.getJComboBox());
        this._ossCredConnLabel.setToolTipText(DataImportArb.getString("CCON_TOOLTIP"));
        this.addCredConnListener();
    }

    private void addCredConnListener() {
        this._ossCredConnListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataPreviewPage.this._ossCredConnName = DataPreviewPage.this.getCredConnection();
                DataPreviewPage.this.resetConnection();
            }
        };
        this._ossCredConnSelector.getJComboBox().addActionListener(this._ossCredConnListener);
    }

    public String getCredConnection() {
        if (this._ossCredConnSelector != null) {
            return this._ossCredConnSelector.getCurrentConnectionName();
        }
        return null;
    }

    private void initSourcePanel() {
        int n = 0;
        if (this._sourceTypeCmp != null) {
            n = this._sourceTypeCmp.getSelectedIndex();
        }
        if (!this._initSource) {
            this._sourceTypePanel = new JPanel(new GridBagLayout());
            this._sourceTypePanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 8, 8));
            this._sourceTypeCmp = new JComboBox<String>(this.getSourceTypes());
            this._sourceTypeCmp.setToolTipText(DataImportArb.getString("SOURCE_TYPE_TIP"));
            this._sourceTypeLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DataImportArb.getString("SOURCE_TYPE")));
            this._sourceTypeLabel.setLabelFor(this._sourceTypeCmp);
            this._dataChooserLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DataImportArb.getString("SOURCE_TYPE")));
            this._dataChooserLabel.setToolTipText(DataImportArb.getString("OSS_FILE_TIP"));
            this._dataChooserLabel.setLabelFor(this._dataChooser);
            this._ossLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DataImportArb.getString("SOURCE_TYPE")));
            this._ossLabel.setToolTipText(DataImportArb.getString("OSS_FILE_TIP"));
            this._ossLabel.setLabelFor(this._ossCmp);
            this._ossSampleCmp = new JButton(StringUtils.stripMnemonic((String)DataImportArb.getString("DATA_FILE_SAMPLE")));
            this.initOssCmp(null);
            this._ossCmp.setToolTipText(DataImportArb.getString("OSS_FILE_TIP"));
            this.initConn();
            this._ossCredConnSelector.getJComboBox().setToolTipText(DataImportArb.getString("SCONN_TOOLTIP"));
            this._ossCredConnSelector.getJComboBox().addItemListener(new Connector(this._ossCredConnSelector));
            this._ossCredCmp = DataUIUtils.getSQLCombo(this._ossCredLabel);
            Dimension dimension = this._ossCredCmp.getPreferredSize();
            this._ossCredCmp.setMinimumSize(new Dimension(60, dimension.height));
            if ((String)this._iProps.get(ImportKeys.CONNECTION_NAME) != null) {
                DataUIUtils.setCredentialModel(this._ossCredCmp, (String)this._iProps.get(ImportKeys.CONNECTION_NAME));
            }
            this._ossCredCmp.setToolTipText(DataImportArb.getString("CREDENTIAL_TIP"));
            this._ossSampleCmp.setToolTipText(DataImportArb.getString("DATA_FILE_SAMPLE_TIP"));
            this._ossSampleCmp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DataPreviewPage.this.openOSS();
                }
            });
            int n2 = 0;
            this._sourceTypePanel.add((Component)this._sourceTypeLabel, LayoutControl.GBC.gbc(0, n2, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
            this._sourceTypePanel.add(this._sourceTypeCmp, LayoutControl.GBC.gbc(1, n2, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
            if (!this._isCart) {
                this._sourceTypePanel.add((Component)this._ossLabel, LayoutControl.GBC.gbc(0, ++n2, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
                this._sourceTypePanel.add((Component)this._ossCmp, LayoutControl.GBC.gbc(1, n2, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
                this._sourceTypePanel.add((Component)this._ossCredLabel, LayoutControl.GBC.gbc(2, n2, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
                this._sourceTypePanel.add(this._ossCredCmp, LayoutControl.GBC.gbc(3, n2, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
                this._sourceTypePanel.add((Component)this._ossSampleCmp, LayoutControl.GBC.gbc(4, n2, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.NONE));
            } else {
                this._sourceTypePanel.add((Component)this._ossCredConnLabel, LayoutControl.GBC.gbc(0, ++n2, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
                this._sourceTypePanel.add((Component)this._ossCredConnSelector.getJComboBox(), LayoutControl.GBC.gbc(1, n2, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
                this._sourceTypePanel.add((Component)this._ossCredLabel, LayoutControl.GBC.gbc(2, n2, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
                this._sourceTypePanel.add(this._ossCredCmp, LayoutControl.GBC.gbc(3, n2, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
                this._sourceTypePanel.add((Component)this._ossLabel, LayoutControl.GBC.gbc(0, ++n2, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
                this._sourceTypePanel.add((Component)this._ossCmp, LayoutControl.GBC.gbc(1, n2, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
                this._sourceTypePanel.add((Component)this._ossSampleCmp, LayoutControl.GBC.gbc(2, n2, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.NONE));
            }
            this._filePanel = new JPanel(new BorderLayout(0, 8));
            this._filePanel.add((Component)this.getDataChooser(), "Center");
            this._sourceTypePanel.add((Component)this._dataChooserLabel, LayoutControl.GBC.gbc(0, n2, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
            this._sourceTypePanel.add((Component)this._filePanel, LayoutControl.GBC.gbc(1, n2, 2, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
            this._sourceTypeCmp.setSelectedIndex(n);
            this.updateSourceComponents();
            this.createSourceTypeListener();
            this.addSourceTypeListener();
            this._initSource = true;
        }
    }

    private void setLocalComponentsVisible(boolean bl) {
        if (this._dataChooserLabel != null) {
            this._dataChooserLabel.setVisible(bl);
        }
        if (this._dataChooser != null) {
            this._dataChooser.setVisible(bl);
        }
    }

    private void setOSSComponentsVisible(boolean bl) {
        this._ossLabel.setVisible(bl);
        this._ossCmp.setVisible(bl);
        this._ossSampleCmp.setVisible(bl);
        this._ossCredLabel.setVisible(bl);
        this._ossCredCmp.setVisible(bl);
        this._ossCredConnLabel.setVisible(bl);
        this._ossCredConnSelector.getJComboBox().setVisible(bl);
    }

    protected String[] getSourceTypes() {
        if (this._iProps.getValueBoolean(ImportKeys.IS_DWCS).booleanValue() || this._iProps.getValueBoolean(ImportKeys.IS_CART).booleanValue()) {
            return new String[]{DataImportArb.getString("LOCAL_FILE"), DataImportArb.getString("OSS_FILE")};
        }
        return new String[]{DataImportArb.getString("LOCAL_FILE")};
    }

    private void initDataChooser(URL uRL) {
        this._dataChooser = URLFileChooser.createURLFileChooserPanel(0, null, false, false);
        if (this._sourceTypePanel != null) {
            this._sourceTypePanel.add((Component)this._filePanel, LayoutControl.GBC.gbc(1, 1, 2, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        }
        this._dataChooser.clearChooseableURLFilters();
        if (uRL == null) {
            this._defaultFileDir = DBConfig.getInstance().getString("IMPORTDIR");
            if (this._defaultFileDir == null || this._defaultFileDir.length() == 0) {
                this._defaultFileDir = DBConfig.getInstance().getString("EXPORTDIR");
            }
            File file = null;
            try {
                file = this._defaultFileDir == null || this._defaultFileDir.equals("") ? (NonUserConfigOptions.get("DEFAULT_EXPORT") == null || NonUserConfigOptions.get("DEFAULT_EXPORT").equals("") ? new File(System.getProperty("user.home")) : new File(NonUserConfigOptions.get("DEFAULT_EXPORT"))) : new File(this._defaultFileDir);
                this._lastURL = file.toURI().toURL();
                this._dataChooser.setText("");
            }
            catch (Exception exception) {
                Logger.warn(((Object)((Object)this)).getClass(), (Throwable)exception);
            }
        } else {
            this._dataChooser.setSelectedURL(uRL);
        }
        this._dataChooser.setVisible(true);
        this._dataChooser.setEnabled(true);
        this._dataChooser.setCheckIfFileExists(false);
        this._dataChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                boolean bl = false;
                if (file != null) {
                    int n;
                    if (file.isDirectory()) {
                        return true;
                    }
                    String string = file.getName();
                    String string2 = null;
                    if (string != null && string.trim().length() > 0 && (n = string.lastIndexOf(46)) >= 0) {
                        string2 = string.substring(n + 1);
                    }
                    bl = "csv".equalsIgnoreCase(string2) || "xls".equalsIgnoreCase(string2) || "xlsx".equalsIgnoreCase(string2) || "txt".equalsIgnoreCase(string2) || "tsv".equalsIgnoreCase(string2) || "dsv".equalsIgnoreCase(string2);
                }
                return bl;
            }

            @Override
            public String getDescription() {
                String string = DataImportArb.getString("FILTER_DESCRIPTION");
                return string;
            }
        });
        this._dataChooser.setPathContext("IMPORTDIR");
        this._dataChooser.setSelectedURL(null);
        this._dataChooser.addActionListener(this._dataFileListener);
    }

    private void initOssCmp(URL uRL) {
        this._ossCmp = URLFileChooser.createURLFileChooserPanel(0, null, null, false, false, false);
        this._ossCmp.clearChooseableURLFilters();
        if (uRL != null) {
            this._ossCmp.setSelectedURL(uRL);
        }
        this._ossCmp.setVisible(true);
        this._ossCmp.setEnabled(true);
        this._ossCmp.setCheckIfFileExists(false);
        this._ossCmp.setURLFilter(new URLFilter(){

            public boolean accept(URL uRL) {
                boolean bl = false;
                if (uRL == null) {
                    return false;
                }
                String string = uRL.getProtocol();
                if (string.equals(DataPreviewPage.HTTPS_PROTOCOL)) {
                    String string2 = uRL.getPath();
                    String string3 = "";
                    if (string2 != null && string2.trim().length() > 0) {
                        int n = string2.lastIndexOf(46);
                        if (n >= 0) {
                            string3 = string2.substring(n + 1);
                        }
                        bl = "csv".equalsIgnoreCase(string3) || "txt".equalsIgnoreCase(string3) || "tsv".equalsIgnoreCase(string3) || "dsv".equalsIgnoreCase(string3);
                    }
                }
                return bl;
            }

            public String getDescription() {
                String string = DataImportArb.getString("FILTER_DESCRIPTION");
                return string;
            }
        });
    }

    protected void newFileInit(String string) throws DataReaderException {
        try {
            this._datareader = DataReaderRegistry.getReader((String)string);
        }
        catch (Exception exception) {
            throw new DataReaderException(ImportResources.format((String)"OPEN_FILE_TYPE_ERROR", (Object[])new Object[]{string}), ExitCode.EXIT_SEVERE, false);
        }
        if (this._datareader == null) {
            throw new DataReaderException(ImportResources.format((String)"OPEN_FILE_TYPE_ERROR", (Object[])new Object[]{string}), ExitCode.EXIT_SEVERE, false);
        }
        if (this._datareader != null) {
            this._datareader.showPreviewMessages(this.initUI);
            this._datareader.setFileName(this._loadFile.getName());
            if (this._iProps.get(ImportKeys.PAGEID) != null) {
                this._datareader.setPage(((Integer)this._iProps.get(ImportKeys.PAGEID)).intValue());
            }
            this._dataGizmo = new DataPreviewGizmo(this._datareader);
            this._iProps.put(ImportKeys.GIZMO, (Object)this._dataGizmo);
            this._formatOptions.setDataReader(this._datareader);
            this._formatPanel = this._formatOptions.getFormatPanel();
            this._formatPanel.setBorder(BorderFactory.createTitledBorder(DataImportArb.getString("FILE_FORMAT")));
            this._dataFormat = (ImportDataFormat)this._formatOptions.getProperties();
            this._dataFormat.setIsFileFragment(this._sourceTypeCmp.getSelectedIndex() != 0);
            this._dataGizmo.setDataFormat(this._dataFormat);
            this.pages = this._datareader.getNosPages();
            this.newFileInitUI();
            this.repaint();
            this.getParent().validate();
        }
    }

    protected void newFileInitUI() {
        this._dataGizmo.initUI();
        this.removeAll();
        JPanel jPanel = new JPanel(new BorderLayout(0, 8));
        jPanel.add((Component)this._topPanel, "North");
        jPanel.add((Component)this._formatPanel, "South");
        this.add(jPanel, "North");
        this.add(this._dataGizmo, "Center");
        this.setDataReader(this._datareader);
        this.addListeners();
        this.resetData = false;
    }

    private void initConfigPanel() {
        JButton jButton = new JButton(DataImportArb.getString("CONFIG_RESTORE_STATE"), RaptorImagesArb.getIcon("GEAR"));
        jButton.setToolTipText(ImportResources.getString((String)"OPEN_CONFIG_TIP"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataPreviewPage.this.openConfig();
            }
        });
        this._configPanel = new JPanel(new BorderLayout());
        this._configPanel.add((Component)jButton, "After");
    }

    private void openConfig() {
        String string = DataImportArb.getString("OPEN_CONFIG_DIALOG_TITLE");
        JPanel jPanel = new JPanel(new GridBagLayout());
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_openimportconfig_html");
        this._configChooser = new URLFileChooser();
        this._configChooser.setSelectedURL(null);
        this._configChooser.setPathContext(CONFIG_PATH_CONTEXT);
        this._configChooser.clearChooseableURLFilters();
        this._configChooser.setFileFilter(this._configFilter);
        int n = this._configChooser.showOpenDialog((Component)((Object)this), string);
        if (n == 0) {
            this._configFile = this._configChooser.getSelectedFile();
            if (this._configFile == null || this._configFile.isDirectory() || !this._configFile.isFile()) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)ImportResources.getString((String)"OPEN_CONFIG_ERROR"), (String)ImportResources.getString((String)"OPEN_CONFIG_ERROR_TITLE"), (String)"IMPORT_FILE_ERROR");
            } else {
                try {
                    this._iProps.put(ImportKeys.CONFIG_URL, (Object)this._configFile.toURI().toURL());
                }
                catch (Exception exception) {
                    Logger.warn(((Object)((Object)this)).getClass(), (String)exception.getMessage());
                }
                this.openConfigOptions(this._configFile);
            }
        }
    }

    public void openConfigOptions(File file) {
        this.openConfigOptions(file, false);
    }

    public void openConfigOptions(File file, boolean bl) {
        try {
            boolean bl2;
            this._exitCode = ExitCode.EXIT_SUCCESS;
            ImportXMLUtil importXMLUtil = new ImportXMLUtil();
            importXMLUtil.setImport(Boolean.valueOf(true));
            FileInputStream fileInputStream = new FileInputStream(file);
            importXMLUtil.parseXML((InputStream)fileInputStream, true);
            ((InputStream)fileInputStream).close();
            String string = (String)this._iProps.get(ImportKeys.CONNECTION_NAME);
            DBObject dBObject = null;
            BasicDBObject basicDBObject = (BasicDBObject)importXMLUtil.getPropertyValueObject(ImportKeys.DBOBJECT);
            if (basicDBObject != null) {
                dBObject = new DBObject(basicDBObject.getURL());
            }
            if (this._loadFile != null && this._loadFile.getName().length() > 0 && !this._isCart && !(bl2 = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)ImportResources.format((String)"CONFIG_OPEN_ERROR29", (Object[])new Object[]{this._loadFile.getName()}), (String)ImportResources.getString((String)"CONFIG_WARN_TITLE"), (String)"FILE_OPEN_WARNING"))) {
                return;
            }
            this._exitCode = this._isCart ? importXMLUtil.reconcileConfig(file.getName(), this._loadFile.getName(), bl, this._isCart) : importXMLUtil.reconcileConfig(file.getName(), this._isExistingTable, string, (BasicDBObject)dBObject, this._loadFile.getName(), bl, this._isCart);
            Object object = "";
            switch (this._exitCode) {
                case EXIT_SUCCESS: {
                    String string2 = ImportResources.getString((String)"EXIT_SUCCESS_LABEL");
                    break;
                }
                case EXIT_WARNING: 
                case EXIT_ERROR: {
                    String string3 = this._exitCode.getSeverity() == ExitCode.EXIT_WARNING.getSeverity() ? ImportResources.getString((String)"EXIT_WARNING_LABEL") : ImportResources.getString((String)"EXIT_ERROR_LABEL");
                    MessageDetailsDialog messageDetailsDialog = new MessageDetailsDialog();
                    messageDetailsDialog.showWarningDialog(ImportResources.format((String)"CONFIG_OPEN_ERROR22", (Object[])new Object[]{string3}), ImportResources.format((String)"CONFIG_OPEN_ERROR14", (Object[])new Object[]{file.getName()}) + "\n" + this._exitCode.getMessage().toString());
                    break;
                }
                default: {
                    String string4 = ImportResources.getString((String)"EXIT_SEVERE_LABEL");
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)(ImportResources.format((String)"CONFIG_OPEN_ERROR22", (Object[])new Object[]{string4}) + "\n" + ImportResources.getString((String)"CONFIG_OPEN_ERROR23") + "\n" + this._exitCode.getMessage().toString()), (String)ImportResources.getString((String)"XML_FILE_ERROR_TITLE"), (String)"XML_FILE_ERROR_TITLE");
                    object = ImportHeadlessResources.format("IMPORT_VALIDATION_COMPLETED", string4) + "\n";
                    Logger.severe(((Object)((Object)this)).getClass(), (String)((String)object + this._exitCode.getMessage()));
                    throw new InvalidCommandArgumentException((String)object + this._exitCode.getMessage());
                }
            }
            if (this._isCart && (basicDBObject = (BasicDBObject)importXMLUtil.getPropertyValueObject(ImportKeys.DBOBJECT)) != null) {
                this._iProps.put(ImportKeys.DBOBJECT, (Object)new DBObject(basicDBObject.getURL()));
            }
            this._loadFile = (LoadFile)importXMLUtil.getPropertyValueObject(ImportKeys.LOAD_FILE);
            this._iProps.put(ImportKeys.TABLE, importXMLUtil.getPropertyValueObject(ImportKeys.TABLE));
            this._iProps.put(ImportKeys.TABLE_NAME, (Object)importXMLUtil.getPropertyValue(ImportKeys.TABLE_NAME));
            this._dataFormat = (ImportDataFormat)importXMLUtil.getPropertyValueObject(ImportKeys.IMPORT_DATA_FORMAT);
            this._iProps.put(ImportKeys.PAGEID, (Object)this._dataFormat.getPageId());
            this._iProps.put(ImportKeys.WORKSHEET_NAME, (Object)this._dataFormat.getWorksneet());
            this._formatOptions = new ImportFormatOptionsPanel(BaseDataFormat.IMPORT_WIZARD, this._loadFile.getType() != null ? this._loadFile.getType() : this._dataFormat.getFormat());
            this._datareader = importXMLUtil.getDataReader();
            this._dataGizmo = new DataPreviewGizmo(this._datareader);
            this._dataGizmo.setDataFormat(this._dataFormat);
            this._dataGizmo.initTable();
            this._datareader.showPreviewMessages(false);
            this._dataGizmo.populateDataTable();
            this._datareader.showPreviewMessages(true);
            this._iProps.put(ImportKeys.GIZMO, (Object)this._dataGizmo);
            this._formatOptions.setDataFormat(this._dataFormat);
            this._formatOptions.setDataReader(this._datareader);
            this._formatPanel = this._formatOptions.getFormatPanel();
            this._formatPanel.setBorder(BorderFactory.createTitledBorder(DataImportArb.getString("FILE_FORMAT")));
            this._iProps.put(ImportKeys.IS_SOURCE_OSS, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.IS_SOURCE_OSS));
            boolean bl3 = this._iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS);
            if (bl3) {
                this._iProps.put(ImportKeys.OSS_PATH, (Object)importXMLUtil.getPropertyValue(ImportKeys.OSS_PATH));
                this._iProps.put(ImportKeys.OSS_CREDENTIAL, (Object)importXMLUtil.getPropertyValue(ImportKeys.OSS_CREDENTIAL));
                this._iProps.put(ImportKeys.CONNECTION_NAME, importXMLUtil.getPropertyValueObject(ImportKeys.CONNECTION_NAME));
                this._ossCredConnSelector.setCurrentConnection((String)importXMLUtil.getPropertyValueObject(ImportKeys.CONNECTION_NAME));
                this.removeSourceTypeListener();
                this._sourceTypeCmp.setSelectedIndex(1);
                this.addSourceTypeListener();
                URL uRL = null;
                try {
                    uRL = new URL((String)this._iProps.get(ImportKeys.OSS_PATH));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this._ossCmp.setSelectedURL(uRL);
                this._ossCredCmp.setSelectedItem(this._iProps.get(ImportKeys.OSS_CREDENTIAL));
            } else {
                this.setDataChooserText(this._loadFile.getName());
                this.removeSourceTypeListener();
                this._sourceTypeCmp.setSelectedIndex(0);
                this.addSourceTypeListener();
            }
            this.updateSourceComponents();
            this.newFileInitUI();
            SwingUtilities.invokeLater(() -> this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false)));
            this._iProps.put(ImportKeys.STAGING_TABLE_NAME, (Object)importXMLUtil.getPropertyValue(ImportKeys.STAGING_TABLE_NAME));
            this._iProps.put(ImportKeys.DROP_STAGING_TABLE, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.DROP_STAGING_TABLE));
            this._iProps.put(ImportKeys.IS_EXISTING_TABLE, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.IS_EXISTING_TABLE));
            this._iProps.put(ImportKeys.TABLE_NAME, (Object)importXMLUtil.getPropertyValue(ImportKeys.TABLE_NAME));
            this._iProps.put(ImportKeys.USE_LOAD_LIMIT, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.USE_LOAD_LIMIT));
            this._iProps.put(ImportKeys.LOAD_LIMIT, (Object)importXMLUtil.getPropertyValueInt(ImportKeys.LOAD_LIMIT));
            this._iProps.put(ImportKeys.SEND_TO_WORKSHEET, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.SEND_TO_WORKSHEET));
            this._iProps.put(ImportKeys.FILE_COLUMNS, importXMLUtil.getPropertyValueObject(ImportKeys.FILE_COLUMNS));
            this._iProps.put(ImportKeys.SELECTED_COLUMNS, importXMLUtil.getPropertyValueObject(ImportKeys.SELECTED_COLUMNS));
            this._iProps.put(ImportKeys.SELECTABLE_COLUMNS, importXMLUtil.getPropertyValueObject(ImportKeys.SELECTABLE_COLUMNS));
            this._iProps.put(ImportKeys.MATCH_BY_TYPE, (Object)importXMLUtil.getPropertyValueInt(ImportKeys.MATCH_BY_TYPE));
            int n = importXMLUtil.getPropertyValueInt(ImportKeys.LOAD_METHOD);
            this._iProps.put(ImportKeys.LOAD_METHOD, (Object)n);
            if (this._isCart && n == -1) {
                this._iProps.put(ImportKeys.LOAD_METHOD, (Object)5);
            }
            if (this._isCart || bl3) {
                this._iProps.put(ImportKeys.CONVERSION_ERRORS, (Object)importXMLUtil.getPropertyValueInt(ImportKeys.CONVERSION_ERRORS));
                this._iProps.put(ImportKeys.DATE_MASK_DATE, (Object)importXMLUtil.getPropertyValue(ImportKeys.DATE_MASK_DATE));
                this._iProps.put(ImportKeys.DATE_MASK_TIMESTAMP, (Object)importXMLUtil.getPropertyValue(ImportKeys.DATE_MASK_TIMESTAMP));
                this._iProps.put(ImportKeys.DATE_MASK_TIMESTAMPTZ, (Object)importXMLUtil.getPropertyValue(ImportKeys.DATE_MASK_TIMESTAMPTZ));
                this._iProps.put(ImportKeys.DATE_MASK_TIMESTAMPLTZ, (Object)importXMLUtil.getPropertyValue(ImportKeys.DATE_MASK_TIMESTAMPLTZ));
                this._iProps.put(ImportKeys.IS_BLANK_COLS, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.IS_BLANK_COLS));
                this._iProps.put(ImportKeys.IS_TRUNCATE_COLS, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.IS_TRUNCATE_COLS));
                this._iProps.put(ImportKeys.MISSING_FIELDS, (Object)importXMLUtil.getPropertyValueInt(ImportKeys.MISSING_FIELDS));
                this._iProps.put(ImportKeys.NULL_ROWS, (Object)importXMLUtil.getPropertyValueInt(ImportKeys.NULL_ROWS));
                this._iProps.put(ImportKeys.USE_REJECT_LIMIT, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.USE_REJECT_LIMIT));
                this._iProps.put(ImportKeys.REJECT_LIMIT, (Object)importXMLUtil.getPropertyValueInt(ImportKeys.REJECT_LIMIT));
                this._iProps.put(ImportKeys.TRIM, (Object)importXMLUtil.getPropertyValueInt(ImportKeys.TRIM));
                this._iProps.put(ImportKeys.IS_COPY_LOG, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.IS_COPY_LOG));
                this._iProps.put(ImportKeys.IS_COPY_BAD, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.IS_COPY_BAD));
                this._iProps.put(ImportKeys.IS_DROP_BAD_AND_LOG, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.IS_DROP_BAD_AND_LOG));
                this._iProps.put(ImportKeys.USE_VALIDATE, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.USE_VALIDATE));
                this._iProps.put(ImportKeys.USE_VALIDATE_LIMIT, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.USE_VALIDATE_LIMIT));
                this._iProps.put(ImportKeys.VALIDATE_LIMIT, (Object)importXMLUtil.getPropertyValueInt(ImportKeys.VALIDATE_LIMIT));
            } else if (n == 2 || n == 3) {
                this._iProps.put(ImportKeys.DIRPATH, (Object)importXMLUtil.getPropertyValue(ImportKeys.DIRPATH));
                this._iProps.put(ImportKeys.ORADIRNAME, (Object)importXMLUtil.getPropertyValue(ImportKeys.ORADIRNAME));
                this._iProps.put(ImportKeys.USEBADFILE, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.USEBADFILE));
                this._iProps.put(ImportKeys.ORABADDIRNAME, (Object)importXMLUtil.getPropertyValue(ImportKeys.ORABADDIRNAME));
                this._iProps.put(ImportKeys.USELOGFILE, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.USELOGFILE));
                this._iProps.put(ImportKeys.ORALOGDIRNAME, (Object)importXMLUtil.getPropertyValue(ImportKeys.ORALOGDIRNAME));
                this._iProps.put(ImportKeys.USEDISCARDFILE, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.USEDISCARDFILE));
                this._iProps.put(ImportKeys.ORADISCARDDIRNAME, (Object)importXMLUtil.getPropertyValue(ImportKeys.ORADISCARDDIRNAME));
            } else if (n == 4) {
                this._iProps.put(ImportKeys.BADDIRNAME, (Object)importXMLUtil.getPropertyValue(ImportKeys.BADDIRNAME));
                this._iProps.put(ImportKeys.LOGDIRNAME, (Object)importXMLUtil.getPropertyValue(ImportKeys.LOGDIRNAME));
                this._iProps.put(ImportKeys.USEGENDIR, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.USEGENDIR));
                this._iProps.put(ImportKeys.GENDIR, (Object)importXMLUtil.getPropertyValue(ImportKeys.GENDIR));
                this._iProps.put(ImportKeys.FILEOUTNEWLINE, (Object)importXMLUtil.getPropertyValue(ImportKeys.FILEOUTNEWLINE));
            }
            this._iProps.put(ImportKeys.CHARNUMCHARACTERS, (Object)importXMLUtil.getPropertyValue(ImportKeys.CHARNUMCHARACTERS));
            this._iProps.put(ImportKeys.CHARSETVAL, (Object)importXMLUtil.getPropertyValue(ImportKeys.CHARSETVAL));
            this._iProps.put(ImportKeys.IS_GENERATE_CHARSET, (Object)importXMLUtil.getPropertyValueBoolean(ImportKeys.IS_GENERATE_CHARSET));
        }
        catch (Exception exception) {
            Logger.warn(((Object)((Object)this)).getClass(), (Throwable)exception);
        }
        this._isConfigUsed = true;
    }

    private JEWTDialog getDialog(Component component, String string) {
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)component, null, (String)string, (int)5);
        jEWTDialog.setResizable(true);
        jEWTDialog.setOKButtonEnabled(true);
        return jEWTDialog;
    }

    private ExitCode getExitCodeHighest(ExitCode exitCode, ExitCode exitCode2) {
        return exitCode2.getSeverity() > exitCode.getSeverity() ? exitCode2 : exitCode;
    }

    public void openConfigOptions() {
        URL uRL = this._configChooser.getSelectedURL();
    }

    private void resetUI() {
        this.removeAll();
        this._loadFile = new LoadFile("");
        this.initUI();
        this.repaint();
        this.getParent().validate();
    }

    private void openOSS() {
        Object object;
        URL uRL = this._ossCmp.getSelectedURL();
        String string = uRL.toString().trim();
        try {
            object = new URL(HTTPS_PREFIX);
            this._ossCmp.setSelectedURL((URL)object);
            this._ossCmp.setSelectedURL(uRL);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._iProps.put(ImportKeys.OSS_PATH, (Object)string);
        object = (String)this._ossCredCmp.getSelectedItem();
        this._iProps.put(ImportKeys.OSS_CREDENTIAL, object);
        if (this._ossCredConnName != null) {
            this._iProps.put(ImportKeys.CONNECTION_NAME, (Object)this._ossCredConnName);
        }
        File file = null;
        if (this._iProps.getValueBoolean(ImportKeys.IS_DWCS).booleanValue() || this._iProps.getValueBoolean(ImportKeys.IS_CART).booleanValue()) {
            try {
                String string2 = string;
                byte[] byArray = CloudStorageUtils.getSampleBytes((ImportProperties)this._iProps, (String)string2, (String)object);
                if (byArray != null) {
                    String string3 = DataReaderUtils.getTempName((String)"oss");
                    String string4 = CloudStorageUtils.getOssTempExtension((String)string2);
                    file = File.createTempFile(string3, "." + string4);
                    file.deleteOnExit();
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(byArray);
                    this._loadFile = new LoadFile(file.getPath());
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    if (this._datareader != null) {
                        this._datareader.closeFile();
                    }
                    this._dataFormat = this.getDefaultFormat(BaseDataFormat.IMPORT_WIZARD);
                    this._dataFormat.setUsePreviewLimit(false);
                    this._dataFormat.setFormat(string4);
                    this._dataFormat.setRecordTerminator(DataToolsResources.getString((String)"STANDARD"));
                    this._formatOptions = new ImportFormatOptionsPanel((BaseDataFormat)this._dataFormat);
                    this.newFileInit(this._loadFile.getType());
                    this.updatePreviewLimit();
                    this._iProps.put(ImportKeys.SELECTED_COLUMNS, null);
                    this._iProps.put(ImportKeys.SELECTABLE_COLUMNS, null);
                    SwingUtilities.invokeLater(() -> this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false)));
                } else {
                    this.resetUI();
                }
            }
            catch (Exception exception) {
                Logger.warn(((Object)((Object)this)).getClass(), (Throwable)exception);
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)ImportResources.format((String)"OPEN_FILE_ERROR", (Object[])new Object[]{string, exception.getMessage()}), (String)ImportResources.getString((String)"OPEN_FILE_ERROR_TITLE"), (String)"IMPORT_OPEN_FILE_ERROR");
                try {
                    if (file != null && file.exists()) {
                        file.delete();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this._ossCredCmp.setSelectedItem(object);
                SwingUtilities.invokeLater(() -> this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false)));
            }
            this._ossCredCmp.setSelectedItem(object);
        }
    }

    protected void resetConnection() {
        if (this._ossCredCmp != null) {
            DataUIUtils.setCredentialModel(this._ossCredCmp, this.getCredConnection());
        }
    }

    private void updatePreviewLimit() {
        if (this._formatOptions != null) {
            JCheckBox jCheckBox = this._formatOptions.getUsePreviewLimitComponent();
            if (jCheckBox != null) {
                jCheckBox.setVisible(this._sourceTypeCmp.getSelectedIndex() == 0);
                this._formatOptions.getPreviewLimitComponent().setVisible(this._sourceTypeCmp.getSelectedIndex() == 0);
                if (this._sourceTypeCmp.getSelectedIndex() != 0) {
                    this._dataFormat.setUsePreviewLimit(false);
                } else {
                    this._dataFormat.setUsePreviewLimit(jCheckBox.isSelected());
                }
            }
            this._dataFormat.setIsFileFragment(this._sourceTypeCmp.getSelectedIndex() != 0);
        }
    }

    private void createSourceTypeListener() {
        if (this._sourceTypeListener == null) {
            this._sourceTypeListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ((JComboBox)actionEvent.getSource()).getSelectedIndex();
                    if (n == 0) {
                        DataPreviewPage.this._dataChooser.setSelectedURL(null);
                        DataPreviewPage.this._dataChooser.setPathContext("IMPORTDIR");
                        DataPreviewPage.this._dataChooser.setSelectedURL(null);
                    } else {
                        DataPreviewPage.this._ossCmp.setSelectedURL(null);
                        DataPreviewPage.this._ossCmp.setPathContext("IMPORTOSS");
                    }
                    DataPreviewPage.this.resetUI();
                    SwingUtilities.invokeLater(() -> DataPreviewPage.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)));
                    DataPreviewPage.this.removeSourceTypeListener();
                    DataPreviewPage.this._sourceTypeCmp.setSelectedIndex(n);
                    DataPreviewPage.this.updateSourceComponents();
                    DataPreviewPage.this.addSourceTypeListener();
                }
            };
        }
    }

    private void addSourceTypeListener() {
        this._sourceTypeCmp.addActionListener(this._sourceTypeListener);
    }

    private void removeSourceTypeListener() {
        this._sourceTypeCmp.removeActionListener(this._sourceTypeListener);
    }

    private void updateSourceComponents() {
        boolean bl = this._sourceTypeCmp.getSelectedIndex() == 0;
        this.setLocalComponentsVisible(bl);
        this.setOSSComponentsVisible(!bl);
        this.updatePreviewLimit();
        if (this._formatOptions != null) {
            JCheckBox jCheckBox = this._formatOptions.getUsePreviewLimitComponent();
            if (jCheckBox != null) {
                jCheckBox.setVisible(bl);
                this._formatOptions.getPreviewLimitComponent().setVisible(bl);
                if (this._sourceTypeCmp.getSelectedIndex() != 0) {
                    this._dataFormat.setUsePreviewLimit(false);
                } else {
                    this._dataFormat.setUsePreviewLimit(jCheckBox.isSelected());
                }
            }
            this._dataFormat.setIsFileFragment(!bl);
        }
    }

    boolean isValid(String string) {
        if (string.length() == 1 && (string.equals("X") || string.equals("x")) || string.length() > 1 && (string.substring(0, 2).equals("X'") || string.substring(0, 2).equals("x'"))) {
            return string.length() > 3 && string.endsWith("'");
        }
        return string.length() != 0;
    }

    public void checkCommit(ApplyEvent applyEvent) throws TraversalException {
    }

    public void commit(ApplyEvent applyEvent) throws TraversalException {
        if (this._datareader != null && !DataFormatHelper.isExcel(this._dataFormat.getFormat()) && !DataFormatHelper.isExcelX(this._dataFormat.getFormat())) {
            this._datareader.closeFile();
        }
    }

    public void rollback(ApplyEvent applyEvent) {
    }

    public void cancel(ApplyEvent applyEvent) {
        if (this._datareader != null) {
            this._datareader.closeFile();
        }
    }

    private class Connector
    implements ItemListener {
        private OracleConnectionComboBox m_selector;

        Connector(OracleConnectionComboBox oracleConnectionComboBox) {
            this.m_selector = oracleConnectionComboBox;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            block6: {
                if (this.m_selector.getJComboBox().getSelectedIndex() != -1) {
                    boolean bl = true;
                    String string = DataPreviewPage.this.getCredConnection();
                    try {
                        Connections.getInstance().getConnection(string);
                        if (string.equals(DataPreviewPage.this._ossCredConnName)) {
                            bl = false;
                        } else {
                            DataPreviewPage.this._ossCredConnName = string;
                        }
                        if (!bl) break block6;
                        DataPreviewPage.this.resetConnection();
                    }
                    catch (Exception exception) {
                        Throwable throwable;
                        Exception exception2;
                        while (exception2 instanceof DBException && (throwable = exception2.getCause()) instanceof Exception) {
                            exception2 = (Exception)throwable;
                        }
                    }
                }
            }
        }
    }
}

