/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.core;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.importer.core.DataType;
import oracle.dbtools.raptor.data.validators.DateValidator;

public class ColumnDefinitionDetective {
    private static Pattern _uriPattern = Pattern.compile("^[a-z0-9-\\.\\+]{2,10}:$");
    private Locale _locale;
    private NumberFormat _fmt;
    private DateValidator _dateValidator = new DateValidator();
    public static final String[] DATE_MASKS = new String[]{"DD-MON-RR", "RRRR-MM-DD", "RR-MM-DD", "RRRR-MON-DD", "RR-MON-DD", "YYYY-MM-DD", "YY-MM-DD", "YYYY-MON-DD", "YY-MON-DD", "YYYY-MM-DD:HH24:MI:SS", "YYYY-MM-DD HH24:MI:SS", "MM/DD/RRRR", "MM/DD/YY", "MM/DD/YYYY", "MONTH DD, YYYY", "DD/MM/YYYY", "Day, Month, RRRR"};
    public static final String[] TIMESTAMP_MASKS = new String[]{"YYYY-MM-DD HH24:MI:SS.FF", "YYYY-MM-DD:HH24:MI:SS.FF", "YYYY-MM-DD HH24:MI:SS", "YYYY-MM-DD:HH24:MI:SS"};
    public static final String[] TIMESTAMPTZ_MASKS = new String[]{"YYYY-MM-DD HH24:MI:SS.FF TZH:TZM", "YYYY-MM-DD HH24:MI:SS.FF TZR"};
    String[] _dateMasks = DATE_MASKS;
    String[] _timestampMasks = TIMESTAMP_MASKS;
    String[] _timestamptzMasks = TIMESTAMPTZ_MASKS;
    String _temporalType;
    int _formatIndex;
    String _format;

    public ColumnDefinitionDetective() {
        this(null, null);
    }

    public ColumnDefinitionDetective(Locale locale, Character c) {
        this._locale = locale;
        if (this._locale != null) {
            this._fmt = (DecimalFormat)DecimalFormat.getInstance(this._locale);
            this._dateValidator.setLocale(this._locale);
        } else {
            this._fmt = (DecimalFormat)DecimalFormat.getInstance();
        }
        if (c != null && this._fmt instanceof DecimalFormat) {
            DecimalFormatSymbols decimalFormatSymbols = ((DecimalFormat)this._fmt).getDecimalFormatSymbols();
            decimalFormatSymbols.setDecimalSeparator(c.charValue());
            ((DecimalFormat)this._fmt).setDecimalFormatSymbols(decimalFormatSymbols);
        }
    }

    public void setMasks(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        this._dateMasks = stringArray;
        this._timestampMasks = stringArray2;
        this._timestamptzMasks = stringArray3;
    }

    public void detect(List<Object[]> list, LoadField loadField, boolean bl) {
        boolean bl2 = true;
        boolean bl3 = true;
        Column column = loadField.getColumn();
        int n = loadField.getColumn().getSourceColID();
        Column column2 = new Column();
        column2.setSourceColID(column.getSourceColID());
        int n2 = column.getPrecision();
        int n3 = 0;
        boolean bl4 = column.getPrecision() != 0;
        boolean bl5 = bl;
        this.temporalInit();
        Iterator<Object[]> iterator = list.iterator();
        column.setPrecision(0);
        while (iterator.hasNext() && (bl2 || bl3 || !bl4)) {
            column2.setPrecision(0);
            column2.setScale(0);
            column2.setFormat("");
            if (bl5) {
                iterator.next();
                bl5 = false;
            } else {
                Object[] objectArray = iterator.next();
                String string = null;
                if (n < objectArray.length && objectArray[n] != null) {
                    string = objectArray[n].toString();
                }
                if (string != null && string.length() > 0) {
                    if (bl2 && this.isNumber(string, column2, true)) {
                        if (column2.getPrecision() - column2.getScale() > column.getPrecision() - column.getScale() && n3 < column2.getPrecision() - column2.getScale()) {
                            n3 = column2.getPrecision() - column2.getScale();
                        }
                        if (column.getScale() < column2.getScale()) {
                            column.setScale(column2.getScale());
                        }
                    } else {
                        bl2 = false;
                        if (column.getPrecision() < string.length()) {
                            column.setPrecision(string.length());
                        }
                    }
                    if (bl2 || !bl3 || !this.isTemporal(string, column2, list, bl)) {
                        bl3 = false;
                    }
                }
            }
            if (bl2 || bl3 || !bl4) continue;
            column.setPrecision(n2);
        }
        if (bl2) {
            column.setPrecision(n3 + column.getScale());
            if (column.getPrecision() == 0 && column.getScale() == 0) {
                bl2 = false;
            }
        }
        if (bl2) {
            column.setType(DataType.NUMBER.toString());
        } else if (bl3 && column2.getType() != null) {
            column.setType(column2.getType());
            column.setFormat(column2.getFormat());
        } else {
            column.setType(DataType.VARCHAR2.toString());
            column.setScale(0);
            if (bl4) {
                column.setPrecision(n2);
            }
        }
        loadField.setDetectedType(column.getType());
        loadField.setDetectedPrecision(column.getPrecision());
        loadField.setDetectedScale(column.getScale());
    }

    public void detectFormat(List<Object[]> list, Column column, boolean bl) {
        String[] stringArray;
        boolean bl2 = bl;
        String string = column.getFormat();
        this.temporalInit();
        int n = column.getSourceColID();
        Iterator<Object[]> iterator = list.iterator();
        if (column.getType().equals(DataType.DATE.toString())) {
            stringArray = this._dateMasks;
        } else if (column.getType().equals(DataType.TIMESTAMP.toString())) {
            stringArray = this._timestampMasks;
        } else if (column.getType().equals(DataType.TIMESTAMPTZ.toString())) {
            stringArray = this._timestamptzMasks;
        } else if (column.getType().equals(DataType.TIMESTAMPLTZ.toString())) {
            stringArray = this._timestampMasks;
        } else {
            return;
        }
        int n2 = 0;
        while (iterator.hasNext()) {
            if (n2 == -1) {
                return;
            }
            if (bl2) {
                iterator.next();
                bl2 = false;
                continue;
            }
            Object[] objectArray = iterator.next();
            if (n >= objectArray.length || objectArray[n] == null) continue;
            String string2 = objectArray[n].toString();
            while (n2 != -1) {
                if ((n2 = this.findValidFormat(string2, column, stringArray, n2)) == -1) continue;
                column.setFormat(stringArray[n2]);
                if (this.isFormatValid(list, column, bl)) {
                    return;
                }
                if (++n2 < stringArray.length) continue;
                n2 = -1;
                column.setFormat(string);
            }
        }
        column.setFormat(string);
    }

    public boolean isNumber(String string, Column column, boolean bl) {
        Object object = "";
        try {
            ParsePosition parsePosition = new ParsePosition(0);
            Number number = this._fmt.parse(string.toString(), parsePosition);
            if (number == null) {
                return false;
            }
            object = "" + number.doubleValue();
            if (parsePosition.getIndex() < string.length()) {
                return false;
            }
            if (((String)object).endsWith(".0")) {
                object = ((String)object).substring(0, ((String)object).length() - 2);
            }
            BigDecimal bigDecimal = new BigDecimal((String)object);
            if (bl && bigDecimal.scale() == 0 && bigDecimal.precision() > 1 && string.startsWith("0")) {
                return false;
            }
            column.setType(DataType.NUMBER.toString());
            column.setPrecision(bigDecimal.precision());
            column.setScale(bigDecimal.scale());
        }
        catch (Exception exception) {
            return false;
        }
        return ((String)object).length() != 0;
    }

    public void temporalInit() {
        this._formatIndex = 0;
        this._temporalType = null;
        this._format = null;
    }

    public boolean isTemporal(String string, Column column, List<Object[]> list, boolean bl) {
        try {
            Matcher matcher = _uriPattern.matcher(string);
            if (matcher.find()) {
                return false;
            }
            boolean bl2 = false;
            if (this._temporalType == null) {
                if (string.contains(":")) {
                    bl2 = true;
                }
                if (string.contains("-") || string.contains("/") || string.contains(",") || bl2) {
                    while (this._formatIndex != -1) {
                        this._temporalType = DataType.DATE.toString();
                        column.setType(this._temporalType);
                        this._formatIndex = this.findValidFormat(string, column, DATE_MASKS, this._formatIndex);
                        if (this._formatIndex == -1) continue;
                        column.setType(this._temporalType);
                        this._format = DATE_MASKS[this._formatIndex];
                        column.setFormat(this._format);
                        if (this.isFormatValid(list, column, bl)) {
                            return true;
                        }
                        ++this._formatIndex;
                        if (this._formatIndex < DATE_MASKS.length) continue;
                        this._formatIndex = -1;
                    }
                }
                if (bl2) {
                    while (this._formatIndex != -1) {
                        this._temporalType = DataType.TIMESTAMP.toString();
                        column.setType(this._temporalType);
                        this._formatIndex = this.findValidFormat(string, column, TIMESTAMP_MASKS, this._formatIndex);
                        if (this._formatIndex == -1) continue;
                        column.setType(this._temporalType);
                        this._format = TIMESTAMP_MASKS[this._formatIndex];
                        column.setFormat(this._format);
                        if (this.isFormatValid(list, column, bl)) {
                            return true;
                        }
                        ++this._formatIndex;
                        if (this._formatIndex < TIMESTAMP_MASKS.length) continue;
                        this._formatIndex = -1;
                    }
                }
                return false;
            }
            column.setType(this._temporalType);
            column.setFormat(this._format);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isFormatValid(List<Object[]> list, Column column, boolean bl) {
        boolean bl2 = true;
        Iterator<Object[]> iterator = list.iterator();
        int n = column.getSourceColID();
        int n2 = -1;
        while (iterator.hasNext()) {
            String string;
            if (bl) {
                iterator.next();
                bl = false;
                continue;
            }
            Object[] objectArray = iterator.next();
            if (n >= objectArray.length || objectArray[n] == null || this._dateValidator.validateData(column, string = objectArray[n].toString())) continue;
            bl2 = false;
        }
        return bl2;
    }

    public int findValidFormat(String string, Column column, String[] stringArray) {
        int n = 0;
        for (String string2 : stringArray) {
            column.setFormat(string2);
            if (this._dateValidator.validateData(column, string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int findValidFormat(String string, Column column, String[] stringArray, int n) {
        while (n < stringArray.length) {
            column.setFormat(stringArray[n]);
            if (this._dateValidator.validateData(column, string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static int getRoundedPrecision(int n, String string) {
        if (string.equals(DataType.VARCHAR2.toString()) || string.equals(DataType.NVARCHAR2.toString())) {
            if (ColumnDefinitionDetective.isBetween(n, 0, 25)) {
                return 26;
            }
            if (ColumnDefinitionDetective.isBetween(n, 17, 100)) {
                return 128;
            }
            if (ColumnDefinitionDetective.isBetween(n, 101, 200)) {
                return 256;
            }
            if (ColumnDefinitionDetective.isBetween(n, 201, 1000)) {
                return 1024;
            }
            if (ColumnDefinitionDetective.isBetween(n, 1001, 1500)) {
                return 2048;
            }
            return 4000;
        }
        if (string.equals(DataType.CHAR.toString()) || string.equals(DataType.NCHAR.toString())) {
            if (ColumnDefinitionDetective.isBetween(n, 0, 25)) {
                return 26;
            }
            if (ColumnDefinitionDetective.isBetween(n, 17, 100)) {
                return 128;
            }
            if (ColumnDefinitionDetective.isBetween(n, 101, 200)) {
                return 256;
            }
            if (ColumnDefinitionDetective.isBetween(n, 201, 1000)) {
                return 1024;
            }
            return 2000;
        }
        if (string.equals(DataType.NUMBER.toString())) {
            return n < 36 ? n + 2 : 38;
        }
        if (string.equals(DataType.FLOAT.toString())) {
            return n < 124 ? n + 2 : 126;
        }
        return n;
    }

    public static boolean isBetween(int n, int n2, int n3) {
        return n2 <= n && n <= n3;
    }

    public static int getDefaultPrecision(int n, String string) {
        if (n == 0) {
            if (string.equals(DataType.VARCHAR2.toString()) || string.equals(DataType.NVARCHAR2.toString())) {
                return 4000;
            }
            if (string.equals(DataType.CHAR.toString()) || string.equals(DataType.NCHAR.toString())) {
                return 2000;
            }
        }
        if (string.equals(DataType.NUMBER.toString())) {
            return 38;
        }
        if (string.equals(DataType.FLOAT.toString())) {
            return 126;
        }
        return n;
    }

    public static int getMaxPrecision(int n, String string) {
        if (string.equals(DataType.VARCHAR2.toString()) || string.equals(DataType.NCHAR.toString()) || string.equals(DataType.NVARCHAR2.toString())) {
            return 4000;
        }
        if (string.equals(DataType.NUMBER.toString())) {
            return 38;
        }
        if (string.equals(DataType.FLOAT.toString())) {
            return 126;
        }
        if (string.equals(DataType.CHAR.toString())) {
            return 2000;
        }
        return n;
    }
}

