/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.query;

import com.adbs.utils.Helpers;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Localizer {
    private static List<String> LOADED_LOCALES = new ArrayList<String>();
    private static final String RELATIVE_DIR = "lang/QueryBuilder_";
    private static final String EXT = ".xml";
    private static final String DFLT = "lang/QueryBuilder.xml";

    static void init(Locale locale) {
        String string = locale.toString();
        if (!LOADED_LOCALES.contains(string)) {
            Localizer.loadLanguageFromResources(string);
            LOADED_LOCALES.add(string);
        }
    }

    private static void loadDefaults() {
        try {
            Class<Localizer> clazz = Localizer.class;
            InputStream inputStream = clazz.getResourceAsStream(DFLT);
            if (inputStream != null) {
                Helpers.localizer.loadLanguageFromStream(inputStream);
                Helpers.localizer.setLanguage("Default");
            }
        }
        catch (Exception exception) {
            Logger.getLogger(Localizer.class.getName()).log(Level.SEVERE, null, exception);
        }
    }

    private static void loadLanguageFromResources(String string) {
        InputStream inputStream = null;
        String string2 = string;
        try {
            Class<Localizer> clazz = Localizer.class;
            inputStream = clazz.getResourceAsStream(RELATIVE_DIR + string2 + EXT);
            if (null == inputStream && string.length() > 2) {
                string2 = string.substring(0, 2);
                inputStream = clazz.getResourceAsStream(RELATIVE_DIR + string2 + EXT);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(Localizer.class.getName()).log(Level.SEVERE, null, exception);
        }
        if (inputStream != null) {
            Helpers.localizer.loadLanguageFromStream(inputStream);
            Helpers.localizer.setLanguage(string2);
        }
    }

    static {
        Localizer.loadDefaults();
    }
}

