/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.listtable;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.javatools.icons.OracleIcons;

public abstract class ListTableModel<T>
extends AbstractTableModel {
    private String[] _columnNames = new String[0];
    private String[] _columnTips = new String[0];
    protected List<T> _rowList;
    private boolean _editable;
    private JTable _table;

    public ListTableModel(String[] stringArray, String[] stringArray2) {
        if (null == stringArray) {
            throw new NullPointerException("Programmer Error: columnNames must not be null");
        }
        this._columnNames = stringArray;
        if (null != stringArray2) {
            if (stringArray2.length != stringArray.length) {
                throw new IllegalArgumentException("Programmer Error: columnTips/columnNames length must macth");
            }
            this._columnTips = stringArray2;
        }
    }

    public void setRowList(List<T> list) {
        this._rowList = new ArrayList<T>(list);
        this.fireTableDataChanged();
    }

    public List<T> getRowList() {
        return this._rowList;
    }

    protected abstract Object getValueAt(T var1, int var2);

    protected abstract void setValueAt(Object var1, T var2, int var3);

    protected abstract boolean isCellEditable(T var1, int var2);

    @Override
    public int getColumnCount() {
        return this._columnNames.length;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return null == this._rowList ? super.getColumnClass(n) : this.getValueAt(0, n).getClass();
    }

    @Override
    public String getColumnName(int n) {
        return this._columnNames[n];
    }

    @Override
    public int getRowCount() {
        return null == this._rowList ? 0 : this._rowList.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.getValueAt(this._rowList.get(n), n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.setValueAt(object, this._rowList.get(n), n2);
        this.fireTableCellUpdated(n, n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.isEditable() ? this.isCellEditable(this._rowList.get(n), n2) : false;
    }

    public int getSelectedRow() {
        return this._table.getSelectedRow();
    }

    public int getSelectedRowCount() {
        return this._table.getSelectedRowCount();
    }

    public void setEditable(boolean bl) {
        if (this._editable != bl) {
            this._editable = bl;
            this._table.setRowSelectionAllowed(bl);
        }
    }

    public boolean isEditable() {
        return this._editable;
    }

    protected List<T> add() {
        return new ArrayList();
    }

    protected List<T> addAll() {
        return new ArrayList();
    }

    public void setTable(JTable jTable) {
        this._table = jTable;
        this._table.getTableHeader().setReorderingAllowed(false);
        this._table.setSelectionMode(1);
        this._table.setRowSelectionAllowed(this.isEditable());
        this._table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.setUpColumnToolTips(this._table);
    }

    public JTable getTable() {
        return this._table;
    }

    public void setUpColumnToolTips(JTable jTable) {
        if (0 < this._columnTips.length) {
            JTableHeader jTableHeader = jTable.getTableHeader();
            ColumnHeaderToolTips columnHeaderToolTips = new ColumnHeaderToolTips();
            for (int i = 0; i < jTable.getColumnCount(); ++i) {
                TableColumn tableColumn = jTable.getColumnModel().getColumn(i);
                columnHeaderToolTips.setToolTip(tableColumn, this._columnTips[i]);
            }
            jTableHeader.addMouseMotionListener(columnHeaderToolTips);
        }
    }

    protected IndexRange getRowSelection() {
        return new IndexRange(this._table.getSelectedRow(), this._table.getSelectedRowCount());
    }

    public AbstractAction getMoveSelectedFirstAction() {
        return this.getMoveSelectedFirstAction(null);
    }

    public AbstractAction getMoveSelectedFirstAction(Icon icon) {
        AbstractAction abstractAction = new AbstractAction("", icon == null ? OracleIcons.getIcon((String)"first.png") : icon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListTableModel.this.moveSelectedFirst();
            }

            @Override
            public boolean isEnabled() {
                return ListTableModel.this.isMovePrevFirstEnabled();
            }
        };
        return abstractAction;
    }

    private boolean isMovePrevFirstEnabled() {
        return this.isEditable() && 0 < this.getRowSelection().min();
    }

    private void moveSelectedFirst() {
        if (this.isMovePrevFirstEnabled()) {
            IndexRange indexRange = this.getRowSelection();
            for (int i = indexRange.size(); i > 0; --i) {
                this._rowList.add(0, this._rowList.remove(indexRange.max()));
            }
            this.fireTableDataChanged();
            this._table.setRowSelectionInterval(0, indexRange.size() - 1);
        }
    }

    public AbstractAction getMoveSelectedPreviousAction() {
        return this.getMoveSelectedPreviousAction(null);
    }

    public AbstractAction getMoveSelectedPreviousAction(Icon icon) {
        AbstractAction abstractAction = new AbstractAction("", icon == null ? OracleIcons.getIcon((String)"previous.png") : icon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListTableModel.this.moveSelectedPrevious();
            }

            @Override
            public boolean isEnabled() {
                return ListTableModel.this.isMovePrevFirstEnabled();
            }
        };
        return abstractAction;
    }

    private void moveSelectedPrevious() {
        if (this.isMovePrevFirstEnabled()) {
            IndexRange indexRange = this.getRowSelection();
            this._rowList.add(indexRange.max(), this._rowList.remove(indexRange.min() - 1));
            this.fireTableDataChanged();
            this._table.setRowSelectionInterval(indexRange.min() - 1, indexRange.max() - 1);
        }
    }

    public AbstractAction getMoveSelectedNextAction() {
        return this.getMoveSelectedNextAction(null);
    }

    public AbstractAction getMoveSelectedNextAction(Icon icon) {
        AbstractAction abstractAction = new AbstractAction("", icon == null ? OracleIcons.getIcon((String)"next.png") : icon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListTableModel.this.moveSelectedNext();
            }

            @Override
            public boolean isEnabled() {
                return ListTableModel.this.isMoveNextLastEnabled();
            }
        };
        return abstractAction;
    }

    private boolean isMoveNextLastEnabled() {
        IndexRange indexRange = this.getRowSelection();
        return this.isEditable() && 0 < indexRange.size() && indexRange.max() < this._rowList.size() - 1;
    }

    private void moveSelectedNext() {
        if (this.isMoveNextLastEnabled()) {
            IndexRange indexRange = this.getRowSelection();
            this._rowList.add(indexRange.min(), this._rowList.remove(indexRange.max() + 1));
            this.fireTableDataChanged();
            this._table.setRowSelectionInterval(indexRange.min() + 1, indexRange.max() + 1);
        }
    }

    public AbstractAction getMoveSelectedLastAction() {
        return this.getMoveSelectedLastAction(null);
    }

    public AbstractAction getMoveSelectedLastAction(Icon icon) {
        AbstractAction abstractAction = new AbstractAction("", icon == null ? OracleIcons.getIcon((String)"last.png") : icon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListTableModel.this.moveSelectedLast();
            }

            @Override
            public boolean isEnabled() {
                return ListTableModel.this.isMoveNextLastEnabled();
            }
        };
        return abstractAction;
    }

    private void moveSelectedLast() {
        if (this.isMoveNextLastEnabled()) {
            int n;
            IndexRange indexRange = this.getRowSelection();
            for (n = indexRange.size(); n > 0; --n) {
                this._rowList.add(this._rowList.remove(indexRange.min()));
            }
            this.fireTableDataChanged();
            n = this._rowList.size() - 1;
            int n2 = n - (indexRange.size() - 1);
            this._table.setRowSelectionInterval(n2, n);
        }
    }

    public AbstractAction getRemoveSelectedAction() {
        return this.getRemoveSelectedAction(null);
    }

    public AbstractAction getRemoveSelectedAction(Icon icon) {
        AbstractAction abstractAction = new AbstractAction("", icon == null ? OracleIcons.getIcon((String)"delete.png") : icon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListTableModel.this.removeSelected();
            }

            @Override
            public boolean isEnabled() {
                return ListTableModel.this.isEditable() && 0 < ListTableModel.this.getRowSelection().size();
            }
        };
        return abstractAction;
    }

    protected void removeSelected() {
        IndexRange indexRange = this.getRowSelection();
        if (0 < indexRange.size()) {
            for (int i = indexRange.size(); i > 0; --i) {
                this._rowList.remove(indexRange.min());
            }
            this.fireTableDataChanged();
        }
    }

    public AbstractAction getAddAfterSelectedAction() {
        return this.getAddAfterSelectedAction(null);
    }

    public AbstractAction getAddAfterSelectedAction(Icon icon) {
        AbstractAction abstractAction = new AbstractAction("", icon == null ? OracleIcons.getIcon((String)"add.png") : icon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListTableModel.this.addAfterSelected();
            }

            @Override
            public boolean isEnabled() {
                return ListTableModel.this.isEditable();
            }
        };
        return abstractAction;
    }

    public AbstractAction getAddAllAfterSelectedAction() {
        return this.getAddAfterSelectedAction(null);
    }

    public AbstractAction getAddAllAfterSelectedAction(Icon icon) {
        AbstractAction abstractAction = new AbstractAction("", icon == null ? OracleIcons.getIcon((String)"shuttle_leftall.png") : icon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListTableModel.this.addAfterSelected(true);
            }

            @Override
            public boolean isEnabled() {
                return ListTableModel.this.isEditable();
            }
        };
        return abstractAction;
    }

    private void addAfterSelected() {
        this.addAfterSelected(false);
    }

    private void addAfterSelected(boolean bl) {
        List<T> list;
        List<T> list2 = list = bl ? this.addAll() : this.add();
        if (0 < list.size()) {
            boolean bl2 = 0 == this._rowList.size();
            IndexRange indexRange = this.getRowSelection();
            int n = this._rowList.size();
            if (0 < indexRange.size() && indexRange.max() < n) {
                n = indexRange.max() + 1;
            }
            this._rowList.addAll(n, list);
            this.fireTableDataChanged();
            if (bl2) {
                this._table.invalidate();
            }
            int n2 = indexRange.min();
            int n3 = indexRange.max();
            if (-1 != n2) {
                this._table.setRowSelectionInterval(n2, n3);
            }
        }
    }

    public AbstractAction getRemoveAllAction() {
        return this.getRemoveAllAction(null);
    }

    public AbstractAction getRemoveAllAction(Icon icon) {
        AbstractAction abstractAction = new AbstractAction("", icon == null ? OracleIcons.getIcon((String)"shuttle_leftall.png") : icon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListTableModel.this.removeAll();
            }

            @Override
            public boolean isEnabled() {
                return ListTableModel.this.isEditable();
            }
        };
        return abstractAction;
    }

    protected void removeAll() {
        this._rowList = new ArrayList<T>();
        this.fireTableDataChanged();
    }

    private class ColumnHeaderToolTips
    extends MouseMotionAdapter {
        TableColumn curCol;
        Map<TableColumn, String> tips = new HashMap<TableColumn, String>();

        private ColumnHeaderToolTips() {
        }

        public void setToolTip(TableColumn tableColumn, String string) {
            if (string == null) {
                this.tips.remove(tableColumn);
            } else {
                this.tips.put(tableColumn, string);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            JTable jTable = jTableHeader.getTable();
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            TableColumn tableColumn = null;
            if (n >= 0) {
                tableColumn = tableColumnModel.getColumn(n);
            }
            if (tableColumn != this.curCol) {
                jTableHeader.setToolTipText(this.tips.get(tableColumn));
                this.curCol = tableColumn;
            }
        }
    }

    protected class IndexRange {
        private int _min = -1;
        private int _size;

        public IndexRange(int n, int n2) {
            this._min = n;
            this._size = n2;
        }

        public int min() {
            return this._min;
        }

        public int max() {
            return 0 == this._size ? -1 : this._min + this._size - 1;
        }

        public int size() {
            return this._size;
        }
    }
}

