/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SpringLayout;
import oracle.dbtools.raptor.controls.SpringUtilities;

public class RadioGroupPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ButtonGroup group;
    private List<JRadioButton> buttons;
    private List<ActionListener> _listeners;
    private ActionListener _listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; RadioGroupPanel.this._listeners != null && i < RadioGroupPanel.this._listeners.size(); ++i) {
                RadioGroupPanel.this._listeners.get(i).actionPerformed(actionEvent);
            }
        }
    };

    public RadioGroupPanel(String[] stringArray, String[] stringArray2) {
        super(new SpringLayout());
        this.process(stringArray, stringArray2);
    }

    private void process(String[] stringArray, String[] stringArray2) {
        int n;
        this.group = new ButtonGroup();
        this.buttons = new ArrayList<JRadioButton>();
        for (n = 0; n < stringArray.length; ++n) {
            JRadioButton jRadioButton = new JRadioButton(stringArray[n]);
            jRadioButton.setActionCommand(stringArray2[n]);
            jRadioButton.addActionListener(this._listener);
            if (n == 0) {
                jRadioButton.setSelected(true);
            }
            this.group.add(jRadioButton);
            this.add(jRadioButton);
            this.buttons.add(jRadioButton);
        }
        SpringUtilities.makeCompactGrid((Container)this, (int)1, (int)n, (int)0, (int)0, (int)1, (int)1);
    }

    public void setSelectedValue(String string) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            JRadioButton jRadioButton = this.buttons.get(i);
            if (!jRadioButton.getActionCommand().equals(string)) continue;
            jRadioButton.setSelected(true);
            break;
        }
    }

    public String getSelectedValue() {
        ButtonModel buttonModel = this.group.getSelection();
        return buttonModel != null ? buttonModel.getActionCommand() : null;
    }

    public void addActionListener(ActionListener actionListener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList<ActionListener>();
        }
        this._listeners.add(actionListener);
    }
}

