/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.data.ui.ImportBadFileOraPanel;
import oracle.dbtools.raptor.data.ui.ImportDiscardFileOraPanel;
import oracle.dbtools.raptor.data.ui.ImportLogFileOraPanel;
import oracle.dbtools.raptor.data.ui.StagingTableOraPanel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class ImportModeExternalTablePreferences
extends DefaultTraversablePanel {
    private JTextField m_directoryValue;
    protected ImportLogFileOraPanel _logFilePanel;
    protected ImportBadFileOraPanel _badFilePanel;
    protected ImportDiscardFileOraPanel _discardFilePanel;
    protected StagingTableOraPanel _stagingTablePanel;
    private static final long serialVersionUID = -2739487292165944123L;

    public ImportModeExternalTablePreferences() {
        this.setHelpID("f1_dbworksheetImportparam_html");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        int n = 0;
        JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)PreferencesArb.getString("IMPORT_ORA_FILE_DIR")));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("IMPORT_ORA_FILE_DIR")));
        this.add(jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 0, 0, 8), 0, 0));
        this.add(this.getDirectoryValue(), new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 3, new Insets(8, 8, 6, 0), 0, 0));
        jLabel.setLabelFor(this.m_directoryValue);
        this._logFilePanel = new ImportLogFileOraPanel(false);
        this.add(this._logFilePanel, new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 18, 0, new Insets(6, 0, 0, 0), 0, 0));
        this.add(Box.createHorizontalBox(), new GridBagConstraints(2, n, 1, 3, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._badFilePanel = new ImportBadFileOraPanel(false);
        this.add(this._badFilePanel, new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 18, 0, new Insets(6, 0, 0, 0), 0, 0));
        this._discardFilePanel = new ImportDiscardFileOraPanel(false);
        this.add(this._discardFilePanel, new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 18, 0, new Insets(6, 0, 0, 0), 0, 0));
        this._stagingTablePanel = new StagingTableOraPanel();
        this.add(this._stagingTablePanel, new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 18, 0, new Insets(6, 0, 0, 0), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected JTextField getDirectoryValue() {
        if (this.m_directoryValue == null) {
            this.m_directoryValue = new JTextField("", 20);
            this.m_directoryValue.setText("");
        }
        return this.m_directoryValue;
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        String string = dBConfig.getString("IMPORT_ORA_DIR");
        this.m_directoryValue.setText(string);
        this._logFilePanel.onEntry(traversableContext);
        this._badFilePanel.onEntry(traversableContext);
        this._discardFilePanel.onEntry(traversableContext);
        this._stagingTablePanel.onEntry(traversableContext);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putString("IMPORT_ORA_DIR", this.m_directoryValue.getText());
        this._logFilePanel.onExit(traversableContext);
        this._badFilePanel.onExit(traversableContext);
        this._discardFilePanel.onExit(traversableContext);
        this._stagingTablePanel.onExit(traversableContext);
    }
}

