/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.verify.services.stage;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Pattern;
import oracle.dbtools.extension.project.commands.stage.utils.StageUtils;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.verify.interfaces.VerifyServiceInterface;
import org.apache.commons.io.FileUtils;

public class StageChangelogFilesValid
implements VerifyServiceInterface {
    String[] fileTypes = new String[]{"sql", "pks", "pkb", "pls"};
    boolean DEBUG = false;
    Pattern apex_yaml_pattern = Pattern.compile(".*\\/apex_apps\\/.*\\/readable");
    String codeCl;
    String stageCl;

    @Override
    public String getName() {
        return "StageChangelogFilesValid";
    }

    @Override
    public String getGroup() {
        return "Stage";
    }

    private boolean processFiles(Collection<File> files) {
        boolean error = false;
        ArrayList errorFiles = new ArrayList();
        for (File file : files) {
            if (file.isDirectory()) {
                error = this.processFiles(FileUtils.listFiles((File)file, (String[])this.fileTypes, (boolean)true));
                continue;
            }
            if (this.apex_yaml_pattern.matcher(file.getParent()).find()) {
                this.addMessage(VerifyServiceInterface.MessageLevel.HIDDEN, "SKIPPING_FILE", "file", file);
                continue;
            }
            if (this.stageCl.contains(file.getName()) || this.codeCl.contains(file.getName())) continue;
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, "File not found in any changelog", "file", file);
        }
        if (!error) {
            this.addMessage(VerifyServiceInterface.MessageLevel.INFO, "Snapshot validation found no issues.");
        }
        return error;
    }

    @Override
    public boolean doTest(HashMap<String, Object> params) {
        try {
            StageUtils tu = new StageUtils(ProjectConfig.getCurrentWorkingProjectRoot(), ProjectConfig.getCurrentContext());
            Path root = tu.getStageRoot();
            this.stageCl = tu.getStageCLog();
            this.codeCl = tu.getCodeCLog();
        }
        catch (Exception e) {
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, e.getMessage(), "exception", e);
            return false;
        }
        return true;
    }
}

