/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.stage.utils;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import oracle.dbtools.extension.project.commands.UtilMessages;
import oracle.dbtools.extension.project.commands.export.Export;
import oracle.dbtools.extension.project.commands.stage.StageMessages;
import oracle.dbtools.extension.project.commands.stage.generators.ApexInstallScriptGenerator;
import oracle.dbtools.extension.project.commands.stage.generators.DropDdlGenerator;
import oracle.dbtools.extension.project.commands.stage.objectclasses.DbDiffObject;
import oracle.dbtools.extension.project.commands.stage.transforms.StageConstants;
import oracle.dbtools.extension.project.commands.stage.utils.ChangeLogSorter;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.exceptions.ChangelogGenerationException;
import oracle.dbtools.extension.project.core.exceptions.CreateDirectoryException;
import oracle.dbtools.extension.project.core.exceptions.CreateFileException;
import oracle.dbtools.extension.project.core.exceptions.ProjectNotIdentifiedException;
import oracle.dbtools.extension.project.core.exceptions.ProjectSettingsException;
import oracle.dbtools.extension.project.core.exceptions.ReleaseProcessException;
import oracle.dbtools.extension.project.core.exceptions.StageProcessException;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.utils.ConsoleColors;
import oracle.dbtools.extension.project.core.utils.GitUtils;
import oracle.dbtools.extension.project.core.utils.ProjectFileUtils;
import oracle.dbtools.extension.project.core.utils.ProjectUtils;
import oracle.dbtools.extension.project.core.utils.XMLFormatter;
import oracle.dbtools.raptor.liquibase.util.DbmsMetaUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.Git;

public class StageUtils {
    private static final ArrayList<String> excludedSchemas = new ArrayList();
    private static final HashMap<String, List<String>> excludedObjects = new HashMap();
    private static final HashMap<String, List<String>> excludedApexs = new HashMap();
    private static final ArrayList<String> excludedOrds = new ArrayList();
    Path root;
    Path distRoot;
    Path utilRoot;
    Path installSql;
    Path preCheckSql;
    Path compileSql;
    Path relRoot;
    Path mainChangeLog;
    Path nextRoot;
    Path nextRelChangeLog;
    Path apexRoot;
    Path apexChangeLog;
    Path nextCodeRoot;
    Path nextCodeChangeLog;
    Path stageRoot;
    Path branchRoot;
    Path stageChangeLog;
    Path codeRoot;
    Path customRoot;
    Path srcRoot;
    Path dbSrcRoot;
    String mainCLog;
    String relCLog;
    String stageCLog;
    String apexClog;
    String codeCLog;
    ScriptRunnerContext _ctx;
    boolean isChangeIsolation;
    boolean isReleaseIsolation;
    Git _git;
    String _branch;

    public StageUtils(Path root, ScriptRunnerContext ctx) throws StageProcessException, ProjectNotIdentifiedException, ProjectSettingsException, CreateFileException, IOException, CreateDirectoryException, InterruptedException {
        this.root = root;
        this._git = GitUtils.findGitRepo(root.toFile());
        if (this._git == null) {
            throw new StageProcessException(StageMessages.get("GIT_NOT_FOUND"));
        }
        this._branch = this._git.getRepository().getBranch();
        this._ctx = ctx;
        String isolation = ProjectSettings.getSettingAsString("stage.softObjectIsolation");
        if (isolation != null && isolation.equals("change")) {
            this.isChangeIsolation = true;
            this.isReleaseIsolation = false;
        } else if (isolation != null && isolation.equals("release")) {
            this.isChangeIsolation = false;
            this.isReleaseIsolation = true;
        } else {
            throw new StageProcessException("Invalid softObjectIsolation value");
        }
        this.checkDirectories();
        this.createBranchDirs(this.getBranch());
        this.loadExcludes();
    }

    public static String getSha1fromString(String data) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        digest.reset();
        digest.update(data.getBytes(StandardCharsets.UTF_8));
        return String.format("%040x", new BigInteger(1, digest.digest()));
    }

    private void loadExcludes() throws ProjectSettingsException {
        excludedSchemas.clear();
        excludedObjects.clear();
        excludedApexs.clear();
        excludedOrds.clear();
        List<String> excludes = ProjectSettings.getSettingAsList("stage.excludeObjects");
        for (String exclude : excludes) {
            String schema;
            if (!exclude.contains(".")) {
                excludedSchemas.add(exclude.toUpperCase());
                continue;
            }
            String[] parts = exclude.split("\\.");
            if (parts.length == 2) {
                schema = parts[0].toUpperCase();
                @NonNull String obj = parts[1].toUpperCase();
                if (obj.equalsIgnoreCase("ORDS")) {
                    excludedOrds.add(parts[0].toUpperCase());
                    continue;
                }
                if (excludedObjects.get(schema) != null) {
                    excludedObjects.get(schema).add(obj);
                    continue;
                }
                excludedObjects.put(schema, new ArrayList());
                excludedObjects.get(schema).add(obj);
                continue;
            }
            if (parts.length == 3) {
                schema = parts[0].toUpperCase();
                @NonNull String apex = parts[1].toUpperCase();
                @NonNull String appid = parts[2].toUpperCase();
                if (apex.equalsIgnoreCase("APEX")) {
                    if (excludedApexs.get(schema) != null) {
                        excludedApexs.get(schema).add(appid);
                        continue;
                    }
                    excludedApexs.put(schema, new ArrayList());
                    excludedApexs.get(schema).add(appid);
                    continue;
                }
                throw new ProjectSettingsException(StageMessages.format("BAD_EXCLUDE_OBJECTS", exclude));
            }
            throw new ProjectSettingsException(StageMessages.format("BAD_EXCLUDE_OBJECTS", exclude));
        }
    }

    private void checkDirectories() throws CreateFileException, IOException, StageProcessException {
        LinkedList<Path> dirs = new LinkedList<Path>();
        this.srcRoot = Paths.get(this.root.toString(), "src");
        if (!this.srcRoot.toFile().exists()) {
            dirs.add(this.srcRoot);
        }
        this.dbSrcRoot = Paths.get(this.srcRoot.toString(), "database");
        this.distRoot = Paths.get(this.root.toString(), "dist");
        if (!this.distRoot.toFile().exists()) {
            dirs.add(this.distRoot);
        }
        this.relRoot = Paths.get(this.distRoot.toString(), "releases");
        if (!this.relRoot.toFile().exists()) {
            dirs.add(this.relRoot);
        }
        this.utilRoot = Paths.get(this.distRoot.toString(), "utils");
        if (!this.utilRoot.toFile().exists()) {
            dirs.add(this.utilRoot);
        }
        this.nextRoot = Paths.get(this.relRoot.toString(), "next");
        if (!this.nextRoot.toFile().exists()) {
            dirs.add(this.nextRoot);
        }
        this.stageRoot = Paths.get(this.nextRoot.toString(), "changes");
        if (!this.stageRoot.toFile().exists()) {
            dirs.add(this.stageRoot);
        }
        if (this.isReleaseIsolation) {
            this.nextCodeRoot = Paths.get(this.nextRoot.toString(), "code");
            if (!this.nextCodeRoot.toFile().exists()) {
                dirs.add(this.nextCodeRoot);
            }
        }
        this.createDirs(dirs);
        this.createChangelogFiles();
    }

    private void createBranchDirs(String branch_name) throws CreateFileException, StageProcessException, IOException {
        LinkedList<Path> dirs = new LinkedList<Path>();
        if (branch_name == null) {
            branch_name = this.getBranch();
        }
        if (branch_name != null && !branch_name.isEmpty()) {
            String branch = ProjectFileUtils.sanitizeFileName(branch_name);
            this.branchRoot = Paths.get(this.stageRoot.toString(), branch);
            if (!this.branchRoot.toFile().exists()) {
                dirs.add(this.branchRoot);
            }
            this.codeRoot = Paths.get(this.branchRoot.toString(), "code");
            if (!this.codeRoot.toFile().exists()) {
                dirs.add(this.codeRoot);
            }
            this.customRoot = Paths.get(this.codeRoot.toString(), "_custom");
            if (!this.customRoot.toFile().exists()) {
                dirs.add(this.customRoot);
            }
        } else {
            this.branchRoot = null;
            this.codeRoot = null;
            this.customRoot = null;
            throw new StageProcessException(StageMessages.get("NULL_BRANCH_NAME"));
        }
        this.createDirs(dirs);
        this.createBranchFiles();
        this.loadChangelogs();
    }

    public String getBranch() throws StageProcessException {
        if (this._branch == null || this._branch.isEmpty()) {
            throw new StageProcessException(StageMessages.get("NULL_BRANCH_NAME"));
        }
        return this._branch;
    }

    private void createDirs(LinkedList<Path> dirs) throws IOException {
        for (Path dir : dirs) {
            if (dir.toFile().exists()) continue;
            GeneralMessages.createDirMsg(this.root.relativize(dir).toString());
            FileUtils.forceMkdir((File)dir.toFile());
        }
    }

    private void createChangelogFiles() throws CreateFileException, StageProcessException {
        if (this.relRoot != null && this.relRoot.toFile().exists()) {
            this.mainChangeLog = this.createFileUsingTemplate(this.relRoot, "main.changelog.xml", "oracle/dbtools/extension/project/commands/stage/templates/main.changelog.tmpl");
        }
        if (this.nextRoot != null && this.nextRoot.toFile().exists()) {
            this.nextRelChangeLog = this.createFileUsingTemplate(this.nextRoot, "release.changelog.xml", "oracle/dbtools/extension/project/commands/stage/templates/release.changelog.tmpl");
        }
        if (this.utilRoot != null && this.utilRoot.toFile().exists()) {
            StringBuilder schemasString = new StringBuilder();
            List<String> schemas = ProjectSettings.getSettingAsList("schemas");
            HashMap<String, String> validReplacements = new HashMap<String, String>();
            if (!schemas.isEmpty()) {
                HashMap<String, String> replacements = new HashMap<String, String>();
                for (String schema : schemas) {
                    if (schema == null || schema.isEmpty()) continue;
                    schemasString.append(schema.toLowerCase()).append(",");
                }
                try {
                    replacements.put("%SCHEMAS%", schemasString.substring(0, schemasString.length() - 1));
                }
                catch (Exception e) {
                    throw new IndexOutOfBoundsException(StageMessages.get("INVALID_SCHEMAS"));
                }
                String repSchema = (String)replacements.get("%SCHEMAS%");
                String[] repSchemas = repSchema.split(",");
                String validSchemas = ProjectUtils.checkValidSchemas(repSchemas, this._ctx);
                validReplacements.put("%SCHEMAS%", validSchemas);
            } else {
                validReplacements.put("%SCHEMAS%", "");
            }
            this.compileSql = this.createFileUsingTemplate(this.utilRoot, "recompile.sql", "oracle/dbtools/extension/project/commands/stage/templates/compile-invalid.sql.tmpl", validReplacements);
            this.preCheckSql = this.createFileUsingTemplate(this.utilRoot, "prechecks.sql", "oracle/dbtools/extension/project/commands/stage/templates/pre-checks.sql.tmpl");
        }
        if (this.isReleaseIsolation && this.nextCodeRoot != null && this.nextCodeRoot.toFile().exists()) {
            this.nextCodeChangeLog = this.createFileUsingTemplate(this.nextCodeRoot, "code.changelog.xml", "oracle/dbtools/extension/project/commands/stage/templates/code.changelog.tmpl");
        }
        if (this.distRoot != null && this.distRoot.toFile().exists()) {
            this.installSql = this.createFileUsingTemplate(this.distRoot, "install.sql", "oracle/dbtools/extension/project/commands/stage/templates/install_sql.tmpl");
        }
    }

    private void createBranchFiles() throws CreateFileException {
        if (this.branchRoot != null && this.branchRoot.toFile().exists()) {
            this.stageChangeLog = this.createFileUsingTemplate(this.branchRoot, "stage.changelog.xml", "oracle/dbtools/extension/project/commands/stage/templates/stage.changelog.tmpl");
        }
    }

    private void loadChangelogs() throws IOException {
        if (this.nextRelChangeLog != null && this.nextRelChangeLog.toFile().exists()) {
            this.relCLog = FileUtils.readFileToString((File)this.nextRelChangeLog.toFile(), (Charset)StandardCharsets.UTF_8);
        }
        if (this.stageChangeLog != null && this.stageChangeLog.toFile().exists()) {
            this.stageCLog = FileUtils.readFileToString((File)this.stageChangeLog.toFile(), (Charset)StandardCharsets.UTF_8);
        }
        if (this.nextCodeChangeLog != null && this.nextCodeChangeLog.toFile().exists()) {
            this.codeCLog = FileUtils.readFileToString((File)this.nextCodeChangeLog.toFile(), (Charset)StandardCharsets.UTF_8);
        }
        if (this.apexChangeLog != null && this.apexChangeLog.toFile().exists()) {
            this.apexClog = FileUtils.readFileToString((File)this.apexChangeLog.toFile(), (Charset)StandardCharsets.UTF_8);
        }
    }

    private Path createFileUsingTemplate(Path directory, String fileName, String template) throws CreateFileException {
        return this.createFileUsingTemplate(directory, fileName, template, null);
    }

    private Path createFileUsingTemplate(Path directory, String fileName, String template, Map<String, String> replaceStrings) throws CreateFileException {
        Path changelog = Paths.get(directory.toString(), fileName);
        if (!changelog.toFile().exists()) {
            if (FilenameUtils.getExtension((String)changelog.toString()).equalsIgnoreCase("xml")) {
                GeneralMessages.createChangeMsg(this.root.relativize(changelog).toString());
            } else {
                GeneralMessages.createFileMsg(this.root.relativize(changelog).toString());
            }
            try {
                ProjectFileUtils.createFileWithContent(changelog, ProjectFileUtils.getResourcesFileContent(Paths.get(template, new String[0])), replaceStrings);
            }
            catch (IOException e) {
                throw new CreateFileException(UtilMessages.format("FILE_CREATE_ERROR", ConsoleColors.RED.code, ConsoleColors.RESET.code, this.root.relativize(changelog).toString(), changelog, e));
            }
        }
        return changelog;
    }

    public Git getGit() throws StageProcessException {
        if (this._git == null) {
            throw new StageProcessException(StageMessages.get("GIT_NOT_FOUND"));
        }
        return this._git;
    }

    public void close() {
        if (this._git != null) {
            this._git.close();
        }
        this._git = null;
    }

    public LinkedList<DbDiffObject> processDiffs(HashMap<String, LinkedList<DbDiffObject>> diffs, Connection conn) throws ChangelogGenerationException, IOException, StageProcessException, CreateFileException, SQLException, ProjectNotIdentifiedException, ProjectSettingsException, NoSuchAlgorithmException {
        this.loadChangelogs();
        LinkedList<DbDiffObject> errors = new LinkedList<DbDiffObject>();
        for (String action : diffs.keySet()) {
            LinkedList<DbDiffObject> entries = diffs.get(action);
            errors.addAll(this.processDiffEntries(entries, action));
        }
        this.saveAllChangeLogs();
        this.processApex(conn);
        return errors;
    }

    private boolean excludeObject(@NonNull String type, @NonNull String name, String schema) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (type.equalsIgnoreCase("APEX")) {
            return excludedApexs.get(schema.toUpperCase()) != null && ProjectUtils.ignoreCaseContains(excludedApexs.get(schema.toUpperCase()), name);
        }
        if (type.equalsIgnoreCase("ORDS")) {
            return ProjectUtils.ignoreCaseContains(excludedOrds, name);
        }
        if (ProjectUtils.ignoreCaseContains(excludedSchemas, schema)) {
            return true;
        }
        if (excludedObjects.get("ALL") != null && ProjectUtils.ignoreCaseContains(excludedObjects.get("ALL"), name)) {
            return true;
        }
        return excludedObjects.get(schema) != null && ProjectUtils.ignoreCaseContains(excludedObjects.get(schema), name);
    }

    /*
     * Unable to fully structure code
     */
    private LinkedList<DbDiffObject> processDiffEntries(LinkedList<DbDiffObject> entries, String action) throws ChangelogGenerationException {
        errors = new LinkedList<DbDiffObject>();
        delete = false;
        rels = new ArrayList<E>();
        ticks = new ArrayList<E>();
        for (DbDiffObject entry : entries) {
            source = entry.getMasterFileContent();
            fileName = entry.getDestFileName();
            type = entry.getObjectType();
            schema = entry.getSchema();
            oName = entry.getObjectName();
            isSoftObject = entry.getIsSoftObject();
            objPath = this.isReleaseIsolation != false && isSoftObject != false && entry.getAction().equals("DELETE") == false ? this.nextCodeRoot.toString() : this.branchRoot.toString();
            if (schema == null || schema.equals("null") || type == null || type.equals("null")) continue;
            dest = Paths.get(objPath, new String[]{schema.toLowerCase(), StageConstants.typeNameTransform.containsKey(type) != false ? StageConstants.typeNameTransform.get(type).toLowerCase() : type.toLowerCase(), fileName.toLowerCase()});
            if (this.isReleaseIsolation && isSoftObject) {
                if (entry.getAction().equals("DELETE") && (oldDest = Paths.get(this.nextCodeRoot.toString(), new String[]{schema.toLowerCase(), StageConstants.typeNameTransform.containsKey(type) != false ? StageConstants.typeNameTransform.get(type).toLowerCase() : type.toLowerCase(), fileName.toLowerCase()})).toFile().exists()) {
                    FileUtils.deleteQuietly((File)oldDest.toFile());
                    GeneralMessages.deleteFileMsg(this.root.relativize(oldDest).toString());
                    stageString = this.getChangeRow(this.nextCodeRoot, oldDest);
                    if (this.codeCLog.contains(stageString)) {
                        this.codeCLog = this.codeCLog.replace(stageString, "");
                        GeneralMessages.updateChangeMsg(this.root.relativize(this.nextCodeChangeLog).toString());
                    }
                }
                logicalPath = Paths.get(this.nextCodeRoot.toString(), new String[]{schema}).relativize(dest).toString();
            } else {
                logicalPath = this.stageRoot.relativize(dest).toString();
            }
            if (oName != null) {
                try {
                    if (this.excludeObject(type, oName, schema)) {
                        GeneralMessages.excludeFileMsg(this.root.relativize(dest).toString());
                        continue;
                    }
                }
                catch (Exception e) {
                    GeneralMessages.debugException(e);
                }
            }
            if ("ADD".equals(action)) {
                try {
                    oldFile = entry.getSourceFileContent();
                    oldFile = oldFile.substring(0, oldFile.indexOf("-- sqlcl_snapshot")).trim();
                    newFile = new StringBuilder();
                    newFile.append("-- liquibase formatted sql\n");
                    newFile.append("-- changeset ").append(entry.getSchema()).append(":").append(StageUtils.getSha1fromString(oldFile)).append(" stripComments:false logicalFilePath:").append(logicalPath).append("\n");
                    newFile.append("-- sqlcl_snapshot ").append(entry.getDiffEntry().getNewPath()).append(":").append(entry.getMasterHash()).append(":").append(entry.getBranchHash()).append(":create\n\n");
                    newFile.append(oldFile);
                    if (!this.filesAreDifferent(dest, newFile.toString())) ** GOTO lbl119
                    FileUtils.writeStringToFile((File)dest.toFile(), (String)newFile.toString(), (Charset)StandardCharsets.UTF_8);
                    GeneralMessages.createFileMsg(this.root.relativize(dest).toString());
                }
                catch (Exception e) {
                    throw new ChangelogGenerationException(e);
                }
            } else if ("MODIFY".equals(action)) {
                alterContainsDrop = false;
                try {
                    if (entry.getBranchSxml() == null && entry.getMasterSxml() == null || isSoftObject) {
                        alterDdl = entry.getBranchFileContent();
                        alterDdl = alterDdl.substring(0, alterDdl.indexOf("-- sqlcl_snapshot")).trim();
                    } else {
                        conn = ProjectUtils.getConnection(ProjectConfig.getCurrentContext());
                        if (conn == null) {
                            throw new ChangelogGenerationException(StageMessages.getString("BAD_CONNECTION"));
                        }
                        collation = ProjectSettings.getSettingAsString("export.setTransform.collationClause");
                        if (collation == null) {
                            collation = "NEVER";
                        }
                        if ((alterDdl = DbmsMetaUtils.getAlterDdlWithTransform((Connection)conn, (String)entry.getMasterSxml(), (String)entry.getBranchSxml(), (String)entry.getObjectType().toUpperCase(), (String)entry.getObjectName().toUpperCase(), (boolean)Boolean.TRUE.equals(ProjectSettings.getSettingAsBoolean("export.setTransform.constraints")), (boolean)Boolean.TRUE.equals(ProjectSettings.getSettingAsBoolean("export.setTransform.constraintsAsAlters")), (boolean)Boolean.TRUE.equals(ProjectSettings.getSettingAsBoolean("export.setTransform.refConstraints")), (boolean)Boolean.TRUE.equals(ProjectSettings.getSettingAsBoolean("export.setTransform.storage")), (boolean)Boolean.TRUE.equals(ProjectSettings.getSettingAsBoolean("export.setTransform.segmentAttributes")), (boolean)Boolean.TRUE.equals(ProjectSettings.getSettingAsBoolean("export.setTransform.tablespace")), (boolean)Boolean.TRUE.equals(ProjectSettings.getSettingAsBoolean("export.setTransform.emitSchema")), (String)entry.getSchema(), (String)collation)) == null || alterDdl.contains("ORA-")) {
                            GeneralMessages.warnMessage(StageMessages.format("CAN_NOT_GET_ALTER_DDL", new Object[]{entry.getSchema(), entry.getObjectName()}));
                            this.debugMessageWithPrettySxmlFormat(entry.getBranchSxml(), entry.getMasterSxml(), alterDdl);
                            continue;
                        }
                        if (Export.format != null) {
                            alterDdl = Export.format.format(alterDdl);
                        }
                        alterDdl = Boolean.TRUE.equals(ProjectSettings.getSettingAsBoolean("export.setTransform.emitSchema")) != false ? alterDdl.replaceAll("(\"?)%USER_NAME%(\"?)", "$1" + schema + "$2") : alterDdl.replaceAll("(\"?%USER_NAME%\"?\\.?)", "");
                        if (Export.format != null) {
                            alterDdl = Export.format.format(alterDdl);
                        }
                    }
                    newFile = new StringBuilder();
                    newFile.append("-- liquibase formatted sql\n");
                    newFile.append("-- changeset ").append(entry.getSchema()).append(":").append(StageUtils.getSha1fromString(alterDdl)).append(" stripComments:false logicalFilePath:").append(logicalPath).append("\n");
                    newFile.append("-- sqlcl_snapshot ").append(entry.getDiffEntry().getNewPath()).append(":").append(entry.getMasterHash()).append(":").append(entry.getBranchHash()).append(":alter\n\n");
                    if (StringUtils.containsIgnoreCase((CharSequence)alterDdl, (CharSequence)"drop ")) {
                        delete = true;
                        alterContainsDrop = true;
                        newFile.append("/*  Uncomment drop statement after ensuring it is performing the correct actions \n");
                    }
                    newFile.append(alterDdl);
                    if (alterContainsDrop) {
                        newFile.append("\n*/");
                        alterContainsDrop = false;
                    }
                    if (!this.filesAreDifferent(dest, newFile.toString())) ** GOTO lbl119
                    FileUtils.writeStringToFile((File)dest.toFile(), (String)newFile.toString(), (Charset)StandardCharsets.UTF_8);
                    GeneralMessages.createFileMsg(this.root.relativize(dest).toString());
                }
                catch (Exception e) {
                    throw new ChangelogGenerationException(e);
                }
            } else if ("DELETE".equals(action)) {
                delete = true;
                try {
                    dropDdl = DropDdlGenerator.getDrop(entry);
                    newFile = new StringBuilder();
                    newFile.append("-- liquibase formatted sql\n");
                    newFile.append("-- changeset ").append(entry.getSchema()).append(":").append(StageUtils.getSha1fromString(dropDdl)).append(" stripComments:false logicalFilePath:").append(logicalPath).append("\n");
                    newFile.append("-- sqlcl_snapshot ").append(entry.getDiffEntry().getOldPath()).append(":").append(entry.getMasterHash()).append(":").append(entry.getBranchHash()).append(":drop\n\n");
                    newFile.append("/*  Uncomment drop statement after ensuring it is performing the correct actions \n").append(dropDdl).append("\n*/");
                    if (this.filesAreDifferent(dest, newFile.toString())) {
                        FileUtils.writeStringToFile((File)dest.toFile(), (String)newFile.toString(), (Charset)StandardCharsets.UTF_8);
                        GeneralMessages.createDropChangeMsg(this.root.relativize(dest).toString());
                    }
                }
                catch (Exception e) {
                    throw new ChangelogGenerationException(e);
                }
            }
lbl119:
            // 7 sources

            if (this.isReleaseIsolation && StageConstants.SoftObjects.contains(type) && !delete) {
                stageString = this.getChangeRow(this.nextCodeRoot, dest);
                if (this.codeCLog.contains(stageString) || this.stageCLog.contains(stageString)) continue;
                this.codeCLog = this.codeCLog.replace("<!--END-->", stageString + "\n<!--END-->");
                GeneralMessages.updateChangeMsg(this.root.relativize(this.nextCodeChangeLog).toString());
                continue;
            }
            stageString = this.getChangeRow(this.branchRoot, dest);
            if (this.stageCLog.contains(stageString)) continue;
            this.stageCLog = this.stageCLog.replace("<!--END-->", stageString + "\n<!--END-->");
            GeneralMessages.updateChangeMsg(this.root.relativize(this.stageChangeLog).toString());
        }
        if (delete) {
            GeneralMessages.warnMessage(StageMessages.get("DROP_LOG_DETAILS"));
        }
        return errors;
    }

    private void saveAllChangeLogs() throws StageProcessException, IOException, ProjectNotIdentifiedException, ProjectSettingsException {
        if (this.filesAreDifferent(this.stageChangeLog, this.stageCLog)) {
            this.saveChangeLog(this.stageChangeLog, ChangeLogSorter.sortChangelog(this.stageCLog), true);
        }
        if (this.isReleaseIsolation && this.filesAreDifferent(this.nextCodeChangeLog, this.codeCLog)) {
            this.saveChangeLog(this.nextCodeChangeLog, ChangeLogSorter.sortChangelog(this.codeCLog), true);
        }
        if (this.apexChangeLog != null && this.apexClog != null && this.filesAreDifferent(this.apexChangeLog, this.apexClog)) {
            this.saveChangeLog(this.apexChangeLog, this.apexClog);
        }
        if (this.filesAreDifferent(this.nextRelChangeLog, this.relCLog)) {
            this.saveChangeLog(this.nextRelChangeLog, this.relCLog);
        }
    }

    public void processApex(Connection conn) throws IOException, CreateFileException, StageProcessException, SQLException, NoSuchAlgorithmException {
        String appid;
        ArrayList<Path> apexFiles = new ArrayList<Path>();
        String[] schemaDirs = this.dbSrcRoot.toFile().list((FilenameFilter)DirectoryFileFilter.INSTANCE);
        if (schemaDirs != null) {
            for (String schemaDir : schemaDirs) {
                String[] appDirs;
                Path apexShemaRoot;
                if (schemaDir.equals("apex_apps") || !(apexShemaRoot = Paths.get(this.dbSrcRoot.toString(), schemaDir, "apex_apps")).toFile().exists() || (appDirs = apexShemaRoot.toFile().list((FilenameFilter)DirectoryFileFilter.INSTANCE)) == null) continue;
                for (String appDir : appDirs) {
                    Path apexFile = Paths.get(apexShemaRoot.toString(), appDir, appDir + ".sql");
                    if (!apexFile.toFile().exists()) continue;
                    apexFiles.add(apexFile);
                }
            }
        }
        if (apexFiles.isEmpty()) {
            return;
        }
        this.apexRoot = Paths.get(this.relRoot.toString(), "apex");
        FileUtils.createParentDirectories((File)Paths.get(this.apexRoot.toString(), "apex.changelog.xml").toFile());
        this.apexChangeLog = this.createFileUsingTemplate(this.apexRoot, "apex.changelog.xml", "oracle/dbtools/extension/project/commands/stage/templates/apex.changelog.tmpl");
        this.loadChangelogs();
        LinkedList<Path> releaseFiles = new LinkedList<Path>();
        for (Path srcPath : apexFiles) {
            String schema = srcPath.getParent().getParent().getParent().getFileName().toString();
            Path relPath = Paths.get(this.relRoot.toString(), "apex", srcPath.getParent().getFileName().toString(), srcPath.getFileName().toString());
            if (srcPath.toFile().exists() && !relPath.toFile().exists()) {
                appid = relPath.getParent().getFileName().toString().replace("f", "");
                if (this.excludeObject("APEX", appid, schema)) {
                    GeneralMessages.excludeFileMsg(this.root.relativize(Paths.get(srcPath.toString(), new String[0])).toString());
                    continue;
                }
                FileUtils.copyFile((File)srcPath.toFile(), (File)relPath.toFile());
                GeneralMessages.createFileMsg(this.root.relativize(relPath).toString());
                releaseFiles.add(relPath);
                continue;
            }
            if (!srcPath.toFile().exists() || !relPath.toFile().exists() || !this.filesAreDifferent(srcPath, relPath)) continue;
            FileUtils.copyFile((File)srcPath.toFile(), (File)relPath.toFile());
            GeneralMessages.createFileMsg(this.root.relativize(relPath).toString());
            releaseFiles.add(relPath);
        }
        for (Path app : releaseFiles) {
            String apexString;
            Path xmlFile = Paths.get(FilenameUtils.removeExtension((String)app.toString()) + ".xml", new String[0]);
            Path sqlFile = Paths.get(FilenameUtils.removeExtension((String)app.toString()) + ".sql", new String[0]);
            appid = app.getParent().getFileName().toString().replace("f", "");
            String installer = ApexInstallScriptGenerator.genApexController(appid, sqlFile.getFileName().toString(), conn);
            if (this.filesAreDifferent(xmlFile, installer)) {
                FileUtils.writeStringToFile((File)xmlFile.toFile(), (String)installer, (Charset)StandardCharsets.UTF_8);
                GeneralMessages.createChangeMsg(this.root.relativize(xmlFile).toString());
            }
            if (this.apexClog.contains(apexString = this.getChangeRow(this.apexRoot, xmlFile))) continue;
            this.apexClog = this.apexClog.replace("<!--END-->", apexString + "\n<!--END-->");
            this.saveChangeLog(this.apexChangeLog, this.apexClog);
        }
        this.mainChangeLog = Paths.get(this.relRoot.toString(), "main.changelog.xml");
        this.mainCLog = FileUtils.readFileToString((File)this.mainChangeLog.toFile(), (Charset)StandardCharsets.UTF_8);
        String clString = this.getChangeRow(this.relRoot, this.apexChangeLog);
        if (!this.mainCLog.contains(clString)) {
            this.mainCLog = this.mainCLog.replace("<!--END-->", "<!--END-->\n" + clString);
            this.saveChangeLog(this.mainChangeLog, this.mainCLog);
        }
    }

    public void release(String version) throws IOException, CreateFileException, ReleaseProcessException, StageProcessException {
        this.loadChangelogs();
        this.mainChangeLog = Paths.get(this.relRoot.toString(), "main.changelog.xml");
        this.mainCLog = FileUtils.readFileToString((File)this.mainChangeLog.toFile(), (Charset)StandardCharsets.UTF_8);
        String nextRow = "<include file=\"next/release.changelog.xml\" relativeToChangelogFile=\"true\"/>";
        String relRow = "<include file=\"" + version + "/release.changelog.xml\" relativeToChangelogFile=\"true\"/>";
        if (this.mainCLog.contains(relRow)) {
            throw new ReleaseProcessException(StageMessages.format("RELEASE_EXISTS", version));
        }
        this.mainCLog = this.mainCLog.replace(nextRow, relRow);
        this.mainCLog = this.mainCLog.replace("<!--END-->", nextRow + "\n<!--END-->");
        this.saveChangeLog(this.mainChangeLog, this.mainCLog);
        String release = this.nextRoot.toString().replace("next", version);
        Path releasePath = Paths.get(release, new String[0]);
        FileUtils.moveDirectory((File)this.nextRoot.toFile(), (File)releasePath.toFile());
        GeneralMessages.moveFolderMsg(this.root.relativize(this.nextRoot).toString(), this.root.relativize(releasePath).toString());
        FileUtils.forceMkdir((File)this.nextRoot.toFile());
        GeneralMessages.createFileMsg(this.root.relativize(this.nextRoot).toString());
        this.nextRelChangeLog = this.createFileUsingTemplate(this.nextRoot, "release.changelog.xml", "oracle/dbtools/extension/project/commands/stage/templates/release.changelog.tmpl");
        GeneralMessages.createChangeMsg(this.root.relativize(this.nextRelChangeLog).toString());
    }

    private void saveChangeLog(Path log, String data) throws IOException, StageProcessException {
        this.saveChangeLog(log, data, false);
    }

    private void saveChangeLog(Path log, String data, boolean release) throws IOException, StageProcessException {
        if (log == null || data == null || data.isEmpty()) {
            throw new StageProcessException(StageMessages.get("BAD_CHANGELOG_INFO"));
        }
        if (this.filesAreDifferent(log, data)) {
            FileUtils.writeStringToFile((File)log.toFile(), (String)data, (Charset)StandardCharsets.UTF_8);
            GeneralMessages.updateChangeMsg(this.root.relativize(log).toString());
        } else {
            GeneralMessages.skipChangeMsg(this.root.relativize(log).toString());
        }
        if (release) {
            String relRow = this.getChangeRow(this.nextRoot, log);
            String type = relRow.contains("file=\"code") ? "code" : (relRow.contains("file=\"changes") ? "change" : null);
            if (!this.relCLog.contains(relRow)) {
                this.relCLog = type == null ? this.relCLog.replace("<!--END-->", relRow + "\n<!--END-->") : (type.equals("code") ? this.relCLog.replace("<!--END CODE-->", relRow + "\n<!--END CODE-->") : this.relCLog.replace("<!--END CHANGES-->", relRow + "\n<!--END CHANGES-->"));
                GeneralMessages.updateChangeMsg(this.root.relativize(this.nextRelChangeLog).toString());
                this.saveChangeLog(this.nextRelChangeLog, this.relCLog);
            }
        }
    }

    private boolean filesAreDifferent(Path src, Path dest) throws IOException {
        int checksum2;
        if (!dest.toFile().exists()) {
            return true;
        }
        String source = FileUtils.readFileToString((File)src.toFile(), (Charset)StandardCharsets.UTF_8);
        String destin = FileUtils.readFileToString((File)dest.toFile(), (Charset)StandardCharsets.UTF_8);
        int checksum = source.hashCode();
        return checksum != (checksum2 = destin.hashCode());
    }

    private boolean filesAreDifferent(Path dest, String content) throws IOException {
        int checksum2;
        if (!dest.toFile().exists()) {
            return true;
        }
        String destin = FileUtils.readFileToString((File)dest.toFile(), (Charset)StandardCharsets.UTF_8);
        int checksum = destin.hashCode();
        return checksum != (checksum2 = content.hashCode());
    }

    protected String getChangeRow(Path root, Path dest) {
        return "<include file=\"" + root.relativize(dest) + "\" relativeToChangelogFile=\"true\"/>";
    }

    private void configObjectIsolation() throws CreateFileException {
        if (this.isReleaseIsolation && !this.nextCodeChangeLog.toFile().exists()) {
            this.nextCodeChangeLog = this.createFileUsingTemplate(this.relRoot, "code.changelog.xml", "oracle/dbtools/extension/project/commands/stage/templates/code.changelog.tmpl");
        }
    }

    public void createCustomFile(String name) throws CreateFileException, IOException, StageProcessException, ProjectNotIdentifiedException, ProjectSettingsException {
        String fileNameWithExtension = ProjectFileUtils.addExtensionIfDoesNotExist(name, ".sql");
        String fileName = ProjectFileUtils.sanitizeFileName(fileNameWithExtension);
        this.loadChangelogs();
        Path customFile = Paths.get(this.customRoot.toString(), ProjectFileUtils.sanitizeFileName(fileName));
        String stageString = this.getChangeRow(this.branchRoot, customFile);
        if (!this.stageCLog.contains(stageString) && !customFile.toFile().exists()) {
            String id;
            this.createFileUsingTemplate(this.customRoot, ProjectFileUtils.sanitizeFileName(fileName), "oracle/dbtools/extension/project/commands/stage/templates/add_custom_sql.tmpl");
            String userFile = FileUtils.readFileToString((File)customFile.toFile(), (Charset)StandardCharsets.UTF_8);
            String author = "SqlCl";
            userFile = userFile.replace("<name>", author);
            try {
                id = StageUtils.getSha1fromString(this.stageRoot.relativize(customFile).toString());
            }
            catch (NoSuchAlgorithmException e) {
                id = String.valueOf(this.stageRoot.relativize(customFile).toString().hashCode());
            }
            userFile = userFile.replace("<id>", id);
            userFile = userFile.replace("<logical>", this.stageRoot.relativize(customFile).toString());
            userFile = userFile.replace("<source>", this.root.relativize(customFile).toString());
            this.saveChangeLog(customFile, userFile);
            this.stageCLog = this.stageCLog.contains("<!--END CUSTOM-->") ? this.stageCLog.replace("<!--END CUSTOM-->", stageString + "\n<!--END CUSTOM-->") : this.stageCLog.replace("</databaseChangeLog>", stageString + "\n</databaseChangeLog>");
            this.saveAllChangeLogs();
        } else {
            if (customFile.toFile().exists()) {
                throw new CreateFileException(StageMessages.format("ADD_CUSTOM_FILE_EXISTS", customFile.toString(), customFile));
            }
            if (this.stageCLog.contains(stageString)) {
                throw new StageProcessException(StageMessages.format("ORPHAN_CHANGELOG_ROW", this.stageChangeLog));
            }
        }
    }

    private void debugMessageWithPrettySxmlFormat(String branchSxml, String masterSxml, String alterDdl) {
        try {
            boolean ignoreDeclaration = true;
            GeneralMessages.debugMessage(StageMessages.format("CAN_NOT_GET_ALTER_DDL_DBEUG", XMLFormatter.prettyFormat(branchSxml, "UTF-8", true), XMLFormatter.prettyFormat(masterSxml, "UTF-8", true), alterDdl));
        }
        catch (Exception e) {
            GeneralMessages.debugException(e);
        }
    }

    @Generated
    public static ArrayList<String> getExcludedSchemas() {
        return excludedSchemas;
    }

    @Generated
    public static HashMap<String, List<String>> getExcludedObjects() {
        return excludedObjects;
    }

    @Generated
    public static HashMap<String, List<String>> getExcludedApexs() {
        return excludedApexs;
    }

    @Generated
    public static ArrayList<String> getExcludedOrds() {
        return excludedOrds;
    }

    @Generated
    public Path getRoot() {
        return this.root;
    }

    @Generated
    public Path getDistRoot() {
        return this.distRoot;
    }

    @Generated
    public Path getUtilRoot() {
        return this.utilRoot;
    }

    @Generated
    public Path getInstallSql() {
        return this.installSql;
    }

    @Generated
    public Path getPreCheckSql() {
        return this.preCheckSql;
    }

    @Generated
    public Path getCompileSql() {
        return this.compileSql;
    }

    @Generated
    public Path getRelRoot() {
        return this.relRoot;
    }

    @Generated
    public Path getMainChangeLog() {
        return this.mainChangeLog;
    }

    @Generated
    public Path getNextRoot() {
        return this.nextRoot;
    }

    @Generated
    public Path getNextRelChangeLog() {
        return this.nextRelChangeLog;
    }

    @Generated
    public Path getApexRoot() {
        return this.apexRoot;
    }

    @Generated
    public Path getApexChangeLog() {
        return this.apexChangeLog;
    }

    @Generated
    public Path getNextCodeRoot() {
        return this.nextCodeRoot;
    }

    @Generated
    public Path getNextCodeChangeLog() {
        return this.nextCodeChangeLog;
    }

    @Generated
    public Path getStageRoot() {
        return this.stageRoot;
    }

    @Generated
    public Path getBranchRoot() {
        return this.branchRoot;
    }

    @Generated
    public Path getStageChangeLog() {
        return this.stageChangeLog;
    }

    @Generated
    public Path getCodeRoot() {
        return this.codeRoot;
    }

    @Generated
    public Path getCustomRoot() {
        return this.customRoot;
    }

    @Generated
    public Path getSrcRoot() {
        return this.srcRoot;
    }

    @Generated
    public Path getDbSrcRoot() {
        return this.dbSrcRoot;
    }

    @Generated
    public String getMainCLog() {
        return this.mainCLog;
    }

    @Generated
    public String getRelCLog() {
        return this.relCLog;
    }

    @Generated
    public String getStageCLog() {
        return this.stageCLog;
    }

    @Generated
    public String getApexClog() {
        return this.apexClog;
    }

    @Generated
    public String getCodeCLog() {
        return this.codeCLog;
    }

    @Generated
    public boolean isChangeIsolation() {
        return this.isChangeIsolation;
    }
}

