/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.stage.objectclasses;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.nio.file.Paths;
import java.util.ArrayList;
import lombok.Generated;
import oracle.dbtools.extension.project.commands.stage.StageMessages;
import oracle.dbtools.extension.project.commands.stage.objectclasses.SrcSnapShot;
import oracle.dbtools.extension.project.commands.stage.transforms.StageConstants;
import oracle.dbtools.extension.project.core.exceptions.ChangelogGenerationException;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jgit.diff.DiffEntry;

public class DbDiffObject {
    ArrayList<String> array;
    DiffEntry diffEntry;
    String sourceFileContent;
    String fileName;
    String objectType;
    String objectName;
    String action;
    Boolean isSoftObject;
    String schema;
    String masterFileContent;
    String branchFileContent;
    String masterHash;
    String branchHash;
    String masterSxml;
    String branchSxml;
    ChangelogGenerationException exception;

    public DbDiffObject(DiffEntry diffEntry, String branchContent, String masterContent) throws ChangelogGenerationException, JsonProcessingException {
        this.diffEntry = diffEntry;
        this.action = diffEntry.getChangeType().toString();
        this.masterFileContent = masterContent;
        this.branchFileContent = branchContent;
        SrcSnapShot snapShot = null;
        if ("ADD".equals(diffEntry.getChangeType().toString()) || "MODIFY".equals(diffEntry.getChangeType().toString())) {
            this.fileName = Paths.get(diffEntry.getNewPath(), new String[0]).getFileName().toString();
            this.fileName = this.fileName.replace(FilenameUtils.getExtension((String)this.fileName), "sql");
            this.sourceFileContent = this.branchFileContent;
            snapShot = SrcSnapShot.loadSnapShot(this.branchFileContent);
            this.branchSxml = snapShot != null ? snapShot.getSxml() : null;
            String string = this.branchHash = snapShot != null ? snapShot.getHash() : null;
        }
        if ("DELETE".equals(diffEntry.getChangeType().toString()) || "MODIFY".equals(diffEntry.getChangeType().toString())) {
            this.fileName = Paths.get(diffEntry.getOldPath(), new String[0]).getFileName().toString();
            this.fileName = this.fileName.replace(FilenameUtils.getExtension((String)this.fileName), "sql");
            this.sourceFileContent = null;
            snapShot = SrcSnapShot.loadSnapShot(this.masterFileContent);
            this.masterSxml = snapShot != null ? snapShot.getSxml() : null;
            String string = this.masterHash = snapShot != null ? snapShot.getHash() : null;
        }
        if (snapShot != null) {
            this.objectName = snapShot.getName().equals("null") ? null : snapShot.getName();
            this.objectType = snapShot.getType().equals("null") ? null : snapShot.getType();
            this.isSoftObject = StageConstants.SoftObjects.contains(this.objectType);
            this.schema = snapShot.getSchemaName().equals("null") ? null : snapShot.getSchemaName();
        } else {
            this.exception = new ChangelogGenerationException(StageMessages.format("UNABLE_TO_PROCESS_FILE", this.fileName));
        }
    }

    public String getDestFileName() {
        return this.fileName;
    }

    @Generated
    public DiffEntry getDiffEntry() {
        return this.diffEntry;
    }

    @Generated
    public String getSourceFileContent() {
        return this.sourceFileContent;
    }

    @Generated
    public String getObjectType() {
        return this.objectType;
    }

    @Generated
    public String getObjectName() {
        return this.objectName;
    }

    @Generated
    public String getAction() {
        return this.action;
    }

    @Generated
    public Boolean getIsSoftObject() {
        return this.isSoftObject;
    }

    @Generated
    public String getSchema() {
        return this.schema;
    }

    @Generated
    public String getMasterFileContent() {
        return this.masterFileContent;
    }

    @Generated
    public String getBranchFileContent() {
        return this.branchFileContent;
    }

    @Generated
    public String getMasterHash() {
        return this.masterHash;
    }

    @Generated
    public String getBranchHash() {
        return this.branchHash;
    }

    @Generated
    public String getMasterSxml() {
        return this.masterSxml;
    }

    @Generated
    public String getBranchSxml() {
        return this.branchSxml;
    }

    @Generated
    public ChangelogGenerationException getException() {
        return this.exception;
    }
}

