/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlcl.commands.blockchain;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.sqlcl.commands.blockchain.BICException;
import oracle.dbtools.sqlcl.commands.blockchain.BICModel;
import oracle.dbtools.sqlcl.commands.blockchain.BICOptions;
import oracle.dbtools.sqlcl.commands.blockchain.BICStubs;
import oracle.dbtools.sqlcl.commands.blockchain.Messages;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleType;
import oracle.sql.RAW;

public class CertificateProcessor {
    public static void addCertificate(BICModel model, ParsedCommand parsedCommand) throws BICException, SQLException {
        LinkedHashMap<Id, Object> binds = new LinkedHashMap<Id, Object>();
        LinkedHashSet<Id> InVar = new LinkedHashSet<Id>();
        LinkedHashSet<Id> OutBinds = new LinkedHashSet<Id>();
        LinkedHashSet<Id> OutFiles = new LinkedHashSet<Id>();
        InVar.add(BICOptions.cert_file.getId());
        InVar.add(BICOptions.wallet_path.getId());
        InVar.add(BICOptions.wallet_certificate_alias.getId());
        OutBinds.add(BICOptions.cert_guid.getId());
        binds = BICStubs.collectOptionValue(model, parsedCommand, binds, InVar, OutBinds, OutFiles);
        String query = BICStubs.getQuery("add", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/certificateQueries.xml");
        if (parsedCommand.getOptionValue(BICOptions.cert_file.getId()) == null && parsedCommand.getOptionValue(BICOptions.wallet_path.getId()).equals("")) {
            throw new BICException(new String[]{String.format(Messages.getString("BICEXP.MISSING_COMPULSORY_PARAMETER"), BICOptions.cert_file.getName() + "' or '" + BICOptions.wallet_path.getName())});
        }
        if (parsedCommand.getOptionValue(BICOptions.cert_file.getId()) != null && !parsedCommand.getOptionValue(BICOptions.wallet_path.getId()).equals("")) {
            throw new BICException(new String[]{String.format(Messages.getString("BICEXP.CONFLICTING_OPTION"), BICOptions.cert_file.getName(), BICOptions.wallet_path.getName())});
        }
        if (!(parsedCommand.getOptionValue(BICOptions.cert_file.getId()) == null || parsedCommand.getOptionValue(BICOptions.wallet_certificate_alias.getId()).equals("") && parsedCommand.getOptionValue(BICOptions.wallet_password.getId()).equals(""))) {
            throw new BICException(new String[]{Messages.getString("BICEXP.WALLET_PARAMS_ONLY_ERROR")});
        }
        if (binds.get(BICOptions.cert_file.getId()) != null) {
            binds.put(BICOptions.cert_file.getId(), BICStubs.parseBlobFromBFile(model, (String)binds.get(BICOptions.cert_file.getId()), BICOptions.cert_file.getName()));
        } else if (binds.get(BICOptions.wallet_path.getId()) != null) {
            String wallet_path = (String)binds.get(BICOptions.wallet_path.getId());
            String wallet_password = (String)parsedCommand.getOptionValue(BICOptions.wallet_password.getId());
            String wallet_certificate_alias = (String)binds.get(BICOptions.wallet_certificate_alias.getId());
            if (wallet_password.equals("")) {
                binds.put(BICOptions.cert_file.getId(), BICStubs.loadCertificateFromWallet(model, wallet_path, null, wallet_certificate_alias));
            } else {
                binds.put(BICOptions.cert_file.getId(), BICStubs.loadCertificateFromWallet(model, wallet_path, wallet_password.toCharArray(), wallet_certificate_alias));
            }
            wallet_password = null;
        }
        binds.remove(BICOptions.wallet_path.getId());
        binds.remove(BICOptions.wallet_certificate_alias.getId());
        OracleCallableStatement returnStatement = null;
        if (LockManager.lock((Connection)model.getConnection())) {
            try {
                returnStatement = (OracleCallableStatement)BICStubs.bind(model.getConnection().prepareCall(query), new ArrayList<Object>(binds.values()));
                returnStatement.registerOutParameter(binds.size() + 1, (SQLType)OracleType.RAW);
                returnStatement.executeUpdate();
                RAW cert_id = returnStatement.getRAW(binds.size() + 1);
                BICStubs.populateBindVariableStringValue(model, BICOptions.cert_guid, cert_id.stringValue());
                model.getContext().writeln("Command executed successfully.");
                model.getContext().writeln("CERTIFICATE_GUID : " + cert_id.stringValue());
            }
            catch (SQLException e) {
                throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
            }
            finally {
                if (returnStatement != null) {
                    returnStatement.close();
                }
                LockManager.unlock((Connection)model.getConnection());
            }
        }
    }

    public static void addCopyCertificate(BICModel model, ParsedCommand parsedCommand) throws BICException {
        String query = BICStubs.getQuery("addCopy", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/certificateQueries.xml");
        if (query == null) {
            throw new BICException(new String[]{String.format(Messages.getString("BICEXP.UNSUPPORTED_DB_VERSION"), "ADD_COPY' or 'addCopy", model.getDbVersion())});
        }
        LinkedHashMap<Id, Object> binds = new LinkedHashMap<Id, Object>();
        LinkedHashSet<Id> InVar = new LinkedHashSet<Id>();
        LinkedHashSet<Id> OutBinds = new LinkedHashSet<Id>();
        LinkedHashSet<Id> OutFiles = new LinkedHashSet<Id>();
        InVar.add(BICOptions.cert_file_req.getId());
        InVar.add(BICOptions.cert_guid_req.getId());
        InVar.add(BICOptions.username.getId());
        binds = BICStubs.collectOptionValue(model, parsedCommand, binds, InVar, OutBinds, OutFiles);
        if (binds.get(BICOptions.cert_file_req.getId()) != null) {
            binds.put(BICOptions.cert_file_req.getId(), BICStubs.parseBlobFromBFile(model, (String)binds.get(BICOptions.cert_file_req.getId()), BICOptions.cert_file_req.getName()));
        }
        DBUtil dBUtil = DBUtil.getInstance((Connection)model.getConnection());
        dBUtil.execute(query, new ArrayList<Object>(binds.values()));
        SQLException e = dBUtil.getLastException();
        if (e != null) {
            throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
        }
        model.getContext().writeln("Command executed successfully.");
        model.getContext().writeln("Certificate " + binds.get(BICOptions.cert_guid_req.getId()) + " added successfully.");
    }

    public static void dropCertificate(BICModel model, ParsedCommand parsedCommand) throws BICException {
        String query = BICStubs.getQuery("drop", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/certificateQueries.xml");
        LinkedHashMap<Id, Object> binds = new LinkedHashMap<Id, Object>();
        LinkedHashSet<Id> InVar = new LinkedHashSet<Id>();
        LinkedHashSet<Id> OutBinds = new LinkedHashSet<Id>();
        LinkedHashSet<Id> OutFiles = new LinkedHashSet<Id>();
        InVar.add(BICOptions.cert_guid_req.getId());
        binds = BICStubs.collectOptionValue(model, parsedCommand, binds, InVar, OutBinds, OutFiles);
        DBUtil dBUtil = DBUtil.getInstance((Connection)model.getConnection());
        dBUtil.execute(query, new ArrayList<Object>(binds.values()));
        SQLException e = dBUtil.getLastException();
        if (e != null) {
            throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
        }
        model.getContext().writeln("Command executed successfully.");
        model.getContext().writeln("Certificate " + binds.get(BICOptions.cert_guid_req.getId()) + " dropped successfully.");
    }

    public static void listCertificate(BICModel model) throws BICException {
        String query = BICStubs.getQuery("ls", model.getConnection(), "oracle/dbtools/sqlcl/commands/blockchain/certificateQueries.xml");
        ScriptRunnerContext ctx = model.getContext();
        StringBuilder sb = new StringBuilder();
        boolean isEmpty = Boolean.TRUE;
        try (Statement stmt = model.getConnection().createStatement(1004, 1007);){
            ResultSet response = stmt.executeQuery(query);
            ResultSetMetaData rsmd = response.getMetaData();
            int totalCols = rsmd.getColumnCount();
            int[] colSize = new int[totalCols];
            while (response.next()) {
                colSize[0] = Integer.max(colSize[0], Integer.max(response.getString("CERTIFICATE_ID") != null ? response.getString("CERTIFICATE_ID").length() : rsmd.getColumnLabel(1).length(), rsmd.getColumnLabel(1).length()));
                colSize[1] = Integer.max(colSize[1], Integer.max(response.getString("USER_NAME") != null ? response.getString("USER_NAME").length() : rsmd.getColumnLabel(2).length(), rsmd.getColumnLabel(2).length()));
                colSize[2] = Integer.max(colSize[2], Integer.max(response.getString("DISTINGUISHED_NAME") != null ? response.getString("DISTINGUISHED_NAME").length() : rsmd.getColumnLabel(3).length(), rsmd.getColumnLabel(3).length()));
                colSize[3] = Integer.max(colSize[3], Integer.max(160, rsmd.getColumnLabel(4).length()));
                isEmpty = Boolean.FALSE;
            }
            if (!isEmpty) {
                for (int i = 0; i < totalCols; ++i) {
                    sb.append(String.format("%-" + colSize[i] + "s\t", rsmd.getColumnLabel(i + 1)));
                }
                sb.append("\n");
                response.beforeFirst();
                while (response.next()) {
                    sb.append(String.format("%-" + colSize[0] + "s\t", response.getString("CERTIFICATE_ID") != null ? response.getString("CERTIFICATE_ID") : ""));
                    sb.append(String.format("%-" + colSize[1] + "s\t", response.getString("USER_NAME") != null ? response.getString("USER_NAME") : ""));
                    sb.append(String.format("%-" + colSize[2] + "s\t", response.getString("DISTINGUISHED_NAME") != null ? response.getString("DISTINGUISHED_NAME") : ""));
                    Blob blob = response.getBlob("CERTIFICATE");
                    byte[] bytes = blob.getBytes(1L, (int)blob.length());
                    String hexString = BICStubs.byteArrayToHex(bytes);
                    String truncatedHex = hexString.substring(0, Math.min(hexString.length(), 160));
                    sb.append(String.format("%-" + colSize[3] + "s\t", truncatedHex.toUpperCase()));
                    sb.append("\n");
                }
            }
        }
        catch (SQLException e) {
            throw new BICException(new String[]{String.format(e.getMessage(), new Object[0])});
        }
        if (!isEmpty) {
            ctx.writeln(sb.toString());
        } else {
            ctx.writeln(String.format(Messages.getString("CERTIFICATE.NOT_AVAILABLE"), new Object[0]));
        }
    }
}

