/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.history;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import javax.ide.extension.ElementName;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.util.Assert;
import oracle.jdeveloper.history.CustomFilter;
import oracle.jdeveloper.history.CustomFilterSubstitution;
import oracle.jdeveloper.resource.HistoryArb;
import oracle.jdevimpl.history.HistoryFilterSubstitutionHook;

public class CustomFilterManager {
    private static final String CUSTOM_FILTERS_DATA_KEY = "HistoryManager.CustomFilters_";
    private CustomFilter[] _customFilters;
    private final Collection<CustomFilterSubstitution> _substitutions = new ArrayList<CustomFilterSubstitution>();
    private final Observable _customFilterObservable = new Observable(){

        @Override
        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    };

    public CustomFilter[] getFilters() {
        if (this._customFilters != null) {
            return this._customFilters;
        }
        Map copyableFilterMap = (Map)Ide.getDTCache().getData(CUSTOM_FILTERS_DATA_KEY);
        if (copyableFilterMap == null) {
            this._customFilters = this.createDefaultFilters();
            this.persistFilters(this._customFilters);
            return this._customFilters;
        }
        ArrayList<CustomFilter> customFilters = new ArrayList<CustomFilter>();
        for (Map.Entry entry : copyableFilterMap.entrySet()) {
            try {
                CustomFilter filter = CustomFilter.parse((String)entry.getValue());
                filter.setName((String)entry.getKey());
                customFilters.add(filter);
            }
            catch (ParseException parseException) {}
        }
        this._customFilters = customFilters.toArray(new CustomFilter[0]);
        return this._customFilters;
    }

    public void setFilters(CustomFilter[] customFilters) {
        this._customFilters = customFilters;
        this.persistFilters(this._customFilters);
        this._customFilterObservable.notifyObservers();
    }

    public CustomFilter[] createDefaultFilters() {
        try {
            ArrayList<CustomFilter> customFilters = new ArrayList<CustomFilter>();
            CustomFilter filter = CustomFilter.parse("DATE = ${system.date}");
            filter.setName(HistoryArb.get("DEFAULT_FILTER_TODAY"));
            customFilters.add(filter);
            filter = CustomFilter.parse("DATE >= ${system.date} - 7");
            filter.setName(HistoryArb.get("DEFAULT_FILTER_ONE_WEEK"));
            customFilters.add(filter);
            filter = CustomFilter.parse("AUTHOR = ${system.user} OR AUTHOR = ${versioning.user} OR REVISION MATCHES REGEXP:(?i)local");
            filter.setName(HistoryArb.get("DEFAULT_MY_CHANGES"));
            customFilters.add(filter);
            filter = CustomFilter.parse("NOT DESCRIPTION MATCHES REGEXP:^$|^\\[.*\\]$|^\\*\\*\\*.+\\*\\*\\*$");
            filter.setName(HistoryArb.get("DEFAULT_FILTER_ANNOTATED"));
            customFilters.add(filter);
            filter = CustomFilter.parse("TAGS MATCHES REGEXP:.+");
            filter.setName(HistoryArb.get("DEFAULT_FILTER_TAGGED"));
            customFilters.add(filter);
            return customFilters.toArray(new CustomFilter[0]);
        }
        catch (ParseException pe) {
            Assert.printStackTrace((Throwable)pe);
            return null;
        }
    }

    public Observable getFilterObservable() {
        return this._customFilterObservable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void registerSubstitution(CustomFilterSubstitution substitution) {
        if (substitution == null) {
            return;
        }
        Collection<CustomFilterSubstitution> collection = this._substitutions;
        synchronized (collection) {
            this._substitutions.add(substitution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void deregisterSubstitution(CustomFilterSubstitution substitution) {
        Collection<CustomFilterSubstitution> collection = this._substitutions;
        synchronized (collection) {
            this._substitutions.remove(substitution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomFilterSubstitution[] getSubstitutions() {
        Collection<CustomFilterSubstitution> collection = this._substitutions;
        synchronized (collection) {
            ArrayList<CustomFilterSubstitution> combinedFilters = new ArrayList<CustomFilterSubstitution>();
            combinedFilters.addAll(this._substitutions);
            combinedFilters.addAll(this.getSubstutionsFromHook());
            return combinedFilters.toArray(new CustomFilterSubstitution[0]);
        }
    }

    private Collection<CustomFilterSubstitution> getSubstutionsFromHook() {
        ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
        HistoryFilterSubstitutionHook filterHook = (HistoryFilterSubstitutionHook)registry.getHook(new ElementName("http://xmlns.oracle.com/ide/extension", "history-filter-substitution-hook"));
        return filterHook.getFilters();
    }

    private void persistFilters(CustomFilter[] customFilters) {
        if (customFilters == null) {
            return;
        }
        HashMap<String, String> copyableFilterMap = new HashMap<String, String>();
        for (CustomFilter customFilter : customFilters) {
            copyableFilterMap.put(customFilter.getName(), customFilter.getSource());
        }
        Ide.getDTCache().putData(CUSTOM_FILTERS_DATA_KEY, copyableFilterMap);
    }
}

