/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.secrets;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.function.Consumer;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import oracle.dbtools.core.secrets.BinarySecret;

enum KeyAlgorithm {
    AES_GCM("AES/GCM/NoPadding", 32);

    private final String algorithm;
    private final int keySizeBytes;

    private KeyAlgorithm(String algorithm, int keySizeBytes) {
        this.algorithm = algorithm;
        this.keySizeBytes = keySizeBytes;
    }

    private static String family(String algo) {
        int slash = algo.indexOf(47);
        if (slash == -1) {
            return algo;
        }
        return algo.substring(0, slash);
    }

    Cipher cipher() throws NoSuchPaddingException, NoSuchAlgorithmException {
        return Cipher.getInstance(this.algorithm);
    }

    AlgorithmParameterSpec parameterSpec(byte[] iv) {
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(iv.length * 8, iv);
        return gcmParameterSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Key generate(Consumer<byte[]> entropyGenerator) {
        byte[] bytes = new byte[this.keySizeBytes()];
        try {
            entropyGenerator.accept(bytes);
            Key key = this.toKey(bytes);
            return key;
        }
        finally {
            BinarySecret.erase(bytes);
        }
    }

    int keySizeBytes() {
        return this.keySizeBytes;
    }

    private Key toKey(byte[] keyMaterial) {
        String algoFamily = KeyAlgorithm.family(this.algorithm);
        SecretKeySpec keySpec = new SecretKeySpec(keyMaterial, algoFamily);
        return keySpec;
    }
}

