/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.dms.instrument.PhaseEvent;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SensorCreator;
import oracle.sdovis.DataException;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.RSBundle;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.theme.LocalThemeDataProducer;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.theme.WFSThemeDefinition;
import oracle.sdovis.util.HttpConnection;
import oracle.sdovis.util.TopThemeQueries;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.WhereClause;
import oracle.sdovis.util.XMLDOMParser;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.GML;
import oracle.spatial.util.GML3g;
import oracle.xml.parser.v2.DOMParser;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WFSThemeProducer
implements ThemeDataProducer {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static final PhaseEvent wfsSensor = SensorCreator.createPhaseEvent(SensorCreator.NounsEnum.THEMEPRODUCER, "WFS", "Producer", "Time spent preparing data");
    private Theme owner = null;
    private WFSThemeDefinition def = null;
    private double xl;
    private double yl;
    private double xh;
    private double yh;
    private LocalThemeDataProducer features = null;
    private long maxFeaturesToBePrepared = -1L;

    public WFSThemeProducer(Theme t) {
        this.owner = t;
        this.def = (WFSThemeDefinition)t.getDefinition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int prepareData(Rectangle2D queryWin, VisContext vc) throws DataException {
        block138: {
            block139: {
                block135: {
                    block132: {
                        block134: {
                            block133: {
                                block131: {
                                    block130: {
                                        block137: {
                                            block127: {
                                                block129: {
                                                    block128: {
                                                        block136: {
                                                            block126: {
                                                                block125: {
                                                                    block124: {
                                                                        block123: {
                                                                            block122: {
                                                                                block121: {
                                                                                    block120: {
                                                                                        tokenW = 0L;
                                                                                        axisOrder = 0;
                                                                                        tokenW = WFSThemeProducer.wfsSensor.start();
                                                                                        t0 = System.currentTimeMillis();
                                                                                        this.clearFeatures();
                                                                                        this.xl = queryWin.getMinX();
                                                                                        this.yl = queryWin.getMinY();
                                                                                        this.xh = queryWin.getMaxX();
                                                                                        this.yh = queryWin.getMaxY();
                                                                                        if (this.def.getURL() != null) break block120;
                                                                                        vc.processDataError(null, WFSThemeProducer.log, RSBundle.getMsg("MAPVIEWER-01046") + " [" + this.owner.getName() + "]");
                                                                                        var8_6 = 0;
                                                                                        WFSThemeProducer.wfsSensor.stop(tokenW);
                                                                                        return var8_6;
                                                                                    }
                                                                                    if (this.def.readCapabilities(this.getTheme().getDecorator().getRequestTimeout())) break block121;
                                                                                    var8_7 = 0;
                                                                                    WFSThemeProducer.wfsSensor.stop(tokenW);
                                                                                    return var8_7;
                                                                                }
                                                                                if (this.def.getSRS() != null) break block122;
                                                                                vc.processDataError(null, WFSThemeProducer.log, "Theme definition has no SRS information. Must read Capabilities.");
                                                                                var8_8 = 0;
                                                                                WFSThemeProducer.wfsSensor.stop(tokenW);
                                                                                return var8_8;
                                                                            }
                                                                            srsinfo = this.def.getSRS();
                                                                            if (srsinfo.indexOf(":") < 0) {
                                                                                srsinfo = "SDO:" + this.def.getSRS();
                                                                            }
                                                                            if ((featType = this.def.getFeatureType()) != null) break block123;
                                                                            vc.processDataError(null, WFSThemeProducer.log, "Wfs feature Type is null.");
                                                                            var10_11 = 0;
                                                                            WFSThemeProducer.wfsSensor.stop(tokenW);
                                                                            return var10_11;
                                                                        }
                                                                        version = this.def.getVersion();
                                                                        format = this.def.getOutputFormat();
                                                                        if (format == null || version == null || version.equals("1.0.0")) {
                                                                            format = "GML2";
                                                                        }
                                                                        if ((featFormats = featType.getOutputFormats()) == null || featFormats.length <= 0 || version == null || version.equals("1.0.0")) break block124;
                                                                        ftSupported = false;
                                                                        for (i = 0; i < featFormats.length; ++i) {
                                                                            if (!format.equalsIgnoreCase(featFormats[i])) continue;
                                                                            ftSupported = true;
                                                                            break;
                                                                        }
                                                                        if (ftSupported) break block124;
                                                                        vc.processDataError(null, WFSThemeProducer.log, "Requested format [" + format + "] is not supported for Wfs feature type [" + featType.getName() + "].");
                                                                        i = 0;
                                                                        WFSThemeProducer.wfsSensor.stop(tokenW);
                                                                        return i;
                                                                    }
                                                                    getfeaturePostUrl = this.def.getCapabilities().getFeaturePostURL();
                                                                    getfeatureGetUrl = this.def.getCapabilities().getFeatureGetURL();
                                                                    if (getfeaturePostUrl != null || getfeatureGetUrl != null) break block125;
                                                                    WFSThemeProducer.log.warning("GetFeature POST and GET URLs are null.");
                                                                    var15_19 = 0;
                                                                    WFSThemeProducer.wfsSensor.stop(tokenW);
                                                                    return var15_19;
                                                                }
                                                                getrequest = "";
                                                                if (getfeatureGetUrl != null) {
                                                                    getrequest = getfeatureGetUrl;
                                                                    if (getrequest.lastIndexOf(63) > -1) {
                                                                        if (!getrequest.endsWith("?") && !getrequest.endsWith("&")) {
                                                                            getrequest = getrequest + "&";
                                                                        }
                                                                    } else if (!getrequest.endsWith("&")) {
                                                                        getrequest = getrequest + "?";
                                                                    }
                                                                    getrequest = getrequest + "VERSION=" + version + "&SERVICE=WFS&REQUEST=GetFeature";
                                                                }
                                                                transformSRid = false;
                                                                srs = null;
                                                                isGeodetic = false;
                                                                unit = null;
                                                                sc = DSManager.getSRSCache(this.owner.getDataSourceName());
                                                                if (sc != null) {
                                                                    srs = sc.get(this.def.getSrid());
                                                                }
                                                                if (srs != null) {
                                                                    isGeodetic = srs.isGeodetic();
                                                                    unit = srs.getUnit();
                                                                } else if (this.def.getSrid() > 0) {
                                                                    WFSThemeProducer.log.warning("cannot locate an SRS object for srid: " + this.def.getSrid());
                                                                }
                                                                xi = this.xl;
                                                                xf = this.xh;
                                                                yi = this.yl;
                                                                yf = this.yh;
                                                                masterScale = vc.getCurrentScale();
                                                                this.getTheme().setShowLabels(true);
                                                                if (vc.getMasterSRID() <= 0 || this.def.getSrid() <= 0 || this.def.getSrid() == vc.getMasterSRID()) ** GOTO lbl138
                                                                conn = null;
                                                                try {
                                                                    conn = DSUtil.getDBConnection(this.owner.getDataSourceName(), vc);
                                                                }
                                                                catch (Exception e) {
                                                                    WFSThemeProducer.log.info("Unbale to get datasource connection to convert SRID");
                                                                    var33_38 = 0;
                                                                    WFSThemeProducer.wfsSensor.stop(tokenW);
                                                                    return var33_38;
                                                                }
                                                                if (masterScale == Infinity || masterScale == -Infinity) ** GOTO lbl131
                                                                inmbr = new double[]{this.xl, this.yl, this.xh, this.yh};
                                                                outmbr = Util.convertMBR(inmbr, vc.getMasterSRID(), this.def.getSrid(), conn);
                                                                if (outmbr != null) {
                                                                    this.xl = outmbr[0];
                                                                    this.yl = outmbr[1];
                                                                    this.xh = outmbr[2];
                                                                    this.yh = outmbr[3];
                                                                    transformSRid = true;
                                                                    break block126;
                                                                }
                                                                try {
                                                                    DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                                                                }
                                                                catch (Exception e) {
                                                                    WFSThemeProducer.log.warning(e.getMessage());
                                                                }
                                                                vc.processDataError(null, WFSThemeProducer.log, RSBundle.getMsg("MAPVIEWER-01024"));
                                                                e = 0;
                                                                WFSThemeProducer.wfsSensor.stop(tokenW);
                                                                return e;
                                                            }
                                                            break block136;
lbl131:
                                                            // 1 sources

                                                            transformSRid = true;
                                                        }
                                                        try {
                                                            DSUtil.closeDBConnection(conn, this.def.getDataSourceName());
                                                        }
                                                        catch (Exception e) {
                                                            // empty catch block
                                                        }
lbl138:
                                                        // 3 sources

                                                        if (masterScale == Infinity || masterScale == -Infinity) break block127;
                                                        factor = Math.abs(this.yh - this.yl) / Math.abs(yf - yi);
                                                        WFSThemeProducer.log.finer("[Master scale] " + masterScale + " [Theme scale factor] " + factor);
                                                        scale = masterScale * factor;
                                                        if (this.getTheme().getScaleType() != "RATIO") break block128;
                                                        if (vc.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != vc.getMasterSRID()) {
                                                            srs = sc.get(vc.getMasterSRID());
                                                            centerx = (xi + xf) / 2.0;
                                                            centery = (yi + yf) / 2.0;
                                                            factor = 1.0;
                                                        } else {
                                                            centerx = (this.xl + this.xh) / 2.0;
                                                            centery = (this.yl + this.yh) / 2.0;
                                                        }
                                                        if (vc.isTileRequest() && srs.isGeodetic()) {
                                                            centerx = 0.0;
                                                            centery = 0.0;
                                                        }
                                                        if (srs != null) {
                                                            scale = Math.round(srs.getRatioScale(masterScale * factor, new Point2D.Double(centerx, centery)));
                                                            WFSThemeProducer.log.finer("Ratio scale to compare: " + scale);
                                                            break block128;
                                                        }
                                                        vc.processDataError(null, WFSThemeProducer.log, RSBundle.getMsg("MAPVIEWER-01025"));
                                                        var39_51 = 0;
                                                        WFSThemeProducer.wfsSensor.stop(tokenW);
                                                        return var39_51;
                                                    }
                                                    if (this.getTheme().withinRenderScaleLimits(scale)) break block129;
                                                    WFSThemeProducer.log.warning("Scale definition for theme " + this.getTheme().getName() + " is out of range.");
                                                    centerx = 0;
                                                    WFSThemeProducer.wfsSensor.stop(tokenW);
                                                    return centerx;
                                                }
                                                if (!this.getTheme().withinLabelScaleLimits(scale)) {
                                                    WFSThemeProducer.log.info("Label Scale definition for theme " + this.getTheme().getName() + " is out of range. Labels will not be rendered.");
                                                    this.getTheme().setShowLabels(false);
                                                }
                                            }
                                            v0 = workaround = isGeodetic != false && this.xh - this.xl > 2.0 && this.xh - this.xl < 120.0;
                                            if (workaround) {
                                                this.xl = Math.floor(this.xl);
                                                WFSThemeProducer.log.finest("jtvpxfmfxed: xl=" + this.xl);
                                            }
                                            WFSThemeProducer.log.finest("[ " + this.def.getName() + " ]:  " + this.xl + "," + this.yl + "," + this.xh + "," + this.yh);
                                            applyRotation = false;
                                            if (MapMaker.isSpecial(this.xl, this.yl, this.xh, this.yh) && vc.getRotation() != 0.0) {
                                                WFSThemeProducer.log.warning("Rotation is currently ignored for full extent.");
                                            } else if (vc.getRotation() != 0.0 && !MapMaker.isSpecial(this.xl, this.yl, this.xh, this.yh)) {
                                                if (vc.getRotation() < -360.0 || vc.getRotation() > 360.0) {
                                                    WFSThemeProducer.log.warning("Rotation value must be in between -360 to 360 degrees. ignored");
                                                } else {
                                                    rmbr = Util.rotateMBR(this.xl, this.yl, this.xh, this.yh, vc.getRotation());
                                                    if (rmbr != null) {
                                                        this.xl = Math.min(rmbr[0], this.xl);
                                                        this.yl = Math.min(rmbr[1], this.yl);
                                                        this.xh = Math.max(rmbr[2], this.xh);
                                                        this.yh = Math.max(rmbr[3], this.yh);
                                                        WFSThemeProducer.log.finest("Rotation angle: " + vc.getRotation());
                                                        WFSThemeProducer.log.finest("Search window for rotation: " + this.xl + "," + this.yl + "," + this.xh + "," + this.yh);
                                                        applyRotation = true;
                                                    } else {
                                                        WFSThemeProducer.log.info("Rotated MBR is null. Rotation ignored.");
                                                    }
                                                }
                                            }
                                            featName = this.def.getFeatureName();
                                            attrTypes = null;
                                            attrTypes = this.def.getFeatureType().getAttributeTypes();
                                            xmlns1 = "";
                                            nsp1 = "";
                                            nspreq1 = "";
                                            if (featType.getNameSpaceAlias() != null && featType.getNameSpaceAliasURL() != null) {
                                                xmlns1 = "   xmlns:" + featType.getNameSpaceAlias() + "=\"" + featType.getNameSpaceAliasURL() + "\"\n";
                                                nspreq1 = nsp1 = featType.getNameSpaceAlias() + ":";
                                            }
                                            geomColumn = nsp1 + this.def.getSpatialColumn();
                                            geomColumn1 = nspreq1 + this.def.getSpatialColumn();
                                            if (this.def.getSpatialColumn().indexOf("gml:") > -1) {
                                                geomColumn = this.def.getSpatialColumn();
                                                geomColumn1 = this.def.getSpatialColumn();
                                            }
                                            xml = "<?xml version=\"1.0\" ?>\n<wfs:GetFeature\n   service=\"WFS\"\n   version=\"" + version + "\"\n" + "   outputFormat=\"" + format + "\"\n" + "   xmlns:wfs=\"http://www.opengis.net/wfs\"\n" + "   xmlns:ogc=\"http://www.opengis.net/ogc\"\n" + "   xmlns:gml=\"http://www.opengis.net/gml\"\n" + xmlns1 + "   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n" + "   xsi:schemaLocation=\"http://www.opengis.net/wfs\n";
                                            xml = version.equals("1.1.0") != false ? xml + "                      http://schemas.opengis.net/wfs/1.1.0/WFS.xsd\">\n" : xml + "                      http://schemas.opengis.net/wfs/1.0.0/WFS-basic.xsd\">\n";
                                            xml = xml + "   <wfs:Query typeName=\"" + nsp1 + featType.getName() + "\">\n" + "      <ogc:PropertyName>" + geomColumn + "</ogc:PropertyName>\n";
                                            getrequest = getrequest + "&TYPENAME=" + nspreq1 + featType.getName();
                                            getrequest = getrequest + "&PROPERTYNAME=" + geomColumn1;
                                            keycolAdded = false;
                                            key = this.def.getKeyColumn();
                                            if (this.def.getLabelColumn() != null && !this.def.getLabelColumn().equalsIgnoreCase("dummy")) {
                                                xml = xml + "      <ogc:PropertyName>" + nsp1 + this.def.getLabelColumn() + "</ogc:PropertyName>\n";
                                                getrequest = getrequest + "," + nspreq1 + this.def.getLabelColumn();
                                                if (!keycolAdded && key != null && !key.equalsIgnoreCase("fid") && key.equalsIgnoreCase(this.def.getLabelColumn())) {
                                                    keycolAdded = true;
                                                }
                                            }
                                            attrList = this.def.getFeatureAttributes();
                                            atlist = new ArrayList<String>();
                                            if (attrList != null) {
                                                for (i = 0; i < attrList.length; ++i) {
                                                    if (this.def.getLabelColumn() != null && this.def.getLabelColumn().equalsIgnoreCase(attrList[i]) || atlist.contains(attrList[i].toUpperCase())) continue;
                                                    attr = nsp1 + attrList[i];
                                                    xml = xml + "      <ogc:PropertyName>" + attr + "</ogc:PropertyName>\n";
                                                    getrequest = getrequest + "," + nspreq1 + attrList[i];
                                                    if (!keycolAdded && key != null && !key.equalsIgnoreCase("fid") && key.equalsIgnoreCase(attrList[i])) {
                                                        keycolAdded = true;
                                                    }
                                                    atlist.add(attrList[i].toUpperCase());
                                                }
                                            }
                                            if ((infoColumns = this.def.getIdentifiableColumns()) != null) {
                                                for (i = 0; i < infoColumns.length; ++i) {
                                                    f = infoColumns[i];
                                                    realName = this.def.getRealAttributeName(f.getName());
                                                    if (realName == null || this.def.getLabelColumn() != null && this.def.getLabelColumn().equalsIgnoreCase(f.getName())) continue;
                                                    if (attrList == null) {
                                                        attr = nsp1 + realName;
                                                        xml = xml + "      <ogc:PropertyName>" + attr + "</ogc:PropertyName>\n";
                                                        getrequest = getrequest + "," + nspreq1 + realName;
                                                        if (keycolAdded || key == null || key.equalsIgnoreCase("fid") || !key.equalsIgnoreCase(realName)) continue;
                                                        keycolAdded = true;
                                                        continue;
                                                    }
                                                    exists = false;
                                                    for (k = 0; k < attrList.length; ++k) {
                                                        if (!attrList[k].equalsIgnoreCase(f.getName())) continue;
                                                        exists = true;
                                                        break;
                                                    }
                                                    if (exists) continue;
                                                    attr = nsp1 + realName;
                                                    xml = xml + "      <ogc:PropertyName>" + attr + "</ogc:PropertyName>\n";
                                                    getrequest = getrequest + "," + nspreq1 + realName;
                                                    if (keycolAdded || key == null || key.equalsIgnoreCase("fid") || !key.equalsIgnoreCase(realName)) continue;
                                                    keycolAdded = true;
                                                }
                                            }
                                            if (key != null && !key.equalsIgnoreCase("fid") && !keycolAdded) {
                                                realkeyName = this.def.getRealAttributeName(key);
                                                attr = nsp1 + realkeyName;
                                                xml = xml + "      <ogc:PropertyName>" + attr + "</ogc:PropertyName>\n";
                                                getrequest = getrequest + "," + nspreq1 + realkeyName;
                                                keycolAdded = true;
                                            }
                                            if ((featIds = this.def.getFeatureIds()) != null) break block137;
                                            validCondition = false;
                                            condition = this.def.getQueryCondition();
                                            wc = null;
                                            wcxml = "";
                                            if (condition != null) {
                                                condition = condition.trim();
                                                wc = new WhereClause();
                                                wc.parse(condition);
                                                if (wc.getRootOperator() != null) {
                                                    validCondition = true;
                                                } else {
                                                    WFSThemeProducer.log.warning("Unable to parse query condition (it is ignored).");
                                                }
                                            }
                                            if (!this.isFullExtent(this.xl, this.yl, this.xh, this.yh)) {
                                                bboxstr = "        <ogc:BBOX>\n          <ogc:PropertyName>" + geomColumn + "</ogc:PropertyName>\n" + "          <gml:Box srsName=\"" + srsinfo + "\" xmlns:gml=\"http://www.opengis.net/gml\">\n" + "               <gml:coordinates decimal=\".\" cs=\",\" ts=\" \">" + this.xl + "," + this.yl + " " + this.xh + "," + this.yh + "</gml:coordinates>\n" + "          </gml:Box>\n" + "        </ogc:BBOX>         \n";
                                                bboxreq = "<BBOX><PropertyName>" + geomColumn1 + "</PropertyName><Box srsName=\"" + srsinfo + "\">" + "<coordinates>" + this.xl + "," + this.yl + " " + this.xh + "," + this.yh + "</coordinates>" + "</Box></BBOX>";
                                                if (version.equals("1.1.0")) {
                                                    bboxstr = "        <ogc:BBOX>\n          <ogc:PropertyName>" + geomColumn + "</ogc:PropertyName>\n" + "          <gml:Envelope srsName=\"" + srsinfo + "\" xmlns:gml=\"http://www.opengis.net/gml\">\n" + "               <gml:lowerCorner>" + this.xl + " " + this.yl + "</gml:lowerCorner>\n" + "               <gml:upperCorner>" + this.xh + " " + this.yh + "</gml:upperCorner>\n" + "          </gml:Envelope>\n" + "        </ogc:BBOX>         \n";
                                                    bboxreq = "<BBOX><PropertyName>" + geomColumn1 + "</PropertyName><Envelope srsName=\"" + srsinfo + "\">" + "<lowerCorner>" + this.xl + " " + this.yl + "</lowerCorner>" + "<upperCorner>" + this.xh + " " + this.yh + "</upperCorner>" + "</Envelope></BBOX>";
                                                    if (!this.def.getIgnoreAxisOrderCheck() && this.def.getReverseAxisOrder()) {
                                                        axisOrder = 2;
                                                    }
                                                }
                                                if (!validCondition) {
                                                    xml = xml + "      <ogc:Filter>\n" + bboxstr + "      </ogc:Filter>\n";
                                                    getrequest = getrequest + "&FILTER=<Filter>" + bboxreq + "</Filter>";
                                                    break block130;
                                                } else {
                                                    xml = xml + "    <ogc:Filter>\n";
                                                    xml = xml + "      <ogc:And>\n" + wc.getAsWFSxml(8, featType.getName(), featType.getNameSpaceAlias()) + bboxstr + "      </ogc:And>\n" + "    </ogc:Filter>\n";
                                                    getrequest = getrequest + "&FILTER=<Filter><And>" + wc.getAsWFSstring() + bboxreq + "</And></Filter>";
                                                }
                                                break block130;
                                            } else {
                                                if (validCondition) {
                                                    xml = xml + "      <ogc:Filter>\n" + wc.getAsWFSxml(8, featType.getName(), featType.getNameSpaceAlias()) + "      </ogc:Filter>\n";
                                                    getrequest = getrequest + "&FILTER=<Filter>" + wc.getAsWFSstring() + " </Filter>";
                                                }
                                                if (version.equals("1.1.0") && !this.def.getIgnoreAxisOrderCheck() && this.def.getReverseAxisOrder()) {
                                                    axisOrder = 2;
                                                }
                                            }
                                            break block130;
                                        }
                                        xml = xml + "      <ogc:Filter>\n";
                                        getrequest = getrequest + "&FEATUREID=";
                                        for (i = 0; i < featIds.length; ++i) {
                                            xml = xml + "<ogc:FeatureId fid=\"" + featIds[i] + "\"/>\n";
                                            getrequest = i == 0 ? getrequest + featIds[i] : getrequest + "," + featIds[i];
                                        }
                                        xml = xml + "      </ogc:Filter>\n";
                                    }
                                    xml = xml + "   </wfs:Query>\n</wfs:GetFeature>";
                                    WFSThemeProducer.log.finest("WFS POST XML: " + xml);
                                    featureSet = new ArrayList<StyledFeatureI>(128);
                                    hurl = new HttpConnection();
                                    hurl.connect(getfeaturePostUrl);
                                    hurl.sendXMLRequest("", xml);
                                    WFSThemeProducer.log.info("Waiting XML response for POST request...");
                                    res = hurl.getXMLResponse();
                                    WFSThemeProducer.log.info("Processing XML POST response...");
                                    if (res != null && res.indexOf("srsName=\"http://www.opengis.net/gml/srs/epsg.xml#") > -1) {
                                        res = res.replaceAll("srsName=\"http://www.opengis.net/gml/srs/epsg.xml#", "srsName=\"EPSG:");
                                    }
                                    parser = new DOMParser();
                                    parser.setValidationMode(0);
                                    parser.setPreserveWhitespace(false);
                                    theReader = new StringReader(res);
                                    parser.parse((Reader)theReader);
                                    doc = parser.getDocument();
                                    theReader.close();
                                    root = doc.getFirstChild();
                                    if (root != null) break block131;
                                    WFSThemeProducer.log.info("Invalid XML response. Root node not found.");
                                    var54_88 = 0;
                                    WFSThemeProducer.wfsSensor.stop(tokenW);
                                    return var54_88;
                                }
                                rootName = WFSThemeProducer.normalize(root.getNodeName());
                                if (!(rootName.equalsIgnoreCase("ServiceExceptionReport") || rootName.equalsIgnoreCase("FeatureCollection") || rootName.equalsIgnoreCase("ExceptionReport"))) {
                                    nodes = doc.getChildNodes();
                                    for (i = 0; i < nodes.getLength(); ++i) {
                                        nd = nodes.item(i);
                                        if (nd.getNodeName().indexOf("ServiceExceptionReport") <= -1 && nd.getNodeName().indexOf("FeatureCollection") <= -1 && nd.getNodeName().indexOf("ExceptionReport") <= -1) continue;
                                        root = nd;
                                        rootName = WFSThemeProducer.normalize(root.getNodeName());
                                        break;
                                    }
                                }
                                if (!rootName.equalsIgnoreCase("ServiceExceptionReport") && !rootName.equalsIgnoreCase("ExceptionReport")) break block132;
                                WFSThemeProducer.log.info("WFS error response for POST request: " + res);
                                if (getfeatureGetUrl == null) break block132;
                                WFSThemeProducer.log.info("Trying WFS GET request: " + getrequest);
                                res = Util.issueHttpGetRequest(getrequest);
                                WFSThemeProducer.log.info("Processing GET response...");
                                parser = new DOMParser();
                                parser.setValidationMode(0);
                                parser.setPreserveWhitespace(false);
                                theReader = new StringReader(res);
                                parser.parse((Reader)theReader);
                                doc = parser.getDocument();
                                theReader.close();
                                root = doc.getFirstChild();
                                if (root != null) break block133;
                                WFSThemeProducer.log.info("Invalid XML response. Root node not found.");
                                nodes = 0;
                                WFSThemeProducer.wfsSensor.stop(tokenW);
                                return nodes;
                            }
                            ** try [egrp 16[TRYBLOCK] [10, 26 : 4896->6528)] { 
lbl372:
                            // 1 sources

                            try {
                                rootName = WFSThemeProducer.normalize(root.getNodeName());
                                if (!(rootName.equalsIgnoreCase("ServiceExceptionReport") || rootName.equalsIgnoreCase("FeatureCollection") || rootName.equalsIgnoreCase("ExceptionReport"))) {
                                    nodes = doc.getChildNodes();
                                }
                                break block134;
                            }
                            catch (Exception e) {
                                WFSThemeProducer.log.severe("Exception: " + e.getMessage());
                                e.printStackTrace();
                                res = 0;
                                WFSThemeProducer.wfsSensor.stop(tokenW);
                                return res;
                            }
lbl384:
                            // 3 sources

                            catch (Throwable var74_118) {
                                throw var74_118;
                            }
                            for (i = 0; i < nodes.getLength(); ++i) {
                                nd = nodes.item(i);
                                if (nd.getNodeName().indexOf("ServiceExceptionReport") <= -1 && nd.getNodeName().indexOf("FeatureCollection") <= -1 && nd.getNodeName().indexOf("ExceptionReport") <= -1) continue;
                                root = nd;
                                rootName = WFSThemeProducer.normalize(root.getNodeName());
                                break;
                            }
                        }
                        if (rootName.equalsIgnoreCase("ServiceExceptionReport") || rootName.equalsIgnoreCase("ExceptionReport")) {
                            WFSThemeProducer.log.info("WFS error response for GET request: " + res);
                        }
                    }
                    if (rootName.equalsIgnoreCase("FeatureCollection")) {
                        ndlist = root.getChildNodes();
                        featureMembersTag = false;
                        if (ndlist != null && ndlist.getLength() > 0 && version.equals("1.1.0") && WFSThemeProducer.normalize(ndlist.item(0).getNodeName()).equalsIgnoreCase("featuremembers")) {
                            ndlist = ndlist.item(0).getChildNodes();
                            featureMembersTag = true;
                        }
                        if (ndlist != null && ndlist.getLength() > 0) {
                            WFSThemeProducer.log.finest("Max features to be prepared: " + this.maxFeaturesToBePrepared);
                            block39: for (i = 0; i < ndlist.getLength() && (this.maxFeaturesToBePrepared <= 0L || (long)featureSet.size() < this.maxFeaturesToBePrepared); ++i) {
                                nd = ndlist.item(i);
                                if (!WFSThemeProducer.normalize(nd.getNodeName()).equalsIgnoreCase("featuremember") && (!version.equals("1.1.0") || !featureMembersTag)) continue;
                                feature = null;
                                if (WFSThemeProducer.normalize(nd.getNodeName()).equalsIgnoreCase("featuremember")) break block135;
                                ndname = WFSThemeProducer.normalize(nd.getNodeName());
                                if (ndname.equalsIgnoreCase(featName)) {
                                    feature = nd;
                                }
lbl412:
                                // 5 sources

                                while (true) {
                                    sf = null;
                                    if (feature != null) {
                                        fid = XMLDOMParser.getAttribute(feature, "fid");
                                        if (fid == null) {
                                            fid = XMLDOMParser.getAttribute(feature, "gml:id");
                                        }
                                        if ((attrs = feature.getChildNodes()) != null) {
                                            for (k = 0; k < attrs.getLength(); ++k) {
                                                child = attrs.item(k);
                                                ndname = WFSThemeProducer.normalize(child.getNodeName());
                                                if (child.getNodeName().indexOf("gml:") > -1) {
                                                    ndname = child.getNodeName();
                                                }
                                                if (!ndname.equalsIgnoreCase(this.def.getSpatialColumn())) continue;
                                                geomchild = this.getGeometryNode(child);
                                                if (geomchild == null) break;
                                                geom = null;
                                                geom = format.equals("GML2") != false ? GML.fromNodeToGeometry((Node)geomchild) : GML3g.fromNodeToGeometry((Node)geomchild);
                                                if (geom == null) break;
                                                if (axisOrder == 2) {
                                                    try {
                                                        geom = GML3g.switchXYOrdinates((JGeometry)geom);
                                                    }
                                                    catch (oracle.spatial.geometry.DataException de) {
                                                        WFSThemeProducer.log.warning("Unable to switch axis order for feature [" + fid + "].\n" + de.getMessage());
                                                    }
                                                    catch (Exception ex) {
                                                        WFSThemeProducer.log.warning("Unable to switch axis order for feature [" + fid + "].\n" + ex.getMessage());
                                                    }
                                                }
                                                sf = this.getNewStyledFeatureInstance();
                                                if (!keycolAdded) {
                                                    sf.setID(fid);
                                                }
                                                jgeom = JSDOGeometry.recast(geom);
                                                jgeom.setSRID(this.def.getSrid());
                                                sf.setGeometry(jgeom);
                                                sf.setDataSource(this.def.getDataSourceName());
                                                sf.setFeatureStyleName(this.def.getRenderStyle());
                                                break;
                                            }
                                            if (sf != null) {
                                                if (this.def.getLabelColumn() != null && this.def.getLabelColumn().equalsIgnoreCase("dummy")) {
                                                    sf.setLabel("dummy");
                                                    sf.setLabelStyleName(this.def.getLabelStyle());
                                                }
                                                attrFields = new Hashtable<String, Field>();
                                                infoFields = new Vector<Field>();
                                                for (k = 0; k < attrs.getLength(); ++k) {
                                                    child = attrs.item(k);
                                                    ndname = WFSThemeProducer.normalize(child.getNodeName());
                                                    if (child.getNodeName().indexOf("gml:") > -1) {
                                                        ndname = child.getNodeName();
                                                    }
                                                    if (ndname.equalsIgnoreCase(this.def.getSpatialColumn()) || (text = child.getFirstChild()) == null) continue;
                                                    value = text.getNodeValue();
                                                    if (this.def.getLabelColumn() != null && this.def.getLabelColumn().equalsIgnoreCase(ndname)) {
                                                        sf.setLabel(value);
                                                        sf.setLabelStyleName(this.def.getLabelStyle());
                                                        if (this.isOnAttributeList(ndname)) {
                                                            fieldType = (String)attrTypes.get(ndname);
                                                            f = Field.createField(value, fieldType);
                                                            f.setName(ndname);
                                                            attrFields.put(ndname, f);
                                                        }
                                                        if ((f = this.getInfoColumn(ndname)) != null && attrTypes != null) {
                                                            fieldType = (String)attrTypes.get(ndname);
                                                            field = Field.createField(value, fieldType);
                                                            field.setName(f.getName());
                                                            field.setDisplayName(f.getDisplayName());
                                                            infoFields.add(field);
                                                        }
                                                        if (!keycolAdded || !ndname.equalsIgnoreCase(key)) continue;
                                                        sf.setID(value);
                                                        continue;
                                                    }
                                                    if (attrTypes == null || (fieldType = (String)attrTypes.get(ndname)) == null) continue;
                                                    if (this.isOnAttributeList(ndname)) {
                                                        f = Field.createField(value, fieldType);
                                                        f.setName(ndname);
                                                        attrFields.put(ndname, f);
                                                    }
                                                    if ((f = this.getInfoColumn(ndname)) != null) {
                                                        fType = (String)attrTypes.get(ndname);
                                                        field = Field.createField(value, fType);
                                                        field.setName(f.getName());
                                                        field.setDisplayName(f.getDisplayName());
                                                        infoFields.add(field);
                                                    }
                                                    if (!keycolAdded || !ndname.equalsIgnoreCase(key)) continue;
                                                    sf.setID(value);
                                                }
                                                if (attrFields.size() > 0 && attrTypes != null) {
                                                    fields = new Vector<Field>();
                                                    featAttrs = this.def.getFeatureAttributes();
                                                    for (at = 0; at < featAttrs.length; ++at) {
                                                        fd = (Field)attrFields.get(featAttrs[at]);
                                                        if (fd == null) continue;
                                                        fields.add(fd);
                                                    }
                                                    if (fields.size() > 0) {
                                                        sf.setRenderableAttributes(fields.toArray(new Field[fields.size()]));
                                                    }
                                                }
                                                if (infoFields.size() > 0) {
                                                    sf.setIdentifiableAttributes(infoFields.toArray(new Field[infoFields.size()]));
                                                }
                                            }
                                        }
                                    }
                                    if (sf == null) continue block39;
                                    featureSet.add(sf);
                                    continue block39;
                                    break;
                                }
                            }
                        }
                    }
                    if (featureSet.size() <= 0) {
                        return 0;
                    }
                    if (vc.getMasterSRID() <= 0 || !transformSRid) break block138;
                    WFSThemeProducer.log.info("Transforming styled features SRID " + this.def.getSrid() + " to map SRID " + vc.getMasterSRID());
                    break block139;
                }
                featureNodes = nd.getChildNodes();
                j = 0;
                while (true) {
                    if (j >= featureNodes.getLength()) ** GOTO lbl412
                    ndname = WFSThemeProducer.normalize(featureNodes.item(j).getNodeName());
                    if (ndname.equalsIgnoreCase(featName)) {
                        feature = featureNodes.item(j);
                        ** continue;
                    }
                    ++j;
                }
            }
            for (i = 0; i < featureSet.size(); ++i) {
                sf = (StyledFeatureI)featureSet.get(i);
                jgeom = sf.getGeometry();
                if (jgeom == null || jgeom.getSRID() <= 0 || jgeom.getSRID() == vc.getMasterSRID()) continue;
                geom = null;
                try {
                    geom = Util.processSRIDConversion(this.owner.getDataSourceName(), jgeom, vc.getMasterSRID());
                }
                catch (Exception e) {
                    geom = null;
                }
                if (geom == null) continue;
                sf.setGeometry(JSDOGeometry.recast(geom));
            }
            WFSThemeProducer.log.info("End of SRID transformation.");
            this.xl = xi;
            this.xh = xf;
            this.yl = yi;
            this.yh = yf;
        }
        if (applyRotation) {
            WFSThemeProducer.log.info("Rotating styled feature geometries.");
            for (i = 0; i < featureSet.size(); ++i) {
                sf = (StyledFeatureI)featureSet.get(i);
                jgeom = sf.getGeometry();
                if (jgeom == null || (geomRot = Util.rotateGeometry(jgeom, (this.xl + this.xh) / 2.0, (this.yl + this.yh) / 2.0, vc.getRotation())) == null || (jgeom = JSDOGeometry.recast(geomRot)) == null) continue;
                sf.setGeometry(JSDOGeometry.recast(jgeom));
            }
        }
        this.setStyledFeatures(featureSet);
        cnt = featureSet.size();
        featureSet = null;
        t1 = System.currentTimeMillis();
        TopThemeQueries.add(t1 - t0, this.getTheme().getName(), this.getTheme().getDataSourceName(), xml, "WFS features loaded = " + cnt);
        return this.features.size();
lbl568:
        // 1 sources

        finally {
            WFSThemeProducer.wfsSensor.stop(tokenW);
        }
    }

    private Field getInfoColumn(String infocol) {
        if (infocol == null) {
            return null;
        }
        Field[] infos = this.def.getIdentifiableColumns();
        if (infos == null) {
            return null;
        }
        for (int i = 0; i < infos.length; ++i) {
            Field f = infos[i];
            if (!f.getName().equalsIgnoreCase(infocol)) continue;
            return f;
        }
        return null;
    }

    private boolean isOnAttributeList(String column) {
        if (column == null) {
            return false;
        }
        String[] attrs = this.def.getFeatureAttributes();
        if (attrs == null) {
            return false;
        }
        for (int i = 0; i < attrs.length; ++i) {
            String s = attrs[i];
            if (!s.equalsIgnoreCase(column)) continue;
            return true;
        }
        return false;
    }

    private String getGeometryString(JSDOGeometry geom) {
        if (geom == null) {
            return null;
        }
        int type = geom.getType();
        if (type < 1 || type > 7) {
            return null;
        }
        double[] pts = geom.getPoint();
        String xyz = "null";
        if (pts != null) {
            xyz = "MDSYS.SDO_POINT(" + pts[0] + "," + pts[1] + ",";
            xyz = pts.length > 2 ? (pts[2] != Double.NaN ? xyz + pts[2] + ")" : xyz + "null)") : xyz + "null)";
        }
        int srid = geom.getSRID();
        int gtype = 2000 + type;
        String elinfo = "null";
        int[] elemInfo = geom.getElemInfo();
        if (elemInfo != null) {
            elinfo = "MDSYS.SDO_ELEM_INFO_ARRAY(" + elemInfo[0];
            for (int i = 1; i < elemInfo.length; ++i) {
                elinfo = elinfo + "," + elemInfo[i];
            }
            elinfo = elinfo + ")";
        }
        String ordarray = "null";
        double[] ordArray = geom.getOrdinatesArray();
        if (ordArray != null) {
            ordarray = "MDSYS.SDO_ORDINATE_ARRAY(" + ordArray[0];
            for (int i = 1; i < ordArray.length; ++i) {
                ordarray = ordarray + "," + ordArray[i];
            }
            ordarray = ordarray + ")";
        }
        String geomstr = "MDSYS.SDO_GEOMETRY(" + gtype + "," + srid + "," + xyz + "," + elinfo + "," + ordarray + ")";
        System.out.println("Geom str: " + geomstr);
        return geomstr;
    }

    public static String normalize(String nodeName) {
        if (nodeName == null) {
            return null;
        }
        if (nodeName.indexOf(":") >= 0) {
            return nodeName.substring(nodeName.indexOf(":") + 1);
        }
        return nodeName;
    }

    private boolean isFullExtent(double xl, double yl, double xh, double yh) {
        return Double.isInfinite(xl) || Double.isNaN(xl) || Double.isInfinite(yl) || Double.isNaN(yl) || Double.isInfinite(xh) || Double.isNaN(xh) || Double.isInfinite(yh) || Double.isNaN(yh);
    }

    private Node getGeometryNode(Node parent) {
        if (parent == null) {
            return null;
        }
        NodeList nds = parent.getChildNodes();
        if (nds == null) {
            return null;
        }
        for (int i = 0; i < nds.getLength(); ++i) {
            Node nd = nds.item(i);
            String name = WFSThemeProducer.normalize(nd.getNodeName()).toUpperCase();
            if (!name.equals("POINT") && !name.equals("LINESTRING") && !name.equals("POLYGON") && !name.equals("SURFACE") && !name.equals("MULTISURFACE") && !name.equals("MULTIPOINT") && !name.equals("MULTILINESTRING") && !name.equals("BOX") && !name.equals("LINEARRING") && !name.equals("MULTIPOLYGON") && !name.equals("MULTIGEOMETRY")) continue;
            return nd;
        }
        return null;
    }

    @Override
    public StyledFeatureI getNewStyledFeatureInstance() {
        return new StyledFeature();
    }

    @Override
    public void destroy() {
        this.clearFeatures();
    }

    @Override
    public void abort() {
    }

    private void clearFeatures() {
        if (this.features != null) {
            this.features.setStyledFeatures((List)null);
        }
    }

    @Override
    public StyledFeatureI[] getSelectedFeatures(Rectangle2D window) {
        if (this.features == null) {
            return null;
        }
        return this.features.getSelectedFeatures(window);
    }

    @Override
    public LocalTheme getSelectedFeaturesAsTheme(Rectangle2D window, String name) {
        if (this.features == null) {
            return null;
        }
        return this.features.getSelectedFeaturesAsTheme(window, name);
    }

    @Override
    public void setStyledFeatures(StyledFeatureI[] sfs) {
        this.features = new LocalThemeDataProducer(this.getTheme());
        this.features.setStyledFeatures(sfs);
    }

    public void setStyledFeatures(ArrayList sfs) {
        this.features = new LocalThemeDataProducer(this.getTheme());
        this.features.setStyledFeatures(sfs);
    }

    @Override
    public Theme getTheme() {
        return this.owner;
    }

    @Override
    public StyledFeatureI[] getStyledFeatures() {
        if (this.features == null) {
            return null;
        }
        return this.features.getStyledFeatures();
    }

    @Override
    public StyledFeatureI getStyledFeature(int idx) {
        if (this.features == null) {
            return null;
        }
        return this.features.getStyledFeature(idx);
    }

    @Override
    public double[] getDataMBR() {
        if (this.features == null) {
            return null;
        }
        return this.features.getDataMBR();
    }

    @Override
    public void postPreparation(VisContext vc) {
        if (this.features != null) {
            this.features.postPreparation(vc);
        }
    }

    @Override
    public int size() {
        return this.features != null ? this.features.size() : 0;
    }

    @Override
    public long getMaxFeaturesToBePrepared() {
        return this.maxFeaturesToBePrepared;
    }

    @Override
    public void setMaxFeaturesToBePrepared(long size) {
        this.maxFeaturesToBePrepared = size;
    }
}

