/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stylex;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.stylex.PieChartStyleModel;
import oracle.mapviewer.share.stylex.PieSliceInfo;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SphereCG;
import oracle.sdovis.LabelHelper;
import oracle.sdovis.SRS;
import oracle.sdovis.StyleCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.charts.piechart.PieChart;
import oracle.sdovis.charts.types.PieSliceDesc;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.stylex.AdvancedStyle;
import oracle.sdovis.stylex.PieChartStyleModifiers;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.RectArray;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PieChartStyle
implements AdvancedStyle {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private PieChartStyleModel bean;
    private boolean ignoreSliceDescName = false;

    public PieChartStyle() {
        this.bean = new PieChartStyleModel();
    }

    public PieChartStyle(StyleModel model) {
        this.setModel(model);
    }

    public PieChartStyle(int pieRadius, PieSliceInfo[] psi) {
        this.bean = new PieChartStyleModel(pieRadius, psi);
    }

    public PieChartStyle(Document doc) throws StyleException {
        this.bean = new PieChartStyleModel();
        try {
            Color color;
            Node elem = XMLDOMParser.getSubElement(doc, "AdvancedStyle");
            elem = XMLDOMParser.getSubElement(elem, "PieChartStyle");
            String pierd = XMLDOMParser.getAttribute(elem, "pieradius");
            SizeDefinition pierdsize = SizeDefinition.parse(pierd);
            if (pierdsize == null) {
                throw new StyleException("Invalid pie radius size in PieChartStyle definition.");
            }
            this.bean.setPieRadiusSize(pierdsize);
            this.bean.setPieRadiusUnit(pierdsize.getUnit());
            String strokeColor = XMLDOMParser.getAttribute(elem, "stroke");
            if (strokeColor != null && strokeColor.trim().length() > 0 && (color = StyleUtils.getColor(strokeColor.trim())) != null) {
                String stroke_opacity = XMLDOMParser.getAttribute(elem, "stroke-opacity");
                if (stroke_opacity != null) {
                    try {
                        int value = Integer.parseInt(stroke_opacity);
                        if (value < 0 || value > 255) {
                            log.warning("Stroke opacity value out of range [0,255].");
                        } else {
                            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), value);
                        }
                    }
                    catch (Exception ex) {
                        log.warning("Invalid stroke opacity value: " + stroke_opacity);
                    }
                }
                this.bean.setStrokeColor(color);
            }
            ArrayList nl = XMLDOMParser.getSubElements(elem, "PieSlice");
            this.bean.setNumSlices(nl.size());
            PieSliceInfo[] psi = new PieSliceInfo[nl.size()];
            for (int i = 0; i < nl.size(); ++i) {
                Node el = (Node)nl.get(i);
                PieSliceInfo _psi = new PieSliceInfo();
                _psi.setName(XMLDOMParser.getAttribute(el, "name"));
                try {
                    _psi.setColor(StyleUtils.getColor(XMLDOMParser.getAttribute(el, "color")));
                }
                catch (Exception e) {
                    _psi.setColor(null);
                }
                psi[i] = _psi;
            }
            this.bean.setPieSlices(psi);
        }
        catch (Exception e) {
            throw new StyleException("Invalid PieChartStyle definition.");
        }
    }

    public Object clone() {
        try {
            PieChartStyle sty = (PieChartStyle)super.clone();
            sty.setModel((StyleModel)this.bean.clone());
            return sty;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    @Override
    public String getDefinition() {
        return this.bean.toXMLString();
    }

    public int getPieRadius() {
        return this.bean.getPieRadius();
    }

    public double getDoublePieRadius() {
        return this.bean.getDoublePieRadius();
    }

    public void setPieRadius(int r) {
        this.bean.setPieRadius(r);
    }

    public void setPieRadius(double r) {
        this.bean.setPieRadius(r);
    }

    public void setPieRadiusUnit(String unit) {
        this.bean.setPieRadiusUnit(unit);
    }

    public String getPieRadiusUnit() {
        return this.bean.getPieRadiusUnit();
    }

    public int getNumSlices() {
        return this.bean.getNumSlices();
    }

    public void setNumSlices(int n) {
        this.bean.setNumSlices(n);
    }

    public Color getStrokeColor() {
        return this.bean.getStrokeColor();
    }

    public void setStrokeColor(Color c) {
        this.bean.setStrokeColor(c);
    }

    @Override
    public int getMaxLegendWidth(Graphics2D g, int fontSize) {
        int curWidth = 0;
        int maxWidth = 0;
        Font defaultFont = new Font("Serif", 0, fontSize);
        String label = null;
        PieSliceInfo[] psi = this.bean.getPieSlices();
        FontRenderContext frc = g == null ? new FontRenderContext(null, true, false) : g.getFontRenderContext();
        for (int i = 0; i < this.getNumSlices(); ++i) {
            label = psi[i].getName();
            if (label == null || label.length() == 0 || (curWidth = (int)defaultFont.getStringBounds(label, frc).getWidth()) <= maxWidth) continue;
            maxWidth = curWidth;
        }
        return maxWidth;
    }

    @Override
    public boolean resolveStyles(StyleCache sc, Hashtable dynaStyles) {
        return true;
    }

    @Override
    public boolean refreshResolvedStyles(StyleCache sc, Hashtable dynaStyles) {
        return this.resolveStyles(sc, dynaStyles);
    }

    @Override
    public StyleModel getModel() {
        return this.bean;
    }

    @Override
    public void setModel(StyleModel model) {
        if (!(model instanceof PieChartStyleModel)) {
            throw new IllegalArgumentException("Not a PieChartStyleModel instance.");
        }
        this.bean = (PieChartStyleModel)model;
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, float x, float y, StyleModifiers stymods) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("PieChartStyle not applicable to a point.");
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Rectangle2D rect, StyleModifiers stymods) throws StyleNotApplicableException {
        AffineTransform oldXfm = g.getTransform();
        try {
            int x = (int)rect.getMinX();
            int y = (int)rect.getMinY();
            int numSlices = this.bean.getNumSlices();
            PieSliceInfo[] psi = this.bean.getPieSlices();
            PieSliceDesc[] slices = new PieSliceDesc[numSlices];
            for (int i = 0; i < numSlices; ++i) {
                slices[i] = !this.ignoreSliceDescName ? new PieSliceDesc(psi[i].getName(), 25.0) : new PieSliceDesc(null, 25.0);
                slices[i].setBackground(psi[i].getColor());
            }
            PieChart pc = new PieChart();
            pc.setSize((int)rect.getWidth(), (int)rect.getHeight());
            pc.setBackground(null);
            pc.setBackgroundRectOff();
            pc.setSeries(slices);
            if (!this.ignoreSliceDescName) {
                pc.setLastWordNewline();
            }
            pc.setBorderLeft(0);
            pc.setBorderRight(0);
            pc.setBorderTop(0);
            pc.setBorderBottom(0);
            pc.setForeground(this.bean.getStrokeColor());
            g.translate(x, y);
            pc.drawBuffer(g);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
        g.setTransform(oldXfm);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, StyleModifiers stymods) throws StyleNotApplicableException {
        if (!(shp instanceof Rectangle2D)) {
            throw new StyleNotApplicableException("PieChartStyle not applicable without values.");
        }
        this.apply(null, g, (Rectangle2D)shp, stymods);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, StyleModifiers stymods) throws StyleNotApplicableException {
        int w = this.bean.getPieRadius() * 2;
        if (stymods != null && stymods instanceof PieChartStyleModifiers) {
            w = ((PieChartStyleModifiers)stymods).getPieRadius() * 2;
        }
        if (w < 1) {
            return;
        }
        int h = w;
        if (labelPoint == null) {
            if (gtype == 3 || gtype == 7) {
                float[] pos = LabelHelper.findLoc4RectInPolygon(shp, 5.0, 5.0, (RectArray)cr, true, false, null);
                if (pos != null) {
                    labelPoint = new Point2D.Float(pos[0], pos[1]);
                }
            } else {
                return;
            }
        }
        if (labelPoint != null && cr != null) {
            cr.insert(labelPoint.getX() - (double)(w / 2), labelPoint.getY() - (double)(h / 2), (double)w, (double)h);
        }
        int numSlices = this.bean.getNumSlices();
        if (values == null || values.length < numSlices) {
            log.warning("Insufficient attribute fields for the given pie chart style.");
            return;
        }
        double[] vs = new double[numSlices];
        try {
            for (int i = 0; i < numSlices; ++i) {
                vs[i] = values[i].getShortJavaTypeName().equalsIgnoreCase("string") ? Double.parseDouble(values[i].getString()) : values[i].getDouble();
            }
        }
        catch (Exception e) {
            log.warning("invalid (type of) values for PieChartStyle.");
            return;
        }
        int cx = (int)labelPoint.getX();
        int cy = (int)labelPoint.getY();
        PieSliceInfo[] psi = this.bean.getPieSlices();
        PieSliceDesc[] slices = new PieSliceDesc[numSlices];
        for (int i = 0; i < numSlices; ++i) {
            slices[i] = new PieSliceDesc(null, vs[i]);
            slices[i].setBackground(psi[i].getColor());
        }
        PieChart pc = new PieChart();
        w = (int)((double)this.bean.getPieRadius() * 2.0);
        if (stymods != null && stymods instanceof PieChartStyleModifiers) {
            w = ((PieChartStyleModifiers)stymods).getPieRadius() * 2;
        }
        h = w;
        pc.setSize(w, h);
        pc.setBackground(null);
        pc.setBackgroundRectOff();
        pc.setBorderLeft(0);
        pc.setBorderRight(0);
        pc.setBorderTop(0);
        pc.setBorderBottom(0);
        pc.setForeground(this.bean.getStrokeColor());
        AffineTransform oldXfm = g.getTransform();
        try {
            pc.setSeries(slices);
            g.translate(cx - w / 2, cy - h / 2);
            pc.drawBuffer(g);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        g.setTransform(oldXfm);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, StyleModifiers stymods) throws StyleNotApplicableException {
        if (values == null) {
            throw new StyleNotApplicableException("PieChartStyle not applicable without attribute values.");
        }
        int numSlices = this.bean.getNumSlices();
        if (styleColumns == null) {
            this.apply(null, g, shp, gtype, label, labelPoint, cr, values, stymods);
        } else {
            if (numSlices < 1) {
                throw new StyleNotApplicableException("PieChartStyle must have at least one slice.");
            }
            if (styleColumns.length < numSlices) {
                throw new StyleNotApplicableException("Not enough style columns for PieChartStyle.");
            }
            Field[] svalue = new Field[numSlices];
            for (int i = 0; i < styleColumns.length; ++i) {
                svalue[i] = null;
                String column = styleColumns[i];
                svalue[i] = Util.getField(column, values);
                if (svalue[i] != null) continue;
                throw new StyleNotApplicableException("Unable to find attribute " + column + " for PieChartStyle.");
            }
            this.apply(null, g, shp, gtype, label, labelPoint, cr, svalue, stymods);
        }
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, Style subStyle, String[] substyleColumns, String changeProperty, StyleModifiers stymods) throws StyleNotApplicableException {
        if (styleColumns == null) {
            this.apply(null, g, shp, gtype, label, labelPoint, cr, values, stymods);
        } else {
            this.apply(null, g, shp, gtype, label, labelPoint, cr, values, styleColumns, stymods);
        }
    }

    @Override
    public Object getPropertyValue(String propertyType) {
        return null;
    }

    public boolean ignoreSliceDescriptionName() {
        return this.ignoreSliceDescName;
    }

    public void ignoreSliceDescriptionName(boolean ignore) {
        this.ignoreSliceDescName = ignore;
    }

    @Override
    public StyleModifiers convertToPixelSize(VisContext vc) {
        if (this.isPixelUnit(this.bean.getPieRadiusUnit())) {
            return null;
        }
        PieChartStyleModifiers piemods = new PieChartStyleModifiers();
        if (vc == null || Util.isFullExtent(vc.getQueryWindow().getMinX(), vc.getQueryWindow().getMinX(), vc.getQueryWindow().getMaxX(), vc.getQueryWindow().getMaxY()) || vc.getQueryWindow().getWidth() == 0.0 && vc.getQueryWindow().getHeight() == 0.0) {
            if (this.isPixelUnit(this.bean.getPieRadiusUnit())) {
                piemods.setPieRadius(this.bean.getPieRadius());
            }
        } else {
            double pixelY;
            Rectangle2D devW = vc.getDeviceWindow();
            Rectangle2D queW = vc.getQueryWindow();
            double pixelX = queW.getWidth() / devW.getWidth();
            double pixel = pixelY = queW.getHeight() / devW.getHeight();
            Double convFactor = null;
            if (this.bean.getPieRadiusUnit() != null) {
                convFactor = SRS.getDistanceConversionFactor(this.bean.getPieRadiusUnit());
            }
            if (this.isPixelUnit(this.bean.getPieRadiusUnit())) {
                piemods.setPieRadius(this.bean.getPieRadius());
            } else if (convFactor != null) {
                double pierd = this.bean.getDoublePieRadius() * convFactor;
                if (vc.getSrs() != null && vc.getSrs().isGeodetic()) {
                    double dgw = SphereCG.convertRadius(0.0, 0.0, pierd);
                    piemods.setPieRadius((int)(dgw / pixel + 0.5));
                } else {
                    piemods.setPieRadius((int)(pierd / pixel + 0.5));
                }
            }
        }
        return piemods;
    }

    private boolean isPixelUnit(String unit) {
        return unit == null || unit.equalsIgnoreCase("px") || unit.equalsIgnoreCase("pt");
    }
}

