/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.raytracing;

import javax.vecmath.Point2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import oracle.sdovis.raytracing.Camera;
import oracle.sdovis.raytracing.Ray;

public class PerspectiveCamera
implements Camera {
    private Vector3d center;
    private Vector3d proj;
    private Vector3d up;
    private Vector3d horiz;
    private double angle;
    private double focus;
    private double size;

    public Vector3d getHoriz() {
        return this.horiz;
    }

    public Vector3d getUp() {
        return this.up;
    }

    public PerspectiveCamera(Vector3d center_, Vector3d direction, Vector3d up_, double angle_) {
        this.center = center_;
        this.proj = direction;
        this.proj.normalize();
        this.up = up_;
        this.up.normalize();
        this.horiz = new Vector3d();
        this.horiz.cross(this.proj, this.up);
        this.horiz.normalize();
        this.up.cross(this.horiz, this.proj);
        this.up.normalize();
        this.angle = angle_;
        this.size = 2.0 * Math.tan(this.angle / 2.0);
    }

    @Override
    public Ray generateRay(Point2d point) {
        Vector3d inta = new Vector3d();
        inta.scale((point.x - 0.5) * this.size, (Tuple3d)this.horiz);
        Vector3d intb = new Vector3d();
        intb.scale((point.y - 0.5) * this.size, (Tuple3d)this.up);
        Vector3d newDir = new Vector3d();
        newDir.add((Tuple3d)inta, (Tuple3d)intb);
        newDir.add((Tuple3d)this.proj);
        newDir.normalize();
        Ray newRay = new Ray(newDir, this.center);
        return newRay;
    }
}

