/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.NorthArrow;
import oracle.mapviewer.share.ScaleBar;
import oracle.mapviewer.share.style.MarkerStyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.style.TextStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CustomLogo;
import oracle.sdovis.GeoRasterTheme;
import oracle.sdovis.GlobalVisContext;
import oracle.sdovis.ImageRenderer;
import oracle.sdovis.ImageTheme;
import oracle.sdovis.Legend;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapCacheTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.PredefinedGeometryTheme;
import oracle.sdovis.Proj;
import oracle.sdovis.ScaleBarRenderer;
import oracle.sdovis.ShadedReliefTheme;
import oracle.sdovis.StyleCache;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.ThemeList;
import oracle.sdovis.UTFGrid;
import oracle.sdovis.VectorRenderer;
import oracle.sdovis.VisContext;
import oracle.sdovis.WMSMapTheme;
import oracle.sdovis.XFViewPort;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.style.StyleLine;
import oracle.sdovis.style.StyleMarker;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.stylex.BucketStyle;
import oracle.sdovis.stylex.ColorSchemeStyle;
import oracle.sdovis.stylex.VariableMarkerStyle;
import oracle.sdovis.stylex.VariablePieChartStyle;
import oracle.sdovis.theme.MapCacheThemeProducer;
import oracle.sdovis.theme.PredGeomThemeDefinition;
import oracle.sdovis.theme.PredGeomThemeProducer;
import oracle.sdovis.theme.ThemeDefinition;
import oracle.sdovis.theme.WMSMapThemeDefinition;
import oracle.sdovis.theme.WMSMapThemeProducer;
import oracle.sdovis.util.ImageUtils;
import oracle.sdovis.util.RenderingUtils;

public class RenderingEngine {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    VectorRenderer vecRenderer = new VectorRenderer();
    ImageRenderer imgRenderer = new ImageRenderer();
    MapMaker mapper = null;
    boolean localthemesInLegend = false;

    public VectorRenderer getVectorRenderer() {
        return this.vecRenderer;
    }

    public ImageRenderer getImageRenderer() {
        return this.imgRenderer;
    }

    public void setMapper(MapMaker mapmk) {
        this.mapper = mapmk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Graphics2D g2, VisContext vc) {
        Composite cOld;
        MapCacheThemeProducer p;
        WMSMapThemeProducer wtp;
        Theme theme;
        int i;
        this.prepareForRendering(vc);
        Rectangle2D mDeviceView = vc.getDeviceWindow();
        Composite oldComp = g2.getComposite();
        Color mBackgroundColor = vc.getBgColor();
        if (mBackgroundColor != null) {
            if (vc.isPDFformatRequest()) {
                if (vc.getDeviceType() == 1) {
                    g2.setColor(mBackgroundColor);
                } else if (vc.getDeviceType() == 3) {
                    g2.setColor(Color.white);
                } else {
                    g2.setColor(mBackgroundColor);
                }
                if (vc.getTransparent()) {
                    g2.setColor(new Color(1, 1, 1, 0));
                }
                g2.fillRect((int)mDeviceView.getMinX(), (int)mDeviceView.getMinY(), (int)(mDeviceView.getMaxX() - mDeviceView.getMinX()), (int)(mDeviceView.getMaxY() - mDeviceView.getMinY()));
            } else {
                if (vc.getDeviceType() == 1) {
                    g2.setBackground(mBackgroundColor);
                } else if (vc.getDeviceType() == 3) {
                    g2.setBackground(Color.white);
                } else {
                    g2.setBackground(mBackgroundColor);
                }
                if (vc.getTransparent()) {
                    if (vc.getDeviceType() == 3) {
                        g2.setBackground(new Color(255, 255, 255, 0));
                    } else {
                        g2.setBackground(new Color(mBackgroundColor.getRed(), mBackgroundColor.getGreen(), mBackgroundColor.getBlue(), 0));
                    }
                    g2.setComposite(AlphaComposite.getInstance(1, 0.0f));
                }
                g2.clearRect((int)mDeviceView.getMinX(), (int)mDeviceView.getMinY(), (int)(mDeviceView.getMaxX() - mDeviceView.getMinX()), (int)(mDeviceView.getMaxY() - mDeviceView.getMinY()));
                if (vc.getTransparent()) {
                    g2.setComposite(oldComp);
                }
            }
        } else if (vc.isTileRequest()) {
            g2.setBackground(new Color(1, 1, 1, 0));
            g2.setComposite(AlphaComposite.getInstance(1, 0.0f));
            g2.clearRect((int)mDeviceView.getMinX(), (int)mDeviceView.getMinY(), (int)(mDeviceView.getMaxX() - mDeviceView.getMinX()), (int)(mDeviceView.getMaxY() - mDeviceView.getMinY()));
            g2.setComposite(oldComp);
        }
        Image mBackgroundImage = vc.getBgImage();
        if (mBackgroundImage != null) {
            g2.drawImage(mBackgroundImage, 0, 0, (int)(mDeviceView.getMaxX() - mDeviceView.getMinX()), (int)(mDeviceView.getMaxY() - mDeviceView.getMinY()), null);
        }
        this.vecRenderer.prepare(vc);
        double currentScale = vc.getCurrentScale();
        ThemeList themes = vc.getThemeList();
        ArrayList<Theme> utfGridThemes = null;
        UTFGrid utfGrid = null;
        if (vc.isWithUTFGrid()) {
            utfGridThemes = new ArrayList<Theme>();
            utfGrid = vc.initUTFGrid();
        }
        int lastLineThemeIdx = this.findLastCasedLineTheme(themes, vc);
        String copyright = null;
        for (i = 0; i < themes.size(); ++i) {
            String c;
            theme = themes.getTheme(i);
            if (theme == null) continue;
            if ((theme instanceof ImageTheme || theme instanceof GeoRasterTheme || theme instanceof ShadedReliefTheme) && !vc.getKeepThemesOrder()) {
                this.imgRenderer.render(g2, theme, vc);
                continue;
            }
            if (theme instanceof WMSMapTheme && !vc.getKeepThemesOrder() && ((WMSMapTheme)theme).getIsBackgroundImage()) {
                wtp = (WMSMapThemeProducer)theme.getProducer();
                Image wmsMap = wtp.getWMSMap();
                if (wmsMap == null) continue;
                this.renderWMSImage(wmsMap, theme, vc, g2);
                continue;
            }
            if (!(theme instanceof MapCacheTheme) || vc.getKeepThemesOrder()) continue;
            p = (MapCacheThemeProducer)theme.getProducer();
            Image cachedMap = p.getThemeImage();
            if (cachedMap != null) {
                if (vc.getRotation() == 0.0) {
                    int w = (int)vc.getDeviceWindow().getWidth();
                    int h = (int)vc.getDeviceWindow().getHeight();
                    float alpha = theme.getDecorator().getOpacity();
                    if (alpha >= 0.0f && alpha < 1.0f) {
                        cOld = g2.getComposite();
                        g2.setComposite(AlphaComposite.getInstance(3, alpha));
                        g2.drawImage(cachedMap, 0, 0, w, h, null);
                        g2.setComposite(cOld);
                    } else {
                        g2.drawImage(cachedMap, 0, 0, w, h, null);
                    }
                } else {
                    ImageRenderer.renderImage(g2, cachedMap, p.getDataMBR(), theme.getDecorator().getOpacity(), vc);
                }
            }
            if (vc.getFootnote() != null || ((MapCacheTheme)theme).getCacheInstance() == null || (c = ((MapCacheTheme)theme).getCacheInstance().getConfig().getCopyright()) == null) continue;
            copyright = copyright == null ? c : copyright + "; " + c;
        }
        if (copyright != null) {
            vc.setFootnote(copyright);
        }
        if (!vc.renderRasterOnly()) {
            int i2;
            for (i = 0; i < themes.size(); ++i) {
                theme = themes.getTheme(i);
                if (theme != null) {
                    if ((theme instanceof ImageTheme || theme instanceof GeoRasterTheme || theme instanceof ShadedReliefTheme) && vc.getKeepThemesOrder()) {
                        this.imgRenderer.render(g2, theme, vc);
                        continue;
                    }
                    if (theme instanceof WMSMapTheme && (vc.getKeepThemesOrder() || !((WMSMapTheme)theme).getIsBackgroundImage())) {
                        wtp = (WMSMapThemeProducer)theme.getProducer();
                        Image wmsMap = wtp.getWMSMap();
                        if (wmsMap == null) continue;
                        this.renderWMSImage(wmsMap, theme, vc, g2);
                        continue;
                    }
                    if (theme instanceof MapCacheTheme && vc.getKeepThemesOrder()) {
                        p = (MapCacheThemeProducer)theme.getProducer();
                        Image cachedMap = p.getThemeImage();
                        if (cachedMap == null) continue;
                        if (vc.getRotation() == 0.0) {
                            int w = (int)vc.getDeviceWindow().getWidth();
                            int h = (int)vc.getDeviceWindow().getHeight();
                            float alpha = theme.getDecorator().getOpacity();
                            if (alpha >= 0.0f && alpha < 1.0f) {
                                cOld = g2.getComposite();
                                g2.setComposite(AlphaComposite.getInstance(3, alpha));
                                g2.drawImage(cachedMap, 0, 0, w, h, null);
                                g2.setComposite(cOld);
                                continue;
                            }
                            g2.drawImage(cachedMap, 0, 0, w, h, null);
                            continue;
                        }
                        ImageRenderer.renderImage(g2, cachedMap, p.getDataMBR(), theme.getDecorator().getOpacity(), vc);
                        continue;
                    }
                    if (vc.renderRasterOnly()) continue;
                    BufferedImage bimage = vc.getMapImage();
                    float alpha = theme.getDecorator().getOpacity();
                    if (alpha >= 0.0f && alpha < 1.0f) {
                        BufferedImage argbimage = new BufferedImage(bimage.getWidth(), bimage.getHeight(), 2);
                        Graphics2D gg = argbimage.createGraphics();
                        this.vecRenderer.render(gg, theme, vc);
                        gg.dispose();
                        Composite cOld2 = g2.getComposite();
                        g2.setComposite(AlphaComposite.getInstance(3, alpha));
                        g2.drawImage((Image)argbimage, 0, 0, null);
                        g2.setComposite(cOld2);
                        argbimage.flush();
                        argbimage = null;
                        continue;
                    }
                    this.vecRenderer.render(g2, theme, vc);
                    if (lastLineThemeIdx >= 0 && i >= lastLineThemeIdx) {
                        try {
                            if (vc.getCasedLines().size() > 0) {
                                vc.getCasedLines().renderCasedLines(g2, vc);
                            }
                        }
                        catch (Exception e) {
                            log.log(Level.WARNING, "exception while rendering cased lines.", e);
                        }
                        finally {
                            lastLineThemeIdx = -1;
                        }
                    }
                    if (!vc.isWithUTFGrid() || this.vecRenderer.isHeatMapTheme(theme, vc)) continue;
                    utfGridThemes.add(theme);
                    continue;
                }
                log.fine("theme is null or out of scale range.");
            }
            if (vc.isWithUTFGrid()) {
                StringBuilder sb = new StringBuilder();
                sb.append("{");
                for (int k = 0; k < utfGridThemes.size(); ++k) {
                    Theme utft = (Theme)utfGridThemes.get(k);
                    if (this.vecRenderer.isHeatMapTheme(utft, vc)) continue;
                    sb.append("\"" + utft.getName() + "\":{");
                    BufferedImage argbimage = new BufferedImage(vc.getMapImage().getWidth(), vc.getMapImage().getHeight(), 2);
                    Graphics2D gg = argbimage.createGraphics();
                    gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    this.vecRenderer.renderUTFGrid(gg, utft, vc, VisContext.STYLE_UTFGRID);
                    gg.dispose();
                    vc.getUTFGrid().setGrid(utft.getName(), argbimage);
                    argbimage.flush();
                    argbimage = null;
                    String str1 = vc.getUTFGrid().toString();
                    sb.append(str1);
                    sb.append("}");
                    sb.append(",");
                }
                sb.append("\"resolution\":\"" + vc.getUTFGrid().getGridResolution() + "\",");
                sb.append("\"rows\":\"" + vc.getUTFGrid().getGridHeight() + "\",");
                sb.append("\"columns\":\"" + vc.getUTFGrid().getGridWidth() + "\"");
                sb.append("}");
                vc.getUTFGrid().setUTFGridPack(sb.toString());
                utfGrid.clear();
            }
            Vector<Theme> tmp = new Vector<Theme>(themes.size());
            for (int i3 = 0; i3 < themes.size(); ++i3) {
                Theme t = themes.getTheme(i3);
                if (t instanceof ImageTheme || t instanceof GeoRasterTheme || t instanceof ShadedReliefTheme || t instanceof WMSMapTheme) continue;
                if (t.isTextLabelPresent()) {
                    tmp.addElement(t);
                    continue;
                }
                tmp.insertElementAt(t, 0);
            }
            Hashtable<String, Theme> baseMapThemesToBeLabeled = new Hashtable<String, Theme>();
            for (i2 = 0; i2 < tmp.size(); ++i2) {
                String key;
                Theme theme2 = (Theme)tmp.elementAt(i2);
                if (!theme2.getShowLabels() || !theme2.withinRenderScaleLimits(vc.getCurrentScale()) || !(theme2 instanceof PredefinedGeometryTheme)) continue;
                PredefinedGeometryTheme pt = (PredefinedGeometryTheme)theme2;
                if (((PredGeomThemeProducer)theme2.getProducer()).getBindingParameters() != null || baseMapThemesToBeLabeled.get(key = ((PredefinedGeometryTheme)theme2).getDataSourceName() + "." + ((PredefinedGeometryTheme)theme2).getName()) != null) continue;
                baseMapThemesToBeLabeled.put(key, theme2);
            }
            for (i2 = tmp.size() - 1; i2 >= 0; --i2) {
                String key;
                Theme t;
                Theme theme3 = (Theme)tmp.elementAt(i2);
                if (!theme3.getShowLabels() || theme3 instanceof PredefinedGeometryTheme && ((PredGeomThemeProducer)theme3.getProducer()).getBindingParameters() == null && (t = (Theme)baseMapThemesToBeLabeled.get(key = ((PredefinedGeometryTheme)theme3).getDataSourceName() + "." + ((PredefinedGeometryTheme)theme3).getName())) != null && t != theme3 || theme3 == null || vc.renderRasterOnly()) continue;
                BufferedImage bimage = vc.getMapImage();
                float alpha = theme3.getDecorator().getOpacity();
                if (alpha >= 0.0f && alpha < 1.0f) {
                    BufferedImage argbimage = new BufferedImage(bimage.getWidth(), bimage.getHeight(), 2);
                    Graphics2D gg = argbimage.createGraphics();
                    this.vecRenderer.label(gg, theme3, vc);
                    gg.dispose();
                    Composite cOld3 = g2.getComposite();
                    g2.setComposite(AlphaComposite.getInstance(3, alpha));
                    g2.drawImage((Image)argbimage, 0, 0, null);
                    g2.setComposite(cOld3);
                    argbimage.flush();
                    argbimage = null;
                    continue;
                }
                this.vecRenderer.label(g2, theme3, vc);
            }
            this.renderMapTitle(g2, vc);
            this.renderMapFootNote(g2, vc);
            try {
                this.renderMapLogo(g2, vc);
                this.renderMapLengend(g2, vc);
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "error rendering logo and/or legend.", ex);
            }
        }
        this.renderScaleBar(g2, vc);
        this.renderNorthArrow(g2, vc);
        vc.setLastMapScale(vc.getCurrentScale());
        if (GlobalVisContext.showQueryWindow) {
            ArrayList<StyledFeature> al = new ArrayList<StyledFeature>(1);
            StyledFeature sf = new StyledFeature();
            sf.setShape(vc.getQueryWindow());
            sf.setGeomType(2);
            sf.setFeatureStyle(new StyleColor(null, Color.green));
            al.add(sf);
            LocalTheme lt = new LocalTheme("tmp_" + System.currentTimeMillis(), al);
            this.vecRenderer.render(g2, lt, vc);
        }
    }

    private int findLastCasedLineTheme(ThemeList themes, VisContext vc) {
        int lastLineThemeIdx = -1;
        block0: for (int i = 0; i < themes.size(); ++i) {
            StyledFeatureI[] sfs;
            PredGeomThemeDefinition pdf;
            String[] styles;
            boolean hasCasedLineStyle;
            Theme t = themes.getTheme(i);
            if (t instanceof ImageTheme || t instanceof GeoRasterTheme || t instanceof WMSMapTheme || t instanceof MapCacheTheme || t instanceof PredefinedGeometryTheme && !(hasCasedLineStyle = RenderingUtils.hasCasedLineStyle(styles = (pdf = (PredGeomThemeDefinition)t.getDefinition()).getRenderingStyles(), t.getDataSourceName(), vc)) || (sfs = t.getProducer().getStyledFeatures()) == null) continue;
            for (int k = 0; k < sfs.length; ++k) {
                Style sty;
                StyledFeatureI sf = sfs[k];
                if (sf == null || (sty = sf.getFeatureStyle()) != null && !(sty instanceof StyleLine)) continue;
                if (sty == null && (sty = vc.resolveStyle(sf.getFeatureStyleName(), t.getDataSourceName())) != null) {
                    boolean res;
                    StyleCache sc = DSManager.getStyleCache(sf.getDataSource());
                    if (vc.getTemporaryStyleCache() != null) {
                        sc = vc.getTemporaryStyleCache();
                    }
                    if (!(res = sty.resolveStyles(sc, vc.getDynamicStyles()))) {
                        log.warning("cannot resolve referenced styles for style " + sty.getModel().getName());
                    }
                }
                if (sty == null) continue;
                if (sty instanceof StyleLine) {
                    if (sf.getGeomType() != 2 && sf.getGeomType() != 6 || !((StyleLine)sty).supportCasedLine()) continue;
                    lastLineThemeIdx = i;
                    continue block0;
                }
                if (!(sty instanceof BucketStyle) || sty instanceof ColorSchemeStyle || sty instanceof VariableMarkerStyle || sty instanceof VariablePieChartStyle || sf.getGeomType() != 2 && sf.getGeomType() != 6 || !((BucketStyle)sty).hasCasedLineStyles()) continue;
                lastLineThemeIdx = i;
                continue block0;
            }
        }
        return lastLineThemeIdx;
    }

    private void prepareForRendering(VisContext vc) {
        vc.clearLiveFeatures();
        if (vc.getCasedLines() != null) {
            vc.getCasedLines().clear();
        }
        if (vc.getProjection() != null) {
            vc.setQueryWindow(this.applyProjection(vc.getQueryWindow(), vc.getDeviceWindow(), vc.getProjection()));
        }
        vc.getViewportTransform().setDataScaleOnX(1.0);
        XFViewPort mXFViewPort = vc.getViewportTransform();
        mXFViewPort.setStrict(vc.getBBox());
        mXFViewPort.setDataView(vc.getQueryWindow());
        mXFViewPort.setDeviceView(vc.getDeviceWindow());
        AffineTransform mAT = mXFViewPort.getAffineTransform();
        vc.setAffineXF(mAT);
        double[] xfmMatrix = new double[6];
        mAT.getMatrix(xfmMatrix);
        log.finest("xfm: " + xfmMatrix[0] + " " + xfmMatrix[1] + " " + xfmMatrix[2] + " " + xfmMatrix[3] + " " + xfmMatrix[4] + " " + xfmMatrix[5]);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void renderMapLengend(Graphics2D g2, VisContext vc) {
        int sy;
        int sx;
        Legend legend;
        block8: {
            block9: {
                String pos;
                int offx;
                Rectangle2D mbr;
                Rectangle2D mDeviceView;
                block15: {
                    int offy;
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        legend = this.prepareLegend(vc);
                                        mDeviceView = vc.getDeviceWindow();
                                        if (legend == null) {
                                            return;
                                        }
                                        mbr = legend.computeMBR();
                                        sx = -1;
                                        sy = -1;
                                        offx = legend.getOffsetX();
                                        offy = legend.getOffsetY();
                                        if (legend.getLocation() != null) break block9;
                                        pos = legend.getPositionHint();
                                        if (!"SOUTH_WEST".equals(pos)) break block10;
                                        sx = offx;
                                        sy = (int)(mDeviceView.getHeight() - mbr.getHeight() - (double)offy);
                                        break block8;
                                    }
                                    if (!"SOUTH_EAST".equals(pos)) break block11;
                                    sx = (int)(mDeviceView.getWidth() - mbr.getWidth() - (double)offx);
                                    sy = (int)(mDeviceView.getHeight() - mbr.getHeight() - (double)offy);
                                    break block8;
                                }
                                if (!"SOUTH".equals(pos)) break block12;
                                sx = (int)((mDeviceView.getWidth() - mbr.getWidth()) / 2.0);
                                sy = (int)(mDeviceView.getHeight() - mbr.getHeight() - (double)offy);
                                break block8;
                            }
                            if (!"NORTH".equals(pos)) break block13;
                            sx = (int)((mDeviceView.getWidth() - mbr.getWidth()) / 2.0);
                            sy = offy;
                            break block8;
                        }
                        if (!"NORTH_EAST".equals(pos)) break block14;
                        sx = (int)(mDeviceView.getWidth() - mbr.getWidth() - (double)offx);
                        sy = offy;
                        break block8;
                    }
                    if (!"NORTH_WEST".equals(pos)) break block15;
                    sx = offx;
                    sy = offy;
                    break block8;
                }
                if ("CENTER".equals(pos)) {
                    sx = (int)((mDeviceView.getWidth() - mbr.getWidth()) / 2.0);
                    sy = (int)((mDeviceView.getHeight() - mbr.getHeight()) / 2.0);
                    break block8;
                } else if ("EAST".equals(pos)) {
                    sx = (int)(mDeviceView.getWidth() - mbr.getWidth() - (double)offx);
                    sy = (int)((mDeviceView.getHeight() - mbr.getHeight()) / 2.0);
                    break block8;
                } else {
                    if (!"WEST".equals(pos)) {
                        log.severe("Invalid legend positioning hint!");
                        return;
                    }
                    sx = offx;
                    sy = (int)((mDeviceView.getHeight() - mbr.getHeight()) / 2.0);
                }
                break block8;
            }
            sx = (int)legend.getLocation().getX();
            sy = (int)legend.getLocation().getY();
        }
        Object oldRHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (vc.getAntialiasing()) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        legend.paint(g2, sx, sy);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldRHint);
    }

    public void renderMapLogo(Graphics2D g2, VisContext vc) {
        if (vc.isDisableMapPieces()) {
            return;
        }
        CustomLogo logo = GlobalVisContext.getLogo(vc.getMasterDataSourceName());
        if (logo == null) {
            logo = GlobalVisContext.getLogo();
        }
        if (logo == null) {
            return;
        }
        Image img = logo.getLogo();
        if (img == null) {
            return;
        }
        Rectangle2D mDeviceView = vc.getDeviceWindow();
        int gap = 2;
        Rectangle2D.Float mbr = new Rectangle2D.Float(0.0f, 0.0f, img.getWidth(null), img.getHeight(null));
        int sx = -1;
        int sy = -1;
        String pos = logo.getPositionHint();
        if ("SOUTH_WEST".equals(pos)) {
            sx = gap;
            sy = (int)(mDeviceView.getHeight() - ((RectangularShape)mbr).getHeight() - (double)gap);
        } else if ("SOUTH_EAST".equals(pos)) {
            sx = (int)(mDeviceView.getWidth() - ((RectangularShape)mbr).getWidth() - (double)gap);
            sy = (int)(mDeviceView.getHeight() - ((RectangularShape)mbr).getHeight() - (double)gap);
        } else if ("SOUTH".equals(pos)) {
            sx = (int)((mDeviceView.getWidth() - ((RectangularShape)mbr).getWidth()) / 2.0);
            sy = (int)(mDeviceView.getHeight() - ((RectangularShape)mbr).getHeight() - (double)gap);
        } else if ("NORTH".equals(pos)) {
            sx = (int)((mDeviceView.getWidth() - ((RectangularShape)mbr).getWidth()) / 2.0);
            sy = gap;
        } else if ("NORTH_EAST".equals(pos)) {
            sx = (int)(mDeviceView.getWidth() - ((RectangularShape)mbr).getWidth() - (double)gap);
            sy = gap;
        } else if ("NORTH_WEST".equals(pos)) {
            sx = gap;
            sy = gap;
        } else if ("CENTER".equals(pos)) {
            sx = (int)((mDeviceView.getWidth() - ((RectangularShape)mbr).getWidth()) / 2.0);
            sy = (int)((mDeviceView.getHeight() - ((RectangularShape)mbr).getHeight()) / 2.0);
        } else if ("EAST".equals(pos)) {
            sx = (int)(mDeviceView.getWidth() - ((RectangularShape)mbr).getWidth() - (double)gap);
            sy = (int)((mDeviceView.getHeight() - ((RectangularShape)mbr).getHeight()) / 2.0);
        } else if ("WEST".equals(pos)) {
            sx = gap;
            sy = (int)((mDeviceView.getHeight() - ((RectangularShape)mbr).getHeight()) / 2.0);
        } else {
            log.severe("Invalid map logo positioning hint!");
            return;
        }
        g2.drawImage(img, sx, sy, null);
    }

    public void renderMapTitle(Graphics2D g2, VisContext vc) {
        if (vc.isDisableMapPieces()) {
            return;
        }
        double[] pos = this.prepareMapTitle(vc);
        if (pos == null) {
            return;
        }
        String mTitle = vc.getTitle();
        if (mTitle == null && (mTitle = GlobalVisContext.getGlobalMapTitle(vc.getMasterDataSourceName())) == null) {
            mTitle = GlobalVisContext.getGlobalMapTitle();
        }
        StyleText mTitleStyle = vc.getTitleStyle();
        try {
            mTitleStyle.apply(g2, (float)pos[0], (float)pos[1], mTitle, null);
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
    }

    private double[] prepareMapTitle(VisContext vc) {
        String mTitle = vc.getTitle();
        if (mTitle == null && (mTitle = GlobalVisContext.getGlobalMapTitle(vc.getMasterDataSourceName())) == null) {
            mTitle = GlobalVisContext.getGlobalMapTitle();
        }
        if (mTitle == null || mTitle.length() == 0) {
            return null;
        }
        if (vc.getTitleStyle() == null) {
            if (vc.getTitleStyleName() != null) {
                try {
                    StyleText sty = (StyleText)vc.resolveStyle(vc.getTitleStyleName());
                    vc.setTitleStyle(sty);
                }
                catch (Exception ex) {
                    log.severe(ex.getMessage());
                    vc.setTitleStyle(new StyleText(new Font(GlobalVisContext.getGlobalMaptitleFont(), 1, 18), Color.blue));
                    ((TextStyleModel)vc.getTitleStyle().getModel()).setHalo(3.2f, Color.white);
                }
            } else {
                vc.setTitleStyle(new StyleText(new Font(GlobalVisContext.getGlobalMaptitleFont(), 1, 18), Color.blue));
                ((TextStyleModel)vc.getTitleStyle().getModel()).setHalo(3.2f, Color.white);
            }
        }
        StyleText mTitleStyle = vc.getTitleStyle();
        Rectangle2D mDeviceView = vc.getDeviceWindow();
        if (mTitleStyle == null) {
            return null;
        }
        Rectangle2D mbr = mTitleStyle.getVisualBounds(mTitle, null);
        double cx = 0.0;
        double cy = 0.0;
        double w = mbr.getWidth();
        double h = mbr.getHeight();
        double xpad = mDeviceView.getWidth() * 0.04;
        double ypad = mDeviceView.getHeight() * 0.03;
        String pos = vc.getTitlePos();
        if (pos == null) {
            pos = GlobalVisContext.getGlobalMapTitlePos();
        }
        if ("NORTH".equals(pos)) {
            cx = mDeviceView.getWidth() / 2.0;
            cy = h / 2.0 + ypad;
        } else if ("SOUTH".equals(pos)) {
            cx = mDeviceView.getWidth() / 2.0;
            cy = mDeviceView.getHeight() - h / 2.0 - ypad;
        } else if ("WEST".equals(pos)) {
            cx = xpad + w / 2.0;
            cy = h / 2.0 + ypad;
        } else if ("EAST".equals(pos)) {
            cx = mDeviceView.getWidth() - w / 2.0 - xpad;
            cy = h / 2.0 + ypad;
        } else {
            log.warning("invalid map title positioin; placing on NORTH");
            cx = mDeviceView.getWidth() / 2.0;
            cy = h / 2.0 + ypad;
        }
        return new double[]{cx, cy};
    }

    public void renderMapFootNote(Graphics2D g2, VisContext vc) {
        if (vc.isDisableMapPieces()) {
            return;
        }
        double[] pos = this.prepareMapFootNote(vc);
        if (pos == null) {
            return;
        }
        String mFootNote = vc.getFootnote();
        if (mFootNote == null && (mFootNote = GlobalVisContext.getGlobalMapFootnote(vc.getMasterDataSourceName())) == null) {
            mFootNote = GlobalVisContext.getGlobalMapFootnote();
        }
        StyleText mFootNoteStyle = vc.getFootnoteStyle();
        try {
            mFootNoteStyle.apply(g2, (float)pos[0], (float)pos[1], mFootNote, null);
        }
        catch (Exception ex) {
            log.severe(ex.getMessage());
        }
    }

    private double[] prepareMapFootNote(VisContext vc) {
        StyleText mFootNoteStyle;
        String mFootNote = vc.getFootnote();
        if (mFootNote == null && (mFootNote = GlobalVisContext.getGlobalMapFootnote(vc.getMasterDataSourceName())) == null) {
            mFootNote = GlobalVisContext.getGlobalMapFootnote();
        }
        if (mFootNote == null || mFootNote.length() == 0) {
            return null;
        }
        if (vc.getFootnoteStyle() == null) {
            StyleText sty;
            if (vc.getFootnoteStyleName() != null) {
                try {
                    sty = (StyleText)vc.resolveStyle(vc.getFootnoteStyleName());
                    vc.setFootnoteStyle(sty);
                }
                catch (Exception ex) {
                    log.severe(ex.getMessage());
                    StyleText sty2 = new StyleText(new Font(GlobalVisContext.getGlobalMapFootnoteFont(), 0, 12), Color.black);
                    ((TextStyleModel)sty2.getModel()).setHalo(2.5f, Color.white);
                    vc.setFootnoteStyle(sty2);
                }
            } else {
                sty = new StyleText(new Font(GlobalVisContext.getGlobalMapFootnoteFont(), 0, 12), Color.black);
                ((TextStyleModel)sty.getModel()).setHalo(2.5f, Color.white);
                vc.setFootnoteStyle(sty);
            }
        }
        if ((mFootNoteStyle = vc.getFootnoteStyle()) == null) {
            return null;
        }
        Rectangle2D mDeviceView = vc.getDeviceWindow();
        Rectangle2D mbr = mFootNoteStyle.getVisualBounds(mFootNote, null);
        double cx = 0.0;
        double cy = 0.0;
        double w = mbr.getWidth();
        double h = mbr.getHeight();
        double xpad = mDeviceView.getWidth() * 0.01;
        double ypad = mDeviceView.getHeight() * 0.0075;
        String pos = vc.getFootnotePos();
        if (pos == null) {
            pos = GlobalVisContext.getGlobalMapFootnotePos();
        }
        if ("NORTH".equals(pos)) {
            cx = mDeviceView.getWidth() / 2.0;
            cy = h / 2.0 + ypad;
        } else if ("SOUTH".equals(pos)) {
            cx = mDeviceView.getWidth() / 2.0;
            cy = mDeviceView.getHeight() - h / 2.0 - ypad;
        } else if ("WEST".equals(pos) || "SOUTH_WEST".equals(pos)) {
            cx = xpad + w / 2.0;
            cy = mDeviceView.getHeight() - h / 2.0 - ypad;
        } else if ("EAST".equals(pos) || "SOUTH_EAST".equals(pos)) {
            cx = mDeviceView.getWidth() - w / 2.0 - xpad;
            cy = mDeviceView.getHeight() - h / 2.0 - ypad;
        } else if ("NORTH_EAST".equals(pos)) {
            cx = mDeviceView.getWidth() - w / 2.0 - xpad;
            cy = h / 2.0 + ypad;
        } else if ("NORTH_WEST".equals(pos)) {
            cx = xpad + w / 2.0;
            cy = h / 2.0 + ypad;
        } else {
            cx = mDeviceView.getWidth() / 2.0;
            cy = mDeviceView.getHeight() / 2.0;
        }
        return new double[]{cx, cy};
    }

    public void renderScaleBar(Graphics2D g, VisContext vc) {
        if (vc.isDisableMapPieces()) {
            return;
        }
        if (vc.getSrs() == null) {
            log.warning("SRS is null. Scale bar not rendered.");
            return;
        }
        ScaleBar barDef = vc.getScaleBar();
        if (barDef == null) {
            return;
        }
        ScaleBarRenderer bar = new ScaleBarRenderer(barDef, vc.getSrs(), vc.getQueryWindow(), vc.getDeviceWindow(), vc.getMasterDataSourceName());
        bar.renderScaleBar(g);
    }

    public void renderNorthArrow(Graphics2D g, VisContext vc) {
        NorthArrow na = vc.getNorthArrow();
        if (na == null) {
            return;
        }
        if (na.getStyle() == null) {
            log.warning("North arrow must have a style defined. Not rendered.");
            return;
        }
        StyleMarker northArrow = (StyleMarker)vc.resolveStyle(na.getStyle());
        if (northArrow != null) {
            MarkerStyleModel mm = (MarkerStyleModel)northArrow.getModel();
            int fw = mm.getForcedWidth();
            int fh = mm.getForcedHeight();
            double rotation = mm.getRotation();
            mm.setForcedWidth(na.getWidth());
            mm.setForcedHeight(na.getHeight());
            mm.setRotation(-1.0 * vc.getRotation() * Math.PI / 180.0);
            try {
                northArrow.apply(vc, g, na.getLocationX(), (float)na.getLocationY(), null);
            }
            catch (Exception e) {
                log.severe(e.getMessage());
            }
            mm.setForcedWidth(fw);
            mm.setForcedHeight(fh);
            mm.setRotation(rotation);
        } else {
            log.warning("Unable to load north arrow style " + na.getStyle() + ". Not rendered.");
        }
    }

    private Rectangle2D applyProjection(Rectangle2D dataView, Rectangle2D deviceView, Proj proj) {
        return proj.getBoundingBox(dataView, deviceView);
    }

    public static void setShowQW(boolean v) {
        GlobalVisContext.showQueryWindow = v;
    }

    private void renderWMSImage(Image wmsMap, Theme theme, VisContext vc, Graphics2D g2) {
        if (wmsMap == null || theme == null) {
            return;
        }
        WMSMapThemeProducer wtp = (WMSMapThemeProducer)theme.getProducer();
        WMSMapThemeDefinition wtd = (WMSMapThemeDefinition)theme.getDefinition();
        Image filteredImage = null;
        if ((wtd.getFormat() == null || wtd.getFormat().equalsIgnoreCase("image/png")) && wtd.isTransparent()) {
            Color bgcolor = StyleUtils.getColor(wtd.getBgColor());
            if (bgcolor == null) {
                bgcolor = new Color(255, 255, 255);
            }
            ImageFilter filter = new ImageFilter();
            filter.setTransparentColor(bgcolor.getRed(), bgcolor.getGreen(), bgcolor.getBlue());
            filteredImage = filter.getFilteredImage(wmsMap);
            if (filteredImage != null && !ImageUtils.waitForImage(filteredImage)) {
                log.warning("Unable to get filtered image for WMS png format.");
                filteredImage.flush();
                filteredImage = null;
            } else {
                log.info("Transparent pixels of WMS png image have been filtered.");
            }
        }
        if (vc.getRotation() == 0.0) {
            int w = (int)vc.getDeviceWindow().getWidth();
            int h = (int)vc.getDeviceWindow().getHeight();
            float alpha = theme.getDecorator().getOpacity();
            if (alpha >= 0.0f && alpha < 1.0f) {
                Composite cOld = g2.getComposite();
                g2.setComposite(AlphaComposite.getInstance(3, alpha));
                if (filteredImage == null) {
                    g2.drawImage(wmsMap, 0, 0, w, h, null);
                } else {
                    g2.drawImage(filteredImage, 0, 0, w, h, null);
                }
                g2.setComposite(cOld);
            } else if (filteredImage == null) {
                g2.drawImage(wmsMap, 0, 0, w, h, null);
            } else {
                g2.drawImage(filteredImage, 0, 0, w, h, null);
            }
        } else if (filteredImage == null) {
            ImageRenderer.renderImage(g2, wmsMap, wtp.getDataMBR(), theme.getDecorator().getOpacity(), vc);
        } else {
            ImageRenderer.renderImage(g2, filteredImage, wtp.getDataMBR(), theme.getDecorator().getOpacity(), vc);
        }
        if (filteredImage != null) {
            ImageUtils.removeImageFromTracker(filteredImage);
            filteredImage.flush();
            filteredImage = null;
        }
    }

    public Legend prepareLegend(VisContext vc) {
        if (vc == null) {
            return null;
        }
        Legend legend = vc.getLegend();
        if (legend == null) {
            return null;
        }
        if (this.mapper == null || legend.getNumColumns() > 0) {
            return legend;
        }
        String[] renderedThemes = this.mapper.getRenderedThemes(this.localthemesInLegend);
        if (renderedThemes == null || renderedThemes.length == 0) {
            return null;
        }
        ArrayList<ThemeDefinition> themeDefs = new ArrayList<ThemeDefinition>();
        for (int i = 0; i < renderedThemes.length; ++i) {
            Theme theme = null;
            ThemeDefinition themeDef = null;
            if (vc.getThemeList() != null) {
                for (int j = 0; j < vc.getThemeList().size(); ++j) {
                    Theme th = vc.getThemeList().getTheme(j);
                    if (!th.getName().equalsIgnoreCase(renderedThemes[i])) continue;
                    theme = th;
                    themeDef = theme.getDefinition();
                    break;
                }
            }
            if (themeDef == null) continue;
            themeDefs.add(themeDef);
        }
        if (themeDefs.size() > 0) {
            ThemeDefinition[] tdefs = new ThemeDefinition[themeDefs.size()];
            for (int i = 0; i < themeDefs.size(); ++i) {
                tdefs[i] = (ThemeDefinition)themeDefs.get(i);
            }
            legend.prepare(tdefs, vc);
            return legend;
        }
        return null;
    }

    public void useLocalThemesInAutomaticLegend(boolean uselocalThemes) {
        this.localthemesInLegend = uselocalThemes;
    }

    public boolean useLocalThemesInAutomaticLegend() {
        return this.localthemesInLegend;
    }

    public class ImageFilter {
        private ResImageFilter m_imageFilter = new ResImageFilter();

        public void setTransparentColor(int red, int green, int blue) {
            this.m_imageFilter.setTransparentColor(red, green, blue);
        }

        public Image getFilteredImage(Image img) {
            if (img == null) {
                return null;
            }
            FilteredImageSource ip = new FilteredImageSource(img.getSource(), this.m_imageFilter);
            try {
                return Toolkit.getDefaultToolkit().createImage(ip);
            }
            catch (Throwable ex) {
                log.warning("cannot create filtered image.");
                return null;
            }
        }

        public class ResImageFilter
        extends RGBImageFilter {
            private int m_rgbMaskColor = 0;

            public void setTransparentColor(int red, int green, int blue) {
                this.m_rgbMaskColor = new Color(red, green, blue).getRGB();
            }

            @Override
            public int filterRGB(int x, int y, int rgb) {
                if (rgb == this.m_rgbMaskColor) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        }
    }
}

