/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.Legend;
import oracle.sdovis.LegendEntry;
import oracle.sdovis.StyleFactory;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.stylex.AdvancedStyle;
import oracle.sdovis.stylex.BarChartStyle;
import oracle.sdovis.stylex.CollectionStyle;
import oracle.sdovis.stylex.PieChartStyle;

public class LegendColumn {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    public static final String SEPARATOR = "_-_SEPARATOR_-_";
    private static Style defaultTitleStyle = new StyleText(new Font("Dialog", 1, 14), Color.blue, 2.0f);
    Legend owner = null;
    Vector items = new Vector(5);
    Rectangle2D mbr = null;
    private StyleText descriptionTextStyle = (StyleText)StyleFactory.getDefaultTextStyle();

    public LegendColumn(Legend owner) {
        this.owner = owner;
    }

    public int getProfile() {
        return this.owner.profile;
    }

    public Color getBackground() {
        return this.owner.background;
    }

    public Color getBorderColor() {
        return this.owner.borderColor;
    }

    public Rectangle2D getMBR() {
        return this.mbr;
    }

    public int getBorderWidth() {
        return this.owner.borderWidth;
    }

    public Color getTextColor() {
        return this.owner.textColor;
    }

    public LegendEntry setTitle(String title) {
        LegendEntry le = new LegendEntry(title);
        le.setProfile(this.owner.profile);
        le.setBackground(this.owner.background);
        le.setFontFamily(this.owner.fontFamily);
        this.items.add(le);
        return le;
    }

    public void addEntry(LegendEntry le) {
        le.setProfile(this.owner.profile);
        this.items.add(le);
    }

    public LegendEntry addStyle(String styleName, String shortDesc) {
        LegendEntry le = new LegendEntry(styleName, shortDesc);
        le.setProfile(this.owner.profile);
        le.setFontFamily(this.owner.fontFamily);
        le.setBackground(this.owner.background);
        this.items.addElement(le);
        return le;
    }

    public LegendEntry addStyleWithCustomDimension(String styleName, String shortDesc, int usrWidth, int usrHeight) {
        LegendEntry le = new LegendEntry(styleName, shortDesc);
        le.setProfile(this.owner.profile);
        le.setUserSpcifiedDimensioin(usrWidth, usrHeight);
        le.setFontFamily(this.owner.fontFamily);
        le.setBackground(this.owner.background);
        this.items.addElement(le);
        return le;
    }

    public void addSeparator() {
        LegendEntry le = new LegendEntry();
        le.setProfile(this.owner.profile);
        le.setBackground(this.owner.background);
        this.items.addElement(le);
    }

    public void deleteAllEntries() {
        this.items.removeAllElements();
    }

    public int getNumEntries() {
        return this.items.size();
    }

    public void prepare(VisContext vc) {
        LegendEntry item = null;
        int sz = this.items.size();
        if (sz == 0) {
            return;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            item = (LegendEntry)this.items.get(i);
            item.setProfile(this.owner.profile);
            item.prepare(vc);
        }
        this.mbr = this.getMaxTextBounds();
    }

    public void destroy() {
        if (this.items == null) {
            return;
        }
        LegendEntry item = null;
        for (int i = 0; i < this.items.size(); ++i) {
            item = (LegendEntry)this.items.get(i);
            item.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g2, int sx, int sy) {
        int sz = this.items.size();
        if (sz == 0) {
            return;
        }
        String g2name = g2.toString();
        AttributedCharacterIterator iter = null;
        Color background = this.owner.background;
        Color textColor = this.owner.textColor;
        if (background != null) {
            g2.setColor(background);
            g2.fillRect(sx, sy, (int)this.mbr.getWidth(), (int)this.mbr.getHeight());
        }
        g2.translate(sx, sy);
        g2.setColor(textColor);
        try {
            int height = 3;
            for (int i = 0; i < this.items.size(); ++i) {
                LegendEntry item = (LegendEntry)this.items.get(i);
                int pheight = item.getPreferredHeight();
                if (g2name.indexOf("XDOGraphics2D") < 0 || item.getType() == 1 || item.getType() == 2 || item.getStyle() == null) {
                    AttributedString as = item.getAttrString();
                    if (as == null) continue;
                    iter = as.getIterator();
                    g2.drawString(iter, 2, (height += pheight) - pheight / 2);
                    continue;
                }
                int pwidth = item.getPreferredWidth();
                if (!item.hasAdvancedStyle() || item.getStyle() instanceof PieChartStyle || item.getStyle() instanceof BarChartStyle || item.getStyle() instanceof CollectionStyle) {
                    pwidth = LegendEntry.PROFILE_IMAGE_WIDTH[this.getProfile()];
                    if (item.getUserWidth() > 0) {
                        pwidth = item.getUserWidth();
                    }
                }
                double spaces = (double)(item.getNumSpaces() * item.getTextSize()) / 2.0;
                Rectangle2D.Double r = new Rectangle2D.Double(2.0 + spaces, height, pwidth, pheight);
                StyleModifiers smods = item.getStyle().convertToPixelSize(null);
                item.getStyle().apply(null, g2, r, smods);
                if (item.getText() != null && item.getText().trim().length() > 0) {
                    Font f = item.getFont();
                    if (f == null) {
                        f = new Font("Serif", 0, LegendEntry.PROFILE_TEXT_SIZE[this.getProfile()]);
                    }
                    g2.setFont(f);
                    Color fg = item.getForeground();
                    if (fg == null) {
                        fg = Color.black;
                    }
                    g2.setColor(fg);
                    if (item.hasAdvancedStyle() && !(item.getStyle() instanceof PieChartStyle) && !(item.getStyle() instanceof BarChartStyle) && !(item.getStyle() instanceof CollectionStyle)) {
                        g2.drawString(item.getText(), 10 + ((AdvancedStyle)item.getStyle()).getMaxLegendWidth(null, item.getTextSize()), height + (int)((double)pheight / 2.0 + 0.5));
                    } else {
                        g2.drawString(item.getText(), 10 + pwidth, 3 + height + (int)((double)pheight / 2.0 + 0.5));
                    }
                }
                height += pheight;
            }
        }
        catch (Exception ex) {
        }
        finally {
            g2.translate(-sx, -sy);
        }
    }

    public LegendEntry getEntry(int i) {
        if (i >= this.items.size()) {
            return null;
        }
        return (LegendEntry)this.items.get(i);
    }

    private Rectangle2D getMaxTextBounds() {
        boolean index = false;
        int maxW = 0;
        int accuH = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            LegendEntry item = (LegendEntry)this.items.get(i);
            if (item.type == 1) {
                accuH += item.getPreferredHeight();
                continue;
            }
            int width = item.getPreferredWidth();
            int height = item.getPreferredHeight();
            accuH += height;
            if (maxW >= width) continue;
            maxW = width;
        }
        return new Rectangle2D.Double(0.0, 0.0, maxW += 5, accuH += LegendEntry.PROFILE_IMAGE_HEIGHT[this.owner.profile]);
    }
}

